/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.business;

import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;

public class ShowFormHelper {
    public static final ShowType DEFAULT_SHOW_TYPE = ShowType.MainNewTabPage;
    public static final OperationStatus DEFAULT_OPERATION_STATUS = OperationStatus.VIEW;
    public static final String MULTI_JOIN_LOOK_PARAM_KEY = "joinLook";

    public static BillShowParameter getBillShowParameter(String billName, Long billId, ShowType showType, OperationStatus operationStatus) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billName);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(showType);
        showParameter.setStatus(operationStatus);
        return showParameter;
    }

    public static BillShowParameter getBillShowParameter(String billName, Long billId) {
        return ShowFormHelper.getBillShowParameter(billName, billId, DEFAULT_SHOW_TYPE, DEFAULT_OPERATION_STATUS);
    }

    public static FormShowParameter getBillListShowParameter(String billName, List<Long> billIds) {
        return ShowFormHelper.getBillListShowParameter(billName, billIds, DEFAULT_SHOW_TYPE);
    }

    public static FormShowParameter getBillListShowParameter(String billName, List<Long> billIds, ShowType showType) {
        ListShowParameter showParameter = new ListShowParameter();
        LinkQueryPkIdCollection ids = new LinkQueryPkIdCollection();
        for (Long billId : billIds) {
            ids.addLinkQueryPkId((Object)billId);
        }
        showParameter.setLinkQueryPkIdCollection(ids);
        showParameter.setBillFormId(billName);
        showParameter.getOpenStyle().setShowType(showType);
        return showParameter;
    }

    public static FormShowParameter getMultiBillShowParameter(String caption, Map<String, List<Long>> billMap) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("sctm_joinlookpage");
        if (caption != null) {
            showParameter.setCaption(caption);
        }
        showParameter.getOpenStyle().setShowType(DEFAULT_SHOW_TYPE);
        showParameter.setCustomParam(MULTI_JOIN_LOOK_PARAM_KEY, billMap);
        return showParameter;
    }

    public static FormShowParameter getSubTabFormShowParameter(String tabName, String billName, List<Long> ids) {
        if (tabName == null || billName == null || ids == null || ids.isEmpty()) {
            return null;
        }
        Object parameter = ids.size() == 1 ? ShowFormHelper.getBillShowParameter(billName, ids.get(0), ShowType.NewTabPage, DEFAULT_OPERATION_STATUS) : ShowFormHelper.getBillListShowParameter(billName, ids, ShowType.NewTabPage);
        parameter.getOpenStyle().setTargetKey(tabName);
        return parameter;
    }
}

