/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.sctm.business.ShowFormHelper;

public class ScJoinLookEditPlugin
extends AbstractFormPlugin {
    private static final String TAB_NAME = "tabbills";
    private static final String PAGE_COUNT_CACHE_KEY = "PAGE_COUNT";

    public void afterBindData(EventObject e) {
        this.showJoinBills();
    }

    private void showJoinBills() {
        IFormView view = this.getView();
        Map joinLookMap = (Map)view.getFormShowParameter().getCustomParam("joinLook");
        if (joinLookMap == null) {
            return;
        }
        int pageCount = 0;
        for (Map.Entry entry : joinLookMap.entrySet()) {
            String billName = (String)entry.getKey();
            FormShowParameter showParameter = ShowFormHelper.getSubTabFormShowParameter(TAB_NAME, billName, (List)entry.getValue());
            if (showParameter == null) continue;
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, billName);
            showParameter.setCloseCallBack(closeCallBack);
            view.showForm(showParameter);
            ++pageCount;
        }
        if (pageCount > 0) {
            this.setPageCount(pageCount);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String str = this.getPageCache().get(PAGE_COUNT_CACHE_KEY);
        if (StringUtils.isEmpty((CharSequence)str)) {
            return;
        }
        int newPageCount = Integer.parseInt(str) - 1;
        if (newPageCount < 1) {
            this.getView().close();
        } else {
            this.setPageCount(newPageCount);
        }
    }

    private void setPageCount(int pageCount) {
        this.getPageCache().put(PAGE_COUNT_CACHE_KEY, String.valueOf(pageCount));
    }
}

