/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.formplugin;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.FieldProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.trace.Tracer;
import kd.mpscmm.msbd.business.helper.OwnerHelper;
import kd.mpscmm.msbd.business.helper.SCMCBomHelper;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.pojo.SCMCBomEntryData;
import kd.mpscmm.msbd.common.pojo.SCMCBomExpandData;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.mspur.business.PoTplHelper;
import kd.scmc.sctm.business.ScPoHelper;
import kd.scmc.sctm.common.enums.SubType;

public class ScPoEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String SUB_TYPE_CONFIRM = "subtype_confirm";
    private static final String BOM_CONFIRM = "bom_confirm";
    private static final String SUB_ADD_ROW_BTN = "addrow_sub";
    private static final int MAX_EXPANDBOM_COUNT = 100;
    private static final String ENTITY_SCBOM = "bd_scbom";
    private final Map<Long, Boolean> isInvOrgCache = new HashMap<Long, Boolean>(32);
    private final Map<Long, Long> orgOwnerCache = new HashMap<Long, Long>(32);

    public void registerListener(EventObject e) {
        Toolbar subToolbar = (Toolbar)this.getControl("toolbar_sub");
        if (subToolbar != null) {
            subToolbar.addItemClickListener((ItemClickListener)this);
        }
        this.registerBeforeF7SelectListener("subunit", "subwarehouse", "subowner", "bom");
        BasedataEdit materialEdit = (BasedataEdit)this.getControl("material");
        if (materialEdit != null) {
            materialEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isImport()) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("billentry");
        if (entry != null && !entry.isEmpty()) {
            this.initSubType(entry);
            if (this.isInvOrg((DynamicObject)model.getValue("org"))) {
                for (DynamicObject row : entry) {
                    this.initAllSubDeliverOrg(row);
                }
                this.initAllSubOwner(IntStream.range(0, entry.size()).toArray());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        IDataModel model = this.getModel();
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        int subRowIndex = model.getEntryCurrentRowIndex("billentry_sub");
        switch (fieldKey) {
            case "subunit": {
                DynamicObject subMaterial = (DynamicObject)model.getValue("submaterial", subRowIndex);
                if (subMaterial == null) {
                    this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u4ef6\u7f16\u7801\u3002", (String)"ScPoEditPlugin_0", (String)"scmc-sctm", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    break;
                }
                showParameter.getListFilterParameter().getQFilters().add(PoTplHelper.getUnitF7QFilter((Long)((Long)subMaterial.getPkValue()), (DynamicObject)((DynamicObject)model.getValue("subbaseunit", subRowIndex))));
                break;
            }
            case "subwarehouse": {
                DynamicObject subDeliverOrg = (DynamicObject)model.getValue("subdeliverorg", subRowIndex);
                if (subDeliverOrg != null) break;
                this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d1\u6599\u7ec4\u7ec7\u3002", (String)"ScPoEditPlugin_1", (String)"scmc-sctm", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                break;
            }
            case "subowner": {
                String subOwnerType = (String)model.getValue("subownertype", subRowIndex);
                DynamicObject subDeliverOrg = (DynamicObject)model.getValue("subdeliverorg", subRowIndex);
                showParameter.getListFilterParameter().getQFilters().add(OwnerHelper.getOwnerF7QFilter((String)subOwnerType, (DynamicObject)subDeliverOrg, (IPageCache)this.getPageCache()));
                break;
            }
            case "bom": {
                int entryIndex = this.getModel().getEntryCurrentRowIndex("billentry");
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", entryIndex);
                if (material == null) {
                    this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7269\u6599\u7f16\u7801\u201d\u3002", (String)"ScPoEditPlugin_7", (String)"scmc-sctm", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                    return;
                }
                DynamicObject masterid = material.getDynamicObject("masterid");
                QFilter materialFilter = new QFilter("material.id", "=", masterid.getPkValue());
                showParameter.getListFilterParameter().getQFilters().add(materialFilter);
                showParameter.setCustomParam("ismergerows", (Object)Boolean.TRUE);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        block33: for (ChangeData changeData : changeSet) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (!CommonUtils.isRealChanged((Object)oldValue, (Object)newValue)) continue;
            switch (name) {
                case "qty": {
                    this.changeQty(rowIndex);
                    continue block33;
                }
                case "unit": {
                    this.changeUnit(rowIndex);
                    continue block33;
                }
                case "subtype": {
                    this.changeSubType((String)oldValue, (String)newValue, rowIndex);
                    continue block33;
                }
                case "submaterial": {
                    this.changeSubMaterial((DynamicObject)newValue, rowIndex);
                    continue block33;
                }
                case "subqty": {
                    this.batchUpdateView(ScPoHelper.updateSubQtyUpDown(this.getSubEntryRow(rowIndex), false), rowIndex);
                }
                case "subunit": {
                    this.calcSubBaseQty(rowIndex);
                    continue block33;
                }
                case "qtynumerator": 
                case "qtydenominator": 
                case "wasteformula": 
                case "scraprate": {
                    this.calcSubEntryRow(rowIndex);
                    continue block33;
                }
                case "iscontrolsubqty": {
                    this.clearSubRateUpDown((Boolean)newValue, rowIndex);
                    continue block33;
                }
                case "subrateup": {
                    this.batchUpdateView(ScPoHelper.updateSubQtyUpDownByRate(this.getSubEntryRow(rowIndex), true), rowIndex);
                    continue block33;
                }
                case "subratedown": {
                    this.batchUpdateView(ScPoHelper.updateSubQtyUpDownByRate(this.getSubEntryRow(rowIndex), false), rowIndex);
                    continue block33;
                }
                case "subdeliverorg": {
                    this.initSubOwner((DynamicObject)newValue, rowIndex);
                    continue block33;
                }
                case "material": {
                    String defValue = this.getDefaultSubType((DynamicObject)this.getModel().getValue("linetype", rowIndex));
                    this.stopChange();
                    this.getModel().setValue("subtype", (Object)defValue, rowIndex);
                    this.getModel().setValue("bom", null, rowIndex);
                    this.clearSubEntry(rowIndex);
                    this.startChange();
                    continue block33;
                }
                case "bom": {
                    this.changeBom(oldValue, newValue, rowIndex);
                    continue block33;
                }
            }
        }
    }

    private void changeBom(Object oldValue, Object newValue, int rowIndex) {
        if (this.existSubEntry(rowIndex) && (oldValue != null || newValue != null)) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(BOM_CONFIRM, (IFormPlugin)this);
            HashMap<String, String> customerParam = new HashMap<String, String>(2);
            Long oldValueId = oldValue == null ? Long.valueOf(0L) : (oldValue instanceof DynamicObject ? (Long)((DynamicObject)oldValue).getPkValue() : (Long)oldValue);
            customerParam.put("bomoldvalue", String.valueOf(oldValueId));
            customerParam.put("rowindex", String.valueOf(rowIndex));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u6216\u5220\u9664BOM\u7f16\u7801\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u53d1\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"ScPoEditPlugin_8", (String)"scmc-sctm", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, listener, null, SerializationUtils.toJsonString(customerParam));
            return;
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (SUB_ADD_ROW_BTN.equals(itemKey)) {
            int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
            if (selectRows == null || selectRows.length != 1) {
                this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u7269\u6599\u3002", (String)"ScPoEditPlugin_2", (String)"scmc-sctm", (Object[])new Object[0]));
                evt.setCancel(true);
            } else if (this.isLockSubEntry(selectRows[0])) {
                this.showTipNotification(ResManager.loadKDString((String)"\u6295\u6599\u65b9\u5f0f\u4e3a\u4e0d\u6295\u6599\uff0c\u53d1\u6599\u660e\u7ec6\u4e0d\u80fd\u589e\u884c\u3002", (String)"ScPoEditPlugin_3", (String)"scmc-sctm", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] addRowEntities = e.getRowDataEntities();
        if ("billentry_sub".equals(entryName)) {
            this.initSubEntryRow(addRowEntities);
        } else if ("billentry".equals(entryName) && this.isInvOrg((DynamicObject)this.getModel().getValue("org"))) {
            int[] rowIndexes = new int[addRowEntities.length];
            for (int i = 0; i < addRowEntities.length; ++i) {
                RowDataEntity rowEntity = addRowEntities[i];
                this.initAllSubDeliverOrg(rowEntity.getDataEntity());
                rowIndexes[i] = rowEntity.getRowIndex();
            }
            this.initAllSubOwner(rowIndexes);
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        IDataModel model = this.getModel();
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("material".equals(key)) {
            int currentRowIndex = e.getCurrentRowIndex();
            ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
            String defValue = this.getDefaultSubType((DynamicObject)model.getValue("linetype", currentRowIndex));
            this.stopChange();
            for (int i = 0; i < listSelectedRowCollection.size(); ++i) {
                model.setValue("subtype", (Object)defValue, i + currentRowIndex);
                if (!SubType.isNotInput(defValue)) continue;
                this.clearSubEntry(i + currentRowIndex);
            }
            this.startChange();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "subtype_confirm": {
                this.confirmCallBackChangeSubType(messageBoxClosedEvent);
                break;
            }
            case "callback_linetype": {
                if (!MessageBoxResult.Yes.equals((Object)result)) break;
                Map params = (Map)SerializationUtils.fromJsonString((String)messageBoxClosedEvent.getCustomVaule(), Map.class);
                if (params == null || params.isEmpty()) {
                    return;
                }
                int rowIndex = Integer.parseInt((String)params.get("linetype_rowindex"));
                IDataModel model = this.getModel();
                String defaultSubType = this.getDefaultSubType((DynamicObject)model.getValue("linetype", rowIndex));
                this.stopChange();
                model.setValue("subtype", (Object)defaultSubType, rowIndex);
                if (SubType.isNotInput(defaultSubType)) {
                    this.clearSubEntry(rowIndex);
                }
                this.startChange();
                break;
            }
            case "payaccordsetting": {
                if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("payaccordsetting", "true");
                this.getView().invokeOperation("payaccordsetting", option);
                break;
            }
            case "expandbom": {
                if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) break;
                int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
                for (int i = 0; i < selectRows.length; ++i) {
                    this.clearSubEntry(selectRows[i]);
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("expandbom", "true");
                this.getView().invokeOperation("expandbom", option);
                break;
            }
            case "bom_confirm": {
                this.callBackChangeBom(messageBoxClosedEvent);
                break;
            }
        }
    }

    private void confirmCallBackChangeSubType(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String param = messageBoxClosedEvent.getCustomVaule();
        int splitIndex = param.lastIndexOf(44);
        int rowIndex = Integer.parseInt(param.substring(splitIndex + 1));
        String oldValue = param.substring(0, splitIndex);
        String subType = (String)this.getModel().getValue("subtype", rowIndex);
        DynamicObject bom = (DynamicObject)this.getModel().getValue("bom", rowIndex);
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.stopChange();
            if (SubType.BOM.getValue().equals(subType)) {
                this.setDefBom(rowIndex, subType);
            } else {
                this.getModel().setValue("bom", null, rowIndex);
            }
            this.startChange();
            this.clearSubEntry(rowIndex);
        } else {
            IDataModel model = this.getModel();
            this.stopChange();
            model.setValue("subtype", (Object)oldValue, rowIndex);
            this.startChange();
        }
    }

    private void callBackChangeBom(MessageBoxClosedEvent messageBoxClosedEvent) {
        Integer rowindex;
        String customVaule = messageBoxClosedEvent.getCustomVaule();
        if (customVaule == null || StringUtils.isBlank((CharSequence)customVaule)) {
            return;
        }
        Map param = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
        if (param == null || param.isEmpty()) {
            return;
        }
        Long bomoldvalue = param.get("bomoldvalue") == null ? null : Long.valueOf(Long.parseLong((String)param.get("bomoldvalue")));
        Integer n = rowindex = param.get("rowindex") == null ? null : Integer.valueOf(Integer.parseInt((String)param.get("rowindex")));
        if (bomoldvalue == null || rowindex == null) {
            return;
        }
        if (messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.clearSubEntry(rowindex);
        } else {
            this.stopChange();
            this.getModel().setValue("bom", (Object)bomoldvalue, rowindex.intValue());
            this.startChange();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "showsublist": {
                this.beforeShowSubList(args);
                break;
            }
            case "subdeliver": {
                this.prepareSubListIds(args, false);
                break;
            }
            case "payaccordsetting": {
                this.beforeChangePrePaySetting(args);
                break;
            }
            case "expandbom": {
                this.beforeExpandBom(args);
                break;
            }
        }
    }

    private void beforeExpandBom(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        OperateOption option = operate.getOption();
        if (!"true".equals(option.getVariableValue("expandbom", ""))) {
            int i;
            Date bizTime = (Date)this.getModel().getValue("biztime");
            if (bizTime == null) {
                this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u5355\u65e5\u671f\u3002", (String)"ScPoEditPlugin_9", (String)"scmc-sctm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
            if (selectRows == null || selectRows.length == 0) {
                this.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ScPoEditPlugin_10", (String)"scmc-sctm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (selectRows.length > 100) {
                this.showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301100\u884c\u7269\u6599\u660e\u7ec6\u884c\u5c55\u5f00\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ScPoEditPlugin_11", (String)"scmc-sctm", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            for (i = 0; i < selectRows.length; ++i) {
                String subType = (String)this.getModel().getValue("subtype", selectRows[i]);
                if (StringUtils.isBlank((CharSequence)subType) || !SubType.BOM.getValue().equals(subType)) {
                    this.showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u6295\u6599\u65b9\u5f0f\u4e0d\u662fBOM\uff0c\u65e0\u6cd5\u6309BOM\u5c55\u5f00\uff0c\u8bf7\u4fee\u6539\u6295\u6599\u65b9\u5f0f\u3002", (String)"ScPoEditPlugin_23", (String)"scmc-sctm", (Object[])new Object[0]), selectRows[i] + 1));
                    args.setCancel(true);
                    return;
                }
                Object bom = this.getModel().getValue("bom", selectRows[i]);
                if (bom != null) continue;
                this.showTipNotification(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u8bf7\u5f55\u5165\u201cBOM\u7f16\u7801\u201d\u3002", (String)"ScPoEditPlugin_12", (String)"scmc-sctm", (Object[])new Object[0]), selectRows[i] + 1));
                args.setCancel(true);
                return;
            }
            for (i = 0; i < selectRows.length; ++i) {
                if (!this.existSubEntry(selectRows[i])) continue;
                ConfirmCallBackListener listener = new ConfirmCallBackListener("expandbom", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u6309BOM\u5c55\u5f00\u5c06\u91cd\u65b0\u751f\u6210\u53d1\u6599\u660e\u7ec6\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"ScPoEditPlugin_13", (String)"scmc-sctm", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
                args.setCancel(true);
                return;
            }
        }
    }

    private void afterExpandBom() {
        int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Date bizTime = (Date)this.getModel().getValue("biztime");
        HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
        parameters.put("expandLevel", Integer.valueOf(1));
        parameters.put("expandOrgId", (Long)org.getPkValue());
        ArrayList keys = new ArrayList(10);
        Collections.addAll(keys, "auxpty", "lossformula", "varlossrate");
        parameters.put("customEntryFields", keys);
        ArrayList<String> errorMsgList = new ArrayList<String>(10);
        HashMap<Integer, SCMCBomExpandData> bomExpandDataMap = new HashMap<Integer, SCMCBomExpandData>(selectRows.length);
        for (int rowIndex : selectRows) {
            String subType = (String)this.getModel().getValue("subtype", rowIndex);
            DynamicObject bom = (DynamicObject)this.getModel().getValue("bom", rowIndex);
            if (!StringUtils.isNotBlank((CharSequence)subType) || !SubType.BOM.getValue().equals(subType) || bom == null) continue;
            BigDecimal baseQty = (BigDecimal)this.getModel().getValue("baseqty", rowIndex);
            if (baseQty == null) {
                baseQty = BigDecimal.ZERO;
            }
            parameters.put("parentQty", baseQty);
            SCMCBomExpandData bomExpandData = SCMCBomHelper.expandSCMCBOM((Long)((Long)bom.getPkValue()), (String)ENTITY_SCBOM, parameters);
            String errorMsg = this.validateAndFilterExpandData(bomExpandData, rowIndex, bizTime);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                errorMsgList.add(errorMsg);
                continue;
            }
            bomExpandDataMap.put(rowIndex, bomExpandData);
        }
        if (bomExpandDataMap == null || bomExpandDataMap.isEmpty()) {
            this.showErrorMsg(errorMsgList);
            return;
        }
        errorMsgList.addAll(this.validateAndFilterMaterial(bomExpandDataMap, org));
        if (bomExpandDataMap == null || bomExpandDataMap.isEmpty()) {
            this.showErrorMsg(errorMsgList);
            return;
        }
        this.fillSubEntry(bomExpandDataMap);
        if (!errorMsgList.isEmpty()) {
            this.showErrorMsg(errorMsgList);
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ScPoEditPlugin_14", (String)"scmc-sctm", (Object[])new Object[0]));
        }
    }

    private void showErrorMsg(List<String> errorMsgList) {
        String errorDateRowMsg = String.join((CharSequence)"\n", errorMsgList);
        String title = ResManager.loadKDString((String)"\u6309BOM\u5c55\u5f00\u5b58\u5728\u5931\u8d25", (String)"ScPoEditPlugin_15", (String)"scmc-sctm", (Object[])new Object[0]);
        this.getView().showConfirm(title, errorDateRowMsg, MessageBoxOptions.OK, ConfirmTypes.Fail, null);
    }

    private List<String> validateAndFilterMaterial(Map<Integer, SCMCBomExpandData> bomExpandDataMap, DynamicObject org) {
        QFilter useOrgFilter;
        QFilter enableFilter;
        ArrayList<String> errorMsgs = new ArrayList<String>(10);
        HashSet materialIds = new HashSet(10);
        bomExpandDataMap.values().forEach(expandData -> {
            List entryDataList;
            if (expandData != null && (entryDataList = expandData.getEntryDataList()) != null && !entryDataList.isEmpty()) {
                entryDataList.forEach(entry -> {
                    Long entryMaterialId = entry.getEntryMaterialId();
                    if (entryMaterialId != null) {
                        materialIds.add(entryMaterialId);
                    }
                });
            }
        });
        if (materialIds.isEmpty()) {
            return errorMsgs;
        }
        QFilter idFilter = new QFilter("id", "in", materialIds);
        QFilter statusFilter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue());
        Map load = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id", (QFilter[])new QFilter[]{idFilter, statusFilter, enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()), useOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)((Long)org.getPkValue()))});
        if (load != null && !load.isEmpty()) {
            Set keySet = load.keySet();
            if (!keySet.isEmpty()) {
                materialIds.removeAll(keySet);
            }
            if (materialIds.isEmpty()) {
                return errorMsgs;
            }
            Iterator<Map.Entry<Integer, SCMCBomExpandData>> bomsiterator = bomExpandDataMap.entrySet().iterator();
            while (bomsiterator.hasNext()) {
                Map.Entry<Integer, SCMCBomExpandData> bomExpandData = bomsiterator.next();
                Integer index = bomExpandData.getKey();
                SCMCBomExpandData expandData2 = bomExpandData.getValue();
                List entryDataList = expandData2.getEntryDataList();
                Iterator iterator = entryDataList.iterator();
                while (iterator.hasNext()) {
                    SCMCBomEntryData entryData = (SCMCBomEntryData)iterator.next();
                    Long entryMaterialId = entryData.getEntryMaterialId();
                    String entryMaterialNumber = entryData.getEntryMaterialNumber();
                    if (entryMaterialId == null || !materialIds.contains(entryMaterialId)) continue;
                    errorMsgs.add(String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u5c55\u5f00\u5931\u8d25\uff0c\u7ec4\u4ef6\u7f16\u7801%2$s\u4e0d\u662f\u5f53\u524d\u91c7\u8d2d\u7ec4\u7ec7\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u7269\u6599\u3002", (String)"ScPoEditPlugin_16", (String)"scmc-sctm", (Object[])new Object[0]), index + 1, entryMaterialNumber));
                    iterator.remove();
                }
                if (!entryDataList.isEmpty()) continue;
                bomsiterator.remove();
            }
        } else {
            errorMsgs.add(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u6309BOM\u5c55\u5f00\u5931\u8d25\uff0cBOM\u7ef4\u62a4\u7684\u7ec4\u4ef6\u7f16\u7801\u5747\u4e0d\u662f\u5f53\u524d\u91c7\u8d2d\u7ec4\u7ec7\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u7269\u6599\u3002", (String)"ScPoEditPlugin_17", (String)"scmc-sctm", (Object[])new Object[0]));
            bomExpandDataMap.clear();
        }
        return errorMsgs;
    }

    private String validateAndFilterExpandData(SCMCBomExpandData bomExpandData, int rowIndex, Date bizTime) {
        if (!"SUCCESS".equals(bomExpandData.getResultStatus())) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u6309BOM\u5c55\u5f00\u5931\u8d25\uff0c%2$s", (String)"ScPoEditPlugin_18", (String)"scmc-sctm", (Object[])new Object[0]), rowIndex + 1, bomExpandData.getResultMsg());
        }
        List entryDataList = bomExpandData.getEntryDataList();
        if (entryDataList == null || entryDataList.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\uff0c\u6309BOM\u5c55\u5f00\u5931\u8d25\uff0cBOM\u7ef4\u62a4\u5f02\u5e38\u3002", (String)"ScPoEditPlugin_19", (String)"scmc-sctm", (Object[])new Object[0]), rowIndex + 1);
        }
        Iterator iterator = entryDataList.iterator();
        while (iterator.hasNext()) {
            SCMCBomEntryData entryData = (SCMCBomEntryData)iterator.next();
            if (entryData == null) {
                iterator.remove();
                continue;
            }
            Date entryInvalidDate = entryData.getEntryInvalidDate();
            Date entryValidDate = entryData.getEntryValidDate();
            if (entryInvalidDate == null || entryValidDate == null) {
                iterator.remove();
                continue;
            }
            if (bizTime.compareTo(entryValidDate) < 0 || bizTime.compareTo(entryInvalidDate) > 0) {
                iterator.remove();
                continue;
            }
            Long entryMaterialId = entryData.getEntryMaterialId();
            if (entryMaterialId != null && entryMaterialId.compareTo(0L) != 0) continue;
            iterator.remove();
        }
        if (entryDataList.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u5c55\u5f00\u5931\u8d25\uff0c\u201c\u8ba2\u5355\u65e5\u671f\u201d\u4e0d\u5728BOM\u7ec4\u4ef6\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"ScPoEditPlugin_20", (String)"scmc-sctm", (Object[])new Object[0]), rowIndex + 1);
        }
        return null;
    }

    private void fillSubEntry(Map<Integer, SCMCBomExpandData> bomExpandDataMap) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection billentrys = dataEntity.getDynamicObjectCollection("billentry");
        FieldProp ownertype = (FieldProp)this.getModel().getProperty("subownertype");
        Object ownertypeDefValue = ownertype.getDefValue();
        Date delDateDefValue = TimeServiceHelper.today();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long defaultOwner = 0L;
        Long defaultDelOrg = 0L;
        if (this.isInvOrg(org)) {
            defaultOwner = this.getDefaultOwnerFromCache((Long)org.getPkValue());
            defaultDelOrg = (Long)org.getPkValue();
        }
        int currentRowIndex = 0;
        IDataEntityType subEntityType = null;
        ArrayList<Integer> fillRowIndexs = new ArrayList<Integer>(10);
        for (Map.Entry<Integer, SCMCBomExpandData> bomData : bomExpandDataMap.entrySet()) {
            List entryDataList;
            Integer rowIndex = bomData.getKey();
            currentRowIndex = rowIndex;
            SCMCBomExpandData expandData = bomData.getValue();
            if (expandData == null || (entryDataList = expandData.getEntryDataList()) == null || entryDataList.isEmpty()) continue;
            DynamicObject matEntry = (DynamicObject)billentrys.get(rowIndex.intValue());
            if (subEntityType == null) {
                subEntityType = matEntry.getDataEntityType();
            }
            DynamicObjectCollection subEntrys = matEntry.getDynamicObjectCollection("billentry_sub");
            for (int i = 0; i < entryDataList.size(); ++i) {
                SCMCBomEntryData bomEntryData = (SCMCBomEntryData)entryDataList.get(i);
                if (bomEntryData == null) continue;
                Long entryMaterialId = bomEntryData.getEntryMaterialId();
                Long entryUnitId = bomEntryData.getEntryUnitId();
                BigDecimal qty = bomEntryData.getQty();
                BigDecimal entryQtyDenominator = bomEntryData.getEntryQtyDenominator();
                BigDecimal entryQtyNumerator = bomEntryData.getEntryQtyNumerator();
                String entryQtyType = bomEntryData.getEntryQtyType();
                DynamicObject newSubEntry = subEntrys.addNew();
                newSubEntry.set("seq", (Object)(i + 1));
                newSubEntry.set("submaterial_id", (Object)entryMaterialId);
                newSubEntry.set("subbaseunit_id", (Object)entryUnitId);
                newSubEntry.set("subunit_id", (Object)entryUnitId);
                newSubEntry.set("qtynumerator", (Object)entryQtyNumerator);
                newSubEntry.set("qtydenominator", (Object)entryQtyDenominator);
                newSubEntry.set("qtytype", (Object)entryQtyType);
                newSubEntry.set("subownertype", ownertypeDefValue);
                newSubEntry.set("subdeliverdate", (Object)delDateDefValue);
                newSubEntry.set("subdeliverorg_id", (Object)defaultDelOrg);
                newSubEntry.set("subowner_id", (Object)defaultOwner);
                Map custParam = bomEntryData.getCustParam();
                if (custParam != null) {
                    newSubEntry.set("wasteformula", custParam.get("lossformula"));
                    newSubEntry.set("subauxpty", custParam.get("auxpty"));
                    newSubEntry.set("scraprate", custParam.get("varlossrate"));
                }
                fillRowIndexs.add(rowIndex);
            }
        }
        BusinessDataServiceHelper.loadRefence((Object[])new Object[]{this.getModel().getDataEntity(true)}, (IDataEntityType)this.getModel().getDataEntityType());
        for (int i = 0; i < fillRowIndexs.size(); ++i) {
            Integer rowIndex = (Integer)fillRowIndexs.get(i);
            DynamicObject matEntry = (DynamicObject)billentrys.get(rowIndex.intValue());
            ScPoHelper.updateAllSubEntry(matEntry);
            this.updateSubDelGroupQty(matEntry, rowIndex);
        }
        this.getView().updateView("billentry_sub");
    }

    private void beforeChangePrePaySetting(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        OperateOption option = operate.getOption();
        DynamicObject bill = this.getModel().getDataEntity();
        Object pkValue = bill.getPkValue();
        boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
        boolean dataChanged = this.getModel().getDataChanged();
        if (pkValue == null || pkValue.equals(0L) || !isFromDataBase || dataChanged) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u6216\u5237\u65b0\u5355\u636e\u3002", (String)"ScPoEditPlugin_24", (String)"scmc-sctm", (Object[])new Object[0]));
            return;
        }
        if (!"true".equals(option.getVariableValue("payaccordsetting", ""))) {
            boolean isOverPay = (Boolean)this.getModel().getValue("isallowoverpay");
            String billNo = (String)this.getModel().getValue("billno");
            String msg = isOverPay ? String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u662f\u201d\u66f4\u6539\u4e3a\u201c\u5426\u201d\uff0c\u4e25\u683c\u63a7\u5236\u201c\u4ed8\u6b3e\u91d1\u989d\u201d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u5355\u636e\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ScPoEditPlugin_5", (String)"scmc-sctm", (Object[])new Object[0]), billNo) : String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u5426\u201d\u66f4\u6539\u4e3a\u201c\u662f\u201d\uff0c\u5141\u8bb8\u201c\u4ed8\u6b3e\u91d1\u989d\u201d\u8d85\u8fc7\u5355\u636e\u201c\u4ef7\u7a0e\u5408\u8ba1\u201d\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ScPoEditPlugin_6", (String)"scmc-sctm", (Object[])new Object[0]), billNo);
            ConfirmCallBackListener listener = new ConfirmCallBackListener("payaccordsetting", (IFormPlugin)this);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
            e.setCancel(true);
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        key = ((AbstractOperate)args.getSource()).getOperateKey();
        operationResult = args.getOperationResult();
        var4_4 = key;
        var5_5 = -1;
        switch (var4_4.hashCode()) {
            case 1150651713: {
                if (!var4_4.equals("showsublist")) break;
                var5_5 = 0;
                break;
            }
            case -1595686171: {
                if (!var4_4.equals("subdeliver")) break;
                var5_5 = 1;
                break;
            }
            case 17424614: {
                if (!var4_4.equals("expandbom")) break;
                var5_5 = 2;
                break;
            }
            case 1748515816: {
                if (!var4_4.equals("payaccordsetting")) break;
                var5_5 = 3;
            }
        }
        switch (var5_5) {
            case 0: {
                if (!operationResult.isSuccess()) break;
                Optional.ofNullable(ScPoHelper.getSubTrackDownShowParameter((EventObject)args)).ifPresent((Consumer<FormShowParameter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$afterDoOperation$2(kd.bos.form.FormShowParameter ), (Lkd/bos/form/FormShowParameter;)V)((ScPoEditPlugin)this));
                break;
            }
            case 1: {
                if (!operationResult.isSuccess()) break;
                Optional.ofNullable(ScPoHelper.getImOutShowParameter((EventObject)args)).ifPresent((Consumer<FormShowParameter>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$afterDoOperation$3(kd.bos.form.FormShowParameter ), (Lkd/bos/form/FormShowParameter;)V)((ScPoEditPlugin)this));
                break;
            }
            case 2: {
                if (!operationResult.isSuccess()) break;
                span = Tracer.create((String)"ScPoEditPlugin", (String)"expandbom");
                var7_7 = null;
                this.afterExpandBom();
                if (span == null) break;
                if (var7_7 == null) ** GOTO lbl44
                try {
                    span.close();
                }
                catch (Throwable var8_8) {
                    var7_7.addSuppressed(var8_8);
                }
                break;
lbl44:
                // 1 sources

                span.close();
                break;
                catch (Throwable var8_9) {
                    try {
                        var7_7 = var8_9;
                        throw var8_9;
                    }
                    catch (Throwable var9_10) {
                        if (span != null) {
                            if (var7_7 != null) {
                                try {
                                    span.close();
                                }
                                catch (Throwable var10_11) {
                                    var7_7.addSuppressed(var10_11);
                                }
                            } else {
                                span.close();
                            }
                        }
                        throw var9_10;
                    }
                }
            }
            case 3: {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("billentry");
        if (entry == null) {
            return;
        }
        boolean isInvOrg = this.isInvOrg((DynamicObject)model.getValue("org"));
        for (int i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            String subType = row.getString("subtype");
            if (subType == null) {
                subType = this.getDefaultSubType(row.getDynamicObject("linetype"));
                if (!SubType.isNotInput(subType)) continue;
                row.set("billentry_sub", null);
                continue;
            }
            DynamicObjectCollection subEntry = row.getDynamicObjectCollection("billentry_sub");
            if (subEntry == null) continue;
            if (isInvOrg) {
                this.initAllSubDeliverOrg(row);
            }
            for (int j = 0; j < subEntry.size(); ++j) {
                DynamicObject subRow = (DynamicObject)subEntry.get(j);
                ScPoHelper.updateSubUnit(subRow);
                if (subRow.getDynamicObject("subowner") != null) continue;
                this.setSubOwner(this.getDefaultOwnerFromCache((Long)subRow.getDynamicObject("subdeliverorg").getPkValue()), j, i);
            }
            ScPoHelper.updateAllSubEntry(row);
        }
    }

    private String getDefaultSubType(DynamicObject lineType) {
        if (ScPoHelper.isExpenseItemLineType(lineType)) {
            return SubType.NOT_INPUT.getValue();
        }
        return (String)this.getDefaultValue("subtype");
    }

    private void beforeShowSubList(BeforeDoOperationEventArgs args) {
        if (!BillStatusEnum.AUDIT.getValue().equals(this.getModel().getValue("billstatus"))) {
            this.showTipNotification(ScPoHelper.getNoPushedMessage());
            args.setCancel(true);
            return;
        }
        if (!this.prepareSubListIds(args, true)) {
            this.showTipNotification(ScPoHelper.getNoPushedMessage());
            args.setCancel(true);
        }
    }

    private boolean prepareSubListIds(BeforeDoOperationEventArgs args, boolean filterSubType) {
        IDataModel model = this.getModel();
        StringJoiner idJoiner = new StringJoiner(",", "", "");
        int[] selectedRowIndexes = ScPoHelper.getSelectedRow(this.getControl("billentry"));
        if (selectedRowIndexes == null || selectedRowIndexes.length == 0) {
            Optional.ofNullable(model.getEntryEntity("billentry")).ifPresent(entry -> entry.forEach(row -> this.addSubListId(idJoiner, (DynamicObject)row, filterSubType)));
        } else {
            for (int index : selectedRowIndexes) {
                this.addSubListId(idJoiner, model.getEntryRowEntity("billentry", index), filterSubType);
            }
        }
        ScPoHelper.setCustomParam((EventObject)args, "sctm_scposublist", idJoiner.toString());
        return idJoiner.length() > 0;
    }

    private void addSubListId(StringJoiner idJoiner, DynamicObject row, boolean filterSubType) {
        if (!filterSubType || !ScPoHelper.isNotInput(row)) {
            idJoiner.add(row.getPkValue().toString());
        }
    }

    private void showTipNotification(String message) {
        this.getView().showTipNotification(message);
    }

    private void changeQty(int rowIndex) {
        DynamicObject entryRow = this.getEntryRow(rowIndex);
        if (!ScPoHelper.isNotInput(entryRow)) {
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)entryRow.getBigDecimal("qty"));
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)entryRow.getBigDecimal("baseqty"));
            DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection("billentry_sub");
            if (subEntry == null) {
                return;
            }
            for (int i = 0; i < subEntry.size(); ++i) {
                DynamicObject subEntryRow = (DynamicObject)subEntry.get(i);
                this.batchUpdateView(ScPoHelper.updateSubEntryRow(subEntryRow, qty, baseQty), i, rowIndex);
            }
            this.updateSubDelGroupQty(entryRow, rowIndex);
        }
    }

    private void changeUnit(int rowIndex) {
        DynamicObject entryRow = this.getEntryRow(rowIndex);
        if (!ScPoHelper.isNotInput(entryRow)) {
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)entryRow.getBigDecimal("baseqty"));
            DynamicObjectCollection subEntry = entryRow.getDynamicObjectCollection("billentry_sub");
            if (subEntry == null) {
                return;
            }
            for (int i = 0; i < subEntry.size(); ++i) {
                DynamicObject subEntryRow = (DynamicObject)subEntry.get(i);
                this.batchUpdateView(ScPoHelper.updateSubQtyRatio(subEntryRow, baseQty), i, rowIndex);
            }
            this.updateSubDelGroupQty(entryRow, rowIndex);
        }
    }

    private void calcSubEntryRow(int subRowIndex) {
        DynamicObject subEntryRow = this.getModel().getEntryRowEntity("billentry_sub", subRowIndex);
        DynamicObject parent = (DynamicObject)subEntryRow.getParent();
        this.batchUpdateView(ScPoHelper.updateSubEntryRow(subEntryRow, parent.getBigDecimal("qty"), parent.getBigDecimal("baseqty")), subRowIndex);
        int[] selectedRows = ScPoHelper.getSelectedRow(this.getControl("billentry"));
        this.updateSubDelGroupQty(parent, selectedRows.length == 0 ? 0 : selectedRows[0]);
    }

    private void calcSubBaseQty(int subRowIndex) {
        DynamicObject subEntryRow = this.getModel().getEntryRowEntity("billentry_sub", subRowIndex);
        DynamicObject parent = (DynamicObject)subEntryRow.getParent();
        this.batchUpdateView(ScPoHelper.updateSubBaseQty(subEntryRow, parent.getBigDecimal("baseqty")), subRowIndex);
        int[] selectedRows = ScPoHelper.getSelectedRow(this.getControl("billentry"));
        this.updateSubDelGroupQty(parent, selectedRows.length == 0 ? 0 : selectedRows[0]);
    }

    private void batchUpdateView(Set<String> keys, int rowIndex) {
        IFormView view = this.getView();
        for (String key : keys) {
            view.updateView(key, rowIndex);
        }
    }

    private void batchUpdateView(Set<String> keys, int subRowIndex, int rowIndex) {
        IFormView view = this.getView();
        for (String key : keys) {
            view.updateView(key, subRowIndex, rowIndex);
        }
    }

    private void changeSubMaterial(DynamicObject newValue, int rowIndex) {
        Object defaultIsControlSubQty;
        Object defaultScrapRate;
        Object defaultWasteFormula;
        Object defaultQtyDenominator;
        IDataModel model = this.getModel();
        this.stopChange();
        Object defaultQtyNumerator = this.getDefaultValue("qtynumerator");
        if (defaultQtyNumerator != null) {
            model.setValue("qtynumerator", defaultQtyNumerator, rowIndex);
        }
        if ((defaultQtyDenominator = this.getDefaultValue("qtydenominator")) != null) {
            model.setValue("qtydenominator", defaultQtyDenominator, rowIndex);
        }
        if ((defaultWasteFormula = this.getDefaultValue("wasteformula")) != null) {
            model.setValue("wasteformula", defaultWasteFormula, rowIndex);
        }
        if ((defaultScrapRate = this.getDefaultValue("scraprate")) != null) {
            model.setValue("scraprate", defaultScrapRate, rowIndex);
        }
        if ((defaultIsControlSubQty = this.getDefaultValue("iscontrolsubqty")) != null) {
            model.setValue("iscontrolsubqty", defaultIsControlSubQty, rowIndex);
        }
        this.clearSubRateUpDown(Boolean.FALSE, rowIndex);
        this.initSubUnit(newValue, rowIndex);
        this.startChange();
        this.calcSubEntryRow(rowIndex);
    }

    private void changeSubType(String oldValue, String newValue, int rowIndex) {
        if (StringUtils.isBlank((CharSequence)newValue)) {
            return;
        }
        DynamicObject bom = (DynamicObject)this.getModel().getValue("bom", rowIndex);
        if (this.existSubEntry(rowIndex)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(SUB_TYPE_CONFIRM, "");
            String subTypeName = SubType.INPUT.getValue().equals(newValue) ? SubType.INPUT.getName() : (SubType.NOT_INPUT.getValue().equals(newValue) ? SubType.NOT_INPUT.getName() : SubType.BOM.getName());
            String confirmMsg = String.format(ResManager.loadKDString((String)"\u4fee\u6539\u6295\u6599\u65b9\u5f0f\u4e3a\u201c%s\u201d\uff0c\u5c06\u6e05\u9664\u5f53\u524d\u53d1\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"ScPoEditPlugin_22", (String)"scmc-sctm", (Object[])new Object[0]), subTypeName);
            if (bom == null) {
                this.getView().showConfirm(confirmMsg, null, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, Optional.ofNullable(oldValue).orElse("") + "," + rowIndex);
            } else if ((SubType.isNotInput(newValue) || SubType.INPUT.getValue().equals(newValue)) && bom != null) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u6295\u6599\u65b9\u5f0f\uff0c\u5c06\u6e05\u9664BOM\u7f16\u7801\u548c\u53d1\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u4fee\u6539\uff1f", (String)"ScPoEditPlugin_21", (String)"scmc-sctm", (Object[])new Object[0]), null, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks, null, Optional.ofNullable(oldValue).orElse("") + "," + rowIndex);
            }
        } else if (SubType.BOM.getValue().equals(newValue)) {
            this.setDefBom(rowIndex, newValue);
        } else if (bom != null) {
            this.stopChange();
            this.getModel().setValue("bom", null, rowIndex);
            this.startChange();
        }
    }

    private void setDefBom(int rowIndex, String subType) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material", rowIndex);
        if (material == null || !SubType.BOM.getValue().equals(subType)) {
            return;
        }
        DynamicObject masterid = material.getDynamicObject("masterid");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (masterid == null || org == null) {
            return;
        }
        Long defaultBom = ScPoHelper.getDefaultBom((Long)masterid.getPkValue(), (Long)org.getPkValue());
        if (defaultBom != null) {
            this.stopChange();
            this.getModel().setValue("bom", (Object)defaultBom, rowIndex);
            this.startChange();
        }
    }

    private boolean existSubEntry(int entryRowIndex) {
        DynamicObjectCollection subEntry = this.getSubEntry(entryRowIndex);
        String entityNo = this.getModel().getDataEntityType().getName();
        if ("sctm_scpo".equals(entityNo)) {
            return subEntry != null && !subEntry.isEmpty();
        }
        if (subEntry == null || subEntry.isEmpty()) {
            return false;
        }
        for (DynamicObject subRow : subEntry) {
            String changeType = subRow.getString("subentrychangetype");
            if (changeType == null || !ChangeTypeEnum.UPDATE.getValue().equals(changeType) && !ChangeTypeEnum.ADDNEW.getValue().equals(changeType)) continue;
            return true;
        }
        return false;
    }

    private void clearSubEntry(int entryRow) {
        DynamicObject row = this.getEntryRow(entryRow);
        String entityNo = this.getModel().getDataEntityType().getName();
        if ("sctm_scpo".equals(entityNo)) {
            row.set("billentry_sub", null);
        } else {
            DynamicObjectCollection subEntrys = row.getDynamicObjectCollection("billentry_sub");
            if (subEntrys == null || subEntrys.isEmpty()) {
                return;
            }
            Iterator subIterator = subEntrys.iterator();
            while (subIterator.hasNext()) {
                DynamicObject subEntry = (DynamicObject)subIterator.next();
                if (ChangeTypeEnum.UPDATE.getValue().equals(subEntry.getString("subentrychangetype"))) {
                    subEntry.set("subentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue());
                    continue;
                }
                if (!ChangeTypeEnum.ADDNEW.getValue().equals(subEntry.getString("subentrychangetype"))) continue;
                subIterator.remove();
            }
        }
        this.getView().updateView("billentry_sub");
    }

    private DynamicObjectCollection getSubEntry(int entryRowIndex) {
        return this.getEntryRow(entryRowIndex).getDynamicObjectCollection("billentry_sub");
    }

    private DynamicObject getEntryRow(int entryRowIndex) {
        return this.getModel().getEntryRowEntity("billentry", entryRowIndex);
    }

    private DynamicObject getSubEntryRow(int subEntryRowIndex) {
        return this.getModel().getEntryRowEntity("billentry_sub", subEntryRowIndex);
    }

    private void initSubType(DynamicObjectCollection entry) {
        for (DynamicObject row : entry) {
            if (!ScPoHelper.isExpenseItemLineType(row.getDynamicObject("linetype"))) continue;
            row.set("subtype", (Object)SubType.NOT_INPUT.getValue());
        }
    }

    private void initSubUnit(DynamicObject subMaterial, int subRowIndex) {
        IDataModel model = this.getModel();
        DynamicObject subBaseUnit = ScPoHelper.getDefaultUnit(subMaterial);
        model.setValue("subbaseunit", (Object)subBaseUnit, subRowIndex);
        model.setValue("subunit", (Object)subBaseUnit, subRowIndex);
    }

    private void initSubEntryRow(RowDataEntity[] rowDataEntities) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (!this.isInvOrg(org)) {
            return;
        }
        Long defaultOwner = this.getDefaultOwnerFromCache((Long)org.getPkValue());
        for (RowDataEntity dataEntity : rowDataEntities) {
            int index = dataEntity.getRowIndex();
            if (model.getValue("subdeliverorg", index) == null) {
                model.setValue("subdeliverorg", (Object)org, index);
            }
            if (defaultOwner != null && model.getValue("subowner", index) == null) {
                this.setSubOwner(defaultOwner, index);
            }
            this.calcSubEntryRow(index);
        }
    }

    private void initAllSubDeliverOrg(DynamicObject row) {
        DynamicObjectCollection subEntry = row.getDynamicObjectCollection("billentry_sub");
        if (subEntry != null && !subEntry.isEmpty()) {
            IDataModel model = this.getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                return;
            }
            for (DynamicObject subRow : subEntry) {
                if (subRow.getDynamicObject("subdeliverorg") != null) continue;
                subRow.set("subdeliverorg", (Object)org);
            }
        }
    }

    private void initAllSubOwner(int ... rowIndexes) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        for (int rowIndex : rowIndexes) {
            DynamicObjectCollection subEntry = this.getSubEntry(rowIndex);
            if (subEntry == null || subEntry.isEmpty()) continue;
            Long defaultOwner = this.getDefaultOwnerFromCache((Long)org.getPkValue());
            if (defaultOwner == null) {
                return;
            }
            for (int i = 0; i < subEntry.size(); ++i) {
                this.setSubOwner(defaultOwner, i, rowIndex);
            }
        }
    }

    private void initSubOwner(DynamicObject org, int subRowIndex) {
        Long defaultOwner = org == null ? null : this.getDefaultOwnerFromCache((Long)org.getPkValue());
        this.setSubOwner(defaultOwner, subRowIndex);
    }

    private void setSubOwner(Long defaultOwner, int subRowIndex) {
        if (ScPoHelper.canUpdateSubOwner((String)this.getModel().getValue("subownertype", subRowIndex))) {
            this.getModel().setValue("subowner", (Object)defaultOwner, subRowIndex);
        }
    }

    private void setSubOwner(Long defaultOwner, int subRowIndex, int rowIndex) {
        if (ScPoHelper.canUpdateSubOwner((String)this.getModel().getValue("subownertype", subRowIndex, rowIndex))) {
            this.getModel().setValue("subowner", (Object)defaultOwner, subRowIndex, rowIndex);
        }
    }

    private boolean isInvOrg(DynamicObject org) {
        if (org == null) {
            return false;
        }
        Long orgId = (Long)org.getPkValue();
        Boolean isInvOrg = this.isInvOrgCache.get(orgId);
        if (isInvOrg == null) {
            isInvOrg = ScPoHelper.isInvOrg((Long)org.getPkValue());
            this.isInvOrgCache.put(orgId, isInvOrg);
        }
        return isInvOrg;
    }

    private boolean isLockSubEntry(int entryRowIndex) {
        return SubType.isNotInput((String)this.getModel().getValue("subtype", entryRowIndex));
    }

    private void clearSubRateUpDown(Boolean isControlSubQty, int rowIndex) {
        if (isControlSubQty == null || !isControlSubQty.booleanValue()) {
            IDataModel model = this.getModel();
            model.setValue("subrateup", null, rowIndex);
            model.setValue("subratedown", null, rowIndex);
        }
    }

    private void registerBeforeF7SelectListener(String ... controlNames) {
        for (String name : controlNames) {
            Optional.ofNullable(this.getControl(name)).ifPresent(control -> ((BasedataEdit)control).addBeforeF7SelectListener((BeforeF7SelectListener)this));
        }
    }

    private void stopChange() {
        this.getPageCache().put("stopChange", "true");
    }

    private void startChange() {
        this.getPageCache().put("stopChange", "false");
    }

    private void updateSubDelGroupQty(DynamicObject row, int rowIndex) {
        this.batchUpdateView(ScPoHelper.updateSubDelGroupQty(row), rowIndex);
    }

    private Long getDefaultOwnerFromCache(Long orgId) {
        if (orgId == null) {
            return null;
        }
        Long ownerId = this.orgOwnerCache.get(orgId);
        if (ownerId == null) {
            ownerId = OwnerHelper.getDefaultOwner((Long)orgId);
            this.orgOwnerCache.put(orgId, ownerId == null ? Long.valueOf(0L) : ownerId);
        } else if (ownerId == 0L) {
            ownerId = null;
        }
        return ownerId;
    }

    private Object getDefaultValue(String propertyName) {
        FieldProp prop = (FieldProp)this.getModel().getProperty(propertyName);
        if (prop == null) {
            return null;
        }
        return prop.getDefValue();
    }

    private boolean isImport() {
        IPageCache pageCache = this.getPageCache();
        return pageCache != null && "1".equals(pageCache.get("billcretype"));
    }

    private /* synthetic */ void lambda$afterDoOperation$3(FormShowParameter showParameter) {
        this.getView().showForm(showParameter);
    }

    private /* synthetic */ void lambda$afterDoOperation$2(FormShowParameter showParameter) {
        this.getView().showForm(showParameter);
    }
}

