/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.CurrencyHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.enums.DiscountTypeEnum;
import kd.mpscmm.msbd.common.enums.ExchangeTypeEnum;
import kd.mpscmm.msbd.common.enums.OwnerTypeEnum;
import kd.mpscmm.msbd.common.enums.PayModeEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.BillCreTypeUtils;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.mspur.business.BizCategoryHelper;
import kd.mpscmm.mspur.business.PoTplHelper;
import kd.mpscmm.mspur.business.SupplierHelper;
import kd.mpscmm.mspur.common.enums.SupplierFunction;
import kd.scmc.sctm.business.ScPoHelper;
import kd.scmc.sctm.common.enums.SubType;

public class ScPoImportPlugin
extends AbstractFormPlugin {
    public static final String PERMISSION_ORG_CACHE_KEY = "hasPermissionOrg";
    private final Map<String, Object> tempCache = new HashMap<String, Object>();

    public void initImportData(InitImportDataEventArgs e) {
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        this.getPageCache().put("billcretype", "1");
        IDataModel model = (IDataModel)e.getSource();
        List<Long> hasPermissionOrg = (List<Long>)this.tempCache.get(PERMISSION_ORG_CACHE_KEY);
        if (hasPermissionOrg == null) {
            hasPermissionOrg = this.getHasPermissionOrg(model.getDataEntityType().getName());
            this.tempCache.put(PERMISSION_ORG_CACHE_KEY, hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map sourceData;
        String paymode;
        QFilter operatorgroupOrgFilter;
        Map supplierMap;
        QFilter supplierOrgFilter;
        DynamicObject billtypeparameter;
        String billcretype = this.getPageCache().get("billcretype");
        if (this.isSkip(billcretype)) {
            return;
        }
        DynamicObject org = this.getBaseDataFromCache(e.getSourceData(), "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get(PERMISSION_ORG_CACHE_KEY);
        if (hasPermissionOrg == null || !hasPermissionOrg.contains((Long)org.getPkValue())) {
            Object orgs = e.getSourceData().get("org");
            Map propMap = BillCreTypeUtils.format4ImportAndApi(orgs);
            if (propMap != null) {
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u3010%1$s\u3011\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"ScPoImportPlugin_0", (String)"scmc-sctm", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            }
            e.setCancel(true);
            e.setFireAfterImportData(false);
            return;
        }
        DynamicObject billType = this.getBillType(e.getSourceData());
        if (billType == null) {
            return;
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!billType.getDynamicObject("billformid").getPkValue().equals(formId)) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u4e0d\u7b26\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ScPoImportPlugin_1", (String)"scmc-sctm", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        Map billtypeMap = BillCreTypeUtils.format4ImportAndApi(e.getSourceData().get("billtype"));
        if (billtypeMap != null && (billtypeparameter = (DynamicObject)this.tempCache.get("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")))) == null) {
            billtypeparameter = (DynamicObject)SystemParamServiceHelper.getBillTypeParameter((String)formId, (String)"pm_billtypeparameter", (long)((Long)billType.getPkValue()));
            this.tempCache.put("billtypeparameter" + billtypeMap.get(billtypeMap.get("importprop")), billtypeparameter);
        }
        if ((supplierOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_supplierOrgFilter")) == null) {
            supplierOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_supplierOrgFilter", supplierOrgFilter);
        }
        if ((supplierMap = BillCreTypeUtils.format4ImportAndApi(e.getSourceData().get("supplier"))) != null) {
            if (!this.validSupplier(e, "supplier", SupplierFunction.PURCHASE, org)) {
                return;
            }
            DynamicObject bizType = this.getBizType(e.getSourceData());
            if (bizType != null && BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue())) && !this.getSupplier(e.getSourceData(), supplierMap, "supplier", org).getBoolean("enablevmi")) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%1$s\u201d\u4e0d\u5c5e\u4e8e\u53efVMI\u7684\u4f9b\u5e94\u5546\u3002", (String)"ScPoImportPlugin_3", (String)"scmc-sctm", (Object[])new Object[0]), supplierMap.get(supplierMap.get("importprop"))));
                e.setFireAfterImportData(false);
                return;
            }
        }
        if (!this.validSupplier(e, "providersupplier", SupplierFunction.DELIVER, org)) {
            return;
        }
        if (!this.validSupplier(e, "invoicesupplier", SupplierFunction.INVOICE, org)) {
            return;
        }
        if (!this.validSupplier(e, "receivesupplier", SupplierFunction.RECEIVE, org)) {
            return;
        }
        Map operatorGroupMap = BillCreTypeUtils.format4ImportAndApi(e.getSourceData().get("operatorgroup"));
        Map operatorMap = BillCreTypeUtils.format4ImportAndApi(e.getSourceData().get("operator"));
        if (operatorGroupMap != null && operatorMap != null) {
            operatorgroupOrgFilter = this.getOperatorGroupOrgFilter(org);
            DynamicObject operatorGroup = this.getBaseDataFromCache(e.getSourceData(), "operatorgroup", "bd_operatorgroup", "id,operatornumber,operatorname", new QFilter[]{new QFilter((String)operatorGroupMap.get("importprop"), "=", operatorGroupMap.get(operatorGroupMap.get("importprop"))), operatorgroupOrgFilter});
            if (operatorGroup != null && operatorMap.get(operatorMap.get("importprop")) != null) {
                DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                for (DynamicObject operator : entryentity) {
                    if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                    HashMap<String, Object> newOperator = new HashMap<String, Object>();
                    newOperator.put("id", operator.getPkValue());
                    e.getSourceData().put("operator", newOperator);
                    break;
                }
            }
        } else if (operatorMap != null) {
            operatorgroupOrgFilter = this.getOperatorGroupOrgFilter(org);
            QFilter operatorgroupTypeFilter = new QFilter("operatorgrouptype", "=", (Object)"CGZ");
            Map operatorgroups = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,operatornumber,operatorname", (QFilter[])new QFilter[]{operatorgroupOrgFilter, operatorgroupTypeFilter});
            boolean flag = true;
            block1: for (DynamicObject operatorGroup : operatorgroups.values()) {
                DynamicObjectCollection entryentity = operatorGroup.getDynamicObjectCollection("entryentity");
                for (DynamicObject operator : entryentity) {
                    if (!operatorMap.get(operatorMap.get("importprop")).equals(operator.getString((String)operatorMap.get("importprop")))) continue;
                    HashMap<String, Object> newOperator = new HashMap<String, Object>();
                    newOperator.put("id", operator.getPkValue());
                    e.getSourceData().put("operator", newOperator);
                    HashMap<String, Object> newOperatorGroup = new HashMap<String, Object>();
                    newOperatorGroup.put("id", operatorGroup.getPkValue());
                    e.getSourceData().put("operatorgroup", newOperatorGroup);
                    flag = false;
                    continue block1;
                }
            }
            if (flag) {
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u5458\u201c%1$s\u201d\u6ca1\u6709\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u3002", (String)"ScPoImportPlugin_4", (String)"scmc-sctm", (Object[])new Object[0]), operatorMap.get(operatorMap.get("importprop"))));
                e.setFireAfterImportData(false);
            }
        }
        if ((paymode = (String)(sourceData = e.getSourceData()).get("paymode")) != null && !PayModeEnum.CREDIT.getValue().equals(paymode) && !PayModeEnum.CASH.getValue().equals(paymode)) {
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(0), ResManager.loadKDString((String)"\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u7b26\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ScPoImportPlugin_5", (String)"scmc-sctm", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        DynamicObject defaultLineType = this.getDefaultLineType(sourceData, (Long)billType.getPkValue());
        List<Map<String, Object>> entry = this.getEntry(sourceData);
        for (int i = 0; i < entry.size(); ++i) {
            String subTypeName;
            Map<String, Object> map = entry.get(i);
            String subType = (String)map.get("subtype");
            if (SubType.isNotInput(subType)) {
                if (!this.existSubEntry(map.get("billentry_sub"))) continue;
                this.cancel(e, ResManager.loadKDString((String)"\u6295\u6599\u65b9\u5f0f\u4e3a\u4e0d\u6295\u6599\uff0c\u53d1\u6599\u660e\u7ec6\u4e0d\u80fd\u6709\u503c\u3002", (String)"ScPoImportPlugin_6", (String)"scmc-sctm", (Object[])new Object[0]), i, 0);
                return;
            }
            if (!SubType.INPUT.getValue().equals(subType) && !SubType.BOM.getValue().equals(subType)) continue;
            DynamicObject lineType = this.getLineType(map);
            if (lineType == null) {
                lineType = defaultLineType;
            }
            String string = subTypeName = SubType.INPUT.getValue().equals(subType) ? ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165", (String)"ScPoImportPlugin_19", (String)"scmc-sctm", (Object[])new Object[0]) : "BOM";
            if (ScPoHelper.isExpenseItemLineType(lineType)) {
                this.cancel(e, String.format(ResManager.loadKDString((String)"\u884c\u7c7b\u578b\u4e3a\u201c\u8d39\u7528\u9879\u76ee\u201d\u65f6\uff0c\u6295\u6599\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u201c%1$S\u201d\u3002", (String)"ScPoImportPlugin_20", (String)"scmc-sctm", (Object[])new Object[0]), subTypeName), i, 0);
                return;
            }
            List<Map<String, Object>> subEntry = this.getSubEntry(map);
            if (subEntry.isEmpty()) {
                this.cancel(e, String.format(ResManager.loadKDString((String)"\u6295\u6599\u65b9\u5f0f\u4e3a%1$S\uff0c\u8bf7\u5f55\u5165\u53d1\u6599\u660e\u7ec6\u3002", (String)"ScPoImportPlugin_21", (String)"scmc-sctm", (Object[])new Object[0]), subTypeName), i, 0);
                return;
            }
            for (int j = 0; j < subEntry.size(); ++j) {
                Map<String, Object> subMap = subEntry.get(j);
                if (!subMap.containsKey("submaterial")) {
                    this.cancel(e, String.format(ResManager.loadKDString((String)"\u6295\u6599\u65b9\u5f0f\u4e3a%1$S\u65f6\uff0c\u7ec4\u4ef6\u7f16\u7801\u5fc5\u5f55\u3002", (String)"ScPoImportPlugin_22", (String)"scmc-sctm", (Object[])new Object[0]), subTypeName), i, j);
                    return;
                }
                if (!subMap.containsKey("subunit")) {
                    this.cancel(e, String.format(ResManager.loadKDString((String)"\u6295\u6599\u65b9\u5f0f\u4e3a%1$S\u65f6\uff0c\u53d1\u6599\u660e\u7ec6\u4e2d\u7684\u8ba1\u91cf\u5355\u4f4d\u5fc5\u5f55\u3002", (String)"ScPoImportPlugin_23", (String)"scmc-sctm", (Object[])new Object[0]), subTypeName), i, j);
                    return;
                }
                if (!subMap.containsKey("subdeliverorg")) {
                    this.cancel(e, String.format(ResManager.loadKDString((String)"\u6295\u6599\u65b9\u5f0f\u4e3a%1$S\u65f6\uff0c\u53d1\u6599\u7ec4\u7ec7\u5fc5\u5f55\u3002", (String)"ScPoImportPlugin_24", (String)"scmc-sctm", (Object[])new Object[0]), subTypeName), i, j);
                    return;
                }
                if (subMap.containsKey("qtynumerator")) continue;
                this.cancel(e, String.format(ResManager.loadKDString((String)"\u6295\u6599\u65b9\u5f0f\u4e3a%1$S\u65f6\uff0c\u5b9a\u989d\u5206\u5b50\u5fc5\u5f55\u3002", (String)"ScPoImportPlugin_25", (String)"scmc-sctm", (Object[])new Object[0]), subTypeName), i, j);
                return;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String exchangeType;
        Long settleCurrencyId;
        Long currencyId;
        Long exRateTableId;
        Date exRateDate;
        Date bizTime;
        DynamicObject dept;
        Long bizTypeId;
        String billCreType = this.getPageCache().get("billcretype");
        if (this.isSkip(billCreType)) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue("billcretype", (Object)"1");
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        if (billType != null && bizType == null && (bizTypeId = this.getDefaultBizTypeFromCache((Long)billType.getPkValue())) != null) {
            model.setValue("biztype", (Object)bizTypeId);
        }
        if ((dept = (DynamicObject)model.getValue("dept")) == null) {
            DynamicObject operator = (DynamicObject)model.getValue("operator");
            Long deptID = this.getMainDeptByOperatorFromCache(operator);
            model.setValue("dept", (Object)deptID);
        }
        if ((bizTime = (Date)model.getValue("biztime")) == null) {
            model.setValue("biztime", (Object)TimeServiceHelper.today());
        }
        model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        if (supplier != null) {
            if (model.getValue("providersupplier") == null) {
                model.setValue("providersupplier", (Object)SupplierHelper.getOtherSupplier((DynamicObject)supplier, (String)"deliversupplierid"));
            }
            if (model.getValue("invoicesupplier") == null) {
                model.setValue("invoicesupplier", (Object)SupplierHelper.getOtherSupplier((DynamicObject)supplier, (String)"invoicesupplierid"));
            }
            if (model.getValue("receivesupplier") == null) {
                model.setValue("receivesupplier", (Object)SupplierHelper.getOtherSupplier((DynamicObject)supplier, (String)"receivingsupplierid"));
            }
        }
        if ((exRateDate = (Date)model.getValue("exratedate")) == null) {
            exRateDate = bizTime;
            model.setValue("exratedate", (Object)exRateDate);
        }
        DynamicObject exRateTable = (DynamicObject)model.getValue("exratetable");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject settleCurrency = (DynamicObject)model.getValue("settlecurrency");
        BigDecimal exChangeRate = (BigDecimal)model.getValue("exchangerate");
        if (exRateTable == null) {
            exRateTableId = this.getCurrencyOrExRateTableFromCache((Long)org.getPkValue(), org.getPkValue() + "-exRateMap", "exchangeRateTableID");
            if (exRateTableId != null) {
                model.setValue("exratetable", (Object)exRateTableId);
            }
        } else {
            exRateTableId = (Long)exRateTable.getPkValue();
        }
        if (currency == null) {
            currencyId = this.getCurrencyOrExRateTableFromCache((Long)org.getPkValue(), org.getPkValue() + "-currencyMap", "baseCurrencyID");
            if (currencyId != null) {
                model.setValue("currency", (Object)currencyId);
            }
        } else {
            currencyId = (Long)currency.getPkValue();
        }
        if (settleCurrency == null) {
            settleCurrencyId = currencyId;
            model.setValue("settlecurrency", (Object)settleCurrencyId);
            exChangeRate = BigDecimal.ONE;
            model.setValue("exchangerate", (Object)exChangeRate);
            exchangeType = ExchangeTypeEnum.DIRECT.getValue();
            model.setValue("exchangetype", (Object)exchangeType);
        } else {
            settleCurrencyId = (Long)settleCurrency.getPkValue();
        }
        Map exRateMap = CurrencyHelper.getExChangeRateMap((Long)settleCurrencyId, (Long)currencyId, (Long)exRateTableId, (Date)exRateDate);
        BigDecimal exRate = (BigDecimal)exRateMap.get("exchangerate");
        exchangeType = (String)exRateMap.get("exchangetype");
        model.setValue("exchangetype", (Object)exchangeType);
        if (BigDecimalUtil.isBlank((BigDecimal)exChangeRate)) {
            model.setValue("exchangerate", (Object)exRate);
        }
        DynamicObject defaultLineType = null;
        bizType = (DynamicObject)model.getValue("biztype");
        if (bizType != null) {
            defaultLineType = this.getDefaultLineType((Long)bizType.getPkValue());
        }
        DynamicObjectCollection billEntries = (DynamicObjectCollection)model.getValue("billentry");
        Map totalAmountMap = null;
        if (billEntries != null) {
            for (DynamicObject row : billEntries) {
                DynamicObject taxRateId;
                Object discountType;
                DynamicObject material;
                int index = row.getInt("seq") - 1;
                DynamicObject lineType = row.getDynamicObject("linetype");
                if (lineType == null && defaultLineType != null) {
                    row.set("linetype", (Object)defaultLineType);
                }
                if (bizType != null) {
                    if (BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue()))) {
                        model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue(), index);
                        model.setValue("owner", model.getValue("supplier"), index);
                    } else {
                        model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_ORG.getValue(), index);
                        DynamicObject owner = row.getDynamicObject("owner");
                        if (owner == null) {
                            model.setValue("owner", (Object)PoTplHelper.getOrgOwner((IDataModel)this.getModel(), (IFormView)this.getView(), (int)index), index);
                        }
                    }
                }
                if (row.get("deliverdate") == null) {
                    row.set("deliverdate", (Object)bizTime);
                }
                if ((material = row.getDynamicObject("material")) == null || material.getDynamicObject("masterid") == null) continue;
                DynamicObject materialMasterID = material.getDynamicObject("masterid");
                model.setValue("materialmasterid", materialMasterID.getPkValue(), index);
                boolean isDisposable = materialMasterID.getBoolean("isdisposable");
                if (StringUtils.isBlank((Object)row.get("materialname")) || !isDisposable) {
                    row.set("materialname", (Object)materialMasterID.getLocaleString("name").toString());
                }
                row.set("baseunit", (Object)material.getDynamicObject("masterid").getDynamicObject("baseunit"));
                DynamicObject unit = row.getDynamicObject("unit");
                DynamicObject baseUnit = row.getDynamicObject("baseunit");
                if (unit == null) {
                    unit = material.getDynamicObject("purchaseunit");
                    row.set("unit", (Object)unit);
                }
                if (unit != null && baseUnit != null) {
                    if (unit.getPkValue().equals(baseUnit.getPkValue())) {
                        row.set("baseqty", (Object)row.getBigDecimal("qty"));
                    } else {
                        row.set("baseqty", (Object)BillQuantityHelper.getDesQtyConv((Long)((Long)material.getDynamicObject("masterid").getPkValue()), (DynamicObject)unit, (BigDecimal)row.getBigDecimal("qty"), (DynamicObject)baseUnit));
                    }
                }
                BigDecimal disCountRate = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("discountrate"));
                if (row.getString("discounttype").equals(DiscountTypeEnum.DISRATE.getValue())) {
                    if (BigDecimalUtil.largeThan((BigDecimal)disCountRate, (BigDecimal)BigDecimalUtil.HUNDRED)) {
                        row.set("discountrate", (Object)BigDecimalUtil.HUNDRED);
                    } else if (!BigDecimalUtil.largeZero((BigDecimal)disCountRate)) {
                        row.set("discountrate", (Object)BigDecimalUtil.ZERO);
                    }
                }
                if ((discountType = row.get("discounttype")).equals(DiscountTypeEnum.NULL.getValue())) {
                    row.set("discountrate", (Object)BigDecimalUtil.ZERO);
                }
                if ((taxRateId = row.getDynamicObject("taxrateid")) == null) {
                    row.set("taxrate", (Object)BigDecimalUtil.ZERO);
                } else {
                    BigDecimal taxRate = taxRateId.getBigDecimal("taxrate");
                    row.set("taxrate", (Object)taxRate);
                }
                this.initQtyUpDown(row);
            }
            totalAmountMap = PoTplHelper.calBillAmount((DynamicObject)model.getDataEntity(true));
        }
        if (totalAmountMap == null) {
            model.setValue("totalamount", (Object)BigDecimalUtil.ZERO);
            model.setValue("totaltaxamount", (Object)BigDecimalUtil.ZERO);
            model.setValue("totalallamount", (Object)BigDecimalUtil.ZERO);
        } else {
            for (Map.Entry entry : totalAmountMap.entrySet()) {
                model.setValue((String)entry.getKey(), entry.getValue());
            }
        }
        this.initPayEntry();
    }

    private DynamicObject getDefaultLineType(Long bizTypeId) {
        Long lineTypeId = BizTypeHelper.getDefaultLineType((Long)bizTypeId);
        if (lineTypeId != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
        }
        return null;
    }

    private Long getDefaultBizTypeFromCache(Long billTypeId) {
        Long bizTypeId = (Long)this.tempCache.get(billTypeId + "-biztype");
        if (bizTypeId == null && (bizTypeId = BizTypeHelper.getDefaultBizType((String)this.getView().getEntityId(), (Long)billTypeId, (String)"pm_billtypeparameter")) != null) {
            this.tempCache.put(billTypeId + "-biztype", bizTypeId);
        }
        return bizTypeId;
    }

    private void initPayEntry() {
        IDataModel model = this.getModel();
        int payPlanRowCount = model.getEntryRowCount("billentry_pay");
        DynamicObject payCondition = (DynamicObject)model.getValue("paycondition");
        if (payCondition != null && payPlanRowCount == 0) {
            AmountPlanHelper.changeAmountConditionForView((CommonContext)PoTplHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
        }
    }

    private void initQtyUpDown(DynamicObject row) {
        Boolean isControlQty = (Boolean)row.get("iscontrolqty");
        if (isControlQty != null && !isControlQty.booleanValue()) {
            row.set("receiverateup", (Object)BigDecimalUtil.ZERO);
            row.set("receiveratedown", (Object)BigDecimalUtil.ZERO);
        }
        PoTplHelper.calcReceiveQtyUpDown((DynamicObject)row);
    }

    private Long getMainDeptByOperatorFromCache(DynamicObject operator) {
        Long deptID = null;
        if (operator != null) {
            Long operatorID = (Long)operator.getPkValue();
            deptID = (Long)this.tempCache.get("operator&" + operatorID + "&dept");
            if (deptID == null) {
                Long userID;
                operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operatorID, (String)"bd_operator", (String)"id,operatorid");
                Long l = userID = operator.get("operatorid") != null ? (Long)((DynamicObject)operator.get("operatorid")).getPkValue() : null;
                if (userID != null) {
                    deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    this.tempCache.put("operator&" + operatorID + "&dept", deptID);
                }
            }
        }
        return deptID;
    }

    private Long getCurrencyOrExRateTableFromCache(Long orgId, String cacheKey, String currencyKey) {
        Map exRateMap = (Map)this.tempCache.get(cacheKey);
        if (exRateMap == null && (exRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId)) != null) {
            this.tempCache.put(cacheKey, exRateMap);
        }
        if (exRateMap != null) {
            return (Long)exRateMap.get(currencyKey);
        }
        return null;
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillCreTypeUtils.format4ImportAndApi((Object)sourceData.get(propName));
        if (propMap != null) {
            String importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", propMap.get(importProp))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }

    private QFilter getOperatorGroupOrgFilter(DynamicObject org) {
        QFilter baseDataOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_" + "operatorgroup" + "OrgFilter");
        if (baseDataOrgFilter == null) {
            baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_" + "operatorgroup" + "OrgFilter", baseDataOrgFilter);
        }
        return baseDataOrgFilter;
    }

    private List<Long> getHasPermissionOrg(String entityName) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)"02");
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    private boolean isSkip(String billCreType) {
        return "2".equals(billCreType);
    }

    private List<Map<String, Object>> getSubEntry(Map<String, Object> rowMap) {
        Object subObj = rowMap.get("billentry_sub");
        if (subObj instanceof List) {
            return (List)subObj;
        }
        return Collections.emptyList();
    }

    private DynamicObject getLineType(Map<String, Object> map) {
        return this.getBaseDataFromCache(map, "linetype", "bd_linetype", "id,serviceattribute", null);
    }

    private DynamicObject getBillType(Map<String, Object> sourceData) {
        return this.getBaseDataFromCache(sourceData, "billtype", "bos_billtype", "billformid", null);
    }

    private DynamicObject getDefaultLineType(Map<String, Object> sourceData, Long billTypeId) {
        DynamicObject bizType = this.getBizType(sourceData);
        Long bizTypeId = bizType == null ? this.getDefaultBizTypeFromCache(billTypeId) : (Long)bizType.getPkValue();
        return this.getDefaultLineType(bizTypeId);
    }

    private DynamicObject getBizType(Map<String, Object> sourceData) {
        return this.getBaseDataFromCache(sourceData, "biztype", "bd_biztype", null, null);
    }

    private DynamicObject getSupplier(Map<String, Object> dataMap, Map<?, ?> supplierMap, String key, DynamicObject org) {
        QFilter supplierOrgFilter = (QFilter)this.tempCache.get(org.getPkValue() + "_supplierOrgFilter");
        if (supplierOrgFilter == null) {
            supplierOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_supplier", (Long)((Long)org.getPkValue()));
            this.tempCache.put(org.getPkValue() + "_supplierOrgFilter", supplierOrgFilter);
        }
        return this.getBaseDataFromCache(dataMap, key, "bd_supplier", "id,enablevmi,bizfunction", new QFilter[]{new QFilter((String)supplierMap.get("importprop"), "=", supplierMap.get(supplierMap.get("importprop"))), supplierOrgFilter});
    }

    private boolean validSupplier(BeforeImportDataEventArgs e, String key, SupplierFunction function, DynamicObject org) {
        String supplierPrefix;
        switch (function) {
            case PURCHASE: {
                supplierPrefix = ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546", (String)"ScPoImportPlugin_15", (String)"scmc-sctm", (Object[])new Object[0]);
                break;
            }
            case DELIVER: {
                supplierPrefix = ResManager.loadKDString((String)"\u4f9b\u8d27\u4f9b\u5e94\u5546", (String)"ScPoImportPlugin_16", (String)"scmc-sctm", (Object[])new Object[0]);
                break;
            }
            case INVOICE: {
                supplierPrefix = ResManager.loadKDString((String)"\u7ed3\u7b97\u4f9b\u5e94\u5546", (String)"ScPoImportPlugin_17", (String)"scmc-sctm", (Object[])new Object[0]);
                break;
            }
            case RECEIVE: {
                supplierPrefix = ResManager.loadKDString((String)"\u6536\u6b3e\u4f9b\u5e94\u5546", (String)"ScPoImportPlugin_18", (String)"scmc-sctm", (Object[])new Object[0]);
                break;
            }
            default: {
                supplierPrefix = "";
            }
        }
        Map data = e.getSourceData();
        Map supplierMap = BillCreTypeUtils.format4ImportAndApi(data.get(key));
        if (supplierMap == null) {
            return true;
        }
        Object importValue = supplierMap.get(supplierMap.get("importprop"));
        DynamicObject supplier = this.getSupplier(data, supplierMap, key, org);
        if (supplier == null) {
            this.cancel(e, String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u4e0d\u5728\u8be5\u91c7\u8d2d\u7ec4\u7ec7\u7684\u4f7f\u7528\u8303\u56f4\u5185\u3002", (String)"ScPoImportPlugin_13", (String)"scmc-sctm", (Object[])new Object[0]), supplierPrefix, importValue), 0, 0);
            return false;
        }
        boolean validResult = SupplierHelper.validBizFunction((DynamicObject)supplier, (SupplierFunction)function);
        if (!validResult) {
            this.cancel(e, String.format(ResManager.loadKDString((String)"%1$s\u3010%2$s\u3011\u6ca1\u6709%3$s\u804c\u80fd\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"ScPoImportPlugin_14", (String)"scmc-sctm", (Object[])new Object[0]), supplierPrefix, importValue, function.getName()), 0, 0);
        }
        return validResult;
    }

    private void cancel(BeforeImportDataEventArgs e, String message, int entryRow, int subEntryRow) {
        e.setCancel(true);
        e.addCancelMessage(Integer.valueOf(entryRow), Integer.valueOf(subEntryRow), message);
        e.setFireAfterImportData(false);
    }

    private boolean existSubEntry(Object subEntry) {
        return subEntry instanceof List && !((List)subEntry).isEmpty();
    }

    private List<Map<String, Object>> getEntry(Map<String, Object> sourceData) {
        Object obj = sourceData.get("billentry");
        if (obj instanceof List) {
            return (List)obj;
        }
        return Collections.emptyList();
    }
}

