/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupFilterHelper;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.scmc.sctm.business.ScPoHelper;
import kd.scmc.sctm.common.enums.SubType;

public class ScPoListPlugin
extends AbstractListPlugin {
    private static final int MAX_QUERY_SIZE = 1000;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        switch (operateKey = ((FormOperate)args.getSource()).getOperateKey()) {
            case "showsublist": {
                this.beforeShowSubList(args);
                break;
            }
            case "subdeliver": {
                this.beforeSubDeliver(args);
                break;
            }
            case "payaccordsetting": {
                this.beforeChangePrePaySetting(args);
                break;
            }
        }
    }

    private void beforeChangePrePaySetting(BeforeDoOperationEventArgs e) {
        AbstractOperate operate = (AbstractOperate)e.getSource();
        OperateOption option = operate.getOption();
        if (!"true".equals(option.getVariableValue("payaccordsetting", ""))) {
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            String billFormId = listShowParameter.getBillFormId();
            ListSelectedRowCollection listSelectedData = e.getListSelectedData();
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            if (primaryKeyValues != null && primaryKeyValues.length > 0) {
                HashSet<Long> billIds = new HashSet<Long>(10);
                HashSet<Boolean> isOverPayResult = new HashSet<Boolean>(3);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)billFormId, (String)"isallowoverpay,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)}, null);){
                    for (Row row : dataSet) {
                        isOverPayResult.add(row.getBoolean("isallowoverpay"));
                        billIds.add(row.getLong("id"));
                    }
                }
                if (billIds.size() != primaryKeyValues.length) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ScPoListPlugin_3", (String)"scmc-sctm", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (isOverPayResult.size() != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u503c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ScPoListPlugin_0", (String)"scmc-sctm", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Boolean isOverPay = (Boolean)isOverPayResult.iterator().next();
                String msg = isOverPay != false ? ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u662f\u201d\u66f4\u6539\u4e3a\u201c\u5426\u201d\uff0c\u4e25\u683c\u63a7\u5236\u201c\u4ed8\u6b3e\u91d1\u989d\u201c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u5355\u636e\u201d\u4ef7\u7a0e\u5408\u8ba1\u201c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ScPoListPlugin_4", (String)"scmc-sctm", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u5426\u201d\u66f4\u6539\u4e3a\u201c\u662f\u201d\uff0c\u5141\u8bb8\u201d\u4ed8\u6b3e\u91d1\u989d\u201c\u8d85\u8fc7\u5355\u636e\u201d\u4ef7\u7a0e\u5408\u8ba1\u201c\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"ScPoListPlugin_5", (String)"scmc-sctm", (Object[])new Object[0]);
                ConfirmCallBackListener listener = new ConfirmCallBackListener("payaccordsetting", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
            }
            e.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        switch (key) {
            case "showsublist": {
                if (!operationResult.isSuccess()) break;
                Optional.ofNullable(ScPoHelper.getSubTrackDownShowParameter((EventObject)args)).ifPresent(showParameter -> this.getView().showForm(showParameter));
                break;
            }
            case "subdeliver": {
                if (!operationResult.isSuccess()) break;
                Optional.ofNullable(ScPoHelper.getImOutShowParameter((EventObject)args)).ifPresent(showParameter -> this.getView().showForm(showParameter));
                break;
            }
        }
    }

    private void beforeShowSubList(BeforeDoOperationEventArgs args) {
        Map<Long, Set<Long>> selectedMap = this.getJoinSubListIdMap(args);
        if (selectedMap == null) {
            args.setCancel(true);
            return;
        }
        if (selectedMap.isEmpty()) {
            this.getView().showTipNotification(ScPoHelper.getNoPushedMessage());
            args.setCancel(true);
            return;
        }
        int size = selectedMap.size();
        if (size > 1000) {
            this.getView().showTipNotification(ScPoHelper.getQueryMaxMessage());
            args.setCancel(true);
            return;
        }
        ArrayList<String> entryIds = new ArrayList<String>();
        String idKey = "id";
        String entryIdKey = "billentry.id";
        QFilter qFilter = new QFilter(idKey, "in", selectedMap.keySet()).and("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()).and("billentry.subtype", "!=", (Object)SubType.NOT_INPUT.getValue());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sctm_scpo", (String)"id,billstatus,billentry.id,billentry.subtype", (QFilter[])qFilter.toArray(), null);){
            for (Row row : dataSet) {
                Long entryId = row.getLong(entryIdKey);
                Set<Long> selectEntryIds = selectedMap.get(row.getLong(idKey));
                if (!selectEntryIds.isEmpty() && !selectEntryIds.contains(entryId)) continue;
                entryIds.add(entryId.toString());
            }
        }
        if (!entryIds.isEmpty()) {
            ScPoHelper.setCustomParam((EventObject)args, "sctm_scposublist", String.join((CharSequence)",", entryIds));
        } else {
            this.getView().showTipNotification(ScPoHelper.getNoPushedMessage());
            args.setCancel(true);
        }
    }

    private void beforeSubDeliver(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (listSelectedData == null || listSelectedData.size() == 0) {
            return;
        }
        HashSet<Long> billIds = new HashSet<Long>(16);
        HashSet<Long> rowIds = new HashSet<Long>(16);
        for (ListSelectedRow selectedRow : listSelectedData) {
            Long selectedRowId = (Long)selectedRow.getEntryPrimaryKeyValue();
            if (selectedRowId != null && selectedRowId != 0L) {
                rowIds.add(selectedRowId);
                continue;
            }
            billIds.add((Long)selectedRow.getPrimaryKeyValue());
        }
        if (!rowIds.isEmpty()) {
            ScPoHelper.setCustomParam((EventObject)args, "sctm_scposublist", ScPoHelper.collection2Str(rowIds));
        }
        if (!billIds.isEmpty()) {
            ScPoHelper.setCustomParam((EventObject)args, "sctm_scpo", ScPoHelper.collection2Str(billIds));
        }
    }

    private Map<Long, Set<Long>> getJoinSubListIdMap(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (listSelectedData == null || listSelectedData.size() == 0) {
            return null;
        }
        HashMap<Long, Set<Long>> map = new HashMap<Long, Set<Long>>(16);
        for (ListSelectedRow selectedRow : listSelectedData) {
            Long entryId;
            Long billId = (Long)selectedRow.getPrimaryKeyValue();
            HashSet<Long> selectedRowIds = (HashSet<Long>)map.get(billId);
            if (selectedRowIds == null) {
                selectedRowIds = new HashSet<Long>(16);
            }
            if ((entryId = (Long)selectedRow.getEntryPrimaryKeyValue()) != null && entryId != 0L) {
                selectedRowIds.add(entryId);
            }
            map.put(billId, selectedRowIds);
        }
        return map;
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String key;
        switch (key = event.getCallBackId()) {
            case "payaccordsetting": {
                if (!event.getResult().equals((Object)MessageBoxResult.Yes)) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("payaccordsetting", "true");
                this.getView().invokeOperation("payaccordsetting", option);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        BillList billList;
        super.setFilter(e);
        List qFilters = e.getQFilters();
        for (QFilter qf : qFilters) {
            if (!"id".equals(qf.getProperty()) || null == qf.getValue()) continue;
            return;
        }
        List orgList = null;
        QFilter mainOrgQFilter = e.getMainOrgQFilter();
        if (mainOrgQFilter != null && mainOrgQFilter.getValue() != null) {
            orgList = (List)mainOrgQFilter.getValue();
        }
        String entityId = (billList = (BillList)e.getSource()) == null ? "" : billList.getEntityId();
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qf = new QFilter("number", "=", (Object)entityId);
        DynamicObject entityobject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_entityobject", (QFilter[])new QFilter[]{qf});
        if (entityobject != null && entityobject.getDynamicObject("bizappid") != null) {
            QFilter operatorFilter = OperatorGroupFilterHelper.getQFilterForShare((String)((String)entityobject.getDynamicObject("bizappid").getPkValue()), (String)entityId, (String)"foperatorgroupisolate", (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue(), (String)"02", (Long)userId, (List)orgList, (String)"operatorgroup", (String)"operator");
            e.getQFilters().add(operatorFilter);
        }
    }
}

