/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.sctm.business.ScPoHelper;
import kd.scmc.sctm.business.ShowFormHelper;
import kd.scmc.sctm.business.SubListHelper;

public class SubListListPlugin
extends AbstractListPlugin {
    private static final int MAX_QUERY_SIZE = 5000;

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("scpo_billno".equals(fieldName)) {
            args.setCancel(true);
            List<Long> orderIds = this.queryOrderId(this.getCurrentBillId(args));
            if (orderIds.isEmpty()) {
                this.getView().showTipNotification(SubListHelper.getNoOrderMessage());
            } else {
                this.getView().showForm((FormShowParameter)ShowFormHelper.getBillShowParameter("sctm_scpo", orderIds.get(0)));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("showorder".equals(operateKey)) {
            this.beforeShowOrder(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if ("showorder".equals(key) && operationResult.isSuccess()) {
            Optional.ofNullable(SubListHelper.getShowParameter(args)).ifPresent(showParameter -> this.getView().showForm(showParameter));
        }
    }

    private Long getCurrentBillId(HyperLinkClickArgs args) {
        HyperLinkClickEvent event = args.getHyperLinkClickEvent();
        if (event instanceof BillListHyperLinkClickEvent) {
            return (Long)((BillListHyperLinkClickEvent)event).getCurrentRow().getPrimaryKeyValue();
        }
        return null;
    }

    private List<Long> queryOrderId(Object ... id) {
        ArrayList<Long> orderIds = new ArrayList<Long>();
        if (id != null && id.length != 0) {
            QFilter qFilter = new QFilter("id", "in", (Object)id);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"sctm_scposublist", (String)"id,scpo.id", (QFilter[])qFilter.toArray(), null);){
                for (Row row : dataSet) {
                    Long orderId = row.getLong("scpo.id");
                    if (orderId == null || orderId == 0L) continue;
                    orderIds.add(orderId);
                }
            }
        }
        return orderIds;
    }

    private void beforeShowOrder(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedData = args.getListSelectedData();
        if (selectedData == null) {
            args.setCancel(true);
            return;
        }
        Object[] ids = selectedData.getPrimaryKeyValues();
        if (ids.length > 5000) {
            this.getView().showTipNotification(ScPoHelper.getQueryMaxMessage());
            args.setCancel(true);
            return;
        }
        List<Long> orderIds = this.queryOrderId(ids);
        if (orderIds.isEmpty()) {
            this.getView().showTipNotification(SubListHelper.getNoOrderMessage());
            args.setCancel(true);
            return;
        }
        ScPoHelper.setCustomParam((EventObject)args, "sctm_scpo", ScPoHelper.collection2Str(orderIds));
    }
}

