/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.scmc.sctm.business.ScPoHelper;

public class ScPoOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("org");
        fieldKeys.add("billentry");
        fieldKeys.add("subtype");
        fieldKeys.add("sublistno");
        fieldKeys.add("subliststatus");
        fieldKeys.add("entrypurorg");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "audit": {
                this.beginAudit(dataEntities);
                break;
            }
            case "unaudit": {
                this.beginUnAudit(dataEntities);
                break;
            }
            case "submit": {
                this.beginSubmit(dataEntities);
                break;
            }
        }
    }

    private void beginSubmit(DynamicObject[] dataEntities) {
        for (DynamicObject bill : dataEntities) {
            String billNo = bill.getString("billno");
            String billStatus = bill.getString("billstatus");
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            if (entry == null) continue;
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                if (ScPoHelper.isNotInput(row)) {
                    row.set("sublistno", null);
                } else {
                    row.set("sublistno", (Object)this.getSubListNo(billNo, i));
                }
                row.set("subliststatus", (Object)billStatus);
                row.set("entrypurorg", (Object)org);
            }
        }
    }

    private void beginUnAudit(DynamicObject[] dataEntities) {
        this.updateEntryBillStatus(dataEntities, StatusEnum.SAVE);
    }

    private void beginAudit(DynamicObject[] dataEntities) {
        this.updateEntryBillStatus(dataEntities, StatusEnum.AUDIT);
    }

    private void updateEntryBillStatus(DynamicObject[] dataEntities, StatusEnum statusEnum) {
        if ("sctm_scpo".equals(this.billEntityType.getName())) {
            for (DynamicObject bill : dataEntities) {
                ScPoHelper.updateEntryBillStatus(bill, statusEnum);
            }
        }
    }

    private String getSubListNo(String orderNo, int rowIndex) {
        return orderNo + "#" + String.format("%04d", rowIndex + 1);
    }
}

