/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.mpscmm.msbd.business.helper.OperateLogHelper;
import kd.mpscmm.msbd.common.enums.ChangeStatusEnum;

public class ScPoPayAccordSettingOp
extends AbstractOperationServicePlugIn {
    private static final String OP_KEY = "payaccordsetting";
    private static final String CACHE_RESULTKEY = "payaccordsettingresult";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isallowoverpay");
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("billentry_pay");
        e.getFieldKeys().add("isprepay");
        e.getFieldKeys().add("changestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if (this.dataEntities == null || this.dataEntities.length == 0) {
                    return;
                }
                HashSet<Long> ids = new HashSet<Long>(10);
                for (ExtendedDataEntity extendedData : this.dataEntities) {
                    DynamicObject bill;
                    if (extendedData == null || (bill = extendedData.getDataEntity()) == null) continue;
                    ids.add((Long)bill.getPkValue());
                }
                if (ids.isEmpty()) {
                    return;
                }
                DynamicObjectCollection changingPoIdCol = QueryServiceHelper.query((String)"sctm_scpo", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids), new QFilter("changestatus", "=", (Object)ChangeStatusEnum.CHANGING.getValue())});
                if (changingPoIdCol == null || changingPoIdCol.isEmpty()) {
                    return;
                }
                ArrayList changingPoIds = new ArrayList(ids.size());
                changingPoIdCol.forEach(id -> changingPoIds.add(id.getLong("id")));
                for (ExtendedDataEntity extendedData : this.dataEntities) {
                    DynamicObject bill;
                    if (extendedData == null || (bill = extendedData.getDataEntity()) == null) continue;
                    ids.add((Long)bill.getPkValue());
                    if (!changingPoIds.contains(bill.getPkValue())) continue;
                    this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d8\u66f4\u72b6\u6001\u4e0d\u7b49\u4e8e\u53d8\u66f4\u4e2d\u7684\u6570\u636e\u3002", (String)"ScPoPayAccordSettingOp_3", (String)"scmc-sctm", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || !OP_KEY.equals(operationKey) || dataEntities.length == 0) {
            return;
        }
        Boolean isOverPayResult = null;
        HashSet<Long> ids = new HashSet<Long>(10);
        for (DynamicObject bill : dataEntities) {
            Object pkValue = bill.getPkValue();
            ids.add((Long)pkValue);
            Object isOverPay = bill.get("isallowoverpay");
            if (isOverPayResult != null || isOverPay == null) continue;
            isOverPayResult = (Boolean)isOverPay == false;
        }
        if (isOverPayResult == null || ids.isEmpty()) {
            return;
        }
        this.getOption().setVariableValue(CACHE_RESULTKEY, String.valueOf(isOverPayResult));
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObject[] billFromDB = BusinessDataServiceHelper.load((String)"sctm_scpo", (String)"id,isallowoverpay", (QFilter[])new QFilter[]{idFilter});
        if (billFromDB == null || billFromDB.length == 0) {
            return;
        }
        for (DynamicObject bill : billFromDB) {
            bill.set("isallowoverpay", (Object)isOverPayResult);
        }
        SaveServiceHelper.save((DynamicObject[])billFromDB);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities == null || !OP_KEY.equals(operationKey) || dataEntities.length == 0) {
            return;
        }
        String payaccordsettingresult = this.getOption().getVariableValue(CACHE_RESULTKEY);
        if (StringUtils.isBlank((CharSequence)payaccordsettingresult)) {
            return;
        }
        boolean isOverPayResult = Boolean.parseBoolean(payaccordsettingresult);
        this.writeOperateLog(dataEntities, this.getOperationResult(), isOverPayResult);
        this.sendEventMsg(dataEntities, this.getOperationResult(), isOverPayResult);
    }

    private void sendEventMsg(DynamicObject[] dataEntities, OperationResult operationResult, boolean isOverPayResult) {
        List successPkIds;
        List list = successPkIds = operationResult.getSuccessPkIds() == null ? new ArrayList(10) : operationResult.getSuccessPkIds();
        if (successPkIds.isEmpty()) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            String billStatus = bill.getString("billstatus");
            DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("billentry_pay");
            if (payEntrys == null || payEntrys.isEmpty() || !"C".equals(billStatus)) {
                successPkIds.remove(bill.getPkValue());
                continue;
            }
            boolean hasPrePay = false;
            for (DynamicObject payRow : payEntrys) {
                if (!payRow.getBoolean("isprepay")) continue;
                hasPrePay = true;
                break;
            }
            if (hasPrePay) continue;
            successPkIds.remove(bill.getPkValue());
        }
        if (successPkIds.isEmpty()) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("entityno", this.billEntityType.getName());
        param.put("billids", SerializationUtils.toJsonString(successPkIds));
        param.put("isallowoverpay", String.valueOf(isOverPayResult));
        EventServiceHelper.triggerEventSubscribe((String)"IsAllowOverPayChangeEvent", (String)SerializationUtils.toJsonString(param));
    }

    private void writeOperateLog(DynamicObject[] dataEntities, OperationResult operationResult, boolean isOverPayResult) {
        String appId = this.billEntityType.getAppId();
        Long userId = RequestContext.get().getCurrUserId();
        String name = this.billEntityType.getName();
        Date now = TimeServiceHelper.now();
        ArrayList<AppLogInfo> logList = new ArrayList<AppLogInfo>(10);
        List successPkIds = operationResult.getSuccessPkIds();
        String opDisPlayName = this.getOpName(name, OP_KEY);
        for (DynamicObject bill : dataEntities) {
            Long pkValue = (Long)bill.getPkValue();
            String billNo = bill.getString("billno");
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            Long orgId = (Long)org.getPkValue();
            String msg = successPkIds != null && successPkIds.contains(pkValue) ? (isOverPayResult ? String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c\u6309\u5c65\u7ea6\u652f\u4ed8\u7531\u201c\u5426\u201d\u66f4\u6539\u4e3a\u201c\u662f\u201d\u3002", (String)"ScPoPayAccordSettingOp_0", (String)"scmc-sctm", (Object[])new Object[0]), billNo) : String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c\u6309\u5c65\u7ea6\u652f\u4ed8\u7531\u201c\u662f\u201d\u66f4\u6539\u4e3a\u201c\u5426\u201d\u3002", (String)"ScPoPayAccordSettingOp_1", (String)"scmc-sctm", (Object[])new Object[0]), billNo)) : String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c\u6309\u5c65\u7ea6\u652f\u4ed8\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"ScPoPayAccordSettingOp_2", (String)"scmc-sctm", (Object[])new Object[0]), billNo);
            logList.add(OperateLogHelper.buildAppLogInfo((Long)userId, (String)appId, (String)name, (Long)orgId, (Date)now, (String)opDisPlayName, (String)msg));
        }
        OperateLogHelper.saveAppLog(logList);
    }

    private String getOpName(String entityName, String operationKey) {
        String operationName = "";
        Map dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityName, (String)operationKey);
        if (dataEntityOperate != null) {
            Map opName = (Map)dataEntityOperate.get("name");
            if (opName != null) {
                operationName = opName.containsKey(ResManager.getLanguage()) ? (String)opName.get(ResManager.getLanguage()) : (String)opName.get("zh_CN");
            }
            return operationName;
        }
        return operationName;
    }
}

