/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.scmc.sctm.business.ScPoHelper;

public class ScPoSubDeliverOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ScPoSubDeliverOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("closestatus");
        fieldKeys.add("changestatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ScPoSubDeliverValidator());
    }

    private static class SubDeliverInfo {
        private final ExtendedDataEntity extendedDataEntity;
        private final Integer seq;
        private String message;

        String getMessage() {
            if (this.seq == null) {
                return this.message;
            }
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%s\u884c\uff0c", (String)"ScPoSubDeliverOp_1", (String)"scmc-sctm", (Object[])new Object[0]), this.seq) + this.message;
        }

        void setMessage(String message) {
            this.message = message;
        }

        ExtendedDataEntity getExtendedDataEntity() {
            return this.extendedDataEntity;
        }

        public SubDeliverInfo(ExtendedDataEntity extendedDataEntity, Integer seq) {
            this.extendedDataEntity = extendedDataEntity;
            this.seq = seq;
        }
    }

    private static class ScPoSubDeliverValidator
    extends AbstractValidator {
        private static final String sourceEntity = "sctm_scposublist";
        private static final String targetEntity = "im_osmaterialreqoutbill";
        private static final String DEFAULT_RULE_ID = "1458022257644301312";
        private String ruleId;
        private final List<SubDeliverInfo> errorInfoList = new ArrayList<SubDeliverInfo>();

        private ScPoSubDeliverValidator() {
        }

        public void validate() {
            if (this.skip()) {
                return;
            }
            this.ruleId = this.getRuleId();
            if (this.ruleId == null) {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8f6c\u6362\u89c4\u5219\u3002", (String)"ScPoSubDeliverOp_0", (String)"scmc-sctm", (Object[])new Object[0]));
                }
                return;
            }
            long startTime = System.currentTimeMillis();
            this.subDeliver();
            log.info("\u3010\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u3011\u3010\u53d1\u6599\u3011\u64cd\u4f5c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
            for (SubDeliverInfo errorInfo : this.errorInfoList) {
                this.addErrorMessage(errorInfo.getExtendedDataEntity(), errorInfo.getMessage());
            }
        }

        private boolean skip() {
            ValidateContext validateContext = this.getValidateContext();
            ValidateResultCollection validateResults = validateContext.getValidateResults();
            if (validateResults != null) {
                List errors = validateResults.getValidateErrors();
                return errors != null && !errors.isEmpty();
            }
            return false;
        }

        private String getRuleId() {
            List loadRules = ConvertMetaServiceHelper.loadRules((String)sourceEntity, (String)targetEntity);
            if (loadRules == null || loadRules.isEmpty()) {
                return null;
            }
            HashSet<String> enableRuleId = new HashSet<String>(loadRules.size() << 1);
            String defaultRuleId = null;
            for (ConvertRuleElement loadRule : loadRules) {
                if (!loadRule.isEnabled()) continue;
                String loadRuleId = loadRule.getId();
                if (loadRule.isDefRule()) {
                    defaultRuleId = loadRuleId;
                    break;
                }
                enableRuleId.add(loadRuleId);
            }
            if (defaultRuleId != null) {
                return defaultRuleId;
            }
            if (enableRuleId.size() == 1) {
                return (String)enableRuleId.iterator().next();
            }
            if (enableRuleId.contains(DEFAULT_RULE_ID)) {
                return DEFAULT_RULE_ID;
            }
            return null;
        }

        private void subDeliver() {
            long startTime = System.currentTimeMillis();
            ConvertOperationResult pushAndSaveResult = this.pushAndSave();
            if (pushAndSaveResult == null) {
                return;
            }
            log.info("\u3010\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u3011\u3010\u53d1\u6599\u3011\u3010pushAndSave\u3011\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime));
            Set targetBillIds = pushAndSaveResult.getTargetBillIds();
            if (targetBillIds != null && !targetBillIds.isEmpty()) {
                ScPoHelper.setCustomParam(this.getOption(), targetEntity, ScPoHelper.collection2Str(targetBillIds));
            } else {
                Map<Long, SubDeliverInfo> entryBillMap = this.getEntryBillMap();
                List billReports = pushAndSaveResult.getBillReports();
                for (SourceBillReport billReport : billReports) {
                    String message = billReport.getFailMessage();
                    if (!StringUtils.isNotEmpty((CharSequence)message)) continue;
                    Long subListId = (Long)billReport.getBillId();
                    SubDeliverInfo subDeliverInfo = entryBillMap.get(subListId);
                    subDeliverInfo.setMessage(message);
                    this.errorInfoList.add(subDeliverInfo);
                }
            }
        }

        private Map<Long, SubDeliverInfo> getEntryBillMap() {
            HashMap<Long, SubDeliverInfo> entryBillMap = new HashMap<Long, SubDeliverInfo>(64);
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                DynamicObject bill = extendedDataEntity.getDataEntity();
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
                if (entry == null) continue;
                for (int i = 0; i < entry.size(); ++i) {
                    entryBillMap.put((Long)((DynamicObject)entry.get(i)).getPkValue(), new SubDeliverInfo(extendedDataEntity, i + 1));
                }
            }
            return entryBillMap;
        }

        private ConvertOperationResult pushAndSave() {
            PushArgs pushArgs = this.getPushArgs();
            if (pushArgs == null) {
                return null;
            }
            return ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
        }

        private PushArgs getPushArgs() {
            List<ListSelectedRow> pushRows = this.getPushRows();
            if (pushRows.isEmpty()) {
                log.info("\u3010\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u3011\u3010\u53d1\u6599\u3011\u83b7\u53d6\u4e0b\u63a8\u884c\u5931\u8d25\u3002");
                return null;
            }
            log.info("\u3010\u59d4\u5916\u91c7\u8d2d\u8ba2\u5355\u3011\u3010\u53d1\u6599\u3011\u4e0b\u63a8\u884c\u6570\uff1apushRows=" + pushRows.size());
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(sourceEntity);
            pushArgs.setTargetEntityNumber(targetEntity);
            pushArgs.setBuildConvReport(true);
            pushArgs.setRuleId(this.ruleId);
            pushArgs.setHasRight(false);
            pushArgs.setSelectedRows(pushRows);
            return pushArgs;
        }

        private List<ListSelectedRow> getPushRows() {
            ArrayList<ListSelectedRow> sourceEntryRows = new ArrayList<ListSelectedRow>();
            Set<Long> subListIds = ScPoHelper.getBillIdSet(this.getOption(), sourceEntity);
            Set<Long> billIds = ScPoHelper.getBillIdSet(this.getOption(), "sctm_scpo");
            boolean isAllBill = subListIds.isEmpty();
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                DynamicObject bill = extendedDataEntity.getDataEntity();
                boolean isAllEntry = billIds.contains((Long)bill.getPkValue());
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
                if (entry == null) continue;
                for (DynamicObject row : entry) {
                    DynamicObjectCollection subEntry = row.getDynamicObjectCollection("billentry_sub");
                    Long rowId = (Long)row.getPkValue();
                    if (!isAllBill && !isAllEntry && !subListIds.contains(rowId)) continue;
                    if (subEntry == null || subEntry.isEmpty()) {
                        ListSelectedRow pushRow = new ListSelectedRow();
                        pushRow.setPrimaryKeyValue((Object)rowId);
                        pushRow.setEntryEntityKey("billentry");
                        sourceEntryRows.add(pushRow);
                        continue;
                    }
                    for (DynamicObject subRow : subEntry) {
                        ListSelectedRow pushRow = new ListSelectedRow();
                        pushRow.setPrimaryKeyValue((Object)rowId);
                        pushRow.setEntryEntityKey("billentry");
                        pushRow.setEntryPrimaryKeyValue(subRow.getPkValue());
                        sourceEntryRows.add(pushRow);
                    }
                }
            }
            return sourceEntryRows;
        }
    }
}

