/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.scmc.sctm.business.ScPoHelper;
import kd.scmc.sctm.validator.XScPoPreRateChangeValidator;

public class XScPoOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("sourcebillentity");
        fieldKeys.add("billno");
        fieldKeys.add("billno");
        fieldKeys.add("sourcebillid");
        fieldKeys.add("payentrysrcid");
        fieldKeys.add("totalallamount");
        fieldKeys.add("isprepay");
        fieldKeys.add("payrate");
        fieldKeys.add("billentry_pay");
        fieldKeys.add("changebillno");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new XScPoPreRateChangeValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "bizvalid": {
                this.afterBizValid(dataEntities);
                break;
            }
        }
    }

    private void afterBizValid(DynamicObject[] dataEntities) {
        if (dataEntities == null || dataEntities.length < 1) {
            return;
        }
        this.updateSourceScPos(dataEntities);
        this.comparePrePayAmountChangeAndExcuteEvent(dataEntities);
    }

    private void comparePrePayAmountChangeAndExcuteEvent(DynamicObject[] dataEntities) {
        HashSet<Long> srcBillIds = new HashSet<Long>(10);
        String srcEntity = null;
        for (DynamicObject bill : dataEntities) {
            String sourceBillEntity = bill.getString("sourcebillentity");
            Long sourceBillId = bill.getLong("sourcebillid");
            if (StringUtils.isBlank(srcEntity) && StringUtils.isNotBlank((CharSequence)sourceBillEntity)) {
                srcEntity = sourceBillEntity;
            }
            if (sourceBillId == null || sourceBillId == 0L) continue;
            srcBillIds.add(sourceBillId);
        }
        if (srcBillIds == null || srcBillIds.isEmpty() || StringUtils.isBlank(srcEntity)) {
            return;
        }
        Map<Long, BigDecimal> srcBeforeChangeAmountMap = this.getSrcBeforeChangePrePayAmount(this.operateOption);
        QFilter isPrePay = new QFilter("billentry_pay.isprepay", "=", (Object)Boolean.TRUE);
        QFilter idFilter = new QFilter("id", "in", srcBillIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)srcEntity, (String)"id,isallowoverpay,billentry_pay.payamount as payamount", (QFilter[])new QFilter[]{isPrePay, idFilter}, null);
        DataSet billPayAmountSumDataSet = dataSet.groupBy(new String[]{"id", "isallowoverpay"}).sum("payamount").finish();
        HashMap<Long, BigDecimal> afterChangePayAmountSum = new HashMap<Long, BigDecimal>(10);
        HashSet<Long> isallowoverpayIds = new HashSet<Long>(10);
        for (Row row : billPayAmountSumDataSet) {
            Long id = row.getLong("id");
            Boolean isallowoverpay = row.getBoolean("isallowoverpay");
            if (isallowoverpay != null && isallowoverpay.booleanValue()) {
                isallowoverpayIds.add(id);
            }
            BigDecimal sumPayamount = row.getBigDecimal("payamount") == null ? BigDecimal.ZERO : row.getBigDecimal("payamount");
            afterChangePayAmountSum.put(id, sumPayamount);
        }
        if (!isallowoverpayIds.isEmpty()) {
            for (Long id : isallowoverpayIds) {
                srcBeforeChangeAmountMap.remove(id);
                afterChangePayAmountSum.remove(id);
            }
            if (srcBeforeChangeAmountMap.isEmpty() && afterChangePayAmountSum.isEmpty()) {
                return;
            }
        }
        HashSet<Long> prePayChangedSrcBillIds = new HashSet<Long>(10);
        prePayChangedSrcBillIds.addAll(this.getPrePayChanged(srcBeforeChangeAmountMap, afterChangePayAmountSum));
        prePayChangedSrcBillIds.addAll(this.getPrePayChanged(afterChangePayAmountSum, srcBeforeChangeAmountMap));
        if (prePayChangedSrcBillIds.isEmpty()) {
            return;
        }
        HashMap<String, String> param = new HashMap<String, String>(3);
        param.put("entityno", srcEntity);
        param.put("billids", SerializationUtils.toJsonString(prePayChangedSrcBillIds));
        EventServiceHelper.triggerEventSubscribe((String)"PrePayAmountChangeEvent", (String)SerializationUtils.toJsonString(param));
    }

    private void updateSourceScPos(DynamicObject[] dataEntities) {
        List<DynamicObject> updateScPos = this.updateSubDelGroupQty(this.querySourceScPos(dataEntities));
        if (!updateScPos.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updateScPos.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> updateSubDelGroupQty(DynamicObject[] sourceScPos) {
        if (sourceScPos == null) {
            return Collections.emptyList();
        }
        ArrayList<DynamicObject> updateScPos = new ArrayList<DynamicObject>(sourceScPos.length);
        for (DynamicObject scPo : sourceScPos) {
            DynamicObjectCollection entry = scPo.getDynamicObjectCollection("billentry");
            if (entry == null || entry.isEmpty()) continue;
            boolean update = false;
            for (DynamicObject row : entry) {
                if (ScPoHelper.updateSubDelGroupQty(row).isEmpty()) continue;
                update = true;
            }
            if (!update) continue;
            updateScPos.add(scPo);
        }
        return updateScPos;
    }

    private DynamicObject[] querySourceScPos(DynamicObject[] dataEntities) {
        List<Long> scPoIds = this.getScPoIds(dataEntities);
        if (scPoIds.isEmpty()) {
            return null;
        }
        return BusinessDataServiceHelper.load((Object[])scPoIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"sctm_scpo"));
    }

    private List<Long> getScPoIds(DynamicObject[] dataEntities) {
        ArrayList<Long> scPoIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject bill : dataEntities) {
            long scPoId;
            if (!"sctm_scpo".equals(bill.getString("sourcebillentity")) || (scPoId = bill.getLong("sourcebillid")) == 0L) continue;
            scPoIds.add(scPoId);
        }
        return scPoIds;
    }

    private Map<Long, BigDecimal> getSrcBeforeChangePrePayAmount(OperateOption operateOption) {
        Map variables = operateOption.getVariables();
        HashMap<Long, BigDecimal> srcBillIdAndAmount = new HashMap<Long, BigDecimal>(10);
        if (variables == null || variables.isEmpty()) {
            return srcBillIdAndAmount;
        }
        for (Map.Entry entry : variables.entrySet()) {
            String key = (String)entry.getKey();
            if (key == null || key.indexOf("sumprepayamount") == -1) continue;
            srcBillIdAndAmount.put(Long.parseLong(key.substring(0, key.indexOf("sumprepayamount"))), new BigDecimal((String)entry.getValue()));
        }
        return srcBillIdAndAmount;
    }

    private HashSet<Long> getPrePayChanged(Map<Long, BigDecimal> srcBeforeChangeAmountMap, Map<Long, BigDecimal> afterChangePayAmountSum) {
        HashSet<Long> result = new HashSet<Long>(10);
        for (Map.Entry<Long, BigDecimal> entry : srcBeforeChangeAmountMap.entrySet()) {
            BigDecimal afterAmount;
            BigDecimal srcBeforeAmount;
            Long srcBillId = entry.getKey();
            BigDecimal bigDecimal = srcBeforeAmount = entry.getValue() == null ? BigDecimal.ZERO : entry.getValue();
            if (srcBillId == null || srcBeforeAmount.compareTo(afterAmount = afterChangePayAmountSum.get(srcBillId) == null ? BigDecimal.ZERO : afterChangePayAmountSum.get(srcBillId)) == 0) continue;
            result.add(srcBillId);
        }
        return result;
    }
}

