/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.validator;

import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.mpscmm.msbd.changemodel.common.consts.ChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.MethodParameterUtil;
import kd.scmc.sctm.common.enums.SubType;

public class BomValidator
extends AbstractValidator {
    private static final String PARAM_ISCHECKBOMCOMPLIANCE = "ischeckbomcompliance";

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billentry");
        preparePropertys.add("entrychangetype");
        preparePropertys.add("bom");
        preparePropertys.add("material");
        preparePropertys.add("subtype");
        return preparePropertys;
    }

    public void validate() {
        String customparameter;
        boolean isCheckBomCompliance = false;
        Map validation = this.getValidation();
        if (validation != null && StringUtils.isNotBlank((CharSequence)(customparameter = (String)validation.get("customparameter")))) {
            String isCheckBomComplianceStr = MethodParameterUtil.getValue((Object)customparameter, (String)PARAM_ISCHECKBOMCOMPLIANCE);
            isCheckBomCompliance = isCheckBomComplianceStr == null ? false : "true".equalsIgnoreCase(isCheckBomComplianceStr);
        }
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject masterid;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String subType = entry.getString("subtype");
                String changeType = entry.getString("entrychangetype");
                DynamicObject bom = entry.getDynamicObject("bom");
                if (changeType == null || ChangeTypeEnum.CANCEL.getValue().equals(changeType) || !StringUtils.isNotBlank((CharSequence)subType)) continue;
                if (bom == null && SubType.BOM.getValue().equals(subType)) {
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u201d\u6295\u6599\u65b9\u5f0f\u201c\u4e3aBOM\uff0c\u8bf7\u5f55\u5165\u201cBOM\u7f16\u7801\u201d\u3002", (String)"BomValidator_0", (String)"scmc-sctm", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
                    continue;
                }
                if (bom != null && !SubType.BOM.getValue().equals(subType)) {
                    String subTypeName = subType.equals(SubType.INPUT.getValue()) ? SubType.INPUT.getName() : (subType.equals(SubType.NOT_INPUT.getValue()) ? SubType.NOT_INPUT.getName() : "");
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201d\u6295\u6599\u65b9\u5f0f\u201c\u4e3a%2$s\uff0c\u201cBOM\u7f16\u7801\u201d\u5e94\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BomValidator_1", (String)"scmc-sctm", (Object[])new Object[0]), i + 1, subTypeName), ErrorLevel.Error);
                    continue;
                }
                if (!isCheckBomCompliance || bom == null) continue;
                DynamicObject bomMaterial = bom.getDynamicObject("material");
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || bomMaterial == null || (masterid = material.getDynamicObject("masterid")) == null) continue;
                long materialId = masterid.getLong("id");
                Long bomMaterialId = (Long)bomMaterial.getPkValue();
                if (bomMaterialId == null || bomMaterialId.compareTo(materialId) == 0) continue;
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201cBOM\u7f16\u7801\u201d\u4e0d\u662f\u201c\u7269\u6599\u7f16\u7801\u201d\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u59d4\u5916BOM\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BomValidator_2", (String)"scmc-sctm", (Object[])new Object[0]), i + 1), ErrorLevel.Error);
            }
        }
    }
}

