/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.validator;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;

public class ScPoAllowOverPayValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(ScPoAllowOverPayValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("receivebaseqtyup");
        preparePropertys.add("baseqty");
        preparePropertys.add("price");
        preparePropertys.add("isallowoverpay");
        preparePropertys.add("entrychangetype");
        preparePropertys.add("ispresent");
        preparePropertys.add("price");
        return preparePropertys;
    }

    public void validate() {
        block0: for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            boolean isAllowOverPay = bill.getBoolean("isallowoverpay");
            if (isAllowOverPay) continue;
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            boolean hasPriceErrorCode = false;
            boolean hasUpQtyOrAmountErrorCode = false;
            if (entrys == null || entrys.size() <= 0) continue;
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrys.get(i);
                if (hasPriceErrorCode && hasUpQtyOrAmountErrorCode) continue block0;
                String changeType = entry.getString("entrychangetype");
                if (changeType != null && ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                if (!hasPriceErrorCode) {
                    BigDecimal price = entry.getBigDecimal("price");
                    boolean isPresent = entry.getBoolean("ispresent");
                    if (!isPresent && price != null && BigDecimal.ZERO.compareTo(price) == 0) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u5355\u4ef7\u4e3a0\uff0c\u5e94\u4fee\u6539\u5141\u8bb8\u8d85\u989d\u4ed8\u6b3e\u4e3a\u201c\u662f\u201d\u3002", (String)"ScPoAllowOverPayValidator_0", (String)"scmc-sctm", (Object[])new Object[0]));
                        hasPriceErrorCode = true;
                    }
                }
                if (hasUpQtyOrAmountErrorCode) continue;
                BigDecimal baseQty = entry.getBigDecimal("baseqty");
                BigDecimal receiveBaseQtyUp = entry.getBigDecimal("receivebaseqtyup");
                if (baseQty == null || receiveBaseQtyUp == null || receiveBaseQtyUp.compareTo(baseQty) <= 0) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u6536\u8d27\u4e0a\u9650\u6570\u91cf\u5927\u4e8e\u6570\u91cf\uff0c\u5e94\u5141\u8bb8\u8d85\u989d\u4ed8\u6b3e\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"ScPoAllowOverPayValidator_1", (String)"scmc-sctm", (Object[])new Object[0]));
                hasUpQtyOrAmountErrorCode = true;
            }
        }
    }
}

