/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.scmc.sctm.business.ScPoHelper;

public class ScPoPushedValidator
extends AbstractValidator
implements Serializable {
    private static final long serialVersionUID = 5243093119632770973L;

    public Set<String> preparePropertys() {
        HashSet<String> fieldKeys = new HashSet<String>(16);
        fieldKeys.add("subliststatus");
        fieldKeys.add("subtype");
        return fieldKeys;
    }

    public void validate() {
        Set<Long> pushedIds = this.getPushedIds();
        if (pushedIds.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!pushedIds.contains((Long)bill.getPkValue())) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u4e0b\u63a8\uff0c\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ScPoPushedValidator_0", (String)"scmc-sctm", (Object[])new Object[0]));
        }
    }

    private Set<Long> getPushedIds() {
        int length = this.dataEntities.length;
        ArrayList<Long> billIds = new ArrayList<Long>(length);
        HashMap<Long, Long> entryIdMap = new HashMap<Long, Long>(64);
        this.prepareData(billIds, entryIdMap);
        HashSet<Long> pushedOrderIds = new HashSet<Long>(length << 1);
        Map<Long, BFRowLinkDownNode> poPushedData = this.getDirectTargetBill(this.entityKey, billIds.toArray(new Long[0]));
        if (poPushedData != null && !poPushedData.isEmpty()) {
            pushedOrderIds.addAll(poPushedData.keySet());
        }
        if ("sctm_scpo".equals(this.entityKey)) {
            this.addSubPushedIds(pushedOrderIds, entryIdMap);
        }
        return pushedOrderIds;
    }

    private void addSubPushedIds(Set<Long> pushedOrderIds, Map<Long, Long> entryIdMap) {
        Map<Long, BFRowLinkDownNode> subListPushedData = this.getDirectTargetBill("sctm_scposublist", entryIdMap.keySet().toArray(new Long[0]));
        if (subListPushedData != null) {
            for (Long joinId : subListPushedData.keySet()) {
                Long billId = entryIdMap.get(joinId);
                if (billId == null) continue;
                pushedOrderIds.add(billId);
            }
        }
    }

    private void prepareData(List<Long> billIds, Map<Long, Long> entryIdMap) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            Long scPoId = (Long)bill.getPkValue();
            billIds.add(scPoId);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            if (entry == null) continue;
            for (DynamicObject row : entry) {
                if (ScPoHelper.isNotInput(row)) continue;
                entryIdMap.put((Long)row.getPkValue(), scPoId);
            }
        }
    }

    private Map<Long, BFRowLinkDownNode> getDirectTargetBill(String billName, Long[] ids) {
        return BFTrackerServiceHelper.loadBillLinkDownNodes((String)billName, (Long[])ids, (boolean)true);
    }
}

