/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.validator;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.scmc.sctm.common.enums.SubType;

public class ScPoSubEntryValidator
extends AbstractValidator
implements Serializable {
    private static final long serialVersionUID = 5632045684071220622L;

    public Set<String> preparePropertys() {
        HashSet<String> fieldKeys = new HashSet<String>(16);
        fieldKeys.add("entrychangetype");
        fieldKeys.add("subtype");
        fieldKeys.add("subentrychangetype");
        return fieldKeys;
    }

    public void validate() {
        for (ExtendedDataEntity extendedData : this.dataEntities) {
            DynamicObject bill = extendedData.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            if (entry == null) continue;
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObjectCollection subEntry;
                DynamicObject row = (DynamicObject)entry.get(i);
                String subType = row.getString("subtype");
                if (subType == null || SubType.NOT_INPUT.getValue().equals(subType) || ChangeTypeEnum.isCancel((String)row.getString("entrychangetype")) || (subEntry = row.getDynamicObjectCollection("billentry_sub")) != null && !this.isAllChangeCancel(subEntry)) continue;
                String subTypeName = subType.equals(SubType.INPUT.getValue()) ? SubType.INPUT.getName() : (subType.equals(SubType.BOM.getValue()) ? SubType.BOM.getName() : "");
                this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u6295\u6599\u65b9\u5f0f\u4e3a%2$s\uff0c\u8bf7\u5f55\u5165\u53d1\u6599\u660e\u7ec6\u3002", (String)"ScPoSubEntryValidator_0", (String)"scmc-sctm", (Object[])new Object[0]), i + 1, subTypeName));
            }
        }
    }

    private boolean isAllChangeCancel(DynamicObjectCollection subEntry) {
        for (DynamicObject subRow : subEntry) {
            if (ChangeTypeEnum.isCancel((String)subRow.getString("subentrychangetype"))) continue;
            return false;
        }
        return true;
    }
}

