/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.validator;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;

public class XPoJoinQtyAmountValidator
extends AbstractValidator
implements Serializable {
    private static final long serialVersionUID = -4169661617228462683L;

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            this.checkEntry(data);
            this.checkPayEntry(data);
        }
    }

    private void checkEntry(ExtendedDataEntity extendedData) {
        int i;
        DynamicObject bill = extendedData.getDataEntity();
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null) {
            return;
        }
        boolean isAllCancel = true;
        for (i = 0; i < entry.size(); ++i) {
            DynamicObject billEntry = (DynamicObject)entry.get(i);
            if (ChangeTypeEnum.CANCEL.getValue().equals(billEntry.getString("entrychangetype"))) continue;
            isAllCancel = false;
            break;
        }
        if (isAllCancel) {
            this.addErrorMessage(extendedData, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u4e0d\u5141\u8bb8\u5168\u90e8\u53d6\u6d88\u3002", (String)"XPoJoinQtyAmountValidator_5", (String)"scmc-sctm", (Object[])new Object[0]));
        }
        for (i = 0; i < entry.size(); ++i) {
            DynamicObject row = (DynamicObject)entry.get(i);
            String entryChangeType = row.getString("entrychangetype");
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("qty"));
            BigDecimal receiveBaseQtyUp = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("receivebaseqtyup"));
            BigDecimal joinBaseQty = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("joinbaseqty"));
            BigDecimal joinPayablePriceQty = BigDecimalUtil.getNotNull((Object)row.getBigDecimal("joinpayablepriceqty"));
            if (ChangeTypeEnum.isCancel((String)entryChangeType)) {
                if (!BigDecimalUtil.largeZero((BigDecimal)joinBaseQty) && !BigDecimalUtil.largeZero((BigDecimal)joinPayablePriceQty)) continue;
                this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u201c\u5173\u8054\u6570\u91cf\u201d\u6216\u201c\u5173\u8054\u5e94\u4ed8\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPoJoinQtyAmountValidator_0", (String)"scmc-sctm", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (!ChangeTypeEnum.isUpdate((String)entryChangeType)) continue;
            if (BigDecimalUtil.lessThan((BigDecimal)receiveBaseQtyUp, (BigDecimal)joinBaseQty)) {
                this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6536\u8d27\u4e0a\u9650\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u6570\u91cf\u201d\u3002", (String)"XPoJoinQtyAmountValidator_1", (String)"scmc-sctm", (Object[])new Object[0]), i + 1));
            }
            if (!BigDecimalUtil.lessThan((BigDecimal)qty, (BigDecimal)joinPayablePriceQty)) continue;
            this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u8ba2\u5355\u7684\u201c\u5173\u8054\u5e94\u4ed8\u6570\u91cf\u201d\u3002", (String)"XPoJoinQtyAmountValidator_2", (String)"scmc-sctm", (Object[])new Object[0]), i + 1));
        }
    }

    private void checkPayEntry(ExtendedDataEntity extendedData) {
        DynamicObject bill = extendedData.getDataEntity();
        DynamicObjectCollection payEntry = bill.getDynamicObjectCollection("billentry_pay");
        if (payEntry == null) {
            return;
        }
        for (int i = 0; i < payEntry.size(); ++i) {
            DynamicObject payRow = (DynamicObject)payEntry.get(i);
            String payEntryChangeType = payRow.getString("payentrychangetype");
            BigDecimal payAmount = BigDecimalUtil.getNotNull((Object)payRow.getBigDecimal("payamount"));
            BigDecimal joinPayAmount = BigDecimalUtil.getNotNull((Object)payRow.getBigDecimal("joinpayamount"));
            if (BigDecimalUtil.isZero((BigDecimal)joinPayAmount)) continue;
            if (ChangeTypeEnum.isCancel((String)payEntryChangeType)) {
                this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u7684\u201c\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"XPoJoinQtyAmountValidator_3", (String)"scmc-sctm", (Object[])new Object[0]), i + 1));
                continue;
            }
            if (!BigDecimalUtil.lessThan((BigDecimal)payAmount, (BigDecimal)joinPayAmount)) continue;
            this.addErrorMessage(extendedData, String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u7b2c%1$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u4ed8\u6b3e\u91d1\u989d\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u4ed8\u6b3e\u91d1\u989d\u201d\u3002", (String)"XPoJoinQtyAmountValidator_4", (String)"scmc-sctm", (Object[])new Object[0]), i + 1));
        }
    }
}

