/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sctm.validator;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sctm.business.ScPoHelper;

public class XScPoSubQtyValidator
extends AbstractValidator
implements Serializable {
    private static final long serialVersionUID = -8338610661685945154L;

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            if (entry == null) continue;
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject row = (DynamicObject)entry.get(i);
                if (ScPoHelper.isNotInput(row)) continue;
                String entryChangeType = row.getString("entrychangetype");
                DynamicObjectCollection subEntry = row.getDynamicObjectCollection("billentry_sub");
                if (subEntry == null) continue;
                for (int j = 0; j < subEntry.size(); ++j) {
                    DynamicObject subRow = (DynamicObject)subEntry.get(j);
                    BigDecimal joinSubQty = BigDecimalUtil.getNotNull((Object)subRow.getBigDecimal("joinsubqty"));
                    if (BigDecimalUtil.isZero((BigDecimal)joinSubQty)) continue;
                    if (ChangeTypeEnum.isCancel((String)entryChangeType)) {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u4e0b\u7684\u53d1\u6599\u660e\u7ec6\u7b2c%2$s\u884c\u7684\u201c\u5173\u8054\u53d1\u6599\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u7269\u6599\u660e\u7ec6\u884c\u3002", (String)"XScPoSubQtyValidator_0", (String)"scmc-sctm", (Object[])new Object[0]), i + 1, j + 1));
                        continue;
                    }
                    if (ChangeTypeEnum.isCancel((String)subRow.getString("subentrychangetype"))) {
                        this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u4e0b\u7684\u53d1\u6599\u660e\u7ec6\u7b2c%2$s\u884c\u7684\u201c\u5173\u8054\u53d1\u6599\u6570\u91cf\u201d\u5927\u4e8e0\uff0c\u4e0d\u80fd\u5220\u9664\u53d1\u6599\u660e\u7ec6\u884c\u3002", (String)"XScPoSubQtyValidator_1", (String)"scmc-sctm", (Object[])new Object[0]), i + 1, j + 1));
                        continue;
                    }
                    if (!BigDecimalUtil.lessThan((BigDecimal)BigDecimalUtil.getNotNull((Object)subRow.getBigDecimal("subqtyup")), (BigDecimal)joinSubQty)) continue;
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u4e0b\u7684\u53d1\u6599\u660e\u7ec6\u7b2c%2$s\u884c\u53d8\u66f4\u540e\u7684\u201c\u53d1\u6599\u4e0a\u9650\u6570\u91cf\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u5173\u8054\u53d1\u6599\u6570\u91cf\u201d\u3002", (String)"XScPoSubQtyValidator_2", (String)"scmc-sctm", (Object[])new Object[0]), i + 1, j + 1));
                }
            }
        }
    }
}

