/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.scmc.im.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;

public class ArrayUtils {
    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static int[] concatAll4Int(int[] first, int[] ... rest) {
        int totalLength = first.length;
        for (int[] array : rest) {
            totalLength += array.length;
        }
        int[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (int[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static String[] arraySort(String[] input) {
        for (int i = 0; i < input.length - 1; ++i) {
            for (int j = 0; j < input.length - i - 1; ++j) {
                if (!ArrayUtils.isBiggerThan(input[j], input[j + 1])) continue;
                String temp = input[j];
                input[j] = input[j + 1];
                input[j + 1] = temp;
            }
        }
        return input;
    }

    private static boolean isBiggerThan(String first, String second) {
        if (first == null || second == null || "".equals(first) || "".equals(second)) {
            return false;
        }
        char[] arrayfirst = first.toCharArray();
        char[] arraysecond = second.toCharArray();
        int minSize = Math.min(arrayfirst.length, arraysecond.length);
        for (int i = 0; i < minSize; ++i) {
            if (arrayfirst[i] > arraysecond[i]) {
                return true;
            }
            if (arrayfirst[i] >= arraysecond[i]) continue;
            return false;
        }
        return arrayfirst.length > arraysecond.length;
    }

    public static boolean isNotEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    public static <K> Map<K, DynamicObject> getDynamicObjectMap(String key, DynamicObject[] dyc) {
        HashMap<Object, DynamicObject> result = new HashMap<Object, DynamicObject>();
        if (dyc != null && dyc.length > 0) {
            for (DynamicObject item : dyc) {
                result.put(item.get(key), item);
            }
        }
        return result;
    }

    public static <K> Map<K, List<DynamicObject>> getDynamicObjectsMap(String key, DynamicObject[] dyc) {
        HashMap<Object, List> result = new HashMap<Object, List>();
        if (dyc != null && dyc.length > 0) {
            for (DynamicObject item : dyc) {
                result.computeIfAbsent(item.get(key), k -> new ArrayList());
                ((List)result.get(item.get(key))).add(item);
            }
        }
        return result;
    }
}

