/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pms.business.helper.CurrencyHelper;

public class SalePriceListHelper {
    private static final Log log = LogFactory.getLog(SalePriceListHelper.class);
    private static final String DEFAULT_EXPIRE_DATE = "2099-12-31";
    private static final String CUSTOMER_TAX_RATE_ID = "taxrate.id";
    private static final String TAX_RATE_ID_FLAG = "taxRateId-";
    private static final String ZERO = "0";
    private static final Long MAX_STAIR_QTY = 9999999999999L;
    private static final String BD_CURRENCY = "bd_currency";
    private static final String APPLY_MATERIAL = "A";
    private static final String APPLY_CUSTOMER = "B";
    private static final String BASECURRRENCY = "baseCurrencyID";
    private static final String MASTERID = "masterid";
    private static final String SALESUNIT = "salesunit";
    private static final String ISUSEAUXPTY = "isuseauxpty";
    public static final String ID = "id";

    public static void completeBillInfo(DynamicObject bill) {
        Long orgId;
        Map<String, Long> currencyAndExRateMap;
        DynamicObject currency;
        Date expiryDate;
        Date effectDate;
        String status;
        if (bill == null) {
            return;
        }
        DynamicObject org = (DynamicObject)bill.get("org");
        if (org == null) {
            return;
        }
        String dataStatus = (String)bill.get("status");
        if (dataStatus == null || dataStatus.isEmpty()) {
            bill.set("status", (Object)StatusEnum.SAVE.getValue());
        }
        if ((status = (String)bill.get("enable")) == null || status.isEmpty()) {
            bill.set("enable", (Object)EnableStatusEnum.ENABLE.getValue());
        }
        Date today = TimeServiceHelper.today();
        String applyMaterial = (String)bill.get("applymaterial");
        if (applyMaterial == null || applyMaterial.isEmpty()) {
            bill.set("applymaterial", (Object)APPLY_MATERIAL);
        }
        if ((effectDate = (Date)bill.get("effectdate")) == null) {
            bill.set("effectdate", (Object)today);
        }
        if ((expiryDate = (Date)bill.get("expirydate")) == null) {
            Date defaultExpiryDate = SalePriceListHelper.convertStrToDate(DEFAULT_EXPIRE_DATE);
            bill.set("expirydate", (Object)defaultExpiryDate);
        }
        if ((currency = (DynamicObject)bill.get("currency")) == null && !(currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable(orgId = (Long)org.getPkValue())).isEmpty()) {
            Long currencyId = currencyAndExRateMap.get(BASECURRRENCY);
            currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)BD_CURRENCY);
            bill.set("currency", (Object)currency);
        }
        SalePriceListHelper.completePriceBillInfo(bill, today);
    }

    private static void completePriceBillInfo(DynamicObject bill, Date today) {
        String applyCustomer = (String)bill.get("applycustomer");
        if (applyCustomer == null || applyCustomer.isEmpty()) {
            bill.set("applycustomer", (Object)APPLY_CUSTOMER);
            applyCustomer = APPLY_CUSTOMER;
        }
        boolean isTax = bill.getBoolean("istax");
        boolean isStair = bill.getBoolean("isstair");
        HashMap<String, Object> tempCache = new HashMap<String, Object>(8);
        DynamicObjectCollection priceEntryEntity = bill.getDynamicObjectCollection("priceentryentity");
        if (priceEntryEntity.size() > 0) {
            for (int row = 0; row < priceEntryEntity.size(); ++row) {
                DynamicObject childEntry;
                int childRow;
                DynamicObject unit;
                Date priceExpiryDate;
                Date priceEffectDate;
                BigDecimal taxRate;
                DynamicObject entry = (DynamicObject)priceEntryEntity.get(row);
                DynamicObject materialSalInfo = entry.getDynamicObject("material");
                DynamicObject material = null;
                DynamicObject salesUnit = null;
                if (materialSalInfo != null) {
                    material = materialSalInfo.getDynamicObject(MASTERID);
                    salesUnit = materialSalInfo.getDynamicObject(SALESUNIT);
                }
                if ((taxRate = SalePriceListHelper.setTaxRateId(bill, entry, material, applyCustomer, tempCache)) != null) {
                    BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
                    BigDecimal price = entry.getBigDecimal("price");
                    if (isTax) {
                        if (BigDecimalUtil.isNotBlank((BigDecimal)priceAndTax)) {
                            price = priceAndTax.divide(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate)), 10, RoundingMode.HALF_UP);
                            entry.set("price", (Object)price);
                        }
                    } else if (BigDecimalUtil.isNotBlank((BigDecimal)price)) {
                        priceAndTax = price.multiply(BigDecimalUtil.ONE.add(BigDecimalUtil.div100((BigDecimal)taxRate))).setScale(10, RoundingMode.HALF_UP);
                        entry.set("priceandtax", (Object)priceAndTax);
                    }
                }
                if ((priceEffectDate = entry.getDate("priceeffectdate")) == null) {
                    entry.set("priceeffectdate", (Object)today);
                }
                if ((priceExpiryDate = entry.getDate("priceexpirydate")) == null) {
                    Date defaultExpiryDate = SalePriceListHelper.convertStrToDate(DEFAULT_EXPIRE_DATE);
                    entry.set("priceexpirydate", (Object)defaultExpiryDate);
                }
                if (material != null) {
                    Boolean isuseauxpty = material.getBoolean(ISUSEAUXPTY);
                    if (!isuseauxpty.booleanValue()) {
                        entry.set("auxpty", null);
                    }
                    DynamicObject baseUnit = material.getDynamicObject("baseunit");
                    entry.set("baseunit", (Object)baseUnit);
                }
                if ((unit = entry.getDynamicObject("unit")) == null && salesUnit != null) {
                    unit = salesUnit;
                }
                entry.set("unit", (Object)unit);
                DynamicObjectCollection salStairPriceEntity = entry.getDynamicObjectCollection("salstairprice");
                if (!isStair || salStairPriceEntity.size() <= 0) continue;
                for (childRow = 0; childRow < salStairPriceEntity.size(); ++childRow) {
                    childEntry = (DynamicObject)salStairPriceEntity.get(childRow);
                    childEntry.set("unitid", (Object)unit);
                    BigDecimal stairQtyStart = (BigDecimal)childEntry.get("stairqtystart");
                    if (stairQtyStart != null) continue;
                    childEntry.set("stairqtystart", (Object)BigDecimal.ZERO);
                }
                if (salStairPriceEntity.size() > 1) {
                    Collections.sort(salStairPriceEntity, (p1, p2) -> {
                        BigDecimal a = p1.getBigDecimal("stairqtystart");
                        BigDecimal b = p2.getBigDecimal("stairqtystart");
                        return a.compareTo(b);
                    });
                    DynamicObject lastSalStairPrice = (DynamicObject)salStairPriceEntity.get(salStairPriceEntity.size() - 1);
                    lastSalStairPrice.set("stairqtyend", (Object)new BigDecimal(MAX_STAIR_QTY));
                }
                for (childRow = 0; childRow < salStairPriceEntity.size(); ++childRow) {
                    childEntry = (DynamicObject)salStairPriceEntity.get(childRow);
                    childEntry.set("seq", (Object)(childRow + 1));
                }
                entry.set("salstairprice", (Object)salStairPriceEntity);
            }
        }
    }

    private static BigDecimal setTaxRateId(DynamicObject bill, DynamicObject entry, DynamicObject material, String applyCustomer, Map<String, Object> tempCache) {
        DynamicObject taxRateIdObj = entry.getDynamicObject("taxrateid");
        BigDecimal taxRate = entry.getBigDecimal("taxrate");
        if (taxRateIdObj != null) {
            Long taxRateId = (Long)taxRateIdObj.getPkValue();
            tempCache.put(TAX_RATE_ID_FLAG + taxRateId, taxRateIdObj);
        } else {
            if (material != null) {
                taxRateIdObj = (DynamicObject)material.get("taxrate");
            }
            if (taxRateIdObj != null) {
                Long taxRateId = (Long)taxRateIdObj.getPkValue();
                taxRateIdObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate, activedate, expdate", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)taxRateId)});
                tempCache.put(TAX_RATE_ID_FLAG + taxRateId, taxRateIdObj);
                entry.set("taxrateid", (Object)taxRateIdObj);
            } else if (APPLY_CUSTOMER.equals(applyCustomer)) {
                DynamicObjectCollection customers = bill.getDynamicObjectCollection("customerentryentity");
                HashSet<Long> taxRateIdSet = new HashSet<Long>();
                for (DynamicObject customerRow : customers) {
                    Long id;
                    DynamicObject customer = (DynamicObject)customerRow.get("customer");
                    if (customer == null || (id = (Long)customer.get(CUSTOMER_TAX_RATE_ID)) == null || Long.valueOf(ZERO).equals(id)) continue;
                    taxRateIdSet.add(id);
                }
                if (taxRateIdSet.size() == 1) {
                    Long taxRateId = (Long)taxRateIdSet.iterator().next();
                    taxRateIdObj = (DynamicObject)tempCache.get(TAX_RATE_ID_FLAG + taxRateId);
                    if (taxRateIdObj == null) {
                        taxRateIdObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"taxrate, activedate, expdate", (QFilter[])new QFilter[]{new QFilter(ID, "=", (Object)taxRateId)});
                        tempCache.put(TAX_RATE_ID_FLAG + taxRateId, taxRateIdObj);
                    }
                    entry.set("taxrateid", (Object)taxRateIdObj);
                }
            }
        }
        if (taxRateIdObj != null) {
            taxRate = taxRateIdObj.getBigDecimal("taxrate");
            entry.set("taxrate", (Object)taxRate);
        }
        return taxRate;
    }

    public static Date convertStrToDate(String bizDate) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date bizTime = null;
        try {
            bizTime = simpleDateFormat.parse(bizDate);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u683c\u5f0f\u5316\u5f02\u5e38\uff01\uff01\uff01" + e.getMessage());
        }
        return bizTime;
    }
}

