/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scmc.pms.business.helper.SalStairEntry;

public class SalesStairPriceHelper {
    private static final int ERRORCODE_1 = 100;
    private static final int ERRORCODE_2 = 200;
    private static final int ERRORCODE_3 = 300;
    private static final int ERRORCODE_4 = 400;
    private static final int ERRORCODE_5 = 500;
    private static final int ERRORCODE_6 = 600;
    private static final int ERRORCODE_7 = 700;

    public static int getCheckStairPrice(BigDecimal minPrice, BigDecimal maxPrice, DynamicObjectCollection salStairPrices) {
        if (salStairPrices == null || salStairPrices.size() <= 1) {
            return -1;
        }
        List<SalStairEntry> list = new ArrayList<SalStairEntry>(8);
        int seq = SalesStairPriceHelper.checkpurStairPrices(list, salStairPrices, minPrice, maxPrice);
        if (seq == 0) {
            list = list.stream().sorted(Comparator.comparing(SalStairEntry::getStairqtystart)).collect(Collectors.toList());
            seq = SalesStairPriceHelper.purStairEntrySort(list);
        }
        if (seq == 0) {
            for (int i = 0; i < salStairPrices.size(); ++i) {
                ((DynamicObject)salStairPrices.get(i)).set("stairqtystart", (Object)list.get(i).getStairqtystart());
                ((DynamicObject)salStairPrices.get(i)).set("stairqtyend", (Object)list.get(i).getStairqtyend());
                ((DynamicObject)salStairPrices.get(i)).set("stairprice", (Object)list.get(i).getStairprice());
            }
        }
        return seq;
    }

    private static int checkpurStairPrices(List<SalStairEntry> list, DynamicObjectCollection salStairPrices, BigDecimal minPrice, BigDecimal maxPrice) {
        int seq = 1;
        for (DynamicObject salStairPrice : salStairPrices) {
            SalStairEntry salStairEntry = new SalStairEntry();
            salStairEntry.setSeq(seq);
            BigDecimal stairPrice = salStairPrice.getBigDecimal("stairprice");
            if (stairPrice == null || stairPrice.compareTo(BigDecimal.ZERO) <= 0) {
                return 100;
            }
            if (minPrice.compareTo(BigDecimal.ZERO) != 0 && stairPrice.compareTo(minPrice) < 0) {
                return 200;
            }
            if (maxPrice.compareTo(BigDecimal.ZERO) != 0 && stairPrice.compareTo(maxPrice) > 0) {
                return 300;
            }
            BigDecimal stairQtyStart = salStairPrice.getBigDecimal("stairqtystart");
            BigDecimal stairQtyEnd = salStairPrice.getBigDecimal("stairqtyend");
            if (stairQtyEnd.compareTo(BigDecimal.ZERO) > 0 && stairQtyStart.compareTo(stairQtyEnd) >= 0) {
                return 400;
            }
            salStairEntry.setStairqtystart(stairQtyStart);
            salStairEntry.setStairqtyend(stairQtyEnd);
            salStairEntry.setStairprice(stairPrice);
            list.add(salStairEntry);
            ++seq;
        }
        return 0;
    }

    private static int purStairEntrySort(List<SalStairEntry> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            SalStairEntry stairFirst = list.get(0);
            SalStairEntry stairRow = list.get(i);
            SalStairEntry stairNextRow = list.get(i + 1);
            if (stairFirst.getStairqtystart().compareTo(BigDecimal.ZERO) != 0) {
                return 500;
            }
            if (stairRow.getStairqtyend().compareTo(BigDecimal.ZERO) == 0) {
                return 600;
            }
            if (stairRow.getStairqtyend().compareTo(stairNextRow.getStairqtystart()) == 0) continue;
            return 700;
        }
        return 0;
    }

    public static String getDetailMsg(int count) {
        String msgDetail = "";
        switch (count) {
            case -1: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u5206\u5f55\u9700\u8981\u81f3\u5c11\u67092\u884c\u6570\u636e\u3002", (String)"SalesPriceSubmitValidator_20", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 100: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"SalesPriceSubmitValidator_13", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 200: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u5c0f\u4e8e\u6700\u4f4e\u9650\u4ef7\u3002", (String)"SalesPriceSubmitValidator_14", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 300: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u4e0d\u80fd\u5927\u4e8e\u6700\u9ad8\u9650\u4ef7\u3002", (String)"SalesPriceSubmitValidator_15", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 400: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u540c\u4e00\u884c\u9636\u68af\u6570\u91cf(\u4ece)\u5fc5\u987b\u5c0f\u4e8e\u9636\u68af\u6570\u91cf(\u81f3)\u3002", (String)"SalesPriceSubmitValidator_16", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 500: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u8d77\u59cb\u884c\u9636\u68af\u6570\u91cf(\u4ece)\u5fc5\u987b\u4e3a0\u3002", (String)"SalesPriceSubmitValidator_17", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 600: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u622a\u6b62\u884c\u4e4b\u5916\u7684\u884c\uff0c\u5fc5\u987b\u5f55\u5165\u201c\u9636\u68af\u6570\u91cf(\u81f3)\u201d\u3002", (String)"SalesPriceSubmitValidator_18", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
                break;
            }
            case 700: {
                msgDetail = ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u884c\u7684\u9636\u68af\u6570\u91cf(\u4ece)\u5fc5\u987b\u7b49\u4e8e\u4e0a\u4e00\u884c\u7684\u9636\u68af\u6570\u91cf(\u81f3)\u3002", (String)"SalesPriceSubmitValidator_19", (String)"scmc-sm-opplugin", (Object[])new Object[0]);
            }
        }
        return msgDetail;
    }
}

