/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.custom.ext.bizextplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.sm.enums.CloseStatusEnum;
import kd.scmc.sm.enums.RowCloseStatusEnum;
import kd.sdk.scmc.sm.extpoint.IXSalOrderCasePlugin;

public class XSalOrderSynOrderStatusImpl
implements IXSalOrderCasePlugin {
    private static final Log logger = LogFactory.getLog(XSalOrderSynOrderStatusImpl.class);

    public boolean activeSynOrderBillStatus(DynamicObject srcBill) {
        DynamicObjectCollection billEntry = srcBill.getDynamicObjectCollection("billentry");
        boolean billClose = true;
        if (billEntry != null && !billEntry.isEmpty()) {
            int size = billEntry.size();
            for (int i = 0; i < size; ++i) {
                DynamicObject row = (DynamicObject)billEntry.get(i);
                DynamicObject lineType = row.getDynamicObject("linetype");
                String number = lineType.getString("number");
                if ("010".equals(number)) {
                    BigDecimal deliverBaseQtyDown = row.getBigDecimal("deliverbaseqtydown");
                    BigDecimal invBaseQty = row.getBigDecimal("invbaseqty");
                    if (invBaseQty == null || deliverBaseQtyDown == null) continue;
                    if (invBaseQty.compareTo(deliverBaseQtyDown) >= 0) {
                        row.set("rowclosestatus", (Object)RowCloseStatusEnum.ROWCLOSE.getValue());
                        continue;
                    }
                    row.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
                    billClose = false;
                    continue;
                }
                String rowCloseStatus = row.getString("rowclosestatus");
                if (!RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus)) continue;
                billClose = false;
            }
        }
        logger.info("\u6574\u5355\u662f\u5426\u5b8c\u5168\u5173\u95ed:{}", (Object)billClose);
        if (billClose) {
            srcBill.set("closestatus", (Object)CloseStatusEnum.CLOSED.getValue());
            srcBill.set("closer", (Object)UserServiceHelper.getCurrentUserId());
            srcBill.set("closedate", (Object)TimeServiceHelper.now());
        } else {
            srcBill.set("closestatus", (Object)CloseStatusEnum.UNCLOSED.getValue());
            srcBill.set("closer", null);
            srcBill.set("closedate", null);
        }
        return true;
    }
}

