/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.BizCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.DiscountTypeEnum;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.enums.PayModeEnum;
import kd.mpscmm.msbd.common.enums.RowCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.RowTerminateStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.enums.UnitConvertDirEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.business.helper.LotHelper;
import kd.scmc.sm.business.helper.MaterialHelper;
import kd.scmc.sm.enums.CustomerFunction;

public class BillTplDefaultValueHandler {
    private static final String SPLIT = "-";
    private final List<DynamicObject> bills;
    private final String entityName;
    private final long userId = UserServiceHelper.getCurrentUserId();
    private DynamicObject defaultBillType;
    private final Map<Long, Object> defaultBizTypeCache = new HashMap<Long, Object>(32);
    private final Map<Long, Map<String, DynamicObject>> defaultOperatorGroupMapCache = new HashMap<Long, Map<String, DynamicObject>>(32);
    private final Map<Long, Object> defaultLineTypeCache = new HashMap<Long, Object>(32);
    private Boolean isUseLot;
    private final Map<String, Object> lotCache = new HashMap<String, Object>(64);

    public List<DynamicObject> handleDefaultValues() {
        for (DynamicObject bill : this.bills) {
            this.handleHeadDefaultValues(bill);
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
            if (entry != null) {
                for (DynamicObject row : entry) {
                    this.handleEntryDefaultValues(bill, row);
                }
            }
            this.calcAllAmount(bill);
        }
        return this.bills;
    }

    protected void handleHeadDefaultValues(DynamicObject bill) {
        this.setDefaultHeadStatus(bill);
        this.setDefaultBillType(bill);
        this.setDefaultBizType(bill);
        this.setDefaultOperatorGroup(bill);
        this.setDefaultDept(bill);
        this.setDefaultByCustomer(bill);
        this.setDefaultFinancialInfo(bill);
    }

    protected void handleEntryDefaultValues(DynamicObject bill, DynamicObject row) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject settleOrg = bill.getDynamicObject("settleorg");
        String billStatus = bill.getString("billstatus");
        DynamicObject bizType = bill.getDynamicObject("biztype");
        DynamicObject customer = bill.getDynamicObject("customer");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        boolean isTax = bill.getBoolean("istax");
        this.setDefaultEntryStatus(billStatus, row);
        this.setDefaultLineType(bizType, row);
        this.setDefaultByMaterial(row);
        this.setDefaultEntryOrg(org, settleOrg, row);
        this.setDefaultByQty(row);
        this.setDefaultOwner(org, bizType, row);
        this.setDefaultTax(customer, row);
        this.setDefaultDiscount(isTax, row);
    }

    protected void calcAllAmount(DynamicObject bill) {
        BillTplHelper.calculateAmount4WholeBill(bill, null);
    }

    protected void setDefaultDiscount(boolean isTax, DynamicObject row) {
        if (!row.getBoolean("ispresent")) {
            return;
        }
        BigDecimal price = isTax ? row.getBigDecimal("priceandtax") : row.getBigDecimal("price");
        if (BigDecimalUtil.isBlank((BigDecimal)price)) {
            row.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
            row.set("discountrate", (Object)BigDecimalUtil.ZERO);
        } else {
            row.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
            row.set("discountrate", (Object)BigDecimalUtil.HUNDRED);
        }
    }

    protected void setDefaultTax(DynamicObject customer, DynamicObject row) {
        DynamicObject taxRateId = row.getDynamicObject("taxrateid");
        if (taxRateId == null) {
            DynamicObject material = row.getDynamicObject("material");
            taxRateId = MaterialHelper.getDefaultTaxRate(customer, material);
            row.set("taxrateid", (Object)taxRateId);
        }
        BigDecimal taxRate = taxRateId == null ? BigDecimal.ZERO : taxRateId.getBigDecimal("taxrate");
        row.set("taxrate", (Object)taxRate);
    }

    protected void setDefaultOwner(DynamicObject org, DynamicObject bizType, DynamicObject row) {
    }

    protected void setDefaultByQty(DynamicObject row) {
        DynamicObject material = row.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        BigDecimal qty = row.getBigDecimal("qty");
        BigDecimal baseQty = row.getBigDecimal("baseqty");
        DynamicObject unit = row.getDynamicObject("unit");
        DynamicObject baseUnit = row.getDynamicObject("baseunit");
        if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) {
            qty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
            row.set("qty", (Object)qty);
        } else if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
            baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            row.set("baseqty", (Object)baseQty);
        }
        DynamicObject auxUnit = row.getDynamicObject("auxunit");
        if (auxUnit != null && BigDecimalUtil.isBlank((BigDecimal)row.getBigDecimal("auxqty"))) {
            String unitConvertDir = masterMaterial.getString("unitconvertdir");
            if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                row.set("auxqty", (Object)BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit));
            }
        }
    }

    protected void setDefaultEntryOrg(DynamicObject org, DynamicObject settleOrg, DynamicObject row) {
        if (org != null) {
            row.set("salesorg", (Object)org);
        }
    }

    protected void setDefaultByMaterial(DynamicObject row) {
        String lotNumber;
        DynamicObject material = row.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        if (masterMaterial == null) {
            return;
        }
        row.set("materialmasterid", (Object)masterMaterial);
        if (!masterMaterial.getBoolean("isdisposable") || StringUtils.isEmpty((String)row.getString("materialname"))) {
            row.set("materialname", (Object)masterMaterial.getString("name"));
        }
        DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
        row.set("baseunit", (Object)baseUnit);
        DynamicObject salesUnit = material.getDynamicObject("salesunit");
        if (row.get("unit") == null) {
            row.set("unit", (Object)salesUnit);
        }
        DynamicObject auxUnit = masterMaterial.getDynamicObject("auxptyunit");
        row.set("auxunit", (Object)auxUnit);
        if (auxUnit == null) {
            row.set("auxqty", (Object)BigDecimal.ZERO);
        }
        if (!masterMaterial.getBoolean("isuseauxpty")) {
            row.set("auxpty", null);
        }
        if (row.get("productline") == null) {
            row.set("productline", (Object)masterMaterial.getDynamicObject("productline"));
        }
        if (!"2".equals(masterMaterial.getString("configproperties"))) {
            row.set("configuredcode", null);
        }
        if (StringUtils.isNotEmpty((String)(lotNumber = row.getString("lotnumber")))) {
            if (this.isUseLot()) {
                row.set("lot", (Object)this.getLotFromCache((Long)masterMaterial.getPkValue(), lotNumber));
            } else {
                row.set("lot", null);
            }
        }
    }

    protected void setDefaultLineType(DynamicObject bizType, DynamicObject row) {
        if (bizType != null && row.get("linetype") == null) {
            row.set("linetype", (Object)this.getLineTypeFromCache((Long)bizType.getPkValue()));
        }
    }

    protected void setDefaultEntryStatus(String billStatus, DynamicObject row) {
        String rowCloseStatus = row.getString("rowclosestatus");
        String rowTerminateStatus = row.getString("rowterminatestatus");
        if (StatusEnum.SAVE.getValue().equals(billStatus) || StatusEnum.SUBMIT.getValue().equals(billStatus)) {
            row.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            row.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
        } else {
            if (StringUtils.isEmpty((String)rowCloseStatus)) {
                row.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            }
            if (StringUtils.isEmpty((String)rowTerminateStatus)) {
                row.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
            }
        }
    }

    protected void setDefaultFinancialInfo(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        String exchangeType = bill.getString("exchangetype");
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        Date exRateTime = bill.getDate("exratedate");
        if (currency == null && org != null) {
            currency = CurrencyHelper.getCurrency((Long)org.getPkValue());
            bill.set("currency", (Object)currency);
        }
        if (settleCurrency == null) {
            settleCurrency = currency;
            bill.set("settlecurrency", (Object)settleCurrency);
        }
        if (exRateTable == null && org != null) {
            exRateTable = CurrencyHelper.getExRateTable((Long)org.getPkValue());
            bill.set("exratetable", (Object)exRateTable);
        }
        if (exRateTime == null) {
            exRateTime = bill.getDate("bizdate");
            bill.set("exratedate", (Object)exRateTime);
        }
        if (currency != null && exRateTable != null) {
            BigDecimal exRate = null;
            if (StringUtils.isEmpty((String)exchangeType)) {
                Map exRateMap = kd.mpscmm.msbd.business.helper.CurrencyHelper.getExChangeRateMap((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)exRateTime);
                exRate = (BigDecimal)exRateMap.get("exchangerate");
                exchangeType = (String)exRateMap.get("exchangetype");
                bill.set("exchangetype", (Object)exchangeType);
            }
            if (BigDecimalUtil.isBlank((BigDecimal)exchangeRate)) {
                exchangeRate = exRate != null ? exRate : kd.mpscmm.msbd.business.helper.CurrencyHelper.getExChangeRate((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)exRateTime, (String)exchangeType);
                bill.set("exchangerate", (Object)exchangeRate);
            }
        }
        if (bill.getString("paymode") == null) {
            bill.set("paymode", (Object)PayModeEnum.CREDIT.getValue());
        }
    }

    protected void setDefaultByCustomer(DynamicObject bill) {
        DynamicObject customer = bill.getDynamicObject("customer");
        if (customer == null) {
            return;
        }
        if (StringUtils.isEmpty((String)bill.getString("address"))) {
            bill.set("address", (Object)CustomerHelper.getAddress(customer));
        }
        if (bill.getDynamicObject("linkman") == null) {
            bill.set("linkman", (Object)CustomerHelper.getLinkmanObject(customer));
        }
        if (bill.getDynamicObject("settletype") == null) {
            bill.set("settletype", (Object)CustomerHelper.getDefaultSettleTypeObj(customer));
        }
        if (bill.get("reccustomer") == null) {
            bill.set("reccustomer", (Object)CustomerHelper.getOtherCustomer(customer, "delivercustomerid", CustomerFunction.RECEIVE));
        }
        if (bill.get("payingcustomer") == null) {
            bill.set("payingcustomer", (Object)CustomerHelper.getOtherCustomer(customer, "paymentcustomerid", CustomerFunction.PAY));
        }
        if (bill.get("settlecustomer") == null) {
            bill.set("settlecustomer", (Object)CustomerHelper.getOtherCustomer(customer, "invoicecustomerid", CustomerFunction.SETTLE));
        }
    }

    protected void setDefaultDept(DynamicObject bill) {
        DynamicObject user;
        DynamicObject operator;
        DynamicObject dept = bill.getDynamicObject("dept");
        if (dept == null && (operator = bill.getDynamicObject("operator")) != null && (user = operator.getDynamicObject("operatorid")) != null) {
            bill.set("dept", (Object)OrgHelper.getDefaultDepartmentObject((Long)((Long)user.getPkValue())));
        }
    }

    protected void setDefaultOperatorGroup(DynamicObject bill) {
        if (this.userId == 0L) {
            return;
        }
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        if (operator == null) {
            Map<String, DynamicObject> defaultOperatorAndGroup = this.getOperatorGroupMapFromCache(org);
            if (!defaultOperatorAndGroup.isEmpty()) {
                bill.set("operator", (Object)defaultOperatorAndGroup.get("operator"));
                if (operatorGroup == null) {
                    bill.set("operatorgroup", (Object)defaultOperatorAndGroup.get("operatorgroup"));
                }
            }
        } else if (operatorGroup == null) {
            operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.get("operatorgrpid"), (String)"bd_operatorgroup");
            bill.set("operatorgroup", (Object)operatorGroup);
        }
    }

    protected void setDefaultBizType(DynamicObject bill) {
        DynamicObject bizType;
        DynamicObject billType;
        if (bill.getDynamicObject("biztype") == null && (billType = bill.getDynamicObject("billtype")) != null && (bizType = this.getBizTypeFromCache(billType)) != null) {
            bill.set("biztype", (Object)bizType);
        }
    }

    protected void setDefaultHeadStatus(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        if (CommonUtils.isNull((Object)billStatus)) {
            bill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        }
        Date now = new Date();
        if (CommonUtils.isNull((Object)bill.getDate("biztime"))) {
            bill.set("biztime", (Object)now);
        }
        if (CommonUtils.isNull((Object)bill.getDate("bizdate"))) {
            bill.set("bizdate", (Object)now);
        }
        if (billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("auditor", null);
            bill.set("auditdate", null);
            bill.set("closer", null);
            bill.set("closedate", null);
            bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
        } else if (CommonUtils.isNull((Object)bill.getString("closestatus"))) {
            bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            bill.set("closer", null);
            bill.set("closedate", null);
        }
    }

    protected void setDefaultBillType(DynamicObject bill) {
        DynamicObject billType;
        if (bill.getDynamicObject("billtype") == null && (billType = this.getBillTypeFromCache()) != null) {
            bill.set("billtype", (Object)billType);
        }
    }

    private DynamicObject getBillTypeFromCache() {
        if (this.defaultBillType == null) {
            this.defaultBillType = BillTypeHelper.getDefaultBillTypeObject((String)this.entityName);
        }
        return this.defaultBillType;
    }

    private DynamicObject getLotFromCache(Long materialMasterId, String lotNumber) {
        String lotCacheKey = materialMasterId + SPLIT + lotNumber;
        Object lot = this.lotCache.get(lotCacheKey);
        if (lot == null) {
            QFilter qFilter = new QFilter("number", "=", (Object)lotNumber).and(new QFilter("material", "=", (Object)materialMasterId));
            lot = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_lot", (QFilter[])qFilter.toArray());
            if (lot == null) {
                this.lotCache.put(lotCacheKey, 0L);
            } else {
                this.lotCache.put(lotCacheKey, lot);
            }
            return (DynamicObject)lot;
        }
        return lot instanceof DynamicObject ? (DynamicObject)lot : null;
    }

    private boolean isUseLot() {
        if (this.isUseLot == null) {
            this.isUseLot = LotHelper.isUseLotMainFile();
        }
        return this.isUseLot;
    }

    private DynamicObject getLineTypeFromCache(Long bizTypeId) {
        Object defaultLineType = this.defaultLineTypeCache.get(bizTypeId);
        if (defaultLineType == null) {
            defaultLineType = BizTypeHelper.getDefaultLineTypeObject((Long)bizTypeId);
            if (defaultLineType == null) {
                this.defaultLineTypeCache.put(bizTypeId, 0L);
            } else {
                this.defaultLineTypeCache.put(bizTypeId, defaultLineType);
            }
            return (DynamicObject)defaultLineType;
        }
        return defaultLineType instanceof DynamicObject ? (DynamicObject)defaultLineType : null;
    }

    private Map<String, DynamicObject> getOperatorGroupMapFromCache(DynamicObject org) {
        Long orgId = (Long)org.getPkValue();
        Map defaultMap = this.defaultOperatorGroupMapCache.get(orgId);
        if (defaultMap == null) {
            defaultMap = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)orgId, (Long)this.userId, (String)OperatorGrpTypeEnum.SALEGRP.getValue());
            this.defaultOperatorGroupMapCache.put(orgId, defaultMap);
        }
        return defaultMap;
    }

    private DynamicObject getBizTypeFromCache(DynamicObject billType) {
        Long billTypeId = (Long)billType.getPkValue();
        Object defaultBizType = this.defaultBizTypeCache.get(billTypeId);
        if (defaultBizType == null) {
            defaultBizType = BizTypeHelper.getDefaultBizTypeObject((String)this.entityName, (Long)billTypeId, (String)"sm_billtypeparam");
            if (defaultBizType == null) {
                this.defaultBizTypeCache.put(billTypeId, 0L);
            } else {
                this.defaultBizTypeCache.put(billTypeId, defaultBizType);
            }
            return (DynamicObject)defaultBizType;
        }
        return defaultBizType instanceof DynamicObject ? (DynamicObject)defaultBizType : null;
    }

    public BillTplDefaultValueHandler(DynamicObject ... bill) {
        if (bill.length == 0) {
            throw new IllegalArgumentException("bills can not be empty!");
        }
        this.entityName = bill[0].getDynamicObjectType().getName();
        this.bills = new ArrayList<DynamicObject>(bill.length);
        this.bills.addAll(Arrays.asList(bill));
    }

    public BillTplDefaultValueHandler(List<DynamicObject> bills) {
        if (bills == null || bills.isEmpty()) {
            throw new IllegalArgumentException("bills can not be empty!");
        }
        this.entityName = bills.get(0).getDynamicObjectType().getName();
        this.bills = bills;
    }
}

