/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.scmc.sm.business.handler.BillTplDefaultValueHandler;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.util.CommonUtils;

public class SaleReturnApplyDefaultValueHandler
extends BillTplDefaultValueHandler {
    public SaleReturnApplyDefaultValueHandler(DynamicObject ... bill) {
        super(bill);
    }

    public SaleReturnApplyDefaultValueHandler(List<DynamicObject> bills) {
        super(bills);
    }

    @Override
    protected void handleHeadDefaultValues(DynamicObject bill) {
        super.handleHeadDefaultValues(bill);
        this.setCustomerInfo(bill);
    }

    @Override
    protected void handleEntryDefaultValues(DynamicObject bill, DynamicObject row) {
        HashMap cacheMap = new HashMap(8);
        super.handleEntryDefaultValues(bill, row);
        DynamicObject bizType = (DynamicObject)bill.get("biztype");
        String bizTypeNum = (String)bizType.get("number");
        DynamicObject saleOrg = bill.getDynamicObject("org");
        this.setProductType(row);
        this.setOwnerType(row, bizTypeNum);
        this.setOwner(row);
        this.setInspectOrg(row, cacheMap);
        this.setSettleOrg(row, saleOrg, cacheMap);
        this.forceSetValues(row);
    }

    protected void setProductType(DynamicObject row) {
        if (CommonUtils.isNull((Object)row.getString("producttype"))) {
            row.set("producttype", (Object)"standard");
        }
    }

    protected void forceSetValues(DynamicObject row) {
        row.set("pricemodel", null);
        row.set("kittransfermodel", null);
        row.set("kitqty", null);
        row.set("parentqty", null);
        row.set("kitpid", null);
        row.set("kitproduct", null);
        row.set("bom", null);
    }

    protected void setOwnerType(DynamicObject row, String bizTypeNum) {
        if (row.get("ownertype") == null) {
            if (bizTypeNum.equals("2101") || bizTypeNum.equals("2102")) {
                row.set("ownertype", (Object)"bos_org");
            }
        } else if (bizTypeNum.equals("2401")) {
            row.set("ownertype", (Object)"bd_supplier");
        } else if (!bizTypeNum.equals("2101") && !bizTypeNum.equals("2102")) {
            row.set("ownertype", (Object)"bos_org");
        }
    }

    protected void setOwner(DynamicObject row) {
        Long entryInvOrgId;
        DynamicObject defaultOrg;
        DynamicObject entryInvOrg;
        if (row.get("owner") == null && "bos_org".equals(row.get("ownertype")) && (entryInvOrg = row.getDynamicObject("entryinvorg")) != null && (defaultOrg = OrgHelper.getOrgForFormDefObjValue((Long)(entryInvOrgId = (Long)entryInvOrg.getPkValue()), (String)"10", (String)"05", (String)"fromorg")) != null) {
            row.set("owner", (Object)defaultOrg);
        }
    }

    protected void setInspectOrg(DynamicObject row, Map cacheMap) {
        DynamicObject inspectOrg = row.getDynamicObject("inspectorg");
        DynamicObject entryInvOrg = row.getDynamicObject("entryinvorg");
        if (inspectOrg == null && entryInvOrg != null) {
            DynamicObject defaultOrg;
            Long entryInvOrgId = (Long)entryInvOrg.getPkValue();
            String inspectCacheKey = entryInvOrgId + "inspectorg";
            if (cacheMap.containsKey(inspectCacheKey)) {
                defaultOrg = (DynamicObject)cacheMap.get(inspectCacheKey);
            } else {
                defaultOrg = OrgHelper.getOrgForFormDefObjValue((Long)entryInvOrgId, (String)"", (String)"06", (String)"toorg");
                cacheMap.put(inspectCacheKey, defaultOrg);
            }
            row.set("inspectorg", (Object)defaultOrg);
        }
    }

    private void setSettleOrg(DynamicObject row, DynamicObject saleOrg, Map cacheMap) {
        DynamicObject entrySettleOrg = row.getDynamicObject("entrysettleorg");
        if (entrySettleOrg == null && saleOrg != null) {
            DynamicObject defaultOrg;
            Long orgId = (Long)saleOrg.getPkValue();
            String settleCacheKey = orgId + "settleorg";
            if (cacheMap.containsKey(settleCacheKey)) {
                defaultOrg = (DynamicObject)cacheMap.get(settleCacheKey);
            } else {
                defaultOrg = OrgHelper.getOrgForFormDefObjValue((Long)orgId, (String)"03", (String)"10", (String)"toorg");
                cacheMap.put(settleCacheKey, defaultOrg);
            }
            row.set("entrysettleorg", (Object)defaultOrg);
        }
    }

    @Override
    protected void setDefaultByQty(DynamicObject row) {
        super.setDefaultByQty(row);
    }

    protected void setCustomerInfo(DynamicObject bill) {
        DynamicObject recCustomer = bill.getDynamicObject("reccustomer");
        if (recCustomer != null) {
            if (bill.get("reclinkman") == null) {
                bill.set("reclinkman", (Object)CustomerHelper.getLinkmanObject(recCustomer));
            }
            if (StringUtils.isEmpty((String)bill.getString("receiveaddress"))) {
                bill.set("receiveaddress", (Object)CustomerHelper.getAddress(recCustomer));
            }
        }
    }
}

