/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.handler;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.business.handler.BillTplDefaultValueHandler;
import kd.scmc.sm.business.helper.SystemCallParamHelper;

public class SalesAgencyDefaultValueHandler
extends BillTplDefaultValueHandler {
    private Boolean isBookDateEqBizDate;

    @Override
    protected void handleHeadDefaultValues(DynamicObject bill) {
        super.handleHeadDefaultValues(bill);
        this.setDefaultBookDate(bill);
        this.setDefaultVerify(bill);
    }

    @Override
    protected void handleEntryDefaultValues(DynamicObject bill, DynamicObject row) {
        super.handleEntryDefaultValues(bill, row);
        this.setDefaultSettleType(row);
    }

    protected void setDefaultSettleType(DynamicObject row) {
        if (row.get("settlementtype") == null) {
            row.set("settlementtype", (Object)"B");
        }
    }

    protected void setDefaultVerify(DynamicObject bill) {
        bill.set("isverify", (Object)Boolean.FALSE);
    }

    protected void setDefaultBookDate(DynamicObject bill) {
        if (this.isBookDateEqBizDate == null) {
            this.isBookDateEqBizDate = SystemCallParamHelper.isBookDateEqBizDate();
        }
        if (this.isBookDateEqBizDate.booleanValue() || bill.get("bookdate") == null) {
            bill.set("bookdate", (Object)bill.getDate("bizdate"));
        }
    }

    @Override
    protected void setDefaultByQty(DynamicObject row) {
        DynamicObject material;
        super.setDefaultByQty(row);
        BigDecimal unVerifyQty = row.getBigDecimal("entrustunverifyqty");
        if (BigDecimalUtil.isBlank((BigDecimal)unVerifyQty)) {
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)row.get("qty"));
            BigDecimal verifyQty = BigDecimalUtil.getNotNull((Object)row.get("entrustverifyqty"));
            unVerifyQty = qty.subtract(verifyQty);
            row.set("entrustunverifyqty", (Object)unVerifyQty);
        }
        if ((material = row.getDynamicObject("material")) == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        DynamicObject unit = row.getDynamicObject("unit");
        DynamicObject baseUnit = row.getDynamicObject("baseunit");
        row.set("entrustunverifybaseqty", (Object)BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)unit, (BigDecimal)unVerifyQty, (DynamicObject)baseUnit));
    }

    public SalesAgencyDefaultValueHandler(DynamicObject ... bill) {
        super(bill);
    }

    public SalesAgencyDefaultValueHandler(List<DynamicObject> bills) {
        super(bills);
    }
}

