/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.enums.ExChangeTypeEnum;

public class AmountCalcHelper {
    private AmountCalcHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void resetAmount(IDataModel bill, int[] rowIndexs, BigDecimal sign) {
        BigDecimal totalTaxAmount = (BigDecimal)bill.getValue("totaltaxamount");
        BigDecimal totalAmount = (BigDecimal)bill.getValue("totalamount");
        BigDecimal totalAllAmount = (BigDecimal)bill.getValue("totalallamount");
        BigDecimal cur_totalAmount = (BigDecimal)bill.getValue("curtotalamount");
        BigDecimal cur_totalAllAmount = (BigDecimal)bill.getValue("curtotalallamount");
        for (int seq : rowIndexs) {
            BigDecimal taxAmount = (BigDecimal)bill.getValue("taxamount", seq);
            BigDecimal amount = (BigDecimal)bill.getValue("amount", seq);
            BigDecimal amountAndTax = (BigDecimal)bill.getValue("amountandtax", seq);
            BigDecimal curAmount = (BigDecimal)bill.getValue("curamount", seq);
            BigDecimal curAmountAndTax = (BigDecimal)bill.getValue("curamountandtax", seq);
            totalTaxAmount = totalTaxAmount.subtract(taxAmount.multiply(sign));
            totalAmount = totalAmount.subtract(amount.multiply(sign));
            totalAllAmount = totalAllAmount.subtract(amountAndTax.multiply(sign));
            cur_totalAmount = cur_totalAmount.subtract(curAmount.multiply(sign));
            cur_totalAllAmount = cur_totalAllAmount.subtract(curAmountAndTax.multiply(sign));
        }
        bill.setValue("totalamount", (Object)totalAmount);
        bill.setValue("totalallamount", (Object)totalAllAmount);
        bill.setValue("totaltaxamount", (Object)totalTaxAmount);
        bill.setValue("curtotalamount", (Object)cur_totalAmount);
        bill.setValue("curtotalallamount", (Object)cur_totalAllAmount);
    }

    public static void recalHeadAmount(DynamicObject bill, int rowIndex) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)billentry.get(rowIndex);
        BigDecimal totalTaxAmount = bill.getBigDecimal("totaltaxamount");
        BigDecimal totalAmount = bill.getBigDecimal("totalamount");
        BigDecimal totalAllAmount = bill.getBigDecimal("totalallamount");
        BigDecimal cur_totalAmount = bill.getBigDecimal("curtotalamount");
        BigDecimal cur_totalAllAmount = bill.getBigDecimal("curtotalallamount");
        BigDecimal taxAmount = entry.getBigDecimal("taxamount");
        BigDecimal amount = entry.getBigDecimal("amount");
        BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
        BigDecimal curAmount = entry.getBigDecimal("curamount");
        BigDecimal curAmountAndTax = entry.getBigDecimal("curamountandtax");
        totalTaxAmount = totalTaxAmount.subtract(taxAmount);
        totalAmount = totalAmount.subtract(amount);
        totalAllAmount = totalAllAmount.subtract(amountAndTax);
        cur_totalAmount = cur_totalAmount.subtract(curAmount);
        cur_totalAllAmount = cur_totalAllAmount.subtract(curAmountAndTax);
        bill.set("totalamount", (Object)totalAmount);
        bill.set("totalallamount", (Object)totalAllAmount);
        bill.set("totaltaxamount", (Object)totalTaxAmount);
        bill.set("curtotalamount", (Object)cur_totalAmount);
        bill.set("curtotalallamount", (Object)cur_totalAllAmount);
    }

    public static Map<String, BigDecimal> getHeadAmount(IDataModel bill, int[] rowIndexs, BigDecimal sign) {
        BigDecimal totalTaxAmount = (BigDecimal)bill.getValue("totaltaxamount");
        BigDecimal totalAmount = (BigDecimal)bill.getValue("totalamount");
        BigDecimal totalAllAmount = (BigDecimal)bill.getValue("totalallamount");
        BigDecimal cur_totalAmount = (BigDecimal)bill.getValue("curtotalamount");
        BigDecimal cur_totalAllAmount = (BigDecimal)bill.getValue("curtotalallamount");
        for (int seq : rowIndexs) {
            BigDecimal taxAmount = (BigDecimal)bill.getValue("taxamount", seq);
            BigDecimal amount = (BigDecimal)bill.getValue("amount", seq);
            BigDecimal amountAndTax = (BigDecimal)bill.getValue("amountandtax", seq);
            BigDecimal curAmount = (BigDecimal)bill.getValue("curamount", seq);
            BigDecimal curAmountAndTax = (BigDecimal)bill.getValue("curamountandtax", seq);
            totalTaxAmount = totalTaxAmount.subtract(taxAmount.multiply(sign));
            totalAmount = totalAmount.subtract(amount.multiply(sign));
            totalAllAmount = totalAllAmount.subtract(amountAndTax.multiply(sign));
            cur_totalAmount = cur_totalAmount.subtract(curAmount.multiply(sign));
            cur_totalAllAmount = cur_totalAllAmount.subtract(curAmountAndTax.multiply(sign));
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("totalamount", totalAmount);
        map.put("totalallamount", totalAllAmount);
        map.put("totaltaxamount", totalTaxAmount);
        map.put("curtotalamount", cur_totalAmount);
        map.put("curtotalallamount", cur_totalAllAmount);
        return map;
    }

    public static Map<String, BigDecimal> getEntrySumCount(DynamicObject bill, String ... entryKey) {
        return AmountCalcHelper.getEntrySumCount(bill, null, null, entryKey);
    }

    public static Map<String, BigDecimal> getEntrySumCount(DynamicObject bill, String excludeKey, Object excludeValue, String[] entryKey) {
        ConcurrentHashMap<String, BigDecimal> sumMap = new ConcurrentHashMap<String, BigDecimal>(16);
        if (bill == null || entryKey == null || entryKey.length == 0) {
            return sumMap;
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.isEmpty()) {
            return sumMap;
        }
        for (String key : entryKey) {
            sumMap.put(key, BigDecimal.ZERO);
        }
        for (DynamicObject row : entry) {
            if (StringUtils.isNotEmpty((String)excludeKey) && row.get(excludeKey).equals(excludeValue)) continue;
            for (Map.Entry e : sumMap.entrySet()) {
                BigDecimal value = row.getBigDecimal((String)e.getKey());
                if (value == null) continue;
                sumMap.put((String)e.getKey(), ((BigDecimal)e.getValue()).add(value));
            }
        }
        return sumMap;
    }

    public static BigDecimal getCurAmountByRate(BigDecimal amount, BigDecimal exChangeRate, int currencyPrecision, String exChangeType) {
        BigDecimal curAmount = BigDecimal.ZERO;
        if (amount == null) {
            return curAmount;
        }
        if (exChangeRate == null || exChangeRate.compareTo(BigDecimal.ZERO) == 0) {
            return curAmount;
        }
        curAmount = exChangeType != null && ExChangeTypeEnum.INDIRECTRATE.getValue().equals(exChangeType) ? amount.divide(exChangeRate, currencyPrecision, RoundingMode.HALF_UP) : amount.multiply(exChangeRate).setScale(currencyPrecision, RoundingMode.HALF_UP);
        return curAmount;
    }

    public static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill) {
        HashMap<String, String> fieldMapping = new HashMap<String, String>(8);
        fieldMapping.put("totalamount", "amount");
        fieldMapping.put("totaltaxamount", "taxamount");
        fieldMapping.put("totalallamount", "amountandtax");
        fieldMapping.put("curtotalamount", "curamount");
        fieldMapping.put("curtotalallamount", "curamountandtax");
        return AmountCalcHelper.calcTotalAmount(bill, fieldMapping, "entrychangetype");
    }

    private static Map<String, BigDecimal> calcTotalAmount(DynamicObject bill, Map<String, String> fieldMapping, String changeTypeField) {
        HashMap<String, BigDecimal> calcResult = new HashMap<String, BigDecimal>(8);
        DynamicObjectType billType = bill.getDynamicObjectType();
        Map<String, String> filteredMapping = AmountCalcHelper.mappingFilter(billType, fieldMapping);
        if (filteredMapping.isEmpty()) {
            return calcResult;
        }
        for (String headField : filteredMapping.keySet()) {
            calcResult.put(headField, BigDecimal.ZERO);
        }
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        if (entry == null || entry.isEmpty()) {
            return calcResult;
        }
        DynamicObjectType entryType = ((DynamicObject)entry.get(0)).getDynamicObjectType();
        Map<String, DynamicProperty> entryFieldProperties = AmountCalcHelper.getEntryFieldProperties(entryType, filteredMapping);
        if (entryFieldProperties.isEmpty()) {
            return calcResult;
        }
        DynamicProperty changeTypeProp = entryType.getProperty(changeTypeField);
        for (DynamicObject row : entry) {
            if (changeTypeProp != null && ChangeTypeEnum.isCancel((String)((String)changeTypeProp.getValueFast((Object)row)))) continue;
            for (Map.Entry<String, DynamicProperty> propertyEntry : entryFieldProperties.entrySet()) {
                String headKey = propertyEntry.getKey();
                calcResult.put(headKey, ((BigDecimal)calcResult.get(headKey)).add(BigDecimalUtil.getNotNull((Object)propertyEntry.getValue().getValueFast((Object)row))));
            }
        }
        return calcResult;
    }

    private static Map<String, String> mappingFilter(DynamicObjectType billType, Map<String, String> fieldMapping) {
        HashMap<String, String> filteredMapping = new HashMap<String, String>(8);
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            String key = entry.getKey();
            if (billType.getProperty(key) == null) continue;
            filteredMapping.put(key, entry.getValue());
        }
        return filteredMapping;
    }

    private static Map<String, DynamicProperty> getEntryFieldProperties(DynamicObjectType entryType, Map<String, String> filteredMapping) {
        HashMap<String, DynamicProperty> entryFieldProperties = new HashMap<String, DynamicProperty>(8);
        for (Map.Entry<String, String> entry : filteredMapping.entrySet()) {
            DynamicProperty property = entryType.getProperty(entry.getValue());
            if (property == null) continue;
            entryFieldProperties.put(entry.getKey(), property);
        }
        return entryFieldProperties;
    }
}

