/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.business.helper.MaterialHelper;

public class BillImportHelper {
    public static void billCreTypeFlag(IPageCache pageCache, List<Map<String, Object>> sourceDataList) {
        for (Map<String, Object> sourceData : sourceDataList) {
            if (sourceData.get("billcretype") != null) {
                pageCache.put("billcretype", (String)sourceData.get("billcretype"));
                continue;
            }
            pageCache.put("billcretype", "1");
        }
    }

    public static boolean calcBaseQtyAndAuxQty(DynamicObject entryInfo) {
        if (entryInfo == null) {
            return false;
        }
        BigDecimal qty = entryInfo.getBigDecimal("qty");
        BigDecimal baseQty = entryInfo.getBigDecimal("baseqty");
        BigDecimal originQty = new BigDecimal(baseQty.toString());
        DynamicObject unit = entryInfo.getDynamicObject("unit");
        if (unit != null && qty != null) {
            int precision = unit.getInt("precision");
            int precisionaccount = BillImportHelper.getRoundMode(unit);
            qty = qty.setScale(precision, precisionaccount);
            entryInfo.set("qty", (Object)qty);
            DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
            if (baseUnit != null) {
                DynamicObject material = entryInfo.getDynamicObject("material");
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal muConv = MaterialHelper.getMUConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)unit, (DynamicObject)baseUnit, (boolean)true);
                    int basePrecision = baseUnit.getInt("precision");
                    int basePrecisionaccount = BillImportHelper.getRoundMode(baseUnit);
                    baseQty = muConv.multiply(qty).setScale(basePrecision, basePrecisionaccount);
                }
                entryInfo.set("baseqty", (Object)baseQty);
            }
        }
        return originQty.compareTo(baseQty) != 0;
    }

    public static int getRoundMode(DynamicObject unit) {
        if (unit == null) {
            return 4;
        }
        int precisionaccount = unit.getInt("precisionaccount");
        int baseUnitPrecisionType = 4;
        if (precisionaccount == 2) {
            baseUnitPrecisionType = 1;
        } else if (precisionaccount == 3) {
            baseUnitPrecisionType = 0;
        }
        return baseUnitPrecisionType;
    }

    @Deprecated
    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    public static Map<?, ?> format4ImportAndApi(Object sourceData) {
        if (sourceData instanceof JSONObject) {
            return BillImportHelper.format4Api((Map)SerializationUtils.fromJsonString((String)sourceData.toString(), Map.class));
        }
        if (sourceData instanceof Map) {
            return BillImportHelper.format4Api((Map)sourceData);
        }
        return null;
    }

    private static Map<String, Object> format4Api(Map sourceData) {
        if (sourceData == null || sourceData.get("importprop") != null) {
            return sourceData;
        }
        if (sourceData.get("number") != null) {
            sourceData.put("importprop", "number");
        }
        if (sourceData.get("id") != null) {
            sourceData.put("importprop", "id");
        }
        if (sourceData.get("operatornumber") != null) {
            sourceData.put("importprop", "operatornumber");
        }
        if (sourceData.get("operatorname") != null) {
            sourceData.put("importprop", "operatorname");
        }
        if (sourceData.get("phone") != null) {
            sourceData.put("importprop", "phone");
        }
        return sourceData;
    }

    public static DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters, Map tempCache) {
        if (sourceData == null) {
            return null;
        }
        Map<?, ?> propMap = BillImportHelper.format4ImportAndApi(sourceData.get(propName));
        if (propMap != null) {
            String importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            if (value == null && "id".equals(importProp)) {
                value = BusinessDataServiceHelper.newDynamicObject((String)propEntityName);
                value.set("id", propMap.get("id"));
            }
            return value;
        }
        return null;
    }

    public static QFilter getBaseDataOrgFilterFromCache(DynamicObject org, String propName, String propEntityName, Map tempCache) {
        QFilter baseDataOrgFilter = (QFilter)tempCache.get(org.getPkValue() + "_" + propName + "OrgFilter");
        if (baseDataOrgFilter == null) {
            baseDataOrgFilter = BaseDataServiceHelper.getBaseDataFilter((String)propEntityName, (Long)((Long)org.getPkValue()));
            tempCache.put(org.getPkValue() + "_" + propName + "OrgFilter", baseDataOrgFilter);
        }
        return baseDataOrgFilter;
    }

    public static boolean isImport(String billcretype) {
        return "1".equals(billcretype);
    }

    public static boolean isApi(String billcretype) {
        return "3".equals(billcretype);
    }

    public static boolean isManual(String billcretype) {
        return !"1".equals(billcretype) && !"2".equals(billcretype) && !"3".equals(billcretype);
    }
}

