/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginCall;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.sm.business.helper.AmountCalcHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.business.pojo.AmountInfo;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.enums.ExChangeTypeEnum;
import kd.sdk.scmc.sm.extpoint.IAmountCalculateCasePlugin;

public class BillTplHelper {
    private static final Log LOG = LogFactory.getLog(BillTplHelper.class);
    private static final String[] CHANGEUNITUPDATEPROP = new String[]{"price", "priceandtax", "discountrate", "discountamount", "qty", "amount", "amountandtax", "taxamount", "baseqty", "baseunit", "curamount", "curamountandtax", "curtaxamount", "auxqty"};
    private static final String[] CHANGEQTYUPDATEPROP = new String[]{"price", "priceandtax", "amount", "amountandtax", "taxamount", "baseqty", "discountrate", "discountamount", "curamount", "curamountandtax", "curtaxamount", "auxqty"};
    private static final String[] CHANGEPRICEUPDATEPROP = new String[]{"discountrate", "discountamount", "priceandtax", "amount", "amountandtax", "taxamount", "curamount", "curamountandtax", "curtaxamount"};
    private static final String[] CHANGEPRICEANDTAXUPDATEPROP = new String[]{"discountrate", "discountamount", "price", "amount", "amountandtax", "taxamount", "curamount", "curamountandtax", "curtaxamount"};
    private static final String[] CHANGEAUXQTYUPDATEPROP = new String[]{"price", "priceandtax", "discountrate", "discountamount", "qty", "amount", "amountandtax", "taxamount", "baseqty", "curamount", "curamountandtax", "curtaxamount"};
    private static final String[] CHANGEUPDATEPROP = new String[]{"price", "priceandtax", "amount", "amountandtax", "taxamount", "discountrate", "discountamount", "curamount", "curamountandtax", "curtaxamount"};
    private static final String[] CHANGEISPRESENTUPDATEPROP = new String[]{"price", "priceandtax", "taxrateid", "taxrate", "amount", "amountandtax", "taxamount", "discountrate", "discountamount", "curamount", "curamountandtax", "curtaxamount"};
    private static final String[] QUOTEUPDATEPROP = new String[]{"discountrate", "discountamount", "price", "priceandtax", "taxrateid", "taxrate", "amount", "amountandtax", "taxamount", "curamount", "curamountandtax", "curtaxamount", "discounttype"};
    private static final String[] CHANGEAMOUNTUPDATEPROP = new String[]{"curamount", "taxamount", "curtaxamount", "amountandtax", "curamountandtax", "price", "priceandtax", "discountrate", "discountamount"};
    private static final String[] CHANGEAMOUNTANDTAXUPDATEPROP = new String[]{"amount", "curamount", "taxamount", "curtaxamount", "curamountandtax", "price", "priceandtax", "discountrate", "discountamount"};

    public static boolean calcBaseQtyAndAuxQty(DynamicObject bill, int rowIndex) {
        if (bill == null) {
            return false;
        }
        DynamicObjectCollection colls = bill.getDynamicObjectCollection("billentry");
        if (colls.size() == 0) {
            return false;
        }
        DynamicObject entryInfo = (DynamicObject)colls.get(rowIndex);
        if (entryInfo == null) {
            return false;
        }
        BigDecimal qty = entryInfo.getBigDecimal("qty");
        BigDecimal baseQty = entryInfo.getBigDecimal("baseqty");
        if (qty == null || baseQty == null) {
            return false;
        }
        BigDecimal originQty = new BigDecimal(baseQty.toString());
        DynamicObject unit = entryInfo.getDynamicObject("unit");
        if (unit != null) {
            int precision = unit.getInt("precision");
            int precisionaccount = BillTplHelper.getRoundMode(unit);
            qty = qty.setScale(precision, precisionaccount);
            entryInfo.set("qty", (Object)qty);
            DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
            if (baseUnit != null) {
                DynamicObject material = entryInfo.getDynamicObject("material");
                if (material == null) {
                    return true;
                }
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    baseQty = BillTplHelper.getDesQtyConv(masterMaterial, unit, qty, baseUnit);
                }
                entryInfo.set("baseqty", (Object)baseQty);
                DynamicObject auxptyUnit = entryInfo.getDynamicObject("auxunit");
                if (auxptyUnit != null) {
                    String unitConvertDir = masterMaterial.getString("unitconvertdir");
                    if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                        BigDecimal auxQty = BigDecimal.ZERO;
                        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
                            auxQty = BillTplHelper.getDesQtyConv(masterMaterial, baseUnit, baseQty, auxptyUnit);
                        }
                        entryInfo.set("auxqty", (Object)auxQty);
                    }
                }
            }
        }
        if (originQty.compareTo(baseQty) != 0) {
            return true;
        }
        return originQty.compareTo(BigDecimal.ZERO) == 0 && qty.compareTo(BigDecimal.ZERO) == 0 && baseQty.compareTo(BigDecimal.ZERO) == 0;
    }

    public static boolean calcBaseQtyAndAuxQty(IDataModel model, int rowIndex) {
        if (model == null) {
            return false;
        }
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal baseQty = (BigDecimal)model.getValue("baseqty", rowIndex);
        if (qty == null || baseQty == null) {
            return false;
        }
        BigDecimal originQty = new BigDecimal(baseQty.toString());
        DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
        if (unit != null) {
            int precision = unit.getInt("precision");
            int precisionaccount = BillTplHelper.getRoundMode(unit);
            qty = qty.setScale(precision, precisionaccount);
            model.beginInit();
            model.setValue("qty", (Object)qty, rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            if (baseUnit != null) {
                DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
                if (material == null) {
                    return true;
                }
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    baseQty = BillTplHelper.getDesQtyConv(masterMaterial, unit, qty, baseUnit);
                }
                model.setValue("baseqty", (Object)baseQty, rowIndex);
                DynamicObject auxptyUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
                if (auxptyUnit != null) {
                    String unitConvertDir = masterMaterial.getString("unitconvertdir");
                    if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                        BigDecimal auxQty = BigDecimal.ZERO;
                        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
                            auxQty = BillTplHelper.getDesQtyConv(masterMaterial, baseUnit, baseQty, auxptyUnit);
                        }
                        model.setValue("auxqty", (Object)auxQty, rowIndex);
                    }
                }
            }
            model.endInit();
        }
        if (originQty.compareTo(baseQty) != 0) {
            return true;
        }
        return originQty.compareTo(BigDecimal.ZERO) == 0 && qty.compareTo(BigDecimal.ZERO) == 0 && baseQty.compareTo(BigDecimal.ZERO) == 0;
    }

    public static void calculateBillAmount(DynamicObject bill, int rowIndex) {
        if (bill == null) {
            return;
        }
        BigDecimal totalBalance = BigDecimal.ZERO;
        BigDecimal totalAmountBalance = BigDecimal.ZERO;
        DynamicObjectCollection colls = bill.getDynamicObjectCollection("billentry");
        if (colls == null || colls.size() == 0) {
            return;
        }
        DynamicObject entryInfo = (DynamicObject)colls.get(rowIndex);
        AmountInfo amountInfo = BillTplHelper.initAmountInfo(bill, rowIndex);
        amountInfo = BillTplHelper.getAmount(amountInfo);
        if (entryInfo != null) {
            BigDecimal amountAndTax = amountInfo.getAmountAndTax();
            BigDecimal taxAmout = amountInfo.getTaxAmount();
            BigDecimal amount = amountInfo.getAmount();
            BigDecimal curAmountAndTax = amountInfo.getCurAmountAndTax();
            BigDecimal curAmount = amountInfo.getCurAmount();
            BigDecimal curTaxAmount = amountInfo.getCurTaxAmount();
            BigDecimal discountRate = amountInfo.getDiscountRate();
            BigDecimal discountAmount = amountInfo.getDiscountAmount();
            BigDecimal price = amountInfo.getPrice();
            BigDecimal priceAndTax = amountInfo.getPriceAndTax();
            entryInfo.set("price", (Object)price);
            entryInfo.set("priceandtax", (Object)priceAndTax);
            entryInfo.set("discountrate", (Object)discountRate);
            entryInfo.set("discountamount", (Object)discountAmount);
            BigDecimal balance = BillTplHelper.calcTotalBalance(entryInfo, amountAndTax, "amountandtax");
            entryInfo.set("amountandtax", (Object)amountAndTax);
            BillTplHelper.changeTotalAmount(bill, entryInfo, taxAmout, "taxamount", "totaltaxamount");
            entryInfo.set("taxamount", (Object)taxAmout);
            BigDecimal amountBalance = BillTplHelper.calcTotalBalance(entryInfo, amount, "amount");
            entryInfo.set("amount", (Object)amount);
            BillTplHelper.changeTotalAmount(bill, entryInfo, curAmountAndTax, "curamountandtax", "curtotalallamount");
            entryInfo.set("curamountandtax", (Object)curAmountAndTax);
            BillTplHelper.changeTotalAmount(bill, entryInfo, curAmount, "curamount", "curtotalamount");
            entryInfo.set("curamount", (Object)curAmount);
            entryInfo.set("curtaxamount", (Object)curTaxAmount);
            totalBalance = totalBalance.add(balance);
            totalAmountBalance = totalAmountBalance.add(amountBalance);
        }
        bill.set("totalamount", (Object)bill.getBigDecimal("totalamount").add(totalAmountBalance));
        bill.set("totalallamount", (Object)bill.getBigDecimal("totalallamount").add(totalBalance));
    }

    public static void calculateDeliverUpAndDownQty(DynamicObject bill, int rowIndex) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)billentry.get(rowIndex);
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject unit = entry.getDynamicObject("unit");
        if (unit == null || baseUnit == null) {
            entry.set("deliverqtyup", null);
            entry.set("deliverbaseqtyup", null);
            entry.set("deliverqtydown", null);
            entry.set("deliverbaseqtydown", null);
            return;
        }
        int precision = unit.getInt("precision");
        int precisionaccount = BillTplHelper.getRoundMode(unit);
        int basePrecision = baseUnit.getInt("precision");
        int basePrecisionaccount = BillTplHelper.getRoundMode(baseUnit);
        BigDecimal deliverrateup = entry.getBigDecimal("deliverrateup");
        BigDecimal deliverratedown = entry.getBigDecimal("deliverratedown");
        BigDecimal deliverqtyup = qty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100), precision, precisionaccount);
        BigDecimal deliverbaseqtyup = baseQty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
        BigDecimal deliverqtydown = qty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100), precision, precisionaccount);
        BigDecimal deliverbaseqtydown = baseQty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
        entry.set("deliverqtyup", (Object)deliverqtyup);
        entry.set("deliverbaseqtyup", (Object)deliverbaseqtyup);
        entry.set("deliverqtydown", (Object)deliverqtydown);
        entry.set("deliverbaseqtydown", (Object)deliverbaseqtydown);
    }

    public static void calculateDeliverUpAndDownQty(DynamicObject bill) {
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entrys) {
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            Boolean iscontrolqty = material.getBoolean("iscontrolqty");
            entry.set("iscontrolqty", (Object)iscontrolqty);
            BigDecimal deliverrateup = BigDecimal.ZERO;
            BigDecimal deliverratedown = BigDecimal.ZERO;
            if (iscontrolqty.booleanValue()) {
                deliverrateup = material.getBigDecimal("dlivrateceiling");
                deliverratedown = material.getBigDecimal("dlivratefloor");
                entry.set("deliverrateup", (Object)deliverrateup);
                entry.set("deliverratedown", (Object)deliverratedown);
            }
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            DynamicObject unit = entry.getDynamicObject("unit");
            if (unit == null || baseUnit == null || qty == null || baseQty == null || deliverrateup == null || deliverratedown == null) continue;
            int precision = unit.getInt("precision");
            int precisionaccount = BillTplHelper.getRoundMode(unit);
            int basePrecision = baseUnit.getInt("precision");
            int basePrecisionaccount = BillTplHelper.getRoundMode(baseUnit);
            BigDecimal deliverqtyup = qty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100), precision, precisionaccount);
            BigDecimal deliverbaseqtyup = baseQty.multiply(new BigDecimal(100).add(deliverrateup)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
            BigDecimal deliverqtydown = qty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100), precision, precisionaccount);
            BigDecimal deliverbaseqtydown = baseQty.multiply(new BigDecimal(100).subtract(deliverratedown)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
            entry.set("deliverqtyup", (Object)deliverqtyup);
            entry.set("deliverbaseqtyup", (Object)deliverbaseqtyup);
            entry.set("deliverqtydown", (Object)deliverqtydown);
            entry.set("deliverbaseqtydown", (Object)deliverbaseqtydown);
        }
    }

    private void calcMinOrderBaseQty(DynamicObject bill, int rowIndex) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject row = (DynamicObject)billentry.get(rowIndex);
        if (row != null) {
            BigDecimal minOrderBaseQty = BigDecimal.ZERO;
            DynamicObject masterMat = row.getDynamicObject("material");
            if (masterMat != null) {
                BigDecimal minOrderQty = masterMat.getBigDecimal("minorderqty");
                DynamicObject salesUnit = masterMat.getDynamicObject("salesunit");
                DynamicObject baseUnit = row.getDynamicObject("baseunit");
                if (baseUnit != null && salesUnit != null && minOrderQty != null && BigDecimal.ZERO.compareTo(minOrderQty) != 0) {
                    minOrderBaseQty = BillTplHelper.getDesQtyConv(masterMat.getDynamicObject("masterid"), salesUnit, minOrderQty, baseUnit);
                }
            }
            row.set("minorderbaseqty", (Object)minOrderBaseQty);
        }
    }

    public static boolean calcBaseQtyAndQty(DynamicObject bill, int rowIndex) {
        if (bill == null) {
            return false;
        }
        DynamicObjectCollection colls = bill.getDynamicObjectCollection("billentry");
        if (colls.size() == 0) {
            return false;
        }
        DynamicObject entryInfo = (DynamicObject)colls.get(rowIndex);
        BigDecimal auxqty = entryInfo.getBigDecimal("auxqty");
        DynamicObject auxunit = entryInfo.getDynamicObject("auxunit");
        BigDecimal qty = entryInfo.getBigDecimal("qty");
        BigDecimal originQty = new BigDecimal(qty.toString());
        if (auxunit != null) {
            DynamicObject material = entryInfo.getDynamicObject("material");
            if (material == null) {
                return true;
            }
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
            if (baseUnit != null) {
                String unitConvertDir = masterMaterial.getString("unitconvertdir");
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    DynamicObject unit;
                    BigDecimal baseQty = BigDecimal.ZERO;
                    if (auxqty.compareTo(BigDecimal.ZERO) != 0) {
                        baseQty = BillTplHelper.getDesQtyConv(masterMaterial, auxunit, auxqty, baseUnit);
                    }
                    entryInfo.set("baseqty", (Object)baseQty);
                    qty = BigDecimal.ZERO;
                    if (baseQty.compareTo(BigDecimal.ZERO) != 0 && (unit = entryInfo.getDynamicObject("unit")) != null) {
                        qty = BillTplHelper.getDesQtyConv(masterMaterial, baseUnit, baseQty, unit);
                    }
                    entryInfo.set("qty", (Object)qty);
                }
            }
        }
        return originQty.compareTo(qty) != 0;
    }

    public static boolean calcBaseQtyAndQty(IDataModel model, int rowIndex) {
        if (model == null) {
            return false;
        }
        BigDecimal auxqty = (BigDecimal)model.getValue("auxqty", rowIndex);
        DynamicObject auxunit = (DynamicObject)model.getValue("auxunit", rowIndex);
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        BigDecimal originQty = new BigDecimal(qty.toString());
        if (auxunit != null) {
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            if (material == null) {
                return true;
            }
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            if (baseUnit != null) {
                String unitConvertDir = masterMaterial.getString("unitconvertdir");
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    DynamicObject unit;
                    BigDecimal baseQty = BigDecimal.ZERO;
                    if (auxqty.compareTo(BigDecimal.ZERO) != 0) {
                        baseQty = BillTplHelper.getDesQtyConv(masterMaterial, auxunit, auxqty, baseUnit);
                    }
                    model.beginInit();
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    qty = BigDecimal.ZERO;
                    if (baseQty.compareTo(BigDecimal.ZERO) != 0 && (unit = (DynamicObject)model.getValue("unit", rowIndex)) != null) {
                        qty = BillTplHelper.getDesQtyConv(masterMaterial, baseUnit, baseQty, unit);
                    }
                    model.setValue("qty", (Object)qty, rowIndex);
                    model.endInit();
                }
            }
        }
        return originQty.compareTo(qty) != 0;
    }

    public static void calcMinOrderBaseQty(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        DynamicObjectCollection entryInfos = bill.getDynamicObjectCollection("billentry");
        if (!entryInfos.isEmpty()) {
            for (int i = 0; i < entryInfos.size(); ++i) {
                DynamicObject entryInfo = (DynamicObject)entryInfos.get(i);
                BigDecimal minOrderBaseQty = BigDecimal.ZERO;
                DynamicObject masterMat = entryInfo.getDynamicObject("material.masterid");
                BigDecimal minOrderQty = entryInfo.getBigDecimal("material.minorderqty");
                DynamicObject salesUnit = entryInfo.getDynamicObject("material.salesunit");
                DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
                if (masterMat != null && baseUnit != null && salesUnit != null && minOrderQty != null && BigDecimal.ZERO.compareTo(minOrderQty) != 0) {
                    minOrderBaseQty = BillTplHelper.getDesQtyConv(masterMat, salesUnit, minOrderQty, baseUnit);
                }
                entryInfo.set("minorderbaseqty", (Object)minOrderBaseQty);
            }
        }
    }

    public static BigDecimal getDesQtyConv(DynamicObject matMasterID, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (matMasterID != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)matMasterID.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("denominator") != 0) {
                int precision = desUnit.getInt("precision");
                return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, BillTplHelper.getRoundMode(desUnit));
            }
        }
        return BigDecimal.ZERO;
    }

    @Deprecated
    public static BigDecimal calculateAmount(DynamicObject bill, int rowIndex) {
        return null;
    }

    public static void calculateAmount(DynamicObject bill, int[] rowIndexs, IDataModel model) {
        if (bill == null) {
            return;
        }
        BigDecimal totalBalance = BigDecimal.ZERO;
        BigDecimal totalAmountBalance = BigDecimal.ZERO;
        for (int rowIndex : rowIndexs) {
            DynamicObjectCollection colls = bill.getDynamicObjectCollection("billentry");
            if (colls == null || colls.size() == 0) {
                return;
            }
            DynamicObject entryInfo = (DynamicObject)colls.get(rowIndex);
            AmountInfo amountInfo = BillTplHelper.initAmountInfo(bill, rowIndex);
            amountInfo = BillTplHelper.getAmount(amountInfo);
            if (entryInfo == null) continue;
            BigDecimal amountAndTax = amountInfo.getAmountAndTax();
            BigDecimal taxAmout = amountInfo.getTaxAmount();
            BigDecimal amount = amountInfo.getAmount();
            BigDecimal curAmountAndTax = amountInfo.getCurAmountAndTax();
            BigDecimal curAmount = amountInfo.getCurAmount();
            BigDecimal curTaxAmount = amountInfo.getCurTaxAmount();
            BigDecimal discountRate = amountInfo.getDiscountRate();
            BigDecimal discountAmount = amountInfo.getDiscountAmount();
            BigDecimal price = amountInfo.getPrice();
            BigDecimal priceAndTax = amountInfo.getPriceAndTax();
            entryInfo.set("price", (Object)price);
            entryInfo.set("priceandtax", (Object)priceAndTax);
            entryInfo.set("discountrate", (Object)discountRate);
            entryInfo.set("discountamount", (Object)discountAmount);
            BigDecimal balance = BillTplHelper.calcTotalBalance(entryInfo, amountAndTax, "amountandtax");
            model.setValue("amountandtax", (Object)amountAndTax, rowIndex);
            BillTplHelper.changeTotalAmount(bill, entryInfo, taxAmout, "taxamount", "totaltaxamount");
            entryInfo.set("taxamount", (Object)taxAmout);
            BigDecimal amountBalance = BillTplHelper.calcTotalBalance(entryInfo, amount, "amount");
            model.setValue("amount", (Object)amount, rowIndex);
            BillTplHelper.changeTotalAmount(bill, entryInfo, curAmountAndTax, "curamountandtax", "curtotalallamount");
            entryInfo.set("curamountandtax", (Object)curAmountAndTax);
            BillTplHelper.changeTotalAmount(bill, entryInfo, curAmount, "curamount", "curtotalamount");
            entryInfo.set("curamount", (Object)curAmount);
            entryInfo.set("curtaxamount", (Object)curTaxAmount);
            totalBalance = totalBalance.add(balance);
            totalAmountBalance = totalAmountBalance.add(amountBalance);
        }
        model.setValue("totalamount", (Object)bill.getBigDecimal("totalamount").add(totalAmountBalance));
        model.setValue("totalallamount", (Object)bill.getBigDecimal("totalallamount").add(totalBalance));
    }

    public static void calculateAmount4WholeBill(DynamicObject bill, IDataModel model) {
        if (bill == null) {
            return;
        }
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal curTotalAllAmount = BigDecimal.ZERO;
        BigDecimal curTotalAmount = BigDecimal.ZERO;
        DynamicObjectCollection colls = bill.getDynamicObjectCollection("billentry");
        if (colls == null || colls.size() == 0) {
            return;
        }
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)colls.get(i);
            AmountInfo amountInfo = BillTplHelper.initAmountInfo(bill, i);
            amountInfo = BillTplHelper.getAmount(amountInfo);
            BigDecimal amountAndTax = amountInfo.getAmountAndTax();
            BigDecimal taxAmout = amountInfo.getTaxAmount();
            BigDecimal amount = amountInfo.getAmount();
            BigDecimal curAmountAndTax = amountInfo.getCurAmountAndTax();
            BigDecimal curAmount = amountInfo.getCurAmount();
            BigDecimal curTaxAmount = amountInfo.getCurTaxAmount();
            BigDecimal discountRate = amountInfo.getDiscountRate();
            BigDecimal discountAmount = amountInfo.getDiscountAmount();
            BigDecimal price = amountInfo.getPrice();
            BigDecimal priceAndTax = amountInfo.getPriceAndTax();
            entryInfo.set("price", (Object)price);
            entryInfo.set("priceandtax", (Object)priceAndTax);
            entryInfo.set("discountamount", (Object)discountAmount);
            entryInfo.set("discountrate", (Object)discountRate);
            if (model != null) {
                model.setValue("amount", (Object)amount, i);
                model.setValue("amountandtax", (Object)amountAndTax, i);
            } else {
                entryInfo.set("amount", (Object)amount);
                entryInfo.set("amountandtax", (Object)amountAndTax);
            }
            entryInfo.set("taxamount", (Object)taxAmout);
            entryInfo.set("curamountandtax", (Object)curAmountAndTax);
            entryInfo.set("curamount", (Object)curAmount);
            entryInfo.set("curtaxamount", (Object)curTaxAmount);
            totalAllAmount = totalAllAmount.add(amountAndTax);
            totalAmount = totalAmount.add(amount);
            totalTaxAmount = totalTaxAmount.add(taxAmout);
            curTotalAllAmount = curTotalAllAmount.add(curAmountAndTax);
            curTotalAmount = curTotalAmount.add(curAmount);
        }
        if (model != null) {
            model.setValue("totalallamount", (Object)totalAllAmount);
            model.setValue("totalamount", (Object)totalAmount);
        } else {
            bill.set("totalallamount", (Object)totalAllAmount);
            bill.set("totalamount", (Object)totalAmount);
        }
        bill.set("totaltaxamount", (Object)totalTaxAmount);
        bill.set("curtotalallamount", (Object)curTotalAllAmount);
        bill.set("curtotalamount", (Object)curTotalAmount);
    }

    private static void changeTotalAmount(DynamicObject bill, DynamicObject entryInfo, BigDecimal amount, String entryAmountField, String headAmountField) {
        if (bill == null || entryInfo == null || amount == null) {
            return;
        }
        BigDecimal balance = amount.subtract(entryInfo.getBigDecimal(entryAmountField));
        bill.set(headAmountField, (Object)bill.getBigDecimal(headAmountField).add(balance));
    }

    private static BigDecimal calcTotalBalance(DynamicObject entryInfo, BigDecimal amount, String entryAmountField) {
        if (entryInfo == null || amount == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal balance = amount.subtract(entryInfo.getBigDecimal(entryAmountField));
        return balance;
    }

    public static void calcQtyAndBaseQty(int rowIndex, DynamicObject bill) {
        if (bill == null) {
            return;
        }
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        DynamicObject entry = (DynamicObject)billentry.get(rowIndex);
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject unit = entry.getDynamicObject("unit");
        if (unit != null && qty != null) {
            int precision = unit.getInt("precision");
            int precisionaccount = BillTplHelper.getRoundMode(unit);
            qty = qty.setScale(precision, precisionaccount);
            entry.set("qty", (Object)qty);
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            if (baseUnit != null) {
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null) {
                    return;
                }
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                BigDecimal baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    baseQty = BillTplHelper.getDesQtyConv(masterMaterial, unit, qty, baseUnit);
                }
                entry.set("baseqty", (Object)baseQty);
            }
        }
    }

    public static void calcQtyAndBaseQty(int rowIndex, IDataModel model) {
        BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
        DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
        if (unit != null && qty != null) {
            int precision = unit.getInt("precision");
            int precisionaccount = BillTplHelper.getRoundMode(unit);
            qty = qty.setScale(precision, precisionaccount);
            model.beginInit();
            model.setValue("qty", (Object)qty, rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            if (baseUnit != null) {
                DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
                if (material == null) {
                    return;
                }
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                BigDecimal baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    baseQty = BillTplHelper.getDesQtyConv(masterMaterial, unit, qty, baseUnit);
                }
                model.setValue("baseqty", (Object)baseQty, rowIndex);
            }
            model.endInit();
        }
    }

    public static int getRoundMode(DynamicObject unit) {
        if (unit == null) {
            return 4;
        }
        String precisionaccount = unit.getString("precisionaccount");
        int baseUnitPrecisionType = 4;
        if ("2".equals(precisionaccount)) {
            baseUnitPrecisionType = 1;
        } else if ("3".equals(precisionaccount)) {
            baseUnitPrecisionType = 0;
        }
        return baseUnitPrecisionType;
    }

    @Deprecated
    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    public static boolean checkPermission(String itemKey, DynamicObject org, String appID, String formID) {
        boolean hasPer = true;
        switch (itemKey) {
            case "rowterminate": {
                hasPer = BillTplHelper.getUserPermission("01RJEMDWF33R", org, appID, formID);
                break;
            }
            case "rowunterminate": {
                hasPer = BillTplHelper.getUserPermission("01RJGZA78NV8", org, appID, formID);
                break;
            }
            case "rowclose": {
                hasPer = BillTplHelper.getUserPermission("0DAQSVNVIT3U", org, appID, formID);
                break;
            }
            case "rowunclose": {
                hasPer = BillTplHelper.getUserPermission("01RJ=4CGSE07", org, appID, formID);
                break;
            }
        }
        return hasPer;
    }

    public static boolean getUserPermission(String permissionId, DynamicObject org, String appID, String formID) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int checkPermission = OrgHelper.checkPermission(userId, (Long)org.getPkValue(), appID, formID, permissionId);
        return 1 == checkPermission;
    }

    public static String[] getEntryRefreshFields(String propName) {
        if ("unit".equals(propName)) {
            return CHANGEUNITUPDATEPROP;
        }
        if ("qty".equals(propName)) {
            return CHANGEQTYUPDATEPROP;
        }
        if ("priceandtax".equals(propName)) {
            return CHANGEPRICEANDTAXUPDATEPROP;
        }
        if ("price".equals(propName)) {
            return CHANGEPRICEUPDATEPROP;
        }
        if ("auxqty".equals(propName)) {
            return CHANGEAUXQTYUPDATEPROP;
        }
        if ("discountrate".equals(propName) || "discounttype".equals(propName) || "taxrateid".equals(propName) || "istax".equals(propName) || "exchangerate".equals(propName) || "discountamount".equals(propName)) {
            return CHANGEUPDATEPROP;
        }
        if ("ispresent".equals(propName)) {
            return CHANGEISPRESENTUPDATEPROP;
        }
        if ("quote".equals(propName)) {
            return QUOTEUPDATEPROP;
        }
        if ("amount".equals(propName)) {
            return CHANGEAMOUNTUPDATEPROP;
        }
        if ("amountandtax".equals(propName)) {
            return CHANGEAMOUNTANDTAXUPDATEPROP;
        }
        return null;
    }

    public static BigDecimal processAmount4BotpConvert(DynamicObject bill) {
        if (bill == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject customer = bill.getDynamicObject("customer");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        String exchangeType = bill.getString("exchangetype");
        DynamicObject org = bill.getDynamicObject("org");
        Date bizTime = bill.getDate("exratedate");
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            if (currency == null) {
                currency = CurrencyHelper.getCurrency(orgId);
                bill.set("currency", (Object)currency);
            }
            if (exRateTable == null) {
                exRateTable = CurrencyHelper.getExRateTable(orgId);
                bill.set("exratetable", (Object)exRateTable);
            }
        }
        if (settleCurrency == null) {
            DynamicProperty prop = customer.getDynamicObjectType().getProperty("settlementcyid");
            if (prop != null) {
                settleCurrency = customer.getDynamicObject("settlementcyid");
            }
            if (settleCurrency == null) {
                settleCurrency = currency;
            }
            bill.set("settlecurrency", (Object)settleCurrency);
        }
        if (currency != null && exRateTable != null) {
            BigDecimal exRate = null;
            if (StringUtils.isEmpty((CharSequence)exchangeType)) {
                Map<String, Object> exRateMap = CurrencyHelper.getExchangeRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), bizTime);
                exRate = (BigDecimal)exRateMap.get("exchangeRate");
                Boolean quoteType = (Boolean)exRateMap.get("quoteType");
                exchangeType = quoteType != null && quoteType == false ? ExChangeTypeEnum.DIRECTRATE.getValue() : ExChangeTypeEnum.INDIRECTRATE.getValue();
                bill.set("exchangetype", (Object)exchangeType);
            }
            if (BigDecimalUtil.isBlank((BigDecimal)exChangeRate)) {
                exChangeRate = exRate != null ? exRate : CurrencyHelper.getExRate((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exRateTable.getPkValue(), bizTime, exchangeType);
                bill.set("exchangerate", (Object)exChangeRate);
            }
        }
        BillTplHelper.calculateAmount4WholeBill(bill, null);
        return bill.getBigDecimal("totalallamount");
    }

    public static AmountInfo getAmount(AmountInfo amountInfo) {
        return BillTplHelper.getAmount(amountInfo, Boolean.FALSE);
    }

    public static AmountInfo getAmount(AmountInfo amountInfo, Boolean isCalDiscountRate) {
        BigDecimal HUNDRED = new BigDecimal("100");
        BigDecimal ONE = BigDecimal.ONE;
        BigDecimal ZERO = BigDecimal.ZERO;
        String entityName = amountInfo.getEntityName();
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = amountInfo.getTaxRate().divide(HUNDRED);
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        int settlePricePrecision = amountInfo.getSettlePricePrecision();
        int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        String exchangeType = amountInfo.getExchangeType();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
            discountRate = BigDecimal.ZERO;
            discountAmount = amountInfo.getDiscountAmount();
        }
        BigDecimal amountAndTax = BigDecimal.ZERO;
        if (qty != null && qty.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal dividedDiscountRate;
            if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, 4);
                if (StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (discountRate == null || discountRate.compareTo(ZERO) == 0) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                    } else {
                        dividedDiscountRate = discountRate.divide(HUNDRED);
                        discountAmount = qty.multiply(priceAndTax).multiply(dividedDiscountRate).setScale(settleAmtPrecision, 4);
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                        amountAndTax = amountAndTax.subtract(discountAmount);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    if (discountRate == null || discountRate.compareTo(ZERO) == 0) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                    } else {
                        discountAmount = qty.multiply(discountRate).setScale(settleAmtPrecision, 4);
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                        amountAndTax = amountAndTax.subtract(discountAmount);
                    }
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    if (discountAmount == null || discountAmount.compareTo(ZERO) == 0) {
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                    } else {
                        discountAmount = discountAmount.setScale(settleAmtPrecision, 4);
                        discountRate = discountAmount.divide(qty, settlePricePrecision, 4);
                        amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                        amountAndTax = amountAndTax.subtract(discountAmount);
                    }
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settleAmtPrecision, 4);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, 4);
                if (StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue())) {
                    amount = qty.multiply(price).setScale(settleAmtPrecision, 4);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    if (discountRate == null || discountRate.compareTo(ZERO) == 0) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, 4);
                    } else {
                        dividedDiscountRate = discountRate.divide(HUNDRED);
                        discountAmount = qty.multiply(priceAndTax).multiply(dividedDiscountRate).setScale(settleAmtPrecision, 4);
                        amount = qty.multiply(price).multiply(ONE.subtract(dividedDiscountRate)).setScale(settleAmtPrecision, 4);
                    }
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && !isCalDiscountRate.booleanValue()) {
                    if (discountRate == null || discountRate.compareTo(ZERO) == 0) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, 4);
                    } else {
                        discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate)).setScale(settleAmtPrecision, 4);
                        amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, 4);
                    }
                } else if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) && isCalDiscountRate.booleanValue()) {
                    if (discountAmount == null || discountAmount.compareTo(ZERO) == 0) {
                        amount = qty.multiply(price).setScale(settleAmtPrecision, 4);
                    } else {
                        discountAmount = discountAmount.setScale(settleAmtPrecision, 4);
                        discountRate = discountAmount.divide(qty, 10, 4).divide(ONE.add(taxRate), settlePricePrecision, 4);
                        amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, 4);
                    }
                }
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, 4);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, 4);
            } else {
                priceAndTax = ZERO;
                price = ZERO;
            }
        } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
            priceAndTax = priceAndTax.setScale(settlePricePrecision, 4);
            price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, 4);
        } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
            price = price.setScale(settlePricePrecision, 4);
            priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, 4);
        } else {
            priceAndTax = ZERO;
            price = ZERO;
        }
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setAmount(amount);
        amountInfo.setDiscountRate(discountRate);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setTaxAmount(taxAmount);
        amountInfo.setAmountAndTax(amountAndTax);
        try {
            PluginCallImpl pci;
            List amountSet;
            PluginProxy pluginProxy = PluginProxy.create(null, IAmountCalculateCasePlugin.class, (String)"SCMC_SM_BILL_CALCULTEAMOUNTANDTAX", null);
            List fieldSets = pluginProxy.callReplace(p -> p.beforeCalculte(entityName));
            HashSet selectFields = new HashSet();
            if (fieldSets != null && fieldSets.size() > 0) {
                for (Set fiedsSet : fieldSets) {
                    selectFields.addAll(fiedsSet);
                }
            }
            MainEntityType billtype = EntityMetadataCache.getDataEntityType((String)entityName);
            Map<String, Object> amountMap = amountInfo.convertMap();
            if (selectFields.size() > 0) {
                selectFields.forEach(f -> {
                    if (!amountMap.containsKey(f) && billtype.getAllFields().containsKey(f) && ((IDataEntityProperty)billtype.getAllFields().get(f)).getParent() != null) {
                        if ("billentry".equals(((IDataEntityProperty)billtype.getAllFields().get(f)).getParent().getName())) {
                            amountMap.put((String)f, amountInfo.getEntryInfo().get(f));
                        } else if (entityName.equals(((IDataEntityProperty)billtype.getAllFields().get(f)).getParent().getName())) {
                            amountMap.put((String)f, ((DynamicObject)amountInfo.getEntryInfo().getParent()).get(f));
                        }
                    }
                });
            }
            if ((amountSet = pluginProxy.callReplace(pci = new PluginCallImpl(amountAndTax, entityName, amountMap))) != null && amountSet.size() > 0) {
                amountAndTax = (BigDecimal)amountSet.get(amountSet.size() - 1);
            }
            if (amountAndTax.compareTo(amountInfo.getAmountAndTax()) != 0) {
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settleAmtPrecision, 4);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amountInfo.setAmount(amount);
                amountInfo.setTaxAmount(taxAmount);
                amountInfo.setAmountAndTax(amountAndTax);
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BillTplHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]);
            msg = String.format(msg, "SCMC_SM_BILL_CALCULTEAMOUNTANDTAX");
            String msgTotal = msg + e.getMessage();
            LOG.info(msgTotal);
            throw new KDBizException(msgTotal);
        }
        if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0 && (amountAndTax.compareTo(ZERO) != 0 || taxAmount.compareTo(ZERO) != 0 || amount.compareTo(ZERO) != 0)) {
            BigDecimal curAmount = ZERO;
            BigDecimal curTaxAmount = ZERO;
            BigDecimal curAmountAndTax = ZERO;
            curTaxAmount = AmountCalcHelper.getCurAmountByRate(taxAmount, exChangeRate, currencyAmtPrecision, exchangeType);
            if (isTax) {
                curAmountAndTax = AmountCalcHelper.getCurAmountByRate(amountAndTax, exChangeRate, currencyAmtPrecision, exchangeType);
                curAmount = curAmountAndTax.subtract(curTaxAmount);
            } else {
                curAmount = AmountCalcHelper.getCurAmountByRate(amount, exChangeRate, currencyAmtPrecision, exchangeType);
                curAmountAndTax = curAmount.add(curTaxAmount);
            }
            amountInfo.setCurAmount(curAmount);
            amountInfo.setCurTaxAmount(curTaxAmount);
            amountInfo.setCurAmountAndTax(curAmountAndTax);
        }
        return amountInfo;
    }

    private static AmountInfo initAmountInfo(DynamicObject bill, int rowIndex) {
        DynamicObjectCollection collsInit = bill.getDynamicObjectCollection("billentry");
        DynamicObject entryInfoInit = (DynamicObject)collsInit.get(rowIndex);
        boolean isTax = bill.getBoolean("istax");
        DynamicObject currency = bill.getDynamicObject("currency");
        int currencyAmtPrecision = currency == null ? 10 : currency.getInt("amtprecision");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
        BigDecimal qty = entryInfoInit.getBigDecimal("qty");
        BigDecimal price = entryInfoInit.getBigDecimal("price");
        BigDecimal priceAndTax = entryInfoInit.getBigDecimal("priceandtax");
        BigDecimal taxRate = entryInfoInit.getBigDecimal("taxrate");
        String discountType = entryInfoInit.getString("discounttype");
        BigDecimal discountRate = entryInfoInit.getBigDecimal("discountrate");
        BigDecimal discountAmount = entryInfoInit.getBigDecimal("discountamount");
        String exchangeType = bill.getString("exchangetype");
        AmountInfo amountInfo = new AmountInfo(bill.getDataEntityType().getName(), entryInfoInit);
        amountInfo.setTax(isTax);
        amountInfo.setQty(qty);
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setTaxRate(taxRate);
        amountInfo.setDiscountType(discountType);
        amountInfo.setDiscountRate(discountRate);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setExChangeRate(exChangeRate);
        amountInfo.setSettleAmtPrecision(settleAmtPrecision);
        amountInfo.setCurrencyAmtPrecision(currencyAmtPrecision);
        amountInfo.setExchangeType(exchangeType);
        return amountInfo;
    }

    private static class PluginCallImpl<P, R>
    implements PluginCall<P, R> {
        BigDecimal amountAndTax;
        String entityName;
        Map<String, Object> amountMap;

        public PluginCallImpl(BigDecimal amountAndTax, String entityName, Map<String, Object> amountMap) {
            this.amountAndTax = amountAndTax;
            this.entityName = entityName;
            this.amountMap = amountMap;
        }

        public R call(P p) {
            if (p instanceof IAmountCalculateCasePlugin) {
                return (R)((IAmountCalculateCasePlugin)p).calculteAmountAndTax(this.amountAndTax, this.entityName, this.amountMap);
            }
            return null;
        }
    }
}

