/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sm.enums.BizCategoryEnum;
import kd.scmc.sm.enums.OwnerTypeEnum;
import kd.scmc.sm.util.CommonUtils;

public class BizTypeHelper {
    private static Log log = LogFactory.getLog(BizTypeHelper.class);

    public static QFilter getMaterialQFilterByBizCategory(String bizCategory) {
        QFilter qFilter = null;
        if (!BizCategoryEnum.BZ.getValue().equals(bizCategory) && !BizCategoryEnum.WW.getValue().equals(bizCategory)) {
            if (BizCategoryEnum.FY.getValue().equals(bizCategory)) {
                qFilter = new QFilter("masterid.materialtype", "=", (Object)"7");
            } else if (BizCategoryEnum.ZC.getValue().equals(bizCategory)) {
                qFilter = new QFilter("masterid.materialtype", "=", (Object)"8");
                qFilter.and("masterid.enableasset", "=", (Object)"1");
            } else if (BizCategoryEnum.VMI.getValue().equals(bizCategory)) {
                qFilter = new QFilter("masterid.enablevmi", "=", (Object)"1");
            } else if (!(BizCategoryEnum.ZY.getValue().equals(bizCategory) || BizCategoryEnum.FX.getValue().equals(bizCategory) || BizCategoryEnum.JS.getValue().equals(bizCategory) || BizCategoryEnum.ST.getValue().equals(bizCategory) || !BizCategoryEnum.FW.getValue().equals(bizCategory))) {
                qFilter = new QFilter("masterid.materialtype", "=", (Object)"9");
            }
        }
        return qFilter;
    }

    public static void setBizLineTypeDefaultValue(DynamicObject bill, String billtypeFiled, String biztypeFiled, String linetypeFiled) {
        if (bill == null) {
            return;
        }
        DynamicObject billType = bill.getDynamicObject(billtypeFiled);
        DynamicObject bizType = bill.getDynamicObject(biztypeFiled);
        if (CommonUtils.isNull((Object)billType)) {
            return;
        }
        if (CommonUtils.isNull((Object)bizType)) {
            bizType = kd.mpscmm.msbd.business.helper.BizTypeHelper.getDefaultBizTypeObject((String)bill.getDataEntityType().getName(), (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
            bill.set(biztypeFiled, (Object)bizType);
        }
        if (CommonUtils.isNull((Object)bizType) || "sm_salesagency".equals(bill.getDataEntityType().getName())) {
            return;
        }
        DynamicObject lineType = kd.mpscmm.msbd.business.helper.BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
        if (CommonUtils.isNull((Object)lineType)) {
            return;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        entrys.forEach(dym -> {
            if (CommonUtils.isNull((Object)dym.getDynamicObject(linetypeFiled))) {
                dym.set(linetypeFiled, (Object)lineType);
            }
        });
    }

    public static void setBizLineTypeDefaultWithOwner(DynamicObject bill, String billtypeFiled, String biztypeFiled, String linetypeFiled) {
        if (bill == null) {
            return;
        }
        DynamicObject billType = bill.getDynamicObject(billtypeFiled);
        DynamicObject bizType = bill.getDynamicObject(biztypeFiled);
        if (CommonUtils.isNull((Object)billType)) {
            return;
        }
        Boolean isBizTypeNull = Boolean.FALSE;
        if (CommonUtils.isNull((Object)bizType)) {
            log.info("BizTypeHelper : bizType is null");
            bizType = kd.mpscmm.msbd.business.helper.BizTypeHelper.getDefaultBizTypeObject((String)bill.getDataEntityType().getName(), (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
            if (CommonUtils.isNull((Object)bizType)) {
                return;
            }
            bizType = BusinessDataServiceHelper.loadSingleFromCache((Object)((Long)bizType.getPkValue()), (String)"bd_biztype");
            bill.set(biztypeFiled, (Object)bizType);
            isBizTypeNull = Boolean.TRUE;
            log.info("BizTypeHelper : bizType domain is " + bizType.getString("domain"));
        }
        if (CommonUtils.isNull((Object)bizType) || "sm_salesagency".equals(bill.getDataEntityType().getName())) {
            return;
        }
        if (bizType != null) {
            DynamicObject lineType = kd.mpscmm.msbd.business.helper.BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
            if (CommonUtils.isNull((Object)lineType)) {
                return;
            }
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
            entrys.forEach(dym -> {
                if (CommonUtils.isNull((Object)dym.getDynamicObject(linetypeFiled))) {
                    dym.set(linetypeFiled, (Object)lineType);
                }
            });
            if (isBizTypeNull.booleanValue() && bizType != null && "6".equals(bizType.getString("domain"))) {
                log.info("BizTypeHelper : ownerType is supplier");
                entrys.forEach(dym -> {
                    dym.set("ownertype", (Object)OwnerTypeEnum.SUPPLIER.getValue());
                    dym.set("owner", null);
                });
            }
        }
    }
}

