/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.sm.business.pojo.ReturnResultInfo;

public class BotpHelper {
    private static final Log log = LogFactory.getLog(BotpHelper.class);

    public static ReturnResultInfo botpGenerateTargetBill(Map<Long, Long> sourceIdMap, String ruleId, String sourceEntity, String sourceEntryEntity, String targetEntity, String status, Map<String, String> param, boolean needCheckPermisson) {
        ReturnResultInfo returnResultInfo = new ReturnResultInfo();
        if (sourceIdMap != null && sourceIdMap.size() > 0) {
            PushArgs pushArgs = new PushArgs();
            pushArgs.setSourceEntityNumber(sourceEntity);
            pushArgs.setTargetEntityNumber(targetEntity);
            if (StringUtils.isNotEmpty((CharSequence)targetEntity) && needCheckPermisson) {
                pushArgs.setAppId(BotpHelper.getAppId(targetEntity));
                pushArgs.setHasRight(false);
            }
            pushArgs.setBuildConvReport(true);
            if (param != null) {
                for (Map.Entry<String, String> entry : param.entrySet()) {
                    pushArgs.addCustomParam(entry.getKey(), entry.getValue());
                }
            }
            pushArgs.setRuleId(ruleId);
            ArrayList<ListSelectedRow> sourceEntryRows = new ArrayList<ListSelectedRow>(sourceIdMap.size());
            for (Map.Entry<Long, Long> entry : sourceIdMap.entrySet()) {
                ListSelectedRow row = new ListSelectedRow();
                row.setPrimaryKeyValue((Object)entry.getValue());
                row.setEntryPrimaryKeyValue((Object)entry.getKey());
                row.setEntryEntityKey(sourceEntryEntity);
                sourceEntryRows.add(row);
            }
            pushArgs.setSelectedRows(sourceEntryRows);
            ConvertOperationResult convertOperationResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)targetEntity);
            IRefrencedataProvider refDataProvider = new IRefrencedataProvider(){

                public void fillReferenceData(Object[] dataEntitys, IDataEntityType dataType) {
                    BusinessDataServiceHelper.loadRefence((Object[])dataEntitys, (IDataEntityType)dataType);
                }
            };
            List targetBills = null;
            if (!convertOperationResult.isSuccess()) {
                log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5931\u8d25\uff1a" + convertOperationResult.getMessage());
                returnResultInfo.setSuccess(false);
                returnResultInfo.setMessage(convertOperationResult.getMessage());
                return returnResultInfo;
            }
            targetBills = convertOperationResult.loadTargetDataObjects(refDataProvider, mainEntityType);
            log.info("\u6e90\u5355\u5355\u636e(" + sourceEntity + ")\u4e0b\u63a8\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u6210\u529f");
            if (targetBills != null && targetBills.size() > 0) {
                if (!("save".equals(status) || "submit".equals(status) || "audit".equals(status))) {
                    log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4e0b\u63a8\u6210\u529f\uff1a" + targetBills);
                    returnResultInfo.setSuccess(true);
                    returnResultInfo.setSuccessList(targetBills);
                    return returnResultInfo;
                }
                OperateOption option = OperateOption.create();
                option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
                if (needCheckPermisson) {
                    option.setVariableValue("ishasright", String.valueOf(Boolean.FALSE));
                } else {
                    option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
                }
                option.setVariableValue("WF", String.valueOf(false));
                OperationResult saveResult = SaveServiceHelper.saveOperate((String)targetEntity, (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)option);
                if (saveResult != null && saveResult.getSuccessPkIds().size() > 0 && saveResult.isSuccess()) {
                    List saveSuccessPkIds = saveResult.getSuccessPkIds();
                    if (!"submit".equals(status) && !"audit".equals(status)) {
                        log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4fdd\u5b58\u6210\u529f\uff1a" + saveSuccessPkIds);
                        returnResultInfo.setSuccess(true);
                        returnResultInfo.setSuccessList(saveSuccessPkIds);
                        return returnResultInfo;
                    }
                    OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntity, (Object[])saveSuccessPkIds.toArray(new Object[0]), (OperateOption)option);
                    if (submitResult != null && submitResult.getSuccessPkIds().size() > 0 && (needCheckPermisson || submitResult.isSuccess())) {
                        List submitSuccessPkIds = submitResult.getSuccessPkIds();
                        if (!"audit".equals(status)) {
                            log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u63d0\u4ea4\u6210\u529f\uff1a" + submitSuccessPkIds);
                            returnResultInfo.setSuccess(true);
                            returnResultInfo.setSuccessList(submitSuccessPkIds);
                            return returnResultInfo;
                        }
                        OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntity, (Object[])submitSuccessPkIds.toArray(new Object[0]), (OperateOption)option);
                        if (auditResult != null && auditResult.getSuccessPkIds().size() > 0 && auditResult.isSuccess()) {
                            log.info("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5ba1\u6838\u6210\u529f\uff1a" + auditResult.getSuccessPkIds());
                            returnResultInfo.setSuccess(true);
                            returnResultInfo.setSuccessList(auditResult.getSuccessPkIds());
                            return returnResultInfo;
                        }
                        if (auditResult != null) {
                            log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u5ba1\u6838\u5f02\u5e38\uff1a" + BotpHelper.buildErrorInfoMessage(auditResult));
                            returnResultInfo.setSuccess(false);
                            returnResultInfo.setMessage(auditResult.getMessage());
                            return returnResultInfo;
                        }
                    } else if (submitResult != null) {
                        log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u63d0\u4ea4\u5f02\u5e38\uff1a" + BotpHelper.buildErrorInfoMessage(submitResult));
                        returnResultInfo.setSuccess(false);
                        returnResultInfo.setMessage(submitResult.getMessage());
                        return returnResultInfo;
                    }
                } else if (saveResult != null) {
                    log.error("\u76ee\u6807\u5355\u636e(" + targetEntity + ")\u4fdd\u5b58\u5f02\u5e38\uff1a" + BotpHelper.buildErrorInfoMessage(saveResult));
                    returnResultInfo.setSuccess(false);
                    returnResultInfo.setMessage(saveResult.getMessage());
                    return returnResultInfo;
                }
            }
        }
        returnResultInfo.setSuccess(false);
        return returnResultInfo;
    }

    private static String buildErrorInfoMessage(OperationResult opResult) {
        List allErrorInfos = opResult.getAllErrorInfo();
        StringBuilder sb = new StringBuilder();
        if (allErrorInfos != null) {
            for (OperateErrorInfo errorInfo : allErrorInfos) {
                String message = errorInfo.getMessage();
                sb.append(message);
            }
        }
        return sb.toString();
    }

    private static String getAppId(String entityNumber) {
        String appNumber;
        String appId = "";
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String string = appNumber = mainType == null ? "" : mainType.getBizAppNumber();
        if (StringUtils.isNotBlank((CharSequence)appNumber)) {
            try {
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
                if (null != appInfo) {
                    appId = appInfo.getId();
                }
            }
            catch (KDException var6) {
                log.error((Throwable)var6);
            }
        }
        return appId;
    }
}

