/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.enums.CustomerFunction;

public class CustomerHelper {
    private static final String IS_SET_DEFAULT_SETTLE_TYPE = "isSetDefaultSettleType";

    public static Long getLinkman(DynamicObject customer) {
        if (customer == null) {
            return null;
        }
        DynamicObject customerLinkMans = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)"bd_customer");
        DynamicObjectCollection linkmans = customerLinkMans.getDynamicObjectCollection("entry_linkman");
        Long customerLinkmanId = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                return (Long)linkman.getPkValue();
            }
            if (customerLinkmanId != null || invalid) continue;
            customerLinkmanId = (Long)linkman.getPkValue();
        }
        return customerLinkmanId;
    }

    public static DynamicObject getLinkmanObject(DynamicObject customer) {
        if (customer == null) {
            return null;
        }
        DynamicObject customerLinkMans = BusinessDataServiceHelper.loadSingleFromCache((Object)customer.getPkValue(), (String)"bd_customer");
        DynamicObjectCollection linkmans = customerLinkMans.getDynamicObjectCollection("entry_linkman");
        DynamicObject customerLinkmanId = null;
        for (DynamicObject linkman : linkmans) {
            boolean isDefault = linkman.getBoolean("isdefault_linkman");
            boolean invalid = linkman.getBoolean("invalid");
            if (isDefault && !invalid) {
                customerLinkmanId = linkman;
                break;
            }
            if (customerLinkmanId != null || invalid) continue;
            customerLinkmanId = linkman;
        }
        DynamicObject linkmanObject = null;
        if (customerLinkmanId != null) {
            linkmanObject = BusinessDataServiceHelper.loadSingleFromCache((Object)customerLinkmanId.getPkValue(), (String)"bd_customerlinkman");
        }
        return linkmanObject;
    }

    public static Set<Long> getAllLinkMans(DynamicObject customer) {
        HashSet<Long> ids = new HashSet<Long>(8);
        if (customer == null) {
            return ids;
        }
        DynamicObjectCollection linkmans = customer.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject linkman : linkmans) {
            boolean invalid = linkman.getBoolean("invalid");
            if (invalid) continue;
            ids.add((Long)linkman.getPkValue());
        }
        return ids;
    }

    public static String getAddress(DynamicObject customer) {
        if (customer == null) {
            return "";
        }
        QFilter id1 = new QFilter("customerid", "in", (Object)customer.getPkValue().toString());
        QFilter id2 = new QFilter("invalid", "=", (Object)"0");
        Map bd_address = BusinessDataServiceHelper.loadFromCache((String)"bd_address", (QFilter[])new QFilter[]{id1.and(id2)});
        String validAddress = "";
        if (bd_address.size() > 0) {
            for (Map.Entry entry : bd_address.entrySet()) {
                DynamicObject add = (DynamicObject)entry.getValue();
                boolean isDefault = add.getBoolean("default");
                if (isDefault) {
                    return add.getString("detailaddress");
                }
                if (!"".equalsIgnoreCase(validAddress)) continue;
                validAddress = add.getString("detailaddress");
            }
        }
        return validAddress;
    }

    protected static void setDefaultCustomer(DynamicObject bill) {
        CustomerHelper.setDefaultCustomer(bill, Collections.EMPTY_MAP);
    }

    protected static void setDefaultCustomer(DynamicObject bill, Map<Object, Object> conditionMap) {
        DynamicObject recCustomer;
        DynamicObject linkman;
        DynamicObject customer = bill.getDynamicObject("customer");
        if (customer == null) {
            return;
        }
        String address = bill.getString("address");
        if (StringUtils.isEmpty((String)address)) {
            bill.set("address", (Object)CustomerHelper.getAddress(customer));
        }
        if ((linkman = bill.getDynamicObject("linkman")) == null) {
            bill.set("linkman", (Object)CustomerHelper.getLinkmanObject(customer));
        }
        if (bill.getDynamicObject("reccondition") == null) {
            DynamicObject reccondition = customer.getDynamicObject("receivingcondid");
            bill.set("reccondition", (Object)reccondition);
        }
        DynamicObject settleType = null;
        if (((Boolean)conditionMap.getOrDefault(IS_SET_DEFAULT_SETTLE_TYPE, Boolean.TRUE)).booleanValue() && (settleType = bill.getDynamicObject("settletype")) == null) {
            bill.set("settletype", (Object)CustomerHelper.getDefaultSettleTypeObj(customer));
        }
        if (bill.get("payingcustomer") == null) {
            bill.set("payingcustomer", (Object)CustomerHelper.getOtherCustomer(customer, "paymentcustomerid", CustomerFunction.PAY));
        }
        if (bill.get("settlecustomer") == null) {
            bill.set("settlecustomer", (Object)CustomerHelper.getOtherCustomer(customer, "invoicecustomerid", CustomerFunction.SETTLE));
        }
        if ((recCustomer = bill.getDynamicObject("reccustomer")) == null) {
            recCustomer = CustomerHelper.getOtherCustomer(customer, "delivercustomerid", CustomerFunction.RECEIVE);
            bill.set("reccustomer", (Object)recCustomer);
        }
        if (recCustomer != null) {
            if (bill.get("reclinkman") == null) {
                bill.set("reclinkman", (Object)CustomerHelper.getLinkmanObject(recCustomer));
            }
            if (StringUtils.isEmpty((String)bill.getString("receiveaddress"))) {
                bill.set("receiveaddress", (Object)CustomerHelper.getAddress(recCustomer));
            }
        }
    }

    public static DynamicObject getOtherCustomer(DynamicObject customer, String otherCustomer, CustomerFunction function) {
        if (customer == null) {
            return null;
        }
        DynamicObject otherCus = customer.getDynamicObject(otherCustomer);
        if (otherCus != null) {
            if (CustomerHelper.checkBizFunction(otherCus = BusinessDataServiceHelper.loadSingleFromCache((Object)otherCus.getPkValue(), (String)"bd_customer"), function)) {
                return otherCus;
            }
        } else if (CustomerHelper.checkBizFunction(customer, function)) {
            return customer;
        }
        return null;
    }

    public static DynamicObject getDefaultSettleTypeObj(DynamicObject customer) {
        DynamicObject settleType;
        if (customer != null && (settleType = customer.getDynamicObject("settlementtypeid")) != null) {
            return settleType;
        }
        QFilter isDefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isEnable = new QFilter("enable", "=", (Object)"1");
        QFilter filter = isDefault.and(isEnable);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (String)"id,isdefault,enable", (QFilter[])filter.toArray());
    }

    public static boolean checkBizFunction(DynamicObject supplier, CustomerFunction function) {
        if (supplier == null) {
            return false;
        }
        String bizFunction = supplier.getString("bizfunction");
        if (bizFunction == null) {
            return false;
        }
        return function != null && bizFunction.contains(function.getValue());
    }

    public static boolean isBlockedorder(DynamicObject supplier) {
        return supplier != null && supplier.getBoolean("blockedorder");
    }
}

