/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.ExceptionUtils;

public class InspectionHelper {
    protected static final Log log = LogFactory.getLog(InspectionHelper.class);

    public static Set<Integer> getNeedInspectByIndex(DynamicObject checkBill, Collection<Integer> checkIndex, String bizType) {
        Map<String, JSONObject> params = InspectionHelper.buildInspectionParams(checkBill, checkIndex, bizType);
        Set<String> calInspectResult = InspectionHelper.calInspect(params);
        HashSet<Integer> result = new HashSet<Integer>(calInspectResult.size());
        for (String resultKey : calInspectResult) {
            result.add(Integer.valueOf(resultKey));
        }
        return result;
    }

    public static Map<String, JSONObject> buildInspectionParams(DynamicObject checkBill, Collection<Integer> checkIndex, String bizType) {
        if (checkBill == null) {
            return new HashMap<String, JSONObject>();
        }
        DynamicObjectType checkBillType = checkBill.getDynamicObjectType();
        HashMap<String, JSONObject> params = new HashMap<String, JSONObject>(checkIndex.size());
        DynamicObjectCollection entries = checkBill.getDynamicObjectCollection("billentry");
        for (int index : checkIndex) {
            DynamicObject entry = (DynamicObject)entries.get(index);
            DynamicObject material = entry.getDynamicObject("material");
            DynamicObject inspectOrg = entry.getDynamicObject("inspectOrg");
            if (material == null || inspectOrg == null) continue;
            JSONObject objs = InspectionHelper.buildInspectionParam(material, inspectOrg, bizType);
            params.put("" + index, objs);
        }
        return params;
    }

    public static JSONObject buildInspectionParam(DynamicObject material, DynamicObject inspectOrg, String bizType) {
        if (material == null || inspectOrg == null) {
            return null;
        }
        JSONObject objs = new JSONObject();
        objs.put("materialId", material.getDynamicObject("masterid").getPkValue());
        objs.put("inspectOrgId", inspectOrg.getPkValue());
        objs.put("bizType", (Object)bizType);
        return objs;
    }

    public static Set<String> calInspect(Map<String, JSONObject> params) {
        if (params.isEmpty()) {
            return new HashSet<String>(0);
        }
        HashSet<String> needInsp = new HashSet<String>(params.size());
        try {
            log.info("\u8c03\u7528 \u8d28\u68c0isNeedInspectBat\u63a5\u53e3\u5f00\u59cb\uff0c\u53c2\u6570\u4e3a\uff1a" + params);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"qmc", (String)"qcbd", (String)"MaterialInspectService", (String)"isNeedInspectBat", (Object[])new Object[]{params});
            log.info("\u8c03\u7528 \u8d28\u68c0isNeedInspectBat\u63a5\u53e3\u7ed3\u675f\uff0c\u8fd4\u56de\u4e3a\uff1a" + result);
            for (Map.Entry entry : result.entrySet()) {
                JSONObject value = (JSONObject)entry.getValue();
                Boolean isNeed = value.getBoolean("isNeedInspect");
                if (!Boolean.TRUE.equals(isNeed)) continue;
                needInsp.add((String)entry.getKey());
            }
        }
        catch (Exception e) {
            log.info("\u8c03\u7528 \u8d28\u68c0isNeedInspectBat\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd4\u56de\u4e3a\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            return new HashSet<String>(0);
        }
        return needInsp;
    }
}

