/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.mpscmm.msbd.common.enums.KitStructCtlEnum;
import kd.mpscmm.msbd.common.enums.PriceModelEnum;
import kd.scmc.sm.business.helper.AmountCalcHelper;
import kd.scmc.sm.business.pojo.KitStructureMaterialInfo;
import kd.scmc.sm.business.pojo.KitStructureParentInfo;
import kd.scmc.sm.business.pojo.KitStructureResultInfo;
import kd.scmc.sm.consts.BillTplEntryConst;
import kd.scmc.sm.enums.DiscountTypeEnum;
import kd.scmc.sm.enums.ProductTypeEnum;

public class KitSalesHelper {
    private static final Log log = LogFactory.getLog(KitSalesHelper.class);
    public static final String KITSALEPARAM = "KITSALE";

    public static boolean isKitSale(IPageCache pageCache, String entityType) {
        if (pageCache.get(KITSALEPARAM) == null) {
            if (KitSalesHelper.isAllowKit(entityType)) {
                QFilter paramFilter = new QFilter("number", "=", (Object)"KIT0001");
                DynamicObject kitSaleParam = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_scmcapplevelparam", (QFilter[])new QFilter[]{paramFilter});
                if (kitSaleParam != null) {
                    pageCache.put(KITSALEPARAM, kitSaleParam.getString("enable"));
                    if ("1".equals(kitSaleParam.getString("enable"))) {
                        return true;
                    }
                } else {
                    pageCache.put(KITSALEPARAM, "0");
                }
            }
            return false;
        }
        return "1".equals(pageCache.get(KITSALEPARAM));
    }

    public static boolean isAllowKit(String entityType) {
        if (StringUtils.isEmpty((CharSequence)entityType)) {
            return false;
        }
        if ("sm_salesagency".equals(entityType)) {
            return false;
        }
        String inheritPath = MetadataServiceHelper.getDataEntityType((String)entityType).getInheritPath();
        return !inheritPath.contains("1EULGF41VQJF");
    }

    public static boolean isKitSale() {
        QFilter paramFilter = new QFilter("number", "=", (Object)"KIT0001");
        DynamicObject kitSaleParam = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_scmcapplevelparam", (QFilter[])new QFilter[]{paramFilter});
        return kitSaleParam != null && "1".equals(kitSaleParam.getString("enable"));
    }

    public static List<String> getAmountAndQtyFieldList(DynamicObject billOb, String entry) {
        ArrayList<String> listFields = new ArrayList<String>(12);
        Map allFields = ((BillEntityType)billOb.getDataEntityType()).getAllFields();
        for (IDataEntityProperty pro : allFields.values()) {
            String field;
            if (!(pro instanceof PriceProp) && !(pro instanceof AmountProp) || (field = KitSalesHelper.getField(pro, entry)) == null) continue;
            listFields.add(field);
        }
        return listFields;
    }

    private static String getField(IDataEntityProperty po, String entry) {
        IDataEntityType parent;
        String entryName;
        String name = po.getName();
        if ((entry = entry + ".").equals(entryName = KitSalesHelper.getEntryName(parent = po.getParent(), ""))) {
            return name;
        }
        return null;
    }

    private static String getEntryName(IDataEntityType entry, String entryName) {
        IDataEntityType parent;
        String name = entry.getName();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            entryName = name + "." + entryName;
        }
        if ((parent = entry.getParent()) != null) {
            KitSalesHelper.getEntryName(parent, entryName);
        }
        return entryName;
    }

    public static boolean isDraw(String formId, DynamicObject billObj) {
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)formId);
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        ExtendedDataEntitySet dataSet = new ExtendedDataEntitySet();
        dataSet.Parse(new DynamicObject[]{billObj}, (MainEntityType)billObj.getDataEntityType());
        for (LinkSetItemElement linkEntry : linkSet.getItems()) {
            ExtendedDataEntity[] rows = dataSet.FindByEntityKey(linkEntry.getLinkEntityKey());
            if (rows == null || rows.length <= 0) continue;
            for (ExtendedDataEntity row : rows) {
                if (!KitSalesHelper.haveSourceBillId(row.getDataEntity())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean haveSourceBillId(DynamicObject linkRow) {
        LinkEntryType linkType = (LinkEntryType)linkRow.getDataEntityType();
        Long sBillId = (Long)linkType.getSBillIdProp().getValueFast((Object)linkRow);
        return sBillId != null && sBillId != 0L;
    }

    public static int getUnitPrecision(DynamicObject unit) {
        int precision = 10;
        if (unit != null && unit.containsProperty("precision") && (precision = unit.getInt("precision")) == 0) {
            precision = 10;
        }
        return precision;
    }

    public static RoundingMode getUnitRoundingMode(DynamicObject unit) {
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        if (unit != null && unit.containsProperty("precisionaccount")) {
            String precisionAccount = unit.getString("precisionaccount");
            if ("3".equals(precisionAccount)) {
                roundingMode = RoundingMode.UP;
            } else if ("2".equals(precisionAccount)) {
                roundingMode = RoundingMode.DOWN;
            }
        }
        return roundingMode;
    }

    public static String getMaterialCode(DynamicObject material) {
        String materialCode = "";
        if (material != null && material.containsProperty("masterid") && material.getDynamicObject("masterid") != null && material.getDynamicObject("masterid").containsProperty("number")) {
            materialCode = material.getDynamicObject("masterid").getString("number");
        }
        return materialCode;
    }

    public static String getMaterialName(DynamicObject material) {
        String materialName = "";
        if (material != null && material.containsProperty("masterid") && material.getDynamicObject("masterid") != null && material.getDynamicObject("masterid").containsProperty("name")) {
            materialName = material.getDynamicObject("masterid").getString("name");
        }
        return materialName;
    }

    public static KitStructureResultInfo expandKitStructure(String billEntity, Long billId, Long billEntryId, BigDecimal parentBaseQty) {
        KitStructureResultInfo resultInfo = new KitStructureResultInfo(billEntity, billId, billEntryId, parentBaseQty);
        DynamicObject bill = null;
        try {
            bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)billEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"KitSalesHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]);
            resultInfo.setStatusFail();
            resultInfo.setMessage(msg);
            return resultInfo;
        }
        if (bill == null || bill.getPkValue() == null || (Long)bill.getPkValue() == 0L) {
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u8be5\u5355\u636e\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"KitSalesHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]);
            resultInfo.setStatusFail();
            resultInfo.setMessage(msg);
            return resultInfo;
        }
        DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
        Long pid = 0L;
        for (DynamicObject billEntry : billEntrys) {
            if (((Long)billEntry.getPkValue()).longValue() != billEntryId.longValue()) continue;
            pid = billEntry.getLong("kitpid");
            break;
        }
        if (pid == null || pid == 0L) {
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5957\u4ef6\u884c\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"KitSalesHelper_1", (String)"scmc-sm-business", (Object[])new Object[0]);
            resultInfo.setStatusFail();
            resultInfo.setMessage(msg);
            return resultInfo;
        }
        HashMap<Long, KitStructureMaterialInfo> entryMap = new HashMap<Long, KitStructureMaterialInfo>();
        BigDecimal originalParentQty = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        String priceModel = "";
        for (DynamicObject billEntry : billEntrys) {
            DynamicObject lineType;
            Long rowPid = billEntry.getLong("kitpid");
            String productType = billEntry.getString("producttype");
            if (rowPid.longValue() != pid.longValue() || !ProductTypeEnum.KITPARENT.getValue().equals(productType)) continue;
            BigDecimal originalParentBaseQty = billEntry.getBigDecimal("baseqty");
            priceModel = billEntry.getString("pricemodel");
            Long entryId = (Long)billEntry.getPkValue();
            DynamicObject material = billEntry.getDynamicObject("material");
            Long materialId = 0L;
            if (material != null && material.containsProperty("masterid") && material.getDynamicObject("masterid") != null) {
                materialId = (Long)material.getDynamicObject("masterid").getPkValue();
            }
            KitStructureParentInfo parentInfo = new KitStructureParentInfo(entryId, productType, materialId, rowPid);
            if (parentBaseQty == null || BigDecimal.ZERO.compareTo(parentBaseQty) == 0) {
                parentInfo.setBaseQty(originalParentBaseQty);
                parentBaseQty = originalParentBaseQty;
            }
            if ((lineType = billEntry.getDynamicObject("linetype")) != null && lineType.containsProperty("storageout")) {
                Boolean storageOut = lineType.getBoolean("storageout");
                parentInfo.setStorageOut(storageOut);
            }
            parentInfo.setBaseQty(parentBaseQty);
            originalParentQty = billEntry.getBigDecimal("qty");
            if (PriceModelEnum.PARENT.getValue().equals(priceModel)) {
                BigDecimal price = billEntry.getBigDecimal("price");
                BigDecimal priceAndTax = billEntry.getBigDecimal("priceandtax");
                BigDecimal amount = billEntry.getBigDecimal("amount");
                BigDecimal amountAndTax = billEntry.getBigDecimal("amountandtax");
                BigDecimal curAmount = billEntry.getBigDecimal("curamount");
                parentInfo.setPrice(price);
                parentInfo.setPriceAndTax(priceAndTax);
                parentInfo.setAmount(amount);
                parentInfo.setAmountAndTax(amountAndTax);
                parentInfo.setCurAmount(curAmount);
            }
            taxRate = billEntry.getBigDecimal("taxrate").divide(new BigDecimal("100"));
            resultInfo.setParent(parentInfo);
            break;
        }
        if (resultInfo.getParent() == null) {
            String msg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5957\u4ef6\u7236\u9879\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"KitSalesHelper_2", (String)"scmc-sm-business", (Object[])new Object[0]);
            resultInfo.setStatusFail();
            resultInfo.setMessage(msg);
            return resultInfo;
        }
        BigDecimal childAmountSum = BigDecimal.ZERO;
        BigDecimal childCurAmountSum = BigDecimal.ZERO;
        BigDecimal childAmountAndTaxSum = BigDecimal.ZERO;
        BigDecimal childDiscountAmount = BigDecimal.ZERO;
        for (DynamicObject billEntry : billEntrys) {
            Long rowPid = billEntry.getLong("kitpid");
            String productType = billEntry.getString("producttype");
            if (rowPid.longValue() != pid.longValue() || !ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
            Long entryId = (Long)billEntry.getPkValue();
            DynamicObject material = billEntry.getDynamicObject("material");
            Long materialId = 0L;
            if (material != null && material.containsProperty("masterid") && material.getDynamicObject("masterid") != null) {
                materialId = (Long)material.getDynamicObject("masterid").getPkValue();
            }
            KitStructureMaterialInfo entry = new KitStructureMaterialInfo(entryId, productType, materialId, rowPid);
            DynamicObject lineType = billEntry.getDynamicObject("linetype");
            if (lineType != null && lineType.containsProperty("storageout")) {
                Boolean storageOut = lineType.getBoolean("storageout");
                entry.setStorageOut(storageOut);
            }
            BigDecimal kitQty = billEntry.getBigDecimal("kitqty");
            BigDecimal parentQty = billEntry.getBigDecimal("parentqty");
            entry.setKitQty(kitQty);
            entry.setParentQty(parentQty);
            DynamicObject baseUnit = billEntry.getDynamicObject("baseunit");
            int precision = KitSalesHelper.getUnitPrecision(baseUnit);
            RoundingMode roundingMode = KitSalesHelper.getUnitRoundingMode(baseUnit);
            BigDecimal baseQty = BigDecimal.ZERO;
            if (parentQty != null && BigDecimal.ZERO.compareTo(parentQty) != 0) {
                baseQty = parentBaseQty.multiply(kitQty).divide(parentQty, precision, roundingMode);
            }
            entry.setBaseQty(baseQty);
            if (PriceModelEnum.CHILD.getValue().equals(priceModel)) {
                BigDecimal amount = billEntry.getBigDecimal("amount");
                BigDecimal curAmount = billEntry.getBigDecimal("curamount");
                BigDecimal amountAndTax = billEntry.getBigDecimal("amountandtax");
                BigDecimal discountAmount = billEntry.getBigDecimal("discountamount");
                childAmountSum = childAmountSum.add(amount);
                childAmountAndTaxSum = childAmountAndTaxSum.add(amountAndTax);
                childCurAmountSum = childCurAmountSum.add(curAmount);
                childDiscountAmount = childDiscountAmount.add(discountAmount);
            }
            entryMap.put(entryId, entry);
        }
        resultInfo.setChild(entryMap);
        if (PriceModelEnum.CHILD.getValue().equals(priceModel)) {
            KitStructureParentInfo parentInfo = resultInfo.getParent();
            BigDecimal price = BigDecimal.ZERO;
            BigDecimal priceAndTax = BigDecimal.ZERO;
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal amountAndTax = BigDecimal.ZERO;
            BigDecimal curAmount = BigDecimal.ZERO;
            BigDecimal discountAmount = BigDecimal.ZERO;
            BigDecimal discountRate = BigDecimal.ZERO;
            BigDecimal taxAmount = BigDecimal.ZERO;
            Boolean isTax = bill.getBoolean("istax");
            DynamicObject currency = bill.getDynamicObject("currency");
            int currencyAmtPrecision = 10;
            if (currency != null && currency.containsProperty("amtprecision")) {
                currencyAmtPrecision = currency.getInt("amtprecision");
            }
            DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
            int settleAmtPrecision = 10;
            if (settleCurrency != null && settleCurrency.containsProperty("amtprecision")) {
                settleAmtPrecision = settleCurrency.getInt("amtprecision");
            }
            BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
            String exchangeType = bill.getString("exchangetype");
            if (isTax.booleanValue()) {
                amountAndTax = childAmountAndTaxSum;
                discountAmount = childDiscountAmount;
                if (originalParentQty != null && BigDecimal.ZERO.compareTo(originalParentQty) != 0) {
                    priceAndTax = amountAndTax.add(discountAmount).divide(originalParentQty, 10, RoundingMode.HALF_UP);
                }
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), 10, 4);
                taxAmount = amountAndTax.divide(BigDecimal.ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settleAmtPrecision, 4);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                if (exChangeRate != null && exChangeRate.compareTo(BigDecimal.ZERO) != 0 && (amountAndTax.compareTo(BigDecimal.ZERO) != 0 || taxAmount.compareTo(BigDecimal.ZERO) != 0 || amount.compareTo(BigDecimal.ZERO) != 0)) {
                    BigDecimal curTaxAmount = AmountCalcHelper.getCurAmountByRate(taxAmount, exChangeRate, currencyAmtPrecision, exchangeType);
                    BigDecimal curAmountAndTax = AmountCalcHelper.getCurAmountByRate(amountAndTax, exChangeRate, currencyAmtPrecision, exchangeType);
                    curAmount = curAmountAndTax.subtract(curTaxAmount);
                }
                if (originalParentQty != null && BigDecimal.ZERO.compareTo(originalParentQty) != 0) {
                    discountRate = discountAmount.divide(originalParentQty, 10, RoundingMode.HALF_UP);
                }
            } else {
                amount = childAmountSum;
                discountAmount = childDiscountAmount;
                if (originalParentQty != null && BigDecimal.ZERO.compareTo(originalParentQty) != 0) {
                    discountRate = discountAmount.divide(originalParentQty, 10, RoundingMode.HALF_UP).divide(BigDecimal.ONE.add(taxRate), 10, RoundingMode.HALF_UP);
                }
                if (originalParentQty != null && BigDecimal.ZERO.compareTo(originalParentQty) != 0) {
                    price = amount.divide(originalParentQty, 10, RoundingMode.HALF_UP).add(discountRate);
                }
                priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate)).setScale(10, 4);
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, 4);
                amountAndTax = amount.add(taxAmount).setScale(settleAmtPrecision, 4);
                if (exChangeRate != null && exChangeRate.compareTo(BigDecimal.ZERO) != 0 && (amountAndTax.compareTo(BigDecimal.ZERO) != 0 || taxAmount.compareTo(BigDecimal.ZERO) != 0 || amount.compareTo(BigDecimal.ZERO) != 0)) {
                    curAmount = AmountCalcHelper.getCurAmountByRate(amount, exChangeRate, currencyAmtPrecision, exchangeType);
                }
            }
            parentInfo.setPrice(price);
            parentInfo.setPriceAndTax(priceAndTax);
            parentInfo.setAmount(amount);
            parentInfo.setAmountAndTax(amountAndTax);
            parentInfo.setCurAmount(curAmount);
            parentInfo.setDiscountRate(discountRate);
            parentInfo.setDiscountAmount(discountAmount);
            parentInfo.setTaxAmount(taxAmount);
            resultInfo.setParent(parentInfo);
        }
        return resultInfo;
    }

    public static void initEntryInfo4Kit(DynamicObjectCollection entrys, Set<String> enableColumn, Map<String, Object> param) {
        Long newKitPid = -1L;
        DynamicObject newKitProduct = null;
        DynamicObject newMaterial = null;
        for (int i = 0; entrys != null && i < entrys.size(); ++i) {
            DynamicObject entryInfo = (DynamicObject)entrys.get(i);
            String productType = entryInfo.getString("producttype");
            DynamicObject material = entryInfo.getDynamicObject("material");
            DynamicObject masterid = material.getDynamicObject("masterid");
            if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                entryInfo.set("kitqty", (Object)BigDecimal.ONE);
                entryInfo.set("parentqty", (Object)BigDecimal.ONE);
                KitSalesHelper.genPKValue(entryInfo);
                newKitPid = entryInfo.getLong("id");
                entryInfo.set("id", (Object)newKitPid);
                entryInfo.set("kitpid", (Object)newKitPid);
                entryInfo.set("pricemodel", (Object)material.getString("pricemodel"));
                entryInfo.set("kittransfermodel", (Object)material.getString("kittransfermodel"));
                if (PriceModelEnum.CHILD.getValue().equals(material.getString("pricemodel"))) {
                    enableColumn.forEach(f -> entryInfo.set(f, null));
                    entryInfo.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                }
                newKitProduct = masterid;
                newMaterial = material;
                continue;
            }
            if (ProductTypeEnum.KITCHILD.getValue().equals(productType)) {
                entryInfo.set("kitpid", (Object)newKitPid);
                entryInfo.set("kitproduct", newKitProduct);
                if (newMaterial == null) continue;
                entryInfo.set("pricemodel", (Object)newMaterial.getString("pricemodel"));
                entryInfo.set("kittransfermodel", (Object)newMaterial.getString("kittransfermodel"));
                if (!PriceModelEnum.PARENT.getValue().equals(newMaterial.getString("pricemodel"))) continue;
                enableColumn.forEach(f -> entryInfo.set(f, null));
                entryInfo.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                continue;
            }
            for (String f2 : BillTplEntryConst.KIT_ASSN_FIELDS) {
                entryInfo.set(f2, null);
            }
        }
    }

    public static void resetSeq4KitSale(DynamicObject srcBill) {
        DynamicObjectCollection billEntry = srcBill.getDynamicObjectCollection("billentry");
        if (billEntry != null && !billEntry.isEmpty()) {
            int size = billEntry.size();
            int cursor = 0;
            for (int i = 0; i < size; ++i) {
                String productType = ((DynamicObject)billEntry.get(i)).getString("producttype");
                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                    int currentParentSeq = ((DynamicObject)billEntry.get(i)).getInt("seq");
                    Long currentParentPID = ((DynamicObject)billEntry.get(i)).getLong("kitpid");
                    if (currentParentSeq <= cursor) {
                        currentParentSeq = ++cursor;
                        ((DynamicObject)billEntry.get(i)).set("seq", (Object)currentParentSeq);
                    } else {
                        cursor = currentParentSeq;
                    }
                    for (int j = 0; j < size; ++j) {
                        String sortEntryProductType = ((DynamicObject)billEntry.get(j)).getString("producttype");
                        Long sortEntryPID = ((DynamicObject)billEntry.get(j)).getLong("kitpid");
                        if (!ProductTypeEnum.KITCHILD.getValue().equals(sortEntryProductType) || !currentParentPID.equals(sortEntryPID)) continue;
                        ((DynamicObject)billEntry.get(j)).set("seq", (Object)(++cursor));
                    }
                    continue;
                }
                if (!ProductTypeEnum.STANDARD.getValue().equals(productType) || cursor <= 0) continue;
                ((DynamicObject)billEntry.get(i)).set("seq", (Object)(++cursor));
            }
        }
    }

    private static Long genPKValue(DynamicObject curObj) {
        if (curObj.getPkValue() == null || Long.valueOf("0").equals(curObj.getPkValue())) {
            curObj.set("id", (Object)DBServiceHelper.genGlobalLongId());
            return (Long)curObj.get("id");
        }
        return (Long)curObj.getPkValue();
    }

    public static void setKitQtyDefValue(DynamicObject[] bills) {
        if (bills == null || bills.length <= 0) {
            return;
        }
        if (!KitSalesHelper.isKitSale()) {
            return;
        }
        HashMap<Long, DynamicObject> parentRowInfoMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, ArrayList<DynamicObject>> childRowListMap = new HashMap<Long, ArrayList<DynamicObject>>();
        for (DynamicObject bill : bills) {
            parentRowInfoMap.clear();
            childRowListMap.clear();
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            if ("sm_returnapply".equals(bill.getDataEntityType().getName()) && KitSalesHelper.isDraw("sm_returnapply", bill)) continue;
            for (DynamicObject billRow : billEntry) {
                String productType = billRow.getString("producttype");
                Long pId = billRow.getLong("kitpid");
                if (ProductTypeEnum.KITPARENT.getValue().equals(productType)) {
                    parentRowInfoMap.put(pId, billRow);
                    if (billRow.getBigDecimal("kitqty").compareTo(BigDecimal.ZERO) == 0) {
                        billRow.set("kitqty", (Object)BigDecimal.ONE);
                    }
                    if (billRow.getBigDecimal("parentqty").compareTo(BigDecimal.ZERO) != 0) continue;
                    billRow.set("parentqty", (Object)BigDecimal.ONE);
                    continue;
                }
                if (!ProductTypeEnum.KITCHILD.getValue().equals(productType)) continue;
                ArrayList<DynamicObject> childRowList = (ArrayList<DynamicObject>)childRowListMap.get(pId);
                if (childRowList == null) {
                    childRowList = new ArrayList<DynamicObject>();
                }
                childRowList.add(billRow);
                childRowListMap.put(pId, childRowList);
            }
            for (Map.Entry childRowListEntry : childRowListMap.entrySet()) {
                DynamicObject parentRow = (DynamicObject)parentRowInfoMap.get(childRowListEntry.getKey());
                if (parentRow == null) continue;
                BigDecimal baseQtyParent = parentRow.getBigDecimal("baseqty");
                Boolean isBomCurl = Boolean.FALSE;
                DynamicObject kitBom = parentRow.getDynamicObject("bom");
                DynamicObject parentMaterial = parentRow.getDynamicObject("material");
                if (kitBom != null && parentMaterial != null && KitStructCtlEnum.NONADJ.getValue().equals(parentMaterial.getString("kitstructctl"))) {
                    isBomCurl = Boolean.TRUE;
                }
                List childRowList = (List)childRowListEntry.getValue();
                for (DynamicObject childRow : childRowList) {
                    BigDecimal baseQty = childRow.getBigDecimal("baseqty");
                    BigDecimal kitQty = BigDecimal.ONE;
                    BigDecimal parentQty = BigDecimal.ONE;
                    if (baseQty != null && baseQtyParent != null && baseQty.compareTo(BigDecimal.ZERO) != 0 && baseQtyParent.compareTo(BigDecimal.ZERO) != 0) {
                        kitQty = baseQty;
                        parentQty = baseQtyParent;
                    }
                    if (isBomCurl.booleanValue()) {
                        if (childRow.getBigDecimal("kitqty") != null && BigDecimal.ZERO.compareTo(childRow.getBigDecimal("kitqty")) != 0 && childRow.getBigDecimal("parentqty") != null && BigDecimal.ZERO.compareTo(childRow.getBigDecimal("parentqty")) != 0) continue;
                        childRow.set("kitqty", (Object)kitQty);
                        childRow.set("parentqty", (Object)parentQty);
                        continue;
                    }
                    childRow.set("kitqty", (Object)kitQty);
                    childRow.set("parentqty", (Object)parentQty);
                }
            }
        }
    }
}

