/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.enums.ChangeTypeEnum;
import kd.scmc.sm.enums.EnableStatusEnum;
import kd.scmc.sm.enums.StatusEnum;

public class LotCacheHelper {
    private static final Log log = LogFactory.getLog(LotCacheHelper.class);
    public static final String ENABLE_LOT = "enable_lot";
    private static final String ORG = "org";

    public static void setLotEnable(List<RowDataEntity> currencyRows, IFormView view, IPageCache pageCache) {
        DynamicObject material;
        if (currencyRows.size() == 0) {
            return;
        }
        String entityId = view.getEntityId();
        DynamicObject bill = view.getModel().getDataEntity();
        HashMap<Long, Set<Long>> orgToMaterial = new HashMap<Long, Set<Long>>();
        HashMap<String, Boolean> lotCache = new HashMap();
        String lotCacheStr = pageCache.get(ENABLE_LOT);
        if (StringUtils.isNotEmpty((String)lotCacheStr)) {
            lotCache = (Map)SerializationUtils.fromJsonString((String)lotCacheStr, Map.class);
        }
        for (RowDataEntity row : currencyRows) {
            DynamicObject entryInfo = row.getDataEntity();
            DynamicObject stockOrg = LotCacheHelper.getInvOrg(bill, entryInfo);
            if (entryInfo.getDynamicObject("material") == null || stockOrg == null) continue;
            Long stockOrgID = (Long)stockOrg.getPkValue();
            material = entryInfo.getDynamicObject("material").getDynamicObject("masterid");
            Long materialID = (Long)material.getPkValue();
            if (lotCache.containsKey(LotCacheHelper.getLotCacheKey(materialID, stockOrgID))) continue;
            Set materialSets = orgToMaterial.computeIfAbsent(stockOrgID, key -> {
                HashSet materialIDs = new HashSet();
                return materialIDs;
            });
            materialSets.add(materialID);
        }
        LotCacheHelper.getLotCache(orgToMaterial, lotCache);
        for (RowDataEntity row : currencyRows) {
            int rowIndex = row.getRowIndex();
            DynamicObject entryInfo = row.getDataEntity();
            DynamicObject stockOrg = LotCacheHelper.getInvOrg(bill, entryInfo);
            if (entryInfo.getDynamicObject("material") != null && stockOrg != null) {
                material = entryInfo.getDynamicObject("material").getDynamicObject("masterid");
                Boolean enablelot = (Boolean)lotCache.get(LotCacheHelper.getLotCacheKey(material.getPkValue(), stockOrg.getPkValue()));
                if (enablelot == null) {
                    enablelot = Boolean.FALSE;
                    lotCache.put(LotCacheHelper.getLotCacheKey(material.getPkValue(), stockOrg.getPkValue()), enablelot);
                }
                if (!enablelot.booleanValue()) {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"lot"});
                    continue;
                }
                if ("sm_xsalorder".equals(entityId) && !ChangeTypeEnum.ADDNEW.getValue().equals(entryInfo.getString("entrychangetype"))) {
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
                    view.setEnable(Boolean.FALSE, rowIndex, new String[]{"lot"});
                    continue;
                }
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"lotnumber"});
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"lot"});
                continue;
            }
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"lotnumber"});
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"lot"});
        }
        pageCache.put(ENABLE_LOT, SerializationUtils.toJsonString(lotCache));
    }

    public static Map<Integer, Boolean> checkLot(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        return LotCacheHelper.checkLot(bill, entrys);
    }

    public static Map<Integer, Boolean> checkLot(DynamicObject bill, DynamicObjectCollection entrys) {
        HashMap<Integer, Boolean> checkResult = new HashMap<Integer, Boolean>(8);
        if (entrys != null && entrys.size() > 0) {
            DynamicObject stockOrg;
            HashMap<Long, Set<Long>> orgToMaterial = new HashMap<Long, Set<Long>>(8);
            HashMap<String, Boolean> lotCache = new HashMap<String, Boolean>(8);
            for (DynamicObject entry : entrys) {
                if (!StringUtils.isNotEmpty((String)entry.getString("lotnumber"))) continue;
                stockOrg = LotCacheHelper.getInvOrg(bill, entry);
                if (entry.getDynamicObject("material") == null || stockOrg == null) continue;
                Long stockOrgID = (Long)stockOrg.getPkValue();
                DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
                Long materialID = (Long)material.getPkValue();
                if (lotCache.containsKey(LotCacheHelper.getLotCacheKey(materialID, stockOrgID))) continue;
                Set materialSets = orgToMaterial.computeIfAbsent(stockOrgID, key -> {
                    HashSet materialIDs = new HashSet();
                    return materialIDs;
                });
                materialSets.add(materialID);
            }
            LotCacheHelper.getLotCache(orgToMaterial, lotCache);
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject entry;
                entry = (DynamicObject)entrys.get(i);
                if (!StringUtils.isNotEmpty((String)entry.getString("lotnumber"))) continue;
                stockOrg = LotCacheHelper.getInvOrg(bill, entry);
                if (entry.getString("material") == null || stockOrg == null) continue;
                DynamicObject material = entry.getDynamicObject("material").getDynamicObject("masterid");
                Boolean enablelot = (Boolean)lotCache.get(LotCacheHelper.getLotCacheKey(material.getPkValue(), stockOrg.getPkValue()));
                if (Boolean.TRUE.equals(enablelot)) {
                    checkResult.put(i, true);
                    continue;
                }
                checkResult.put(i, false);
            }
        }
        return checkResult;
    }

    public static DynamicObject getInvOrg(DynamicObject bill, DynamicObject entryInfo) {
        DynamicObject invOrg;
        String entityId;
        switch (entityId = bill.getDataEntityType().getName()) {
            case "sm_salorder": 
            case "sm_xsalorder": 
            case "sm_xssalorder": {
                invOrg = entryInfo.getDynamicObject("e_stockorg");
                break;
            }
            case "sm_delivernotice": {
                invOrg = bill.getDynamicObject("deliverorg");
                break;
            }
            case "sm_returnapply": {
                invOrg = entryInfo.getDynamicObject("entryinvorg");
                break;
            }
            case "sm_salesagency": {
                invOrg = entryInfo.getDynamicObject("e_stockorg");
                break;
            }
            case "sm_salepricelist": {
                invOrg = bill.getDynamicObject(ORG);
                break;
            }
            default: {
                invOrg = null;
            }
        }
        return invOrg;
    }

    public static void getLotCache(Map<Long, Set<Long>> orgToMaterial, Map<String, Boolean> lotCache) {
        Set<Map.Entry<Long, Set<Long>>> conditionSet = orgToMaterial.entrySet();
        for (Map.Entry<Long, Set<Long>> condition : conditionSet) {
            Long k = condition.getKey();
            Set<Long> v = condition.getValue();
            QFilter idFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)k);
            QFilter materialFilter = new QFilter("masterid.id", "in", v);
            QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
            QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"enablelot,masterid", (QFilter[])new QFilter[]{idFilter, materialFilter, statusFilter, enableFilter});
            Set entrySet = result.entrySet();
            for (Map.Entry entry : entrySet) {
                DynamicObject materialInvInfo = (DynamicObject)entry.getValue();
                Boolean enableLot = materialInvInfo.getBoolean("enablelot");
                Long materialPK = (Long)materialInvInfo.getDynamicObject("masterid").getPkValue();
                lotCache.put(LotCacheHelper.getLotCacheKey(materialPK, k), enableLot);
            }
        }
    }

    private static String getLotCacheKey(Object materialID, Object stockOrgID) {
        return String.valueOf(materialID) + "-" + String.valueOf(stockOrgID);
    }
}

