/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.sm.util.CommonUtils;

public class MaterialHelper {
    private static final Long AGENCY_BIZTYPE_ID = 688860294365375488L;
    private static final Long AGENCYBACK_BIZTYPE_ID = 688861035985431552L;
    private static final Long MATERIALS_ATTRIBUTE_ID = 1194029484878120960L;
    private static final String MASTERID = "masterid";
    private static final String SERVICEATTRIBUTE = "serviceattribute.fbasedataid_id";
    private static final String ENABLECONSIGN = "enableconsign";

    public static List<QFilter> getQFilterByLineType(Long billTypeId, Long bizTypeId, Long lineTypeId, boolean isMaterialInfo) {
        Object value;
        QFilter[] qFilterByLineType;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if (CommonUtils.isNull((Object)billTypeId) || CommonUtils.isNull((Object)bizTypeId)) {
            return qFilters;
        }
        if (AGENCY_BIZTYPE_ID.equals(bizTypeId) || AGENCYBACK_BIZTYPE_ID.equals(bizTypeId)) {
            qFilters.add(new QFilter((isMaterialInfo ? "masterid." : "") + SERVICEATTRIBUTE, "=", (Object)MATERIALS_ATTRIBUTE_ID));
            qFilters.add(new QFilter((isMaterialInfo ? "masterid." : "") + ENABLECONSIGN, "=", (Object)Boolean.TRUE));
        } else if (!CommonUtils.isNull((Object)lineTypeId) && (qFilterByLineType = kd.mpscmm.msbd.business.helper.MaterialHelper.getQFilterByLineType((Long)billTypeId, (Long)bizTypeId, (Long)lineTypeId, (boolean)isMaterialInfo)) != null && (value = qFilterByLineType[0].getValue()) != null && !value.equals(1)) {
            QFilter serviceAttrFilter = QFilter.sqlExpress((String)(isMaterialInfo ? "masterid.id" : "id"), (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + " ) "));
            qFilters.add(serviceAttrFilter);
        }
        return qFilters;
    }

    public static DynamicObject getDefaultTaxRate(DynamicObject customer, DynamicObject material) {
        DynamicObject master;
        DynamicObject taxRate = null;
        if (material != null && (master = material.getDynamicObject(MASTERID)) != null && master.getDynamicObject("taxrate") != null) {
            taxRate = master.getDynamicObject("taxrate");
        }
        if (taxRate == null && customer != null) {
            taxRate = customer.getDynamicObject("taxrate");
        }
        if (taxRate != null) {
            Long taxRateId = (Long)taxRate.getPkValue();
            taxRate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"id, taxrate,activedate,expdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateId)});
        }
        return taxRate;
    }

    public static boolean isEnableConsign(DynamicObject material, boolean isMaster) {
        DynamicObject materialMasterId = isMaster ? material : MaterialHelper.getMaterialMaster(material);
        if (materialMasterId == null) {
            return false;
        }
        return materialMasterId.getBoolean(ENABLECONSIGN);
    }

    public static boolean isMaterialType(DynamicObject material, boolean isMaster) {
        DynamicObject materialMasterId = isMaster ? material : MaterialHelper.getMaterialMaster(material);
        if (materialMasterId == null) {
            return false;
        }
        List<Long> serviceAttributeIds = MaterialHelper.getServiceAttributeIds(materialMasterId);
        return serviceAttributeIds.contains(MATERIALS_ATTRIBUTE_ID);
    }

    private static List<Long> getServiceAttributeIds(DynamicObject materialMasterId) {
        DynamicObjectCollection materialServiceAttribute = materialMasterId.getDynamicObjectCollection("serviceattribute");
        if (materialServiceAttribute == null) {
            return Collections.emptyList();
        }
        return materialServiceAttribute.stream().map(dym -> dym.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    private static DynamicObject getMaterialMaster(DynamicObject material) {
        if (material == null) {
            return null;
        }
        return material.getDynamicObject(MASTERID);
    }
}

