/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupFilterHelper;
import kd.scmc.sm.business.helper.AppParameterHelper;
import kd.scmc.sm.enums.EnableStatusEnum;
import kd.scmc.sm.util.CommonUtils;

public class OperGrpHelper {
    public static List<QFilter> buildOperatorFilter(Long userId, DynamicObject org, ListShowParameter showParameter) {
        if (org == null) {
            return null;
        }
        QFilter qFilter = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        Object operatorGroupIsolate = AppParameterHelper.getSmAppParameter((Long)org.getPkValue(), "foperatorgroupisolate");
        if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            QFilter qFilter1 = OperatorGroupFilterHelper.getOperatorGroupByUserForAll((long)userId, (DynamicObject)org, (String)OperatorGrpTypeEnum.SALEGRP.getValue());
            return Collections.singletonList(qFilter1.and(qFilter));
        }
        QFilter qFilter1 = new QFilter("operatorgrpid", "in", OperGrpHelper.getOperatorGroupByOrgForBill((Long)org.getPkValue()));
        return Collections.singletonList(qFilter1.and(qFilter));
    }

    public static ArrayList<Long> getOperatorGroupByUser(Long orgID, Set<Long> userIDs) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("operatorid", "in", userIDs);
        QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)OperGrpHelper.getOperatorGroupType());
        QFilter qFilter3 = new QFilter("operatorgrpid", "in", OperGrpHelper.getOperatorGroupByOrg(orgID));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    public static ArrayList<Long> getOperatorGroupByUserForBill(Long orgID, Set<Long> userIDs) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        QFilter qFilter1 = new QFilter("operatorid", "in", userIDs);
        QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)OperGrpHelper.getOperatorGroupType());
        QFilter qFilter3 = new QFilter("operatorgrpid", "in", OperGrpHelper.getOperatorGroupByOrgForBill(orgID));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }

    public static ArrayList<Long> getOperatorGroupByOrgForBill(Long orgID) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgID);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperGrpHelper.getOperatorGroupType());
        QFilter qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
            }
        }
        return operatorGroupList;
    }

    public static ArrayList<Long> getOperatorGroupByOrg(Long orgID) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgID);
        QFilter qFilter2 = new QFilter("operatorgrouptype", "=", (Object)OperGrpHelper.getOperatorGroupType());
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add((Long)((DynamicObject)list.get(i)).getPkValue());
            }
        }
        return operatorGroupList;
    }

    public static String getOperatorGroupType() {
        return OperatorGrpTypeEnum.SALEGRP.getValue();
    }

    public static List<QFilter> buildOperatorGrpFilter(DynamicObject org, DynamicObject operator) {
        if (org == null || operator == null) {
            return null;
        }
        if (CommonUtils.isNull((Object)operator)) {
            return Collections.singletonList(new QFilter("id", "=", (Object)0));
        }
        operator = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.getPkValue(), (String)"bd_operator");
        HashSet<Long> userIds = new HashSet<Long>();
        userIds.add((Long)operator.getDynamicObject("operatorid").getPkValue());
        QFilter qFilter = new QFilter("id", "in", OperGrpHelper.getOperatorGroupByUser((Long)org.getPkValue(), userIds));
        return Collections.singletonList(qFilter);
    }
}

