/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.util.CommonUtils;

public class OrgHelper {
    public static Map<String, Object> getCompanyByOrg(Long orgId, Boolean isBizUnit, Boolean isSerrchUpward) {
        Map OrgMap = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)isBizUnit, (Boolean)isSerrchUpward);
        return OrgMap;
    }

    public static Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId, Long billTypeId) {
        Long toOrgId = OrgServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (Long)billTypeId);
        return toOrgId;
    }

    public static List<Long> getFromOrgs(String toOrgType, Long fromOrgId, String fromOrgType, Long billTypeId) {
        List ownerOrgs = OrgServiceHelper.getFromOrgs((String)toOrgType, (Long)fromOrgId, (String)fromOrgType, (Long)billTypeId);
        return ownerOrgs;
    }

    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, Long billTypeId) {
        List invOrgs = OrgServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (Long)billTypeId);
        return invOrgs;
    }

    public static int checkPermission(Long userId, Long orgId, String appId, String formId, String permissionId) {
        int checkPermission = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)OrgViewTypeEnum.IS_SALE.getViewType(), (String)appId, (String)formId, (String)permissionId);
        return checkPermission;
    }

    public static List<Long> getAllToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        List orgAdminiDeptIds = OrgUnitServiceHelper.getAllToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return orgAdminiDeptIds;
    }

    public static List<Map<String, String>> getAllPermissionOrgs(MainEntityType dataEntityType, String orgViewType) {
        List hasPermissionSalesOrgs = OrgViewServiceHelper.getAllPermissionOrgs((MainEntityType)dataEntityType, (String)orgViewType);
        return hasPermissionSalesOrgs;
    }

    public static long getDefaultOrgRelation(String fromOrgType, String toOrgType, Long OrgId, String directViewType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(OrgId.longValue());
        param.setFromViewType(fromOrgType);
        param.setToViewType(toOrgType);
        param.setDirectViewType(directViewType);
        Long orgAdminiDeptId = OrgUnitServiceHelper.getDefaultOrgRelation((OrgRelationParam)param);
        return orgAdminiDeptId;
    }

    public static boolean checkOrgFunction(Long orgID, String orgFunction) {
        return OrgUnitServiceHelper.checkOrgFunction((Long)orgID, (String)orgFunction);
    }

    private static String getOrgViewType(String entityName) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        OrgProp org = (OrgProp)dataEntityType.getProperty("org");
        if (org == null) {
            return null;
        }
        String orgViewType = org.getOrgFunc();
        if (StringUtils.isEmpty((String)orgViewType)) {
            orgViewType = "15";
        }
        return orgViewType;
    }

    public static List<Long> getHasPermissionOrg(String entityName) {
        String orgViewType = OrgHelper.getOrgViewType(entityName);
        return OrgHelper.getHasPermissionOrg(entityName, orgViewType);
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = null;
        hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        Map tempInvStart = null;
        ArrayList<Long> orgIDs = new ArrayList<Long>();
        if ("05".equals(orgViewType)) {
            QFilter qFilter = new QFilter("startstatus", "=", (Object)"B");
            tempInvStart = BusinessDataServiceHelper.loadFromCache((String)"im_invstart", (String)"id,org,startdate", (QFilter[])new QFilter[]{qFilter});
            if (CommonUtils.isNull((Object)tempInvStart)) {
                return null;
            }
            for (DynamicObject invStart : tempInvStart.values()) {
                DynamicObject org = invStart.getDynamicObject("org");
                if (org == null) continue;
                orgIDs.add((Long)org.getPkValue());
            }
        }
        ArrayList<Long> orgs = new ArrayList<Long>();
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            if (tempInvStart != null && orgIDs != null && orgIDs.size() >= 1 && !orgIDs.contains(tempOrgId)) continue;
            orgs.add(tempOrgId);
        }
        return orgs;
    }

    public static String getFisAccountViewType() {
        return OrgViewTypeEnum.IS_ACCOUNTING.getViewType();
    }

    public static String getFisInventory() {
        return OrgViewTypeEnum.IS_INVENTORY.getViewType();
    }

    public static String getFisSaleViewType() {
        return OrgViewTypeEnum.IS_SALE.getViewType();
    }
}

