/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PriceListF7Helper {
    public static QFilter getPriceListFilter(DynamicObject bill) {
        QFilter filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
        DynamicObject org = bill.getDynamicObject("org");
        Date bizdate = bill.getDate("bizdate");
        DynamicObject customer = bill.getDynamicObject("customer");
        if (customer == null || bizdate == null || org == null) {
            return filter;
        }
        Long customerGroupID = -1L;
        if (customer.getDynamicObject("group") == null) {
            customer = BusinessDataServiceHelper.loadSingle((String)"bd_customer", (String)"group", (QFilter[])new QFilter[]{new QFilter("id", "=", customer.getPkValue())});
        }
        customerGroupID = (Long)customer.getDynamicObject("group").getPkValue();
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter dateStartFilter = new QFilter("effectdate", "<=", (Object)bizdate);
        QFilter dateEndFilter = new QFilter("expirydate", ">=", (Object)bizdate);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter applyBFilter = new QFilter("applycustomer", "=", (Object)"B").and(new QFilter("customerentryentity.customer", "=", customer.getPkValue()));
        QFilter applyCFilter = new QFilter("applycustomer", "=", (Object)"C").and(new QFilter("customerentryentity.customergroup", "=", (Object)customerGroupID));
        QFilter applyNFilter = QFilter.isNull((String)"customerentryentity");
        QFilter customerFilter = applyBFilter.or(applyCFilter).or(applyNFilter);
        QFilter[] totalFilter = new QFilter[]{orgFilter, dateStartFilter, statusFilter, enableFilter, dateEndFilter, customerFilter};
        HashSet<Long> ids = new HashSet<Long>();
        try (DataSet pricelistSet = QueryServiceHelper.queryDataSet((String)"PriceListF7Helper", (String)"sm_salepricelist", (String)"id", (QFilter[])totalFilter, null);){
            for (Row row : pricelistSet) {
                ids.add(row.getLong("id"));
            }
        }
        return new QFilter("id", "in", ids);
    }
}

