/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scmc.sm.business.helper.AppParameterHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.pojo.RowCloseActionResult;
import kd.scmc.sm.enums.CloseStatusEnum;
import kd.scmc.sm.enums.RowCloseStatusEnum;
import kd.scmc.sm.enums.RowTerminateStatusEnum;
import kd.scmc.sm.enums.StatusEnum;
import kd.scmc.sm.util.QFBuilder;

public class RowOPHelper {
    private static Log log = LogFactory.getLog(RowOPHelper.class);
    private static final Long ADMINISTRATORID = 1L;

    public static RowCloseActionResult checkRowClose(DynamicObject[] billColl, List<Long> selEntryIDs) {
        HashMap<Long, Boolean> paramCache = new HashMap<Long, Boolean>();
        HashMap<Long, Boolean> permissionCache = new HashMap<Long, Boolean>();
        RowCloseActionResult rowCloseActionResult = new RowCloseActionResult();
        HashSet<Long> beUpdateBillIDs = new HashSet<Long>();
        HashMap<Long, BigDecimal> returnBackBaseQtyCache = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> returnBackQtyCache = new HashMap<Long, BigDecimal>();
        log.info("checkRowClose, returnBackQtyCache: " + returnBackQtyCache + "returnBackBaseQtyCache:" + returnBackBaseQtyCache);
        QFBuilder qfBuilder = new QFBuilder();
        for (DynamicObject bill : billColl) {
            String billNo = bill.getString("billno");
            String closeStatus = bill.getString("closestatus");
            String billStatus = bill.getString("billstatus");
            DynamicObject org = bill.getDynamicObject("org");
            permissionCache.computeIfAbsent((Long)org.getPkValue(), k -> {
                boolean hasPermission = BillTplHelper.checkPermission("rowclose", org, "sm", "sm_delivernotice");
                return hasPermission;
            });
            Boolean permissionFlag = (Boolean)permissionCache.get(org.getPkValue());
            if (!permissionFlag.booleanValue()) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650", (String)"RowOPHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            if (CloseStatusEnum.CLOSED.getValue().equals(closeStatus)) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u662f\u201c\u5df2\u5173\u95ed\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u884c\u5173\u95ed\u3002", (String)"RowOPHelper_1", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            if (!StatusEnum.AUDIT.getValue().equals(billStatus)) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u201c\u5df2\u5ba1\u6838\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u884c\u5173\u95ed\u3002", (String)"RowOPHelper_2", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            qfBuilder.clear();
            qfBuilder.add("billentry.srcbillentity", "=", (Object)"sm_delivernotice");
            qfBuilder.add("billentry.srcbillid", "=", bill.getPkValue());
            qfBuilder.add("billstatus", "in", Arrays.asList(StatusEnum.SAVE.getValue(), StatusEnum.SUBMIT.getValue()));
            if (QueryServiceHelper.exists((String)"im_saloutbill", (QFilter[])qfBuilder.toArray())) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u5b58\u5728\u4fdd\u5b58\u6216\u63d0\u4ea4\u72b6\u6001\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"RowOPHelper_3", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            paramCache.computeIfAbsent((Long)org.getPkValue(), key -> {
                Object param = AppParameterHelper.getSmAppParameter((Long)org.getPkValue(), "closetoupdate");
                if (param == null) {
                    param = Boolean.FALSE;
                }
                return (Boolean)param;
            });
            boolean closetoupdate = (Boolean)paramCache.get(org.getPkValue());
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            boolean entryStatusSuccess = false;
            for (DynamicObject billEntry : billEntrys) {
                Long entryID = (Long)billEntry.getPkValue();
                if (!selEntryIDs.contains(entryID)) continue;
                String rowCloseStatus = billEntry.getString("rowclosestatus");
                String rowTerminateStatus = billEntry.getString("rowclosestatus");
                if (rowTerminateStatus != null && !RowTerminateStatusEnum.UNROWTERMINATE.getValue().equals(rowTerminateStatus) || !RowCloseStatusEnum.UNROWCLOSE.getValue().equals(rowCloseStatus)) continue;
                entryStatusSuccess = true;
                rowCloseActionResult.addSuccessEntryID(entryID);
                Long srcBillID = billEntry.getLong("srcbillid");
                Long srcBillEntryID = billEntry.getLong("srcbillentryid");
                String srcBillEntity = billEntry.getString("srcbillentity");
                if (!closetoupdate || srcBillID == 0L || srcBillEntryID == 0L || !"sm_salorder".equals(srcBillEntity)) continue;
                BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
                BigDecimal assoiateBaseQty = billEntry.getBigDecimal("associatedbaseqty");
                BigDecimal qty = billEntry.getBigDecimal("qty");
                BigDecimal assoiateQty = billEntry.getBigDecimal("associatedqty");
                BigDecimal baseQtyCache = (BigDecimal)returnBackBaseQtyCache.get(srcBillEntryID);
                if (baseQtyCache != null) {
                    returnBackBaseQtyCache.put(srcBillEntryID, baseQtyCache.add(baseQty.subtract(assoiateBaseQty)));
                } else {
                    returnBackBaseQtyCache.put(srcBillEntryID, baseQty.subtract(assoiateBaseQty));
                }
                BigDecimal qtyCache = (BigDecimal)returnBackQtyCache.get(srcBillEntryID);
                if (qtyCache != null) {
                    returnBackQtyCache.put(srcBillEntryID, qtyCache.add(qty.subtract(assoiateQty)));
                } else {
                    returnBackQtyCache.put(srcBillEntryID, qty.subtract(assoiateQty));
                }
                beUpdateBillIDs.add(srcBillID);
            }
            if (!entryStatusSuccess) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e2d\u6ca1\u6709\u53ef\u5173\u95ed\u7684\u884c\u3002", (String)"RowOPHelper_4", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            rowCloseActionResult.addSuccessBillID((Long)bill.getPkValue());
        }
        if (beUpdateBillIDs.size() > 0) {
            List<DynamicObject> salOrderColl = RowOPHelper.buildSalorders(beUpdateBillIDs, returnBackBaseQtyCache, returnBackQtyCache, RowCloseStatusEnum.ROWCLOSE);
            rowCloseActionResult.setSalOrders(salOrderColl);
        }
        return rowCloseActionResult;
    }

    /*
     * Exception decompiling
     */
    public static String doRowClose(DynamicObject[] billColl, RowCloseActionResult rowCloseActionResult) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String doRowUnClose(DynamicObject[] billColl, RowCloseActionResult rowCloseActionResult) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<DynamicObject> buildSalorders(Set<Long> srcBillIDs, Map<Long, BigDecimal> returnBackBaseQtyCache, Map<Long, BigDecimal> returnBackQtyCache, RowCloseStatusEnum opType) {
        BigDecimal multiSign = BigDecimal.ONE;
        if (RowCloseStatusEnum.UNROWCLOSE.getValue().equals(opType.getValue())) {
            multiSign = multiSign.negate();
        }
        log.info(opType.toString() + "\uff0cmultiSign:" + multiSign);
        QFBuilder idFilter = new QFBuilder();
        idFilter.add("id", "in", srcBillIDs);
        List<String> selecties = Arrays.asList("billno", "associatedbaseqty", "associatedqty", "basedeliqty", "deliqty", "billno", "seq", "unit", "baseunit", "material");
        DynamicObject[] salorders = BusinessDataServiceHelper.load((String)"sm_salorder", (String)String.join((CharSequence)",", selecties), (QFilter[])idFilter.toArray());
        ArrayList<DynamicObject> salOrderColl = new ArrayList<DynamicObject>(salorders.length);
        log.info(ResManager.loadKDString((String)"buildSalorders\uff0c\u5f00\u59cb\u7ec4\u88c5\u8ba2\u5355\u6570\u636e\uff0c\u7f13\u5b58\u4e2d\u7684\u6570\u636e\u4e3a\uff1a", (String)"RowOPHelper_13", (String)"scmc-sm-business", (Object[])new Object[0]) + returnBackQtyCache + ", " + returnBackBaseQtyCache);
        LinkedHashMap<Object, String> logMap = new LinkedHashMap<Object, String>();
        for (DynamicObject salOrder : salorders) {
            DynamicObjectCollection salOrderEntrys = salOrder.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : salOrderEntrys) {
                if (!returnBackQtyCache.containsKey(entry.getPkValue())) continue;
                BigDecimal associatBaseQty = entry.getBigDecimal("associatedbaseqty").subtract(multiSign.multiply(returnBackBaseQtyCache.get(entry.getPkValue())));
                entry.set("associatedbaseqty", (Object)associatBaseQty);
                BigDecimal associatQty = BillTplHelper.getDesQtyConv(entry.getDynamicObject("material.masterid"), entry.getDynamicObject("baseunit"), associatBaseQty, entry.getDynamicObject("unit"));
                entry.set("associatedqty", (Object)associatQty);
                BigDecimal delivBaseQty = entry.getBigDecimal("basedeliqty").subtract(multiSign.multiply(returnBackBaseQtyCache.get(entry.getPkValue())));
                entry.set("basedeliqty", (Object)delivBaseQty);
                BigDecimal delivQty = BillTplHelper.getDesQtyConv(entry.getDynamicObject("material.masterid"), entry.getDynamicObject("baseunit"), delivBaseQty, entry.getDynamicObject("unit"));
                entry.set("deliqty", (Object)delivQty);
                String tip = salOrder.getString("billno") + ", " + salOrder.getPkValue() + ", associatedbaseqty " + entry.getBigDecimal("associatedbaseqty") + ", associatedqty " + entry.getBigDecimal("associatedqty") + ", basedeliqty " + entry.getBigDecimal("basedeliqty") + ", deliqty " + entry.getBigDecimal("deliqty");
                logMap.put(entry.getPkValue(), tip);
            }
            salOrderColl.add(salOrder);
        }
        log.info(ResManager.loadKDString((String)"\u7ec4\u88c5\u6570\u636e\u5b8c\u6210, \u7ec4\u88c5\u7ed3\u6784\u4e3a: ", (String)"RowOPHelper_14", (String)"scmc-sm-business", (Object[])new Object[0]) + logMap);
        return salOrderColl;
    }

    public static RowCloseActionResult checkRowUnClose(DynamicObject[] billColl, List<Long> selEntryIDs) {
        HashMap<Long, Boolean> paramCache = new HashMap<Long, Boolean>();
        HashMap<Long, Boolean> permissionCache = new HashMap<Long, Boolean>();
        RowCloseActionResult rowCloseActionResult = new RowCloseActionResult();
        HashSet<Long> beUpdateBillIDs = new HashSet<Long>();
        HashMap<Long, BigDecimal> returnBackBaseQtyCache = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> returnBackQtyCache = new HashMap<Long, BigDecimal>();
        log.info("checkRowUnClose, returnBackQtyCache: " + returnBackQtyCache + "returnBackBaseQtyCache:" + returnBackBaseQtyCache);
        Map<Long, BigDecimal[]> salOrderEntryQtyCache = RowOPHelper.getSalorderEntry4Check(billColl, selEntryIDs, paramCache);
        for (DynamicObject bill : billColl) {
            String billNo = bill.getString("billno");
            String closeStatus = bill.getString("closestatus");
            String billStatus = bill.getString("billstatus");
            DynamicObject org = bill.getDynamicObject("org");
            permissionCache.computeIfAbsent((Long)org.getPkValue(), k -> {
                boolean hasPermission = BillTplHelper.checkPermission("rowunclose", org, "sm", "sm_delivernotice");
                return hasPermission;
            });
            Boolean permissionFlag = (Boolean)permissionCache.get(org.getPkValue());
            if (!permissionFlag.booleanValue()) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650", (String)"RowOPHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            if (CloseStatusEnum.CLOSED.getValue().equals(closeStatus)) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u662f\u201c\u5df2\u5173\u95ed\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u884c\u53cd\u5173\u95ed\u3002", (String)"RowOPHelper_15", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            if (!StatusEnum.AUDIT.getValue().equals(billStatus)) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u662f\u201c\u5df2\u5ba1\u6838\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u884c\u53cd\u5173\u95ed\u3002", (String)"RowOPHelper_16", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            boolean closetoupdate = paramCache.computeIfAbsent((Long)org.getPkValue(), key -> {
                Object param = AppParameterHelper.getSmAppParameter((Long)org.getPkValue(), "closetoupdate");
                if (param == null) {
                    param = Boolean.FALSE;
                }
                return (Boolean)param;
            });
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            boolean entryStatusSuccess = false;
            boolean entryQtySuccess = false;
            for (DynamicObject billEntry : billEntrys) {
                Long entryID = (Long)billEntry.getPkValue();
                if (!selEntryIDs.contains(entryID)) continue;
                String rowCloseStatus = billEntry.getString("rowclosestatus");
                String rowTerminateStatus = billEntry.getString("rowterminatestatus");
                if (rowTerminateStatus != null && !RowTerminateStatusEnum.UNROWTERMINATE.getValue().equals(rowTerminateStatus) || !RowCloseStatusEnum.ROWCLOSE.getValue().equals(rowCloseStatus)) continue;
                entryStatusSuccess = true;
                Long srcBillID = billEntry.getLong("srcbillid");
                Long srcBillEntryID = billEntry.getLong("srcbillentryid");
                String srcBillEntity = billEntry.getString("srcbillentity");
                if (closetoupdate && salOrderEntryQtyCache.size() > 0 && srcBillID != 0L && srcBillEntryID != 0L && "sm_salorder".equals(srcBillEntity)) {
                    BigDecimal[] salOrderEntryQty = salOrderEntryQtyCache.get(srcBillEntryID);
                    BigDecimal salOrderEntryBaseQty = salOrderEntryQty[0];
                    BigDecimal salOrderEntryAssoiateQty = salOrderEntryQty[1];
                    BigDecimal baseQty = billEntry.getBigDecimal("baseqty");
                    BigDecimal assoiateBaseQty = billEntry.getBigDecimal("associatedbaseqty");
                    BigDecimal qty = billEntry.getBigDecimal("qty");
                    BigDecimal assoiateQty = billEntry.getBigDecimal("associatedqty");
                    if (baseQty.subtract(assoiateBaseQty).add(salOrderEntryAssoiateQty).compareTo(salOrderEntryBaseQty) > 0) continue;
                    BigDecimal baseQtyCache = (BigDecimal)returnBackBaseQtyCache.get(srcBillEntryID);
                    if (baseQtyCache != null) {
                        returnBackBaseQtyCache.put(srcBillEntryID, baseQtyCache.add(baseQty.subtract(assoiateBaseQty)));
                    } else {
                        returnBackBaseQtyCache.put(srcBillEntryID, baseQty.subtract(assoiateBaseQty));
                    }
                    BigDecimal qtyCache = (BigDecimal)returnBackQtyCache.get(srcBillEntryID);
                    if (qtyCache != null) {
                        returnBackQtyCache.put(srcBillEntryID, qtyCache.add(qty.subtract(assoiateQty)));
                    } else {
                        returnBackQtyCache.put(srcBillEntryID, qty.subtract(assoiateQty));
                    }
                    salOrderEntryQty[1] = salOrderEntryAssoiateQty.add(baseQty.subtract(assoiateBaseQty));
                    entryQtySuccess = true;
                    rowCloseActionResult.addSuccessEntryID(entryID);
                    beUpdateBillIDs.add(srcBillID);
                    continue;
                }
                entryQtySuccess = true;
                rowCloseActionResult.addSuccessEntryID(entryID);
            }
            if (!entryStatusSuccess) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5206\u5f55\u884c\u4e2d\u6ca1\u6709\u53ef\u53cd\u5173\u95ed\u7684\u884c\u3002", (String)"RowOPHelper_11", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            if (!entryQtySuccess) {
                rowCloseActionResult.putErrorMsg(billNo, ResManager.loadKDString((String)"\u4e0a\u6e38\u9500\u552e\u8ba2\u5355\u5b58\u5728\u5206\u5f55\u672a\u53d1\u751f\u6570\u91cf\u65e0\u6cd5\u6ee1\u8db3\u56de\u9000\u8981\u6c42\u3002", (String)"RowOPHelper_12", (String)"scmc-sm-business", (Object[])new Object[0]));
                continue;
            }
            rowCloseActionResult.addSuccessBillID((Long)bill.getPkValue());
        }
        if (beUpdateBillIDs.size() > 0) {
            List<DynamicObject> salOrderColl = RowOPHelper.buildSalorders(beUpdateBillIDs, returnBackBaseQtyCache, returnBackQtyCache, RowCloseStatusEnum.UNROWCLOSE);
            rowCloseActionResult.setSalOrders(salOrderColl);
        }
        return rowCloseActionResult;
    }

    private static Map<Long, BigDecimal[]> getSalorderEntry4Check(DynamicObject[] billColl, List<Long> selEntryIDs, Map<Long, Boolean> paramCache) {
        HashMap<Long, BigDecimal[]> result = new HashMap<Long, BigDecimal[]>();
        HashSet<Long> beCheckSrcEntryIDs = new HashSet<Long>();
        for (DynamicObject bill : billColl) {
            DynamicObject org = bill.getDynamicObject("org");
            DynamicObjectCollection billEntrys = bill.getDynamicObjectCollection("billentry");
            boolean closetoupdate = paramCache.computeIfAbsent((Long)org.getPkValue(), key -> {
                Object param = AppParameterHelper.getSmAppParameter((Long)org.getPkValue(), "closetoupdate");
                if (param == null) {
                    param = Boolean.FALSE;
                }
                return (Boolean)param;
            });
            if (!closetoupdate) continue;
            for (DynamicObject billEntry : billEntrys) {
                Long entryID = (Long)billEntry.getPkValue();
                String rowCloseStatus = billEntry.getString("rowclosestatus");
                String rowTerminateStatus = billEntry.getString("rowterminatestatus");
                if (!selEntryIDs.contains(entryID) || rowTerminateStatus != null && !RowTerminateStatusEnum.UNROWTERMINATE.getValue().equals(rowTerminateStatus) || !RowCloseStatusEnum.ROWCLOSE.getValue().equals(rowCloseStatus)) continue;
                Long srcBillID = billEntry.getLong("srcbillid");
                Long srcBillEntryID = billEntry.getLong("srcbillentryid");
                String srcBillEntity = billEntry.getString("srcbillentity");
                if (srcBillID == 0L || srcBillEntryID == 0L || !"sm_salorder".equals(srcBillEntity)) continue;
                beCheckSrcEntryIDs.add(srcBillEntryID);
            }
        }
        if (beCheckSrcEntryIDs.size() > 0) {
            StringBuffer idFilter = new StringBuffer();
            for (Long id : beCheckSrcEntryIDs) {
                idFilter.append('\'').append(id).append('\'').append(',');
            }
            String idStr = idFilter.substring(0, idFilter.length() - 1);
            StringBuilder sql = new StringBuilder();
            sql.append(" SELECT t.fentryid fentryid, t.fdeliverbaseqtyup fbaseqty, r.fassociatedbaseqty fassociatedbaseqty from t_sm_salorderentry t inner join t_sm_salorderentry_r r on t.fentryid = r.fentryid  where t.fentryid in (");
            sql.append(idStr);
            sql.append(')');
            return (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString(), null, rs -> {
                while (rs.next()) {
                    Long id = rs.getLong("fentryid");
                    BigDecimal baseqty = rs.getBigDecimal("fbaseqty");
                    BigDecimal associatedbaseqty = rs.getBigDecimal("fassociatedbaseqty");
                    result.put(id, new BigDecimal[]{baseqty, associatedbaseqty});
                }
                return result;
            });
        }
        return result;
    }

    public static List<String> getSelector(boolean includeEntry) {
        ArrayList<String> sels = new ArrayList<String>(8);
        sels.add("id");
        sels.add("org");
        sels.add("billno");
        sels.add("billstatus");
        sels.add("closestatus");
        sels.add("closer");
        sels.add("closedate");
        if (includeEntry) {
            sels.add("rowclosestatus");
            sels.add("rowterminatestatus");
            sels.add("srcbillentryid");
            sels.add("srcbillid");
            sels.add("srcbillentity");
            sels.add("baseqty");
            sels.add("associatedbaseqty");
            sels.add("qty");
            sels.add("associatedqty");
            sels.add("producttype");
            sels.add("kittransfermodel");
            sels.add("kitpid");
        }
        return sels;
    }

    public static DynamicObject[] getDeliverBills(Set<Long> billIDs, boolean includeEntry) {
        QFBuilder deliverBuilder = new QFBuilder();
        deliverBuilder.add("id", "in", billIDs);
        return BusinessDataServiceHelper.load((String)"sm_delivernotice", (String)String.join((CharSequence)",", RowOPHelper.getSelector(includeEntry)), (QFilter[])deliverBuilder.toArray());
    }

    public static DynamicObject[] getBills(Set<Long> billIDs, String entityName) {
        QFBuilder billBuilder = new QFBuilder();
        billBuilder.add("id", "in", billIDs);
        return BusinessDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])billBuilder.toArray());
    }

    public static void writeLog(OperationResult opResult, DynamicObject org, String operationKey, String msg, String entityName) {
        if (!opResult.isCancelWriteLog() && org != null) {
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>();
            Long mainOrgId = (Long)org.getPkValue();
            AppLogInfo logInfo = RowOPHelper.buildLogInfo(msg, mainOrgId, operationKey, entityName);
            appLogInfoList.add(logInfo);
            logService.addBatchLog(appLogInfoList);
            opResult.setCancelWriteLog(true);
        }
    }

    private static AppLogInfo buildLogInfo(String msg, Long orgId, String operationKey, String entityName) {
        String appId = "";
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"sm");
        if (null != appInfo) {
            appId = appInfo.getId();
        }
        logInfo.setBizAppID(appId);
        logInfo.setBizObjID(entityName);
        logInfo.setOrgID(orgId);
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(RowOPHelper.getOpName(entityName, operationKey));
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    public static OperationResult createOperationResult() {
        OperationResult result = new OperationResult();
        result.setCancelWriteLog(false);
        return result;
    }

    public static String getOpName(String entityName, String operationKey) {
        String operationName = "";
        Map dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)entityName, (String)operationKey);
        if (dataEntityOperate != null && dataEntityOperate.containsKey("name")) {
            Map opName = (Map)dataEntityOperate.get("name");
            if (opName.containsKey(ResManager.getLanguage())) {
                operationName = (String)opName.get(ResManager.getLanguage());
            } else if (opName.containsKey("zh_CN")) {
                operationName = (String)opName.get("zh_CN");
            }
            return operationName;
        }
        return operationName;
    }
}

