/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BillQuantityHelper;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.BizCancelStatusEnum;
import kd.mpscmm.msbd.common.enums.BizCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeStatusEnum;
import kd.mpscmm.msbd.common.enums.ChangeTypeEnum;
import kd.mpscmm.msbd.common.enums.DiscountTypeEnum;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.mpscmm.msbd.common.enums.OwnerTypeEnum;
import kd.mpscmm.msbd.common.enums.PayModeEnum;
import kd.mpscmm.msbd.common.enums.RowCloseStatusEnum;
import kd.mpscmm.msbd.common.enums.RowTerminateStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.common.enums.UnitConvertDirEnum;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.CurrencyHelper;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.business.helper.LotHelper;
import kd.scmc.sm.business.helper.MaterialHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.scmc.sm.business.helper.SalesOrgHelper;

public class SalOrderBillHelper {
    private static final String IS_SET_DEFAULT_QTY = "isSetDefaultQty";
    private static final String IS_SET_DEFAULT_REC_PLAN_ENTRY = "isSetDefaultRecPlanEntry";
    private static final String IS_SET_DEFAULT_RECEIVE_QTY = "isSetDefaultReceiveQty";
    private static final String IS_SET_DEFAULT_RECEIVE_DAY = "isSetDefaultReceiveDay";
    private static final String IS_SET_DEFAULT_Material_QTY_UNIT = "isSetDefaultMaterialQtyUnit";

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills) {
        return SalOrderBillHelper.completeBillInfoWithCondition(bills, Collections.EMPTY_MAP);
    }

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills, Map<Object, Object> conditionMap) {
        return SalOrderBillHelper.completeBillInfoWithCondition(bills, conditionMap);
    }

    public static List<DynamicObject> completeBillInfoWithCondition(List<DynamicObject> bills, Map<Object, Object> conditionMap) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(8);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(8);
        if (bills == null || bills.size() == 0) {
            return result;
        }
        for (DynamicObject bill : bills) {
            DynamicObject org = bill.getDynamicObject("org");
            if (org == null) continue;
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) {
                billType = BillTypeHelper.getDefaultBillTypeObject((String)bill.getDataEntityType().getName());
                if (billType == null) continue;
                bill.set("billtype", (Object)billType);
            }
            SalOrderBillHelper.setDefaultHeadStatus(bill);
            SalOrderBillHelper.setDefaultBizType(bill);
            SalOrderBillHelper.setDefaultOperatorGroup(bill);
            SalOrderBillHelper.setDefaultDept(bill);
            SalOrderBillHelper.setDefaultSettleOrg(bill, cacheMap);
            CustomerHelper.setDefaultCustomer(bill, conditionMap);
            SalOrderBillHelper.setDefaultFinancialInfo(bill);
            SalOrderBillHelper.setDefaultOtherInfo(bill);
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < (entries != null ? entries.size() : 0); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                SalOrderBillHelper.setDefaultEntryStatus(bill, entry);
                SalOrderBillHelper.setDefaultLineType(bill, entry, cacheMap);
                SalOrderBillHelper.setDefaultMaterialInfo(entry, cacheMap, conditionMap);
                SalOrderBillHelper.setDefaultEntryOrg(bill, entry, cacheMap);
                if (((Boolean)conditionMap.getOrDefault(IS_SET_DEFAULT_QTY, Boolean.TRUE)).booleanValue()) {
                    SalOrderBillHelper.setDefaultQty(entry);
                }
                SalOrderBillHelper.setDefaultDeliverInfo(bill, entry, cacheMap, conditionMap);
                SalOrderBillHelper.setDefaultOtherEntryInfo(bill, entry);
            }
            SalOrderBillHelper.calcuAmount(bill, conditionMap);
            if (((Boolean)conditionMap.getOrDefault(IS_SET_DEFAULT_REC_PLAN_ENTRY, Boolean.TRUE)).booleanValue()) {
                SalOrderRecPlanHelper.reCalcuRecPlanAmountByContion(bill);
                Object billEntrySettleOrg = null;
                if (entries != null && entries.size() > 0) {
                    billEntrySettleOrg = ((DynamicObject)entries.get(0)).get("entrysettleorg");
                }
                SalOrderBillHelper.setDefaultRecPlanEntry(bill, billEntrySettleOrg);
            }
            result.add(bill);
        }
        return result;
    }

    private static void setDefaultHeadStatus(DynamicObject bill) {
        Date bizTime;
        String billStatus = bill.getString("billstatus");
        if (CommonUtils.isNull((Object)billStatus)) {
            bill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        }
        if (CommonUtils.isNull((Object)(bizTime = bill.getDate("biztime")))) {
            bill.set("biztime", (Object)new Date());
        }
        if (billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("auditor", null);
            bill.set("auditdate", null);
            bill.set("closer", null);
            bill.set("closedate", null);
            bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            bill.set("canceler", null);
            bill.set("canceldate", null);
            bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
            bill.set("changer", null);
            bill.set("changedate", null);
            bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
        } else {
            if (CommonUtils.isNull((Object)bill.getString("closestatus"))) {
                bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                bill.set("closer", null);
                bill.set("closedate", null);
            }
            if (CommonUtils.isNull((Object)bill.getString("cancelstatus"))) {
                bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
                bill.set("canceler", null);
                bill.set("canceldate", null);
            }
            if (CommonUtils.isNull((Object)bill.getString("changestatus"))) {
                bill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
                bill.set("changer", null);
                bill.set("changedate", null);
            }
        }
    }

    private static void setDefaultBizType(DynamicObject bill) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType == null) {
            DynamicObject billType = bill.getDynamicObject("billtype");
            bizType = BizTypeHelper.getDefaultBizTypeObject((String)"sm_salorder", (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
            bill.set("biztype", (Object)bizType);
        }
    }

    private static void setDefaultOperatorGroup(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        long userId = UserServiceHelper.getCurrentUserId();
        if (0L == userId) {
            return;
        }
        if (operator == null) {
            Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)((Long)org.getPkValue()), (Long)userId, (String)OperatorGrpTypeEnum.SALEGRP.getValue());
            if (!operatorAndGroup.isEmpty()) {
                bill.set("operator", operatorAndGroup.get("operator"));
                if (operatorGroup == null) {
                    bill.set("operatorgroup", operatorAndGroup.get("operatorgroup"));
                }
            }
        } else if (operatorGroup == null) {
            operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.get("operatorgrpid"), (String)"bd_operatorgroup");
            bill.set("operatorgroup", (Object)operatorGroup);
        }
    }

    private static void setDefaultDept(DynamicObject bill) {
        DynamicObject user;
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject operator = bill.getDynamicObject("operator");
        if (dept == null && operator != null && (user = operator.getDynamicObject("operatorid")) != null) {
            dept = OrgHelper.getDefaultDepartmentObject((Long)((Long)user.getPkValue()));
            bill.set("dept", (Object)dept);
        }
    }

    private static void setDefaultSettleOrg(DynamicObject bill, Map cacheMap) {
        Long orgId = (Long)bill.getDynamicObject("org").getPkValue();
        DynamicObject settleOrg = bill.getDynamicObject("settleorg");
        if (orgId != null && settleOrg == null) {
            String settleCacheKey = orgId + "settleorg";
            if (SalOrderBillHelper.isCached(cacheMap, settleCacheKey)) {
                settleOrg = (DynamicObject)cacheMap.get(settleCacheKey);
            } else {
                settleOrg = OrgHelper.getOrgForFormDefObjValue((Long)orgId, (String)"03", (String)"10", (String)"toorg");
                cacheMap.put(settleCacheKey, settleOrg);
            }
            bill.set("settleorg", (Object)settleOrg);
        }
    }

    private static void setDefaultFinancialInfo(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        DynamicObject exRateTable = bill.getDynamicObject("exratetable");
        BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
        Date exRateTime = bill.getDate("exratedate");
        String exchangeType = bill.getString("exchangetype");
        Boolean isTax = bill.getBoolean("istax");
        if (currency == null) {
            currency = CurrencyHelper.getCurrency((Long)org.getPkValue());
            bill.set("currency", (Object)currency);
        }
        if (settleCurrency == null) {
            settleCurrency = currency;
            bill.set("settlecurrency", (Object)currency);
        }
        if (exRateTable == null) {
            exRateTable = CurrencyHelper.getExRateTable((Long)org.getPkValue());
            bill.set("exratetable", (Object)exRateTable);
        }
        if (exRateTime == null) {
            exRateTime = bill.getDate("bizdate");
            bill.set("exratedate", (Object)exRateTime);
        }
        if (isTax == null) {
            bill.set("istax", (Object)Boolean.TRUE);
        }
        if (currency != null && exRateTable != null) {
            BigDecimal exRate = null;
            if (StringUtils.isEmpty((CharSequence)exchangeType)) {
                Map exRateMap = kd.mpscmm.msbd.business.helper.CurrencyHelper.getExChangeRateMap((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)exRateTime);
                exRate = (BigDecimal)exRateMap.get("exchangerate");
                exchangeType = (String)exRateMap.get("exchangetype");
                bill.set("exchangetype", (Object)exchangeType);
            }
            if (BigDecimalUtil.isBlank((BigDecimal)exchangeRate)) {
                exchangeRate = exRate != null ? exRate : kd.mpscmm.msbd.business.helper.CurrencyHelper.getExChangeRate((Long)((Long)settleCurrency.getPkValue()), (Long)((Long)currency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)exRateTime, (String)exchangeType);
                bill.set("exchangerate", (Object)exchangeRate);
            }
        }
        if (bill.getString("paymode") == null) {
            bill.set("paymode", (Object)PayModeEnum.CREDIT.getValue());
        }
    }

    private static void setDefaultEntryStatus(DynamicObject bill, DynamicObject entry) {
        String billStatus = bill.getString("billstatus");
        String rowCloseStatus = entry.getString("rowclosestatus");
        String rowTerminateStatus = entry.getString("rowterminatestatus");
        if (billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            entry.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            entry.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
        } else {
            if (StringUtils.isEmpty((CharSequence)rowCloseStatus)) {
                entry.set("rowclosestatus", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue());
            }
            if (StringUtils.isEmpty((CharSequence)rowTerminateStatus)) {
                entry.set("rowterminatestatus", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue());
            }
        }
        entry.set("entrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
        DynamicObjectCollection deliverEntrys = entry.getDynamicObjectCollection("orderdeliverentry");
        for (DynamicObject dEntry : deliverEntrys) {
            dEntry.set("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
        }
    }

    private static void setDefaultLineType(DynamicObject bill, DynamicObject entry, Map cacheMap) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType != null && entry.get("linetype") == null) {
            DynamicObject defLineType;
            String cacheKey = String.valueOf(bizType.getPkValue()) + "linetype";
            if (SalOrderBillHelper.isCached(cacheMap, cacheKey)) {
                defLineType = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                defLineType = BizTypeHelper.getDefaultLineTypeObject((Long)((Long)bizType.getPkValue()));
                cacheMap.put(cacheKey, defLineType);
            }
            entry.set("linetype", (Object)defLineType);
        }
    }

    private static void setDefaultMaterialInfo(DynamicObject entry, Map<String, Object> cacheMap, Map<Object, Object> conditionMap) {
        String lotNumber;
        String configproperties;
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        if (masterMaterial == null) {
            return;
        }
        entry.set("materialmasterid", (Object)masterMaterial);
        if (((Boolean)conditionMap.getOrDefault(IS_SET_DEFAULT_Material_QTY_UNIT, Boolean.TRUE)).booleanValue()) {
            Boolean isPresent;
            DynamicObject auxptyUnit;
            if (masterMaterial.getBoolean("isdisposable")) {
                if (StringUtils.isEmpty((CharSequence)entry.getString("materialname"))) {
                    entry.set("materialname", (Object)masterMaterial.getString("name"));
                }
            } else {
                entry.set("materialname", (Object)masterMaterial.getString("name"));
            }
            DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
            entry.set("baseunit", (Object)masterMaterial.getDynamicObject("baseunit"));
            if (entry.getDynamicObject("unit") == null) {
                entry.set("unit", (Object)material.getDynamicObject("salesunit"));
            }
            if ((auxptyUnit = masterMaterial.getDynamicObject("auxptyunit")) == null) {
                entry.set("auxunit", null);
                entry.set("auxqty", null);
            } else {
                entry.set("auxunit", (Object)auxptyUnit);
            }
            Boolean isuseauxpty = masterMaterial.getBoolean("isuseauxpty");
            if (Boolean.FALSE.equals(isuseauxpty)) {
                entry.set("auxpty", null);
            }
            if ((isPresent = Boolean.valueOf(entry.getBoolean("ispresent"))) == null) {
                entry.set("ispresent", (Object)Boolean.FALSE);
            }
            BigDecimal minOrderQty = material.getBigDecimal("minorderqty");
            DynamicObject salesUnit = material.getDynamicObject("salesunit");
            if (baseUnit != null && salesUnit != null && minOrderQty != null && BigDecimal.ZERO.compareTo(minOrderQty) != 0) {
                BigDecimal minOrderBaseQty = BillTplHelper.getDesQtyConv(masterMaterial, salesUnit, minOrderQty, baseUnit);
                entry.set("minorderbaseqty", (Object)minOrderBaseQty);
            }
        }
        if (entry.get("productline") == null) {
            entry.set("productline", (Object)masterMaterial.getDynamicObject("productline"));
        }
        if (!"2".equals(configproperties = masterMaterial.getString("configproperties"))) {
            entry.set("configuredcode", null);
        }
        if (StringUtils.isNotEmpty((CharSequence)(lotNumber = entry.getString("lotnumber")))) {
            String cacheKey = lotNumber + masterMaterial.getPkValue() + "lot";
            DynamicObject lot = null;
            if (SalOrderBillHelper.isCached(cacheMap, cacheKey)) {
                lot = (DynamicObject)cacheMap.get(cacheKey);
            } else if (LotHelper.isUseLotMainFile()) {
                QFilter qFilter = new QFilter("number", "=", (Object)lotNumber).and(new QFilter("material", "=", masterMaterial.getPkValue()));
                lot = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_lot", (QFilter[])new QFilter[]{qFilter});
                cacheMap.put(cacheKey, lot);
            }
            if (lot != null) {
                entry.set("lot", (Object)lot);
            }
        }
    }

    private static void setDefaultEntryOrg(DynamicObject bill, DynamicObject entry, Map cacheMap) {
        DynamicObject settleDept;
        DynamicObject entrySettleOrg;
        DynamicObject org = bill.getDynamicObject("org");
        entry.set("salesorg", (Object)org);
        DynamicObject stockOrg = (DynamicObject)entry.get("e_stockorg");
        if (stockOrg == null) {
            String cacheKey = String.valueOf(org.getPkValue()) + "e_stockorg";
            if (SalOrderBillHelper.isCached(cacheMap, cacheKey)) {
                stockOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                stockOrg = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"03", (String)"05", (String)"toorg");
                cacheMap.put(cacheKey, stockOrg);
            }
            entry.set("e_stockorg", (Object)stockOrg);
        }
        if ((entrySettleOrg = entry.getDynamicObject("entrysettleorg")) == null) {
            String cacheKey = String.valueOf(org.getPkValue()) + "entrysettleorg";
            if (SalOrderBillHelper.isCached(cacheMap, cacheKey)) {
                entrySettleOrg = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                entrySettleOrg = OrgHelper.getOrgForFormDefObjValue((Long)((Long)org.getPkValue()), (String)"03", (String)"10", (String)"toorg");
                cacheMap.put(cacheKey, entrySettleOrg);
            }
            entry.set("entrysettleorg", (Object)entrySettleOrg);
        }
        if ((settleDept = (DynamicObject)entry.get("settledept")) == null && entrySettleOrg != null) {
            String cacheKey = String.valueOf(entrySettleOrg.getPkValue()) + "settledept";
            if (SalOrderBillHelper.isCached(cacheMap, cacheKey)) {
                settleDept = (DynamicObject)cacheMap.get(cacheKey);
            } else {
                settleDept = OrgHelper.getOrgForFormDefObjValue((Long)((Long)entrySettleOrg.getPkValue()), (String)"15", (String)"01", (String)"toorg");
                cacheMap.put(cacheKey, settleDept);
            }
            entry.set("settledept", (Object)settleDept);
        }
    }

    private static void setDefaultDeliverInfo(DynamicObject bill, DynamicObject entry, Map cacheMap, Map<Object, Object> conditionMap) {
        SalOrderBillHelper.setDefaultOwner(bill, entry, cacheMap);
        Date deliverDate = entry.getDate("deliverydate");
        if (deliverDate == null) {
            entry.set("deliverydate", (Object)bill.getDate("bizdate"));
        }
        SalOrderBillHelper.setDefaultReceiveQty(entry, conditionMap);
        if (((Boolean)conditionMap.getOrDefault(IS_SET_DEFAULT_RECEIVE_DAY, Boolean.TRUE)).booleanValue()) {
            SalOrderBillHelper.setDefaultReceiveDay(entry);
        }
    }

    private static void setDefaultQty(DynamicObject entry) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject masterMaterial = material.getDynamicObject("masterid");
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject auxUnit = entry.getDynamicObject("auxunit");
        if (auxUnit == null) {
            entry.set("auxqty", (Object)BigDecimal.ZERO);
        } else {
            BigDecimal auxQty = entry.getBigDecimal("auxqty");
            String unitConvertDir = masterMaterial.getString("unitconvertdir");
            if (BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
                        baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                        entry.set("baseqty", (Object)baseQty);
                    }
                    auxQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                    entry.set("auxqty", (Object)auxQty);
                }
            } else if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)baseQty) && UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir)) {
                baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)auxUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                entry.set("baseqty", (Object)baseQty);
            }
        }
        if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)baseQty)) {
            qty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
            entry.set("qty", (Object)qty);
        } else if (BigDecimalUtil.isBlank((BigDecimal)baseQty) && BigDecimalUtil.isNotBlank((BigDecimal)qty)) {
            baseQty = BillQuantityHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
    }

    private static void setDefaultReceiveQty(DynamicObject entry, Map<Object, Object> conditionMap) {
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        Boolean iscontrolqty = entry.getBoolean("iscontrolqty");
        BigDecimal qty = entry.getBigDecimal("qty");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        if (iscontrolqty.booleanValue()) {
            BigDecimal deliverRateDown;
            BigDecimal deliverRateUp;
            boolean isDeliverRateUpBlank = BigDecimalUtil.isBlank((BigDecimal)entry.getBigDecimal("deliverrateup"));
            boolean isDeliverRateDownBlank = BigDecimalUtil.isBlank((BigDecimal)entry.getBigDecimal("deliverratedown"));
            if (isDeliverRateUpBlank) {
                if (((Boolean)conditionMap.getOrDefault(IS_SET_DEFAULT_RECEIVE_QTY, Boolean.TRUE)).booleanValue()) {
                    deliverRateUp = material.getBigDecimal("dlivrateceiling");
                    entry.set("deliverrateup", (Object)deliverRateUp);
                } else {
                    deliverRateUp = entry.getBigDecimal("deliverrateup");
                }
            } else {
                deliverRateUp = entry.getBigDecimal("deliverrateup");
                entry.set("deliverrateup", (Object)deliverRateUp);
            }
            if (isDeliverRateDownBlank) {
                if (((Boolean)conditionMap.getOrDefault(IS_SET_DEFAULT_RECEIVE_QTY, Boolean.TRUE)).booleanValue()) {
                    deliverRateDown = material.getBigDecimal("dlivratefloor");
                    entry.set("deliverratedown", (Object)deliverRateDown);
                } else {
                    deliverRateDown = entry.getBigDecimal("deliverratedown");
                }
            } else {
                deliverRateDown = entry.getBigDecimal("deliverratedown");
                entry.set("deliverratedown", (Object)deliverRateDown);
            }
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            DynamicObject unit = entry.getDynamicObject("unit");
            if (unit == null || baseUnit == null || qty == null || baseQty == null || deliverRateUp == null || deliverRateDown == null) {
                return;
            }
            int precision = unit.getInt("precision");
            int precisionaccount = BillTplHelper.getRoundMode(unit);
            int basePrecision = baseUnit.getInt("precision");
            int basePrecisionaccount = BillTplHelper.getRoundMode(baseUnit);
            BigDecimal deliverqtyup = qty.multiply(new BigDecimal(100).add(deliverRateUp)).divide(new BigDecimal(100), precision, precisionaccount);
            BigDecimal deliverbaseqtyup = baseQty.multiply(new BigDecimal(100).add(deliverRateUp)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
            entry.set("deliverqtyup", (Object)deliverqtyup);
            entry.set("deliverbaseqtyup", (Object)deliverbaseqtyup);
            BigDecimal deliverqtydown = qty.multiply(new BigDecimal(100).subtract(deliverRateDown)).divide(new BigDecimal(100), precision, precisionaccount);
            BigDecimal deliverbaseqtydown = baseQty.multiply(new BigDecimal(100).subtract(deliverRateDown)).divide(new BigDecimal(100), basePrecision, basePrecisionaccount);
            entry.set("deliverqtydown", (Object)deliverqtydown);
            entry.set("deliverbaseqtydown", (Object)deliverbaseqtydown);
        } else {
            entry.set("deliverqtyup", (Object)qty);
            entry.set("deliverbaseqtyup", (Object)baseQty);
            entry.set("deliverqtydown", (Object)qty);
            entry.set("deliverbaseqtydown", (Object)baseQty);
        }
    }

    private static void setDefaultReceiveDay(DynamicObject entry) {
        boolean isControlDay;
        DynamicObject material = entry.getDynamicObject("material");
        if (material == null) {
            return;
        }
        int receiveDayUp = entry.getInt("deliveradvdays");
        int receiveDayDown = entry.getInt("deliverdelaydays");
        if (receiveDayUp == 0 && receiveDayDown == 0 && (isControlDay = entry.getBoolean("iscontrolday"))) {
            receiveDayUp = material.getInt("deliveradvdays");
            receiveDayDown = material.getInt("deliverdelaydays");
            entry.set("deliveradvdays", (Object)receiveDayUp);
            entry.set("deliverdelaydays", (Object)receiveDayDown);
        }
    }

    private static void setDefaultOwner(DynamicObject bill, DynamicObject entry, Map cacheMap) {
        DynamicObject stockOrg;
        DynamicObject bizType = bill.getDynamicObject("biztype");
        DynamicObject org = bill.getDynamicObject("org");
        if (bizType != null) {
            if ("6".equals(bizType.getString("domain"))) {
                entry.set("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue());
            } else if (!"210".equals(bizType.getString("number"))) {
                entry.set("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_ORG.getValue());
            }
        }
        if (entry.get("owner") == null && OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(entry.get("ownertype")) && (stockOrg = (DynamicObject)entry.get("e_stockorg")) != null) {
            String ownerCacheKey = String.valueOf(org.getPkValue()) + stockOrg.getPkValue() + "owner";
            if (SalOrderBillHelper.isCached(cacheMap, ownerCacheKey)) {
                entry.set("owner", cacheMap.get(ownerCacheKey));
                return;
            }
            Long ownerId = SalesOrgHelper.getOwnerDefaultValue((Long)org.getPkValue(), (Long)stockOrg.getPkValue());
            if (ownerId == null) {
                cacheMap.put(ownerCacheKey, null);
            } else {
                DynamicObject owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org");
                cacheMap.put(ownerCacheKey, owner);
                entry.set("owner", (Object)owner);
            }
        }
    }

    public static void calcuAmount(DynamicObject bill, Map<Object, Object> conditionMap) {
        DynamicObject customer = bill.getDynamicObject("customer");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        Integer settlePricePrecision = settleCurrency == null ? null : Integer.valueOf(settleCurrency.getInt("priceprecision"));
        Boolean isTax = bill.getBoolean("istax");
        bill.set("inputamount", (Object)Boolean.FALSE);
        if (((Boolean)conditionMap.getOrDefault(IS_SET_DEFAULT_Material_QTY_UNIT, Boolean.TRUE)).booleanValue()) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                DynamicObject taxRateId = entry.getDynamicObject("taxrateid");
                if (taxRateId == null) {
                    DynamicObject material = entry.getDynamicObject("material");
                    DynamicObject defaultTaxRate = MaterialHelper.getDefaultTaxRate(customer, material);
                    if (defaultTaxRate != null) {
                        entry.set("taxrateid", (Object)defaultTaxRate);
                        entry.set("taxrate", (Object)defaultTaxRate.getBigDecimal("taxrate"));
                    }
                } else {
                    entry.set("taxrate", (Object)taxRateId.getBigDecimal("taxrate"));
                }
                Boolean isPresent = entry.getBoolean("ispresent");
                if (!Boolean.TRUE.equals(isPresent)) continue;
                if (isTax.booleanValue()) {
                    if (BigDecimalUtil.isZero((BigDecimal)entry.getBigDecimal("priceandtax"))) {
                        entry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                        entry.set("discountrate", (Object)BigDecimalUtil.ZERO);
                        continue;
                    }
                    entry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                    entry.set("discountrate", (Object)BigDecimalUtil.HUNDRED);
                    continue;
                }
                if (BigDecimalUtil.isZero((BigDecimal)entry.getBigDecimal("price"))) {
                    entry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                    entry.set("discountrate", (Object)BigDecimalUtil.ZERO);
                    continue;
                }
                entry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                entry.set("discountrate", (Object)BigDecimalUtil.HUNDRED);
            }
        }
        BillTplHelper.calculateAmount4WholeBill(bill, null);
    }

    private static void setDefaultOtherInfo(DynamicObject bill) {
        String subVersion;
        String billStatus = bill.getString("billstatus");
        String version = bill.getString("version");
        if (version == null || billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("version", (Object)"1");
        }
        if ((subVersion = bill.getString("subversion")) == null || billStatus.equals(StatusEnum.SAVE.getValue()) || billStatus.equals(StatusEnum.SUBMIT.getValue())) {
            bill.set("subversion", (Object)"1");
        }
    }

    private static void setDefaultOtherEntryInfo(DynamicObject bill, DynamicObject entry) {
        String returnType = entry.getString("returntype");
        if (returnType == null) {
            entry.set("returntype", (Object)"2");
        }
        DynamicObject billType = bill.getDynamicObject("billtype");
        Boolean supplytrans = entry.getBoolean("supplytrans");
        if (supplytrans == null) {
            entry.set("supplytrans", (Object)Boolean.FALSE);
        }
    }

    private static void setDefaultRecPlanEntry(DynamicObject bill, Object billEntrySettleOrg) {
        DynamicObjectCollection payEntrys = bill.getDynamicObjectCollection("recplanentry");
        for (DynamicObject entry : payEntrys) {
            DynamicObject entrySettleOrg;
            entry.set("recentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
            Boolean isPrePay = entry.getBoolean("r_needrecadvance");
            if (isPrePay == null) {
                entry.set("r_needrecadvance", (Object)Boolean.FALSE);
            }
            if ((entrySettleOrg = entry.getDynamicObject("r_recsettleorg")) == null && billEntrySettleOrg != null) {
                entry.set("r_recsettleorg", billEntrySettleOrg);
            }
            BigDecimal unRemainAmount = entry.getBigDecimal("r_unremainamount");
            BigDecimal recAmount = entry.getBigDecimal("r_recadvanceamount");
            if (!BigDecimalUtil.isBlank((BigDecimal)unRemainAmount) || !BigDecimalUtil.isNotBlank((BigDecimal)recAmount)) continue;
            BigDecimal remainAmount = entry.getBigDecimal("r_remainamount");
            unRemainAmount = recAmount.subtract(remainAmount);
            entry.set("r_unremainamount", (Object)unRemainAmount);
        }
    }

    private static boolean isCached(Map<String, Object> map, String key) {
        return map.containsKey(key);
    }
}

