/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class SalOrderBillImportHelper {
    public static boolean calcBaseQtyAndAuxQty(DynamicObject bill, int rowIndex) {
        if (bill == null) {
            return false;
        }
        DynamicObjectCollection colls = bill.getDynamicObjectCollection("billentry");
        if (colls.size() == 0) {
            return false;
        }
        DynamicObject entryInfo = (DynamicObject)colls.get(rowIndex);
        BigDecimal qty = entryInfo.getBigDecimal("qty");
        BigDecimal baseQty = entryInfo.getBigDecimal("baseqty");
        BigDecimal originQty = new BigDecimal(baseQty.toString());
        DynamicObject unit = entryInfo.getDynamicObject("unit");
        if (unit != null) {
            int precision = unit.getInt("precision");
            int precisionaccount = SalOrderBillImportHelper.getRoundMode(unit);
            qty = qty.setScale(precision, precisionaccount);
            entryInfo.set("qty", (Object)qty);
            DynamicObject baseUnit = entryInfo.getDynamicObject("baseunit");
            if (baseUnit != null) {
                DynamicObject material = entryInfo.getDynamicObject("material");
                DynamicObject masterMaterial = material.getDynamicObject("masterid");
                baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) > 0) {
                    int baseUnitPrecision = baseUnit.getInt("precision");
                    int baseUnitPrecisionType = SalOrderBillImportHelper.getRoundMode(baseUnit);
                    BigDecimal unitRate = SalOrderBillImportHelper.getUnitRateConv((Long)masterMaterial.getPkValue(), (Long)unit.getPkValue(), (Long)baseUnit.getPkValue());
                    baseQty = qty.multiply(unitRate);
                    baseQty = baseQty.setScale(baseUnitPrecision, baseUnitPrecisionType);
                }
                entryInfo.set("baseqty", (Object)baseQty);
            }
        }
        return originQty.compareTo(baseQty) != 0;
    }

    public static int getRoundMode(DynamicObject unit) {
        if (unit == null) {
            return 4;
        }
        int precisionaccount = unit.getInt("precisionaccount");
        int baseUnitPrecisionType = 4;
        if (precisionaccount == 2) {
            baseUnitPrecisionType = 1;
        } else if (precisionaccount == 3) {
            baseUnitPrecisionType = 0;
        }
        return baseUnitPrecisionType;
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }
}

