/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.MetaDataHelper;
import kd.scmc.sm.business.helper.SalOrderBillModelHelper;
import kd.scmc.sm.enums.ChangeTypeEnum;

public class SalOrderBillLogHelper {
    private static final String UNIT_PRECISION = "precision";
    private static final String SETTLECURRENCY = "settlecurrency";
    private static final String PRICEPRECISION = "priceprecision";
    private static final String AMTPRECISION = "amtprecision";

    public static Map<String, String> compareOrderBillNXOrderBill(DynamicObject salOrderBill, DynamicObject XsalOrderBill) {
        if (salOrderBill != null && XsalOrderBill != null && "sm_salorder".equals(salOrderBill.getDataEntityType().getName()) && "sm_xsalorder".equals(XsalOrderBill.getDataEntityType().getName())) {
            HashMap<String, String> rs = new HashMap<String, String>();
            String[] billfields = SalOrderBillModelHelper.getCanLogBillField;
            StringBuilder billMD = new StringBuilder();
            String salOrder = ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355", (String)"SalOrderBillLogHelper_0", (String)"scmc-sm-business", (Object[])new Object[0]);
            salOrder = "### \u3000" + salOrder + "\u3010";
            String changeCondition = ResManager.loadKDString((String)"\u53d8\u66f4\u60c5\u51b5", (String)"SalOrderBillLogHelper_1", (String)"scmc-sm-business", (Object[])new Object[0]);
            changeCondition = "\u3011" + changeCondition + " ###";
            String a1 = salOrder + salOrderBill.getString("billno") + changeCondition + " \n --- \n";
            billMD.append(a1);
            String changeOperator = ResManager.loadKDString((String)"> \u53d8\u66f4\u4eba\uff1a", (String)"SalOrderBillLogHelper_2", (String)"scmc-sm-business", (Object[])new Object[0]);
            String a2 = changeOperator + SalOrderBillModelHelper.displayFieldValue("modifier", XsalOrderBill.get("modifier")) + "  \n";
            billMD.append(a2);
            String format = InteServiceHelper.getUserFormat((Long)UserServiceHelper.getCurrentUserId()).getDateFormat().getDateFormat();
            SimpleDateFormat df = new SimpleDateFormat(format);
            String changeDate = ResManager.loadKDString((String)"> \u53d8\u66f4\u5355\u65e5\u671f\uff1a", (String)"SalOrderBillLogHelper_3", (String)"scmc-sm-business", (Object[])new Object[0]);
            String a3 = changeDate + SalOrderBillModelHelper.displayFieldValue("bizdate", df.format((Date)XsalOrderBill.get("bizdate"))) + "  \n";
            billMD.append(a3);
            String changeVersion = ResManager.loadKDString((String)"> \u53d8\u66f4\u7248\u672c\uff1a", (String)"SalOrderBillLogHelper_4", (String)"scmc-sm-business", (Object[])new Object[0]);
            String a4 = changeVersion + XsalOrderBill.get("version") + "  \n";
            billMD.append(a4);
            String changeReason = ResManager.loadKDString((String)"> \u53d8\u66f4\u539f\u56e0\uff1a", (String)"SalOrderBillLogHelper_5", (String)"scmc-sm-business", (Object[])new Object[0]);
            String a5 = changeReason + XsalOrderBill.get("reason") + "   \n";
            billMD.append(a5);
            String a6 = ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u53d8\u66f4\u5185\u5bb9", (String)"SalOrderBillLogHelper_6", (String)"scmc-sm-business", (Object[])new Object[0]);
            billMD.append('\n').append("#### \u3000").append(a6).append(" ####").append('\n');
            billMD.append(ResManager.loadKDString((String)"|\u5b57\u6bb5\u540d\u79f0|\u539f\u503c|\u53d8\u66f4\u503c|", (String)"SalOrderBillLogHelper_7", (String)"scmc-sm-business", (Object[])new Object[0])).append('\n').append("|-|-|-|").append('\n');
            for (int fi = 0; fi < billfields.length; ++fi) {
                Object newField;
                Object srcField = salOrderBill.get(billfields[fi]);
                if (SalOrderBillModelHelper.compareField(srcField, newField = XsalOrderBill.get(billfields[fi]))) continue;
                billMD.append('|');
                billMD.append(MetaDataHelper.getPropertyAlias(salOrderBill.getDataEntityType(), billfields[fi]));
                billMD.append("");
                billMD.append('|');
                if (StringUtils.isNotBlank((Object)srcField) && StringUtils.isNotEmpty((CharSequence)srcField.toString())) {
                    billMD.append(SalOrderBillModelHelper.displayFieldValue("", srcField));
                } else {
                    billMD.append("");
                }
                billMD.append("");
                billMD.append('|');
                billMD.append(SalOrderBillModelHelper.displayFieldValue("", newField));
                billMD.append("|\n");
            }
            rs.put("sm_salorder", billMD.toString());
            String[] billEntryFields = SalOrderBillModelHelper.getCanLogBillEntryField;
            String billEntryMD = "\n#### \u3000";
            billEntryMD = billEntryMD + ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u53d8\u66f4\u5185\u5bb9", (String)"SalOrderBillLogHelper_8", (String)"scmc-sm-business", (Object[])new Object[0]);
            billEntryMD = billEntryMD + " ####\n";
            billEntryMD = billEntryMD + SalOrderBillLogHelper.genMDFormatString(salOrderBill, XsalOrderBill, "billentry", "billentry", billEntryFields, "srcbillentryid", "entrychangetype");
            rs.put("billentry", billEntryMD);
            String[] recEntryFields = SalOrderBillModelHelper.getCanLogRecEntryField;
            String billRecEntryMD = "\n#### \u3000";
            billRecEntryMD = billRecEntryMD + ResManager.loadKDString((String)"\u6536\u6b3e\u8ba1\u5212\u53d8\u66f4\u5185\u5bb9", (String)"SalOrderBillLogHelper_9", (String)"scmc-sm-business", (Object[])new Object[0]);
            billRecEntryMD = billRecEntryMD + " ####\n";
            billRecEntryMD = billRecEntryMD + SalOrderBillLogHelper.genMDFormatString(salOrderBill, XsalOrderBill, "recplanentry", "recplanentry", recEntryFields, "srcbillrecentryid", "recentrychangetype");
            rs.put("recplanentry", billRecEntryMD);
            String[] deliverEntryFields = SalOrderBillModelHelper.getCanLogDeliverEntryField;
            String billDeliverEntryMD = "\n#### \u3000";
            billDeliverEntryMD = billDeliverEntryMD + ResManager.loadKDString((String)"\u53d1\u8d27\u8ba1\u5212\u53d8\u66f4\u5185\u5bb9", (String)"SalOrderBillLogHelper_10", (String)"scmc-sm-business", (Object[])new Object[0]);
            billDeliverEntryMD = billDeliverEntryMD + " ####\n";
            billDeliverEntryMD = billDeliverEntryMD + SalOrderBillLogHelper.genMDFormatString(salOrderBill, XsalOrderBill, "orderdeliverentry", "orderdeliverentry", deliverEntryFields, "srcbilldeliverentryid", "delentrychangetype");
            rs.put("orderdeliverentry", billDeliverEntryMD);
            return rs;
        }
        return null;
    }

    public static String genMDFormatString(DynamicObject salOrderBill, DynamicObject XsalOrderBill, String entryName, String xEntryName, String[] billEntryFields, String SrcBillEntryID, String EntryChangeType) {
        StringBuilder billEntryMD = new StringBuilder("|");
        for (int fi = 0; fi < billEntryFields.length; ++fi) {
            billEntryMD.append(MetaDataHelper.getEntryPropertyAlias(salOrderBill.getDataEntityType(), entryName, billEntryFields[fi]));
            billEntryMD.append('|');
            if (!"delentrychangetype".equals(billEntryFields[fi]) || !"orderdeliverentry".equals(entryName)) continue;
            billEntryMD.append(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0 |", (String)"SalOrderBillLogHelper_11", (String)"scmc-sm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection srcBillEntrys = null;
        DynamicObjectCollection xBillEntrys = null;
        Map<DynamicObject, String> deliverEntryAndMaterialName = null;
        Map<DynamicObject, String> deliverEntryAndMaterialName1 = null;
        if ("orderdeliverentry".equals(entryName)) {
            deliverEntryAndMaterialName = SalOrderBillLogHelper.getDeliverEntryAndMaterialName(salOrderBill);
            DynamicObjectCollection saleCollection = new DynamicObjectCollection();
            if (deliverEntryAndMaterialName != null) {
                Iterator<Map.Entry<DynamicObject, String>> iterator = deliverEntryAndMaterialName.entrySet().iterator();
                while (iterator.hasNext()) {
                    DynamicObject key = iterator.next().getKey();
                    saleCollection.add((Object)key);
                }
            }
            deliverEntryAndMaterialName1 = SalOrderBillLogHelper.getDeliverEntryAndMaterialName(XsalOrderBill);
            DynamicObjectCollection xSaleCollection = new DynamicObjectCollection();
            if (deliverEntryAndMaterialName1 != null) {
                Iterator<Map.Entry<DynamicObject, String>> iterator1 = deliverEntryAndMaterialName1.entrySet().iterator();
                while (iterator1.hasNext()) {
                    DynamicObject key = iterator1.next().getKey();
                    xSaleCollection.add((Object)key);
                }
            }
            srcBillEntrys = saleCollection;
            xBillEntrys = xSaleCollection;
        } else {
            srcBillEntrys = salOrderBill.getDynamicObjectCollection(entryName);
            xBillEntrys = XsalOrderBill.getDynamicObjectCollection(xEntryName);
        }
        if (xBillEntrys != null) {
            DynamicObject xBillEntry;
            int i;
            billEntryMD.append("\n|");
            for (int fi = 0; fi < billEntryFields.length; ++fi) {
                billEntryMD.append(":-:|");
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                Long srcBillEntryID = xBillEntry.getLong(SrcBillEntryID);
                if (!ChangeTypeEnum.UPDATE.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                for (int j = 0; j < srcBillEntrys.size(); ++j) {
                    DynamicObject srcBillEntry = (DynamicObject)srcBillEntrys.get(j);
                    Long xBillEntryID = (Long)srcBillEntry.getPkValue();
                    if (srcBillEntryID.longValue() != xBillEntryID.longValue()) continue;
                    StringBuilder rowMD = new StringBuilder("\n|");
                    boolean isChange = false;
                    for (int fi = 0; fi < billEntryFields.length; ++fi) {
                        Object srcField = srcBillEntry.get(billEntryFields[fi]);
                        Object newField = xBillEntry.get(billEntryFields[fi]);
                        if (srcField instanceof BigDecimal && newField instanceof BigDecimal) {
                            srcField = SalOrderBillLogHelper.unit(XsalOrderBill, xBillEntry, billEntryFields[fi], (BigDecimal)srcField);
                            if ((newField = SalOrderBillLogHelper.unit(XsalOrderBill, xBillEntry, billEntryFields[fi], (BigDecimal)newField)).equals("0.00")) {
                                newField = "";
                                if (srcField.equals("0.00")) {
                                    srcField = "";
                                }
                            }
                        }
                        if ("entrychangetype".equals(billEntryFields[fi]) || "delentrychangetype".equals(billEntryFields[fi]) || "recentrychangetype".equals(billEntryFields[fi])) {
                            rowMD = rowMD.append(SalOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                            rowMD = rowMD.append('|');
                            if (!"delentrychangetype".equals(billEntryFields[fi]) || !"orderdeliverentry".equals(entryName)) continue;
                            rowMD = rowMD.append(deliverEntryAndMaterialName1 == null ? null : deliverEntryAndMaterialName1.get(xBillEntry));
                            rowMD = rowMD.append('|');
                            continue;
                        }
                        if (SalOrderBillModelHelper.compareField(srcField, newField)) {
                            rowMD = rowMD.append(SalOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                            rowMD = rowMD.append('|');
                            continue;
                        }
                        rowMD = rowMD.append(SalOrderBillModelHelper.displayCompareFieldValue(srcField, newField));
                        rowMD = rowMD.append('|');
                        isChange = true;
                    }
                    if (!isChange) continue;
                    billEntryMD.append((CharSequence)rowMD);
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.ADDNEW.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                billEntryMD.append("\n|");
                for (int fi = 0; fi < billEntryFields.length; ++fi) {
                    Object newField = xBillEntry.get(billEntryFields[fi]);
                    if (newField instanceof BigDecimal && (newField = SalOrderBillLogHelper.unit(XsalOrderBill, xBillEntry, billEntryFields[fi], (BigDecimal)newField)).equals("0.00")) {
                        newField = "";
                    }
                    if (newField == null) {
                        billEntryMD.append(SalOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                        billEntryMD.append('|');
                        continue;
                    }
                    if (!newField.equals("")) {
                        billEntryMD.append('*');
                        billEntryMD.append(SalOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                        billEntryMD.append("*|");
                        if (!"delentrychangetype".equals(billEntryFields[fi]) || !"orderdeliverentry".equals(entryName)) continue;
                        billEntryMD.append(deliverEntryAndMaterialName1 == null ? null : deliverEntryAndMaterialName1.get(xBillEntry));
                        billEntryMD.append('|');
                        continue;
                    }
                    billEntryMD.append(SalOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                    billEntryMD.append('|');
                }
            }
            for (i = 0; i < xBillEntrys.size(); ++i) {
                xBillEntry = (DynamicObject)xBillEntrys.get(i);
                if (!ChangeTypeEnum.CANCEL.getValue().equals(xBillEntry.get(EntryChangeType))) continue;
                billEntryMD.append("\n|");
                for (int fi = 0; fi < billEntryFields.length; ++fi) {
                    Object newField = xBillEntry.get(billEntryFields[fi]);
                    if (newField instanceof BigDecimal && (newField = SalOrderBillLogHelper.unit(XsalOrderBill, xBillEntry, billEntryFields[fi], (BigDecimal)newField)).equals("0.00")) {
                        newField = "";
                    }
                    billEntryMD.append("~~");
                    billEntryMD.append(SalOrderBillModelHelper.displayFieldValue(billEntryFields[fi], newField));
                    billEntryMD.append("~~|");
                    if (!"delentrychangetype".equals(billEntryFields[fi]) || !"orderdeliverentry".equals(entryName)) continue;
                    billEntryMD.append(deliverEntryAndMaterialName1 == null ? null : deliverEntryAndMaterialName1.get(xBillEntry));
                    billEntryMD.append('|');
                }
            }
        }
        return billEntryMD.toString();
    }

    public static Map<DynamicObject, String> getDeliverEntryAndMaterialName(DynamicObject bill) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        HashMap<DynamicObject, String> map = new HashMap<DynamicObject, String>();
        for (DynamicObject row : entry) {
            DynamicObjectCollection deliverEntry = row.getDynamicObjectCollection("orderdeliverentry");
            String materialName = "";
            if (row.getString("materialname") != null) {
                materialName = row.getString("materialname");
            } else if (row.getDynamicObject("materialmasterid") != null) {
                materialName = row.getDynamicObject("materialmasterid").getString("name");
            } else if (row.getDynamicObject("material") != null) {
                materialName = row.getDynamicObject("material").getDynamicObject("masterid").getString("name");
            }
            if (deliverEntry == null) continue;
            for (DynamicObject drow : deliverEntry) {
                map.put(drow, SalOrderBillModelHelper.getTransString(materialName));
            }
        }
        return map;
    }

    private static Object unit(DynamicObject XsalOrderBill, DynamicObject xBillEntry, String newFieldName, BigDecimal b) {
        if (b.compareTo(BigDecimal.ZERO) == 0) {
            return 0;
        }
        int baseUnitPrecisionType = 4;
        int baseUnitPrecision = 10;
        if ("qty".equals(newFieldName)) {
            DynamicObject unit = (DynamicObject)xBillEntry.get("unit");
            if (unit == null) {
                return 0;
            }
            baseUnitPrecision = unit.getInt(UNIT_PRECISION);
            baseUnitPrecisionType = BillTplHelper.getRoundMode(unit);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        if ("auxqty".equals(newFieldName) && xBillEntry.get("auxunit") != null) {
            DynamicObject unit = (DynamicObject)xBillEntry.get("auxunit");
            if (unit == null) {
                return 0;
            }
            baseUnitPrecision = unit.getInt(UNIT_PRECISION);
            baseUnitPrecisionType = BillTplHelper.getRoundMode(unit);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        if ("amount".equals(newFieldName) || "r_recadvanceamount".equals(newFieldName)) {
            DynamicObject settlecurrency = (DynamicObject)XsalOrderBill.get(SETTLECURRENCY);
            if (settlecurrency == null) {
                return 0;
            }
            baseUnitPrecision = settlecurrency.getInt(AMTPRECISION);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        if ("priceandtax".equals(newFieldName) || "price".equals(newFieldName)) {
            DynamicObject settlecurrency = (DynamicObject)XsalOrderBill.get(SETTLECURRENCY);
            if (settlecurrency == null) {
                return 0;
            }
            baseUnitPrecision = settlecurrency.getInt(PRICEPRECISION);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        if ("d_planqty".equals(newFieldName)) {
            DynamicObject unit = (DynamicObject)xBillEntry.get("d_planunit");
            if (unit == null) {
                return 0;
            }
            baseUnitPrecision = unit.getInt(UNIT_PRECISION);
            baseUnitPrecisionType = BillTplHelper.getRoundMode(unit);
            b = b.setScale(baseUnitPrecision, baseUnitPrecisionType);
            return b;
        }
        DecimalFormat df = new DecimalFormat("#0.00");
        return df.format(b.doubleValue());
    }
}

