/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupHelper;
import kd.mpscmm.msbd.business.helper.OrgHelper;
import kd.mpscmm.msbd.common.enums.OperatorGrpTypeEnum;
import kd.scmc.sm.business.helper.BillTplHelper;
import kd.scmc.sm.business.helper.CustomerConvertInitHelper;
import kd.scmc.sm.business.helper.CustomerHelper;
import kd.scmc.sm.business.helper.SalOrderRecPlanHelper;
import kd.scmc.sm.business.helper.SalesOrgHelper;

public class SalOrderDefaultValueHelper {
    @Deprecated
    public static DynamicObject fillSalOrderDefaultValue(DynamicObject bill, Boolean isProcessOtherCustome, Boolean isCaculateAmount) {
        if (bill == null) {
            return null;
        }
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType == null) {
            return null;
        }
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject settleOrg = null;
        DynamicObject stockOrg = null;
        Map<Long, DynamicObject> ownerMap = null;
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType == null) {
            bizType = BizTypeHelper.getDefaultBizTypeObject((String)"sm_salorder", (Long)((Long)billType.getPkValue()), (String)"sm_billtypeparam");
            bill.set("biztype", (Object)bizType);
        }
        CustomerConvertInitHelper.setDefaultCustomerValue(bill, "customer");
        SalOrderDefaultValueHelper.processCustomer(bill, isProcessOtherCustome);
        SalOrderDefaultValueHelper.setDefaultOperatorGroup(bill);
        SalOrderDefaultValueHelper.setDefaultDept(bill);
        DynamicObjectCollection entrycols = bill.getDynamicObjectCollection("billentry");
        if (entrycols.size() > 0) {
            SalOrderDefaultValueHelper.setLineTypeDefaultValue(entrycols, bizType);
            for (int i = 0; i < entrycols.size(); ++i) {
                DynamicObject entry = (DynamicObject)entrycols.get(i);
                DynamicObject material = entry.getDynamicObject("material");
                if (material != null) {
                    DynamicObject masterMaterial = entry.getDynamicObject("materialmasterid");
                    if (masterMaterial == null && material != null && (masterMaterial = material.getDynamicObject("masterid")) != null) {
                        entry.set("materialmasterid", (Object)masterMaterial);
                    }
                    if (entry.get("productline") == null) {
                        entry.set("productline", (Object)material.getDynamicObject("masterid").getDynamicObject("productline"));
                    }
                }
                SalesOrgHelper.processBotpOrg(org, entry, settleOrg, stockOrg, ownerMap);
                if (entry.getBigDecimal("baseqty") != null && entry.getBigDecimal("auxqty") != null && BigDecimal.ZERO.compareTo(entry.getBigDecimal("baseqty")) != 0 && BigDecimal.ZERO.compareTo(entry.getBigDecimal("auxqty")) != 0) continue;
                BillTplHelper.calcBaseQtyAndAuxQty(bill, i);
            }
            BillTplHelper.calculateDeliverUpAndDownQty(bill);
            SalOrderDefaultValueHelper.processControlDay(bill);
            BillTplHelper.calcMinOrderBaseQty(bill);
        }
        if (isCaculateAmount.booleanValue()) {
            BillTplHelper.processAmount4BotpConvert(bill);
        }
        SalOrderRecPlanHelper.reCalcuRecPlanAmountByContion(bill);
        return bill;
    }

    private static void processCustomer(DynamicObject obj, Boolean isProcessOtherCustome) {
        Long linkmanpk;
        DynamicObject linkman;
        String address = obj.getString("address");
        DynamicObject customer = obj.getDynamicObject("customer");
        if (customer == null) {
            return;
        }
        if (StringUtils.isEmpty((String)address)) {
            obj.set("address", (Object)CustomerHelper.getAddress(customer));
        }
        if ((linkman = obj.getDynamicObject("linkman")) == null && (linkmanpk = CustomerHelper.getLinkman(customer)) != null) {
            DynamicObject lmDy = BusinessDataServiceHelper.loadSingle((Object)linkmanpk, (String)"bd_customerlinkman");
            obj.set("linkman", (Object)lmDy);
        }
        if (obj.getDynamicObject("reccondition") == null) {
            DynamicObject reccondition = customer.getDynamicObject("receivingcondid");
            if (reccondition != null) {
                reccondition = BusinessDataServiceHelper.loadSingleFromCache((Object)reccondition.getPkValue(), (String)"bd_reccondition");
                obj.set("reccondition", (Object)reccondition);
            } else {
                obj.set("reccondition", null);
            }
        }
        if (isProcessOtherCustome.booleanValue()) {
            if (obj.get("payingcustomer") == null) {
                obj.set("payingcustomer", (Object)SalOrderDefaultValueHelper.getCustomerValueOriginal(customer, "paymentcustomerid"));
            }
            if (obj.get("settlecustomer") == null) {
                obj.set("settlecustomer", (Object)SalOrderDefaultValueHelper.getCustomerValueOriginal(customer, "invoicecustomerid"));
            }
            DynamicObject recCustomer = obj.getDynamicObject("reccustomer");
            if (customer != null && recCustomer == null) {
                DynamicObject recLinkman = null;
                String recAddress = null;
                if (customer.getDynamicObject("delivercustomerid") == null || customer.getLong("id") == customer.getDynamicObject("delivercustomerid").getLong("id")) {
                    recCustomer = SalOrderDefaultValueHelper.getCustomerValueOriginal(customer, "delivercustomerid");
                    if (recCustomer != null) {
                        Long linkmanpk2 = CustomerHelper.getLinkman(recCustomer);
                        if (linkmanpk2 != null) {
                            recLinkman = BusinessDataServiceHelper.loadSingle((Object)linkmanpk2, (String)"bd_customerlinkman");
                        }
                        recAddress = CustomerHelper.getAddress(recCustomer);
                    }
                } else {
                    recCustomer = SalOrderDefaultValueHelper.getCustomerValueOriginal(customer, "delivercustomerid");
                    if (recCustomer != null) {
                        Long linkmanpk3 = CustomerHelper.getLinkman(recCustomer = BusinessDataServiceHelper.loadSingleFromCache((Object)recCustomer.getPkValue(), (String)"bd_customer"));
                        if (linkmanpk3 != null) {
                            recLinkman = BusinessDataServiceHelper.loadSingle((Object)linkmanpk3, (String)"bd_customerlinkman");
                        }
                        recAddress = CustomerHelper.getAddress(recCustomer);
                    }
                }
                if (obj.get("reccustomer") == null) {
                    obj.set("reccustomer", (Object)recCustomer);
                }
                if (obj.get("reclinkman") == null) {
                    obj.set("reclinkman", (Object)recLinkman);
                }
                if (StringUtils.isEmpty((String)obj.getString("receiveaddress"))) {
                    obj.set("receiveaddress", (Object)recAddress);
                }
            }
        }
    }

    private static DynamicObject getCustomerValueOriginal(DynamicObject customer, String otherCustomer) {
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        if (dynamicObject != null) {
            return dynamicObject;
        }
        return null;
    }

    private static DynamicObject getCustomerValue(DynamicObject customer, String otherCustomer) {
        String bizfunction;
        if (customer == null) {
            return null;
        }
        DynamicObject dynamicObject = customer.getDynamicObject(otherCustomer);
        if (dynamicObject != null) {
            QFilter id = new QFilter("id", "=", dynamicObject.getPkValue());
            QFilter status = new QFilter("status", "=", (Object)"C");
            id = id.and(status);
            switch (otherCustomer) {
                case "invoicecustomerid": {
                    QFilter invoicehold = new QFilter("invoicehold", "=", (Object)"0");
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%2%");
                    id = id.and(invoicehold).and(bizfunction2);
                    break;
                }
                case "delivercustomerid": {
                    QFilter purchasehold = new QFilter("blockedshipment", "=", (Object)"0");
                    QFilter bizfunction1 = new QFilter("bizfunction", "like", (Object)"%4%");
                    id = id.and(purchasehold).and(bizfunction1);
                    break;
                }
                case "paymentcustomerid": {
                    QFilter bizfunction2 = new QFilter("bizfunction", "like", (Object)"%3%");
                    id = id.and(bizfunction2);
                }
            }
            DynamicObject otCustomer = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_customer", (QFilter[])new QFilter[]{id});
            if (otCustomer != null) {
                return otCustomer;
            }
            if (customer.getPkValue().equals(dynamicObject.getPkValue())) {
                return null;
            }
        }
        if (kd.bd.sbd.utils.StringUtils.isBlank((String)(bizfunction = customer.getString("bizfunction")))) {
            return null;
        }
        switch (otherCustomer) {
            case "invoicecustomerid": {
                if (!customer.getBoolean("invoicehold") && bizfunction.contains("2")) break;
                return null;
            }
            case "delivercustomerid": {
                if (!customer.getBoolean("blockedshipment") && bizfunction.contains("4")) break;
                return null;
            }
            case "paymentcustomerid": {
                if (bizfunction.contains("3")) break;
                return null;
            }
        }
        return customer;
    }

    private static void setLineTypeDefaultValue(DynamicObjectCollection entrycols, DynamicObject bizType) {
        if (bizType == null) {
            return;
        }
        Long lineTypeID = BizTypeHelper.getDefaultLineType((Long)((Long)bizType.getPkValue()));
        if (lineTypeID == null) {
            return;
        }
        DynamicObject lineType = BusinessDataServiceHelper.loadSingle((Object)lineTypeID, (String)"bd_linetype");
        if (lineType != null) {
            entrycols.forEach(entry -> {
                if (entry.get("linetype") == null) {
                    entry.set("linetype", (Object)lineType);
                }
            });
        }
    }

    private static void processControlDay(DynamicObject bill) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : billentry) {
            boolean isControlDay;
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            int receiveDayUp = entry.getInt("deliveradvdays");
            int receiveDayDown = entry.getInt("deliverdelaydays");
            if (receiveDayUp != 0 || receiveDayDown != 0 || !(isControlDay = material.getBoolean("iscontrolday"))) continue;
            receiveDayUp = material.getInt("deliveradvdays");
            receiveDayDown = material.getInt("deliverdelaydays");
            entry.set("deliveradvdays", (Object)receiveDayUp);
            entry.set("deliverdelaydays", (Object)receiveDayDown);
            entry.set("iscontrolday", (Object)isControlDay);
        }
    }

    private static void setDefaultOperatorGroup(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        long userId = UserServiceHelper.getCurrentUserId();
        if (0L == userId) {
            return;
        }
        if (operator == null) {
            Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)((Long)org.getPkValue()), (Long)userId, (String)OperatorGrpTypeEnum.SALEGRP.getValue());
            if (!operatorAndGroup.isEmpty()) {
                bill.set("operator", operatorAndGroup.get("operator"));
                if (operatorGroup == null) {
                    bill.set("operatorgroup", operatorAndGroup.get("operatorgroup"));
                }
            }
        } else if (operatorGroup == null) {
            operatorGroup = BusinessDataServiceHelper.loadSingleFromCache((Object)operator.get("operatorgrpid"), (String)"bd_operatorgroup");
            bill.set("operatorgroup", (Object)operatorGroup);
        }
    }

    private static void setDefaultDept(DynamicObject bill) {
        DynamicObject user;
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject operator = bill.getDynamicObject("operator");
        if (dept == null && operator != null && (user = operator.getDynamicObject("operatorid")) != null) {
            dept = OrgHelper.getDefaultDepartmentObject((Long)((Long)user.getPkValue()));
            bill.set("dept", (Object)dept);
        }
    }
}

