/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.form.IFormView;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.opplugin.AmountPlanValidator;

public class SalOrderRecPlanHelper {
    public static final String APP_ID = "appid";
    public static final String ORGVIEWTYPE = "viewtype";
    public static final String ENTRY_ID = "entrynum";
    public static final String TOTALALLAMOUNT = "totalallamount";
    public static final String BIZTIME = "biztime";
    public static final String AMOUNTCONDITION = "amountcondition";
    public static final String ISPAYRATE = "ispayrate";
    public static final String SETTLECURRENCY = "settlecurrency";
    public static final String ENTRY_ITEMNAME = "itemname";
    public static final String ENTRY_AMOUNT = "amount";
    public static final String ENTRY_RATE = "rate";
    public static final String ENTRY_ISPREPAY = "isprepay";
    public static final String ENTRY_AMOUNTDATE = "amountdate";
    public static final String CHANGETYPE = "changetype";
    public static final String PLANTYPE = "plantype";
    public static final String SALES = "sales";

    public static void reCalcuRecPlanAmountByBill(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        CommonContext context = SalOrderRecPlanHelper.getContext(bill.getDataEntityType().getName());
        AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)context, (DynamicObject)bill);
    }

    public static void reCalcuRecPlanAmount(IFormView view) {
        if (view == null) {
            return;
        }
        CommonContext context = SalOrderRecPlanHelper.getContext(view.getEntityId());
        AmountPlanHelper.calAmountPlanForView((CommonContext)context, (IFormView)view);
    }

    private static CommonContext getContext(String entityId) {
        CommonContext context = CommonContext.get();
        context.setEntityId(entityId);
        Map properytMapping = context.getProperytMapping();
        properytMapping.putAll(SalOrderRecPlanHelper.getParaMap());
        return context;
    }

    public static void reCalcuRecPlanAmountByContion(IFormView view) {
        if (view == null) {
            return;
        }
        view.getModel().clearNoDataRow();
        CommonContext context = SalOrderRecPlanHelper.getContext(view.getEntityId());
        AmountPlanHelper.changeAmountConditionForView((CommonContext)context, (IFormView)view);
    }

    public static void reCalcuRecPlanAmountByContion(DynamicObject bill) {
        if (bill == null) {
            return;
        }
        CommonContext context = SalOrderRecPlanHelper.getContext(bill.getDataEntityType().getName());
        AmountPlanHelper.changeAmountConditionForDynamicObject((CommonContext)context, (DynamicObject)bill);
    }

    public static AbstractValidator getRecAmountValidator() {
        AmountPlanValidator amountPlanValidator = new AmountPlanValidator();
        Map paraMap = SalOrderRecPlanHelper.getParaMap();
        amountPlanValidator.setValidation(paraMap);
        return amountPlanValidator;
    }

    public static void reCalcuRecAmountByCurrency(IDataModel model) {
        int row = model.getEntryRowCount("recplanentry");
        int precision = 10;
        model.beginInit();
        for (int i = 0; i < row; ++i) {
            BigDecimal advanceAmount = (BigDecimal)model.getValue("r_recadvanceamount", i);
            DynamicObject currency = (DynamicObject)model.getValue(SETTLECURRENCY);
            if (currency != null) {
                precision = currency.getInt("amtprecision");
            }
            advanceAmount = advanceAmount.setScale(precision, RoundingMode.HALF_UP);
            model.setValue("r_recadvanceamount", (Object)advanceAmount, i);
        }
        model.endInit();
    }

    public static void changeUnRemainAmount(IDataModel model) {
        int entryRowCount = model.getEntryRowCount("recplanentry");
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal recAmount = model.getValue("r_recadvanceamount", i) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("r_recadvanceamount", i);
            BigDecimal needRemainAmount = model.getValue("r_remainamount", i) == null ? BigDecimal.ZERO : (BigDecimal)model.getValue("r_remainamount", i);
            model.setValue("r_unremainamount", (Object)recAmount.subtract(needRemainAmount), i);
        }
    }

    public static void changeUnRemainAmount(DynamicObject bill) {
        DynamicObjectCollection recplanEntrys = bill.getDynamicObjectCollection("recplanentry");
        for (DynamicObject recplanEntry : recplanEntrys) {
            BigDecimal recAmount = recplanEntry.getBigDecimal("r_recadvanceamount") == null ? BigDecimal.ZERO : recplanEntry.getBigDecimal("r_recadvanceamount");
            BigDecimal needRemainAmount = recplanEntry.getBigDecimal("r_remainamount") == null ? BigDecimal.ZERO : recplanEntry.getBigDecimal("r_remainamount");
            recplanEntry.set("r_unremainamount", (Object)recAmount.subtract(needRemainAmount));
        }
    }

    public static Map getParaMap() {
        HashMap<String, String> paraMap = new HashMap<String, String>(32);
        paraMap.put(APP_ID, "/JJVQ13HQZAJ");
        paraMap.put(ORGVIEWTYPE, "03");
        paraMap.put(ENTRY_ID, "recplanentry");
        paraMap.put(TOTALALLAMOUNT, TOTALALLAMOUNT);
        paraMap.put(BIZTIME, "bizdate");
        paraMap.put(AMOUNTCONDITION, "reccondition");
        paraMap.put(ISPAYRATE, ISPAYRATE);
        paraMap.put(SETTLECURRENCY, SETTLECURRENCY);
        paraMap.put(ENTRY_ITEMNAME, "r_itemname");
        paraMap.put(ENTRY_AMOUNT, "r_recadvanceamount");
        paraMap.put(ENTRY_RATE, "r_recadvancerate");
        paraMap.put(ENTRY_ISPREPAY, "r_needrecadvance");
        paraMap.put(ENTRY_AMOUNTDATE, "r_duedate");
        paraMap.put(CHANGETYPE, "recentrychangetype");
        paraMap.put(PLANTYPE, SALES);
        return paraMap;
    }
}

