/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SalOrderRecPlanProcessor {
    private static final Log log = LogFactory.getLog(SalOrderRecPlanProcessor.class);

    public boolean WbPaidAmount(List<Map<String, Object>> list) {
        if (list == null || list.size() <= 0) {
            log.info("(\u9884)\u4ed8\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        log.info("(\u9884)\u4ed8\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355\u63a5\u53e3\u53c2\u6570:-->" + list);
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> map = list.get(i);
            if (map == null) {
                return false;
            }
            Long mainBillId = (Long)map.get("sourcepk");
            Long entryId = (Long)map.get("sourceentrypk");
            BigDecimal paidAmount = (BigDecimal)map.get("amount");
            if (mainBillId == 0L || entryId == 0L || paidAmount == null) {
                return false;
            }
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)mainBillId, (String)"sm_salorder");
            if (dyn == null) {
                log.info("(\u9884)\u4ed8\u6b3e\u5355\u53cd\u5199\u9500\u552e\u8ba2\u5355id:-->" + mainBillId + "\u4e0d\u5b58\u5728");
                return false;
            }
            DynamicObjectCollection planDy = dyn.getDynamicObjectCollection("recplanentry");
            this.setAmount(dyn, entryId, planDy, paidAmount);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyn});
        }
        return true;
    }

    private void setAmount(DynamicObject dyn, Long entryId, DynamicObjectCollection planDy, BigDecimal sAmount) {
        for (DynamicObject row : planDy) {
            if (row.getLong("id") != entryId.longValue()) continue;
            BigDecimal amount = row.getBigDecimal("r_recamount");
            row.set("r_recamount", (Object)amount.add(sAmount));
            dyn.set("prereceiptamount", (Object)dyn.getBigDecimal("prereceiptamount").add(sAmount));
            break;
        }
    }
}

