/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;

public class SaleDataCtrlHelper {
    private static final String OPERMATERCTRL = "opermaterctrl";
    private static final String CUSMATERCTRL = "cusmaterctrl";
    private static final String OPERCUSCTRL = "opercusctrl";
    private static final String SALOP_MATER_SCHEME = "salop_mater_ctrl";
    private static final String CUS_MATER_SCHEME = "cus_mater_ctrl";

    public static QFilter getAllowMaterialQFilter(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return null;
        }
        QFilter allowMaterialQFilter = null;
        Boolean operMatControl = (Boolean)SysParamHelper.getSysParam4sm((Long)((Long)org.getPkValue()), (String)OPERMATERCTRL);
        Boolean cusMatControl = (Boolean)SysParamHelper.getSysParam4sm((Long)((Long)org.getPkValue()), (String)CUSMATERCTRL);
        if (Boolean.TRUE.equals(operMatControl) && Boolean.TRUE.equals(cusMatControl)) {
            allowMaterialQFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"DataCtrlService", (String)"getQfilter", (Object[])new Object[]{bill, "sm_salorder", "billentry.material.masterid"});
            return allowMaterialQFilter;
        }
        if (Boolean.TRUE.equals(operMatControl)) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
            DynamicObject operator = bill.getDynamicObject("operator");
            DynamicObject operatorgrp = bill.getDynamicObject("operatorgroup");
            DynamicObject dept = bill.getDynamicObject("dept");
            if (operator != null) {
                valueMap.put("operator", operator.getPkValue());
            }
            if (operatorgrp != null) {
                valueMap.put("operatorgroup", operatorgrp.getPkValue());
            }
            if (dept != null) {
                valueMap.put("dept", dept.getPkValue());
            }
            if (valueMap.size() == 0) {
                return null;
            }
            valueMap.put("org", org.getPkValue());
            HashMap<String, HashMap<String, Object>> paraMap = new HashMap<String, HashMap<String, Object>>(8);
            paraMap.put(SALOP_MATER_SCHEME, valueMap);
            allowMaterialQFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"DataCtrlService", (String)"getQfilterByScheme", (Object[])new Object[]{paraMap, "masterid", null});
            return allowMaterialQFilter;
        }
        if (Boolean.TRUE.equals(cusMatControl)) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
            DynamicObject customer = bill.getDynamicObject("customer");
            if (customer != null) {
                valueMap.put("customer", customer.getPkValue());
            }
            if (valueMap.size() == 0) {
                return null;
            }
            valueMap.put("org", org.getPkValue());
            HashMap<String, HashMap<String, Object>> paraMap = new HashMap<String, HashMap<String, Object>>(8);
            paraMap.put(CUS_MATER_SCHEME, valueMap);
            allowMaterialQFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"DataCtrlService", (String)"getQfilterByScheme", (Object[])new Object[]{paraMap, "masterid", null});
            return allowMaterialQFilter;
        }
        return allowMaterialQFilter;
    }

    public static QFilter getAllowCustomerQFilter(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return null;
        }
        QFilter allowCustomerQFilter = null;
        Boolean opercusctrl = (Boolean)SysParamHelper.getSysParam4sm((Long)((Long)org.getPkValue()), (String)OPERCUSCTRL);
        if (Boolean.TRUE.equals(opercusctrl)) {
            allowCustomerQFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"DataCtrlService", (String)"getQfilter", (Object[])new Object[]{bill, "sm_salorder", "customer"});
        }
        return allowCustomerQFilter;
    }

    public static Map<Object, Map<Long, Boolean>> checkMaterialData(Map<Long, List<DynamicObject>> billMap) {
        if (billMap == null) {
            return null;
        }
        HashMap<Object, Map<Long, Boolean>> resultMap = new HashMap<Object, Map<Long, Boolean>>(8);
        for (Map.Entry<Long, List<DynamicObject>> next : billMap.entrySet()) {
            HashMap<String, Object> valueMap;
            HashMap schemeMap;
            HashMap dataColl;
            HashMap paraMap;
            Boolean operMatControl = (Boolean)SysParamHelper.getSysParam4sm((Long)next.getKey(), (String)OPERMATERCTRL);
            Boolean cusMatControl = (Boolean)SysParamHelper.getSysParam4sm((Long)next.getKey(), (String)CUSMATERCTRL);
            List<DynamicObject> bills = next.getValue();
            if (Boolean.TRUE.equals(operMatControl) && Boolean.TRUE.equals(cusMatControl)) {
                Map map = (Map)SaleDataCtrlHelper.invokeDataCtrlService("checkBatchData", bills.toArray(new DynamicObject[0]), "billentry.material.masterid");
                resultMap.putAll(map);
                continue;
            }
            if (Boolean.TRUE.equals(operMatControl)) {
                paraMap = new HashMap(8);
                dataColl = new HashMap(8);
                for (DynamicObject bill : bills) {
                    schemeMap = new HashMap(8);
                    valueMap = new HashMap<String, Object>(8);
                    DynamicObject operator = bill.getDynamicObject("operator");
                    DynamicObject operatorgrp = bill.getDynamicObject("operatorgroup");
                    DynamicObject dept = bill.getDynamicObject("dept");
                    if (operator != null) {
                        valueMap.put("operator", operator.getPkValue());
                    }
                    if (operatorgrp != null) {
                        valueMap.put("operatorgroup", operatorgrp.getPkValue());
                    }
                    if (dept != null) {
                        valueMap.put("dept", dept.getPkValue());
                    }
                    if (valueMap.size() == 0) continue;
                    valueMap.put("org", next.getKey());
                    schemeMap.put(SALOP_MATER_SCHEME, valueMap);
                    paraMap.put(bill.getPkValue(), schemeMap);
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                    if (entrys == null) continue;
                    Set materialIds = entrys.stream().filter(dyn -> dyn.getDynamicObject("material") != null).map(dyn -> (Long)dyn.getDynamicObject("material").getDynamicObject("masterid").getPkValue()).collect(Collectors.toSet());
                    dataColl.put(bill.getPkValue(), materialIds);
                    Map map = (Map)SaleDataCtrlHelper.invokeDataCtrlService("checkBatchDataByScheme", paraMap, dataColl, null);
                    resultMap.putAll(map);
                }
                continue;
            }
            if (!Boolean.TRUE.equals(cusMatControl)) continue;
            paraMap = new HashMap(8);
            dataColl = new HashMap(8);
            for (DynamicObject bill : bills) {
                schemeMap = new HashMap(8);
                valueMap = new HashMap(8);
                DynamicObject customer = bill.getDynamicObject("customer");
                if (customer != null) {
                    valueMap.put("customer", customer.getPkValue());
                    valueMap.put("org", next.getKey());
                }
                if (valueMap.size() == 0) continue;
                schemeMap.put(CUS_MATER_SCHEME, valueMap);
                paraMap.put(bill.getPkValue(), schemeMap);
                DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
                if (entrys == null) continue;
                Set materialIds = entrys.stream().filter(dyn -> dyn.getDynamicObject("material") != null).map(dyn -> (Long)dyn.getDynamicObject("material").getDynamicObject("masterid").getPkValue()).collect(Collectors.toSet());
                dataColl.put(bill.getPkValue(), materialIds);
                Map map = (Map)SaleDataCtrlHelper.invokeDataCtrlService("checkBatchDataByScheme", paraMap, dataColl, null);
                resultMap.putAll(map);
            }
        }
        return resultMap;
    }

    public static Map<Long, Map<Long, Boolean>> checkCustomerData(Map<Long, List<DynamicObject>> billMap) {
        if (billMap == null) {
            return null;
        }
        HashMap<Long, Map<Long, Boolean>> resultMap = new HashMap<Long, Map<Long, Boolean>>(8);
        for (Map.Entry<Long, List<DynamicObject>> next : billMap.entrySet()) {
            Boolean opercusctrl = (Boolean)SysParamHelper.getSysParam4sm((Long)next.getKey(), (String)OPERCUSCTRL);
            if (!Boolean.TRUE.equals(opercusctrl)) continue;
            List<DynamicObject> bills = next.getValue();
            Map map = (Map)SaleDataCtrlHelper.invokeDataCtrlService("checkBatchData", bills.toArray(new DynamicObject[0]), "customer");
            resultMap.putAll(map);
        }
        return resultMap;
    }

    public static <T> T invokeDataCtrlService(String methodName, Object ... paras) {
        return (T)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"DataCtrlService", (String)methodName, (Object[])paras);
    }
}

