/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.scmc.sm.business.handler.SalesAgencyDefaultValueHandler;

public class SalesAgencyHelper {
    public static final String ENTITY_BOS_BILLTYPE = "bos_billtype";
    public static final String ENTITY_SALOUTBILL = "im_saloutbill";

    private SalesAgencyHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isAgencyBiz(IFormView view) {
        if (view == null) {
            return false;
        }
        String appid = view.getFormShowParameter().getAppId();
        Map customParams = view.getFormShowParameter().getCustomParams();
        if ("csm".equals(appid) || customParams != null && "true".equals(customParams.get("isAgency"))) {
            return true;
        }
        Control c = view.getControl("biztype");
        if (c instanceof BasedataEdit && view.getModel() != null) {
            DynamicObject biztype = (DynamicObject)view.getModel().getValue("biztype");
            if (biztype == null) {
                return false;
            }
            return (Long)biztype.getPkValue() == 688860294365375488L || (Long)biztype.getPkValue() == 688861035985431552L;
        }
        return false;
    }

    public static Object getBillTypeID(IFormView view) {
        IFormView parentView;
        String appId = view.getFormShowParameter().getAppId();
        Map customParams = null;
        if ("csm".equals(appId) && (customParams = (parentView = view.getParentView()) != null && "bos_list".equals(parentView.getEntityId()) ? parentView.getFormShowParameter().getCustomParams() : view.getFormShowParameter().getCustomParams()) != null && "true".equals(customParams.get("isAgency"))) {
            return customParams.get("billTypeId");
        }
        return null;
    }

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills) {
        return new SalesAgencyDefaultValueHandler(bills).handleDefaultValues();
    }
}

