/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.org.api.IOrgService;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.sm.business.helper.OrgHelper;
import kd.scmc.sm.util.CommonUtils;

public class SalesOrgHelper {
    public static List<Map<String, String>> getHasPermissionSalesOrg(String entityName) {
        String orgViewType = "03";
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        List<Map<String, String>> hasPermissionSalesOrgs = OrgHelper.getAllPermissionOrgs(dataEntityType, orgViewType);
        if (CommonUtils.isNull(hasPermissionSalesOrgs)) {
            return null;
        }
        return hasPermissionSalesOrgs;
    }

    public static List<Object> getHasPermissionSalesOrgId(String entityName) {
        ArrayList<Object> orgIds;
        List<Map<String, String>> hasPermissionSalesOrgs = SalesOrgHelper.getHasPermissionSalesOrg(entityName);
        if (CommonUtils.isNull(hasPermissionSalesOrgs)) {
            return null;
        }
        if (hasPermissionSalesOrgs != null && hasPermissionSalesOrgs.size() > 0) {
            orgIds = new ArrayList<Object>(hasPermissionSalesOrgs.size());
            for (Map<String, String> org : hasPermissionSalesOrgs) {
                orgIds.add(org.get("id"));
            }
        } else {
            return null;
        }
        return orgIds;
    }

    public static DynamicObject getDeliverDeptDefaultValue(Long deliverorg) {
        OrgRelationParam param = null;
        Long deptId = 0L;
        if (deliverorg == null) {
            return null;
        }
        param = SalesOrgHelper.getOrgRelationParam(deliverorg, "15", "01", "toorg");
        if (param != null) {
            deptId = OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)param);
        }
        return BusinessDataServiceHelper.loadSingleFromCache((Object)deptId, (String)"bos_org");
    }

    public static Long getOrgDefaultValue(Long org, String fromViewType, String toViewType, String directViewType) {
        OrgRelationParam param = null;
        if (org == null) {
            return 0L;
        }
        param = SalesOrgHelper.getOrgRelationParam(org, fromViewType, toViewType, directViewType);
        return OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)param);
    }

    public static Long getOwnerDefaultValue(Long stockOrgId) {
        if (stockOrgId == null) {
            return 0L;
        }
        return SalesOrgHelper.getOrgRelationDefaultValue(stockOrgId, "10", "05", "fromorg");
    }

    public static Long getOwnerDefaultValue(Long OrgId, Long stockOrgId) {
        Long accountingOrg = SalesOrgHelper.getAcccountOrg4Org(OrgId);
        Map<String, Object> allToOrg = SalesOrgHelper.getOrgRelationMap(stockOrgId, "10", "05", "fromorg");
        if (allToOrg != null && !allToOrg.isEmpty()) {
            List orgIds = (List)allToOrg.get("orgId");
            if (orgIds.contains(accountingOrg)) {
                return accountingOrg;
            }
            List detailList = (List)allToOrg.get("data");
            for (Map detailMap : detailList) {
                Boolean isDefault = (Boolean)detailMap.get("isDefault");
                if (!isDefault.booleanValue()) continue;
                return (Long)detailMap.get("orgId");
            }
        }
        return 0L;
    }

    public static Long getAcccountOrg4Org(Long OrgId) {
        if (OrgId == null) {
            return 0L;
        }
        Long acccountOrgPK = 0L;
        Map<String, Object> orgMap = OrgHelper.getCompanyByOrg(OrgId, Boolean.FALSE, Boolean.TRUE);
        if (!CommonUtils.isNull(orgMap)) {
            acccountOrgPK = (Long)orgMap.get("id");
        }
        return acccountOrgPK;
    }

    public static void setOwner(IDataModel model) {
        DynamicObject org = (DynamicObject)model.getValue("org");
        int entryRowCount = model.getEntryRowCount("billentry");
        HashMap<Long, Long> ownerMap = new HashMap<Long, Long>(8);
        for (int i = 0; i < entryRowCount; ++i) {
            Long ownerId;
            DynamicObject stockOrg = (DynamicObject)model.getValue("e_stockorg", i);
            if (stockOrg == null) continue;
            if (ownerMap.get((Long)stockOrg.getPkValue()) == null) {
                ownerId = SalesOrgHelper.getOwnerDefaultValue((Long)org.getPkValue(), (Long)stockOrg.getPkValue());
                if (ownerId == null) {
                    ownerMap.put((Long)stockOrg.getPkValue(), 0L);
                } else {
                    ownerMap.put((Long)stockOrg.getPkValue(), ownerId);
                }
            } else {
                ownerId = (Long)ownerMap.get((Long)stockOrg.getPkValue());
            }
            if (ownerId != null && ownerId != 0L) {
                model.setValue("owner", (Object)ownerId, i);
                continue;
            }
            model.setValue("owner", null, i);
        }
    }

    public static void setOwner(int rowIndex, IDataModel model, DynamicObject org, DynamicObject stockOrg) {
        if (stockOrg == null || org == null) {
            model.setValue("owner", null, rowIndex);
            return;
        }
        Long owner = SalesOrgHelper.getOwnerDefaultValue((Long)org.getPkValue(), (Long)stockOrg.getPkValue());
        if (owner != 0L) {
            model.setValue("owner", (Object)owner, rowIndex);
        } else {
            model.setValue("owner", null, rowIndex);
        }
    }

    public static void setOwner(int rowIndex, IDataModel model, DynamicObject org, DynamicObject stockOrg, IPageCache pageCache) {
        Long owner;
        if (stockOrg == null || org == null) {
            model.setValue("owner", null, rowIndex);
            return;
        }
        String cacheKey = "getOwnerDefaultValue" + org.getPkValue() + "_" + stockOrg.getPkValue();
        if (pageCache.get(cacheKey) == null) {
            owner = SalesOrgHelper.getOwnerDefaultValue((Long)org.getPkValue(), (Long)stockOrg.getPkValue());
            if (owner == null) {
                pageCache.put(cacheKey, String.valueOf(0L));
            } else {
                pageCache.put(cacheKey, String.valueOf(owner));
            }
        } else {
            owner = Long.valueOf(pageCache.get(cacheKey));
        }
        if (owner != null && owner != 0L) {
            model.setValue("owner", (Object)owner, rowIndex);
        } else {
            model.setValue("owner", null, rowIndex);
        }
    }

    public static Map<String, Object> getOrgRelationMap(Long org, String fromViewType, String toViewType, String directViewType) {
        OrgRelationParam param = null;
        if (org == null) {
            return null;
        }
        param = SalesOrgHelper.getOrgRelationParam(org, fromViewType, toViewType, directViewType);
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }

    public static OrgRelationParam getOrgRelationParam(Long org, String fromViewType, String toViewType, String directViewType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(org.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(toViewType);
        if ("fromorg".equals(directViewType)) {
            param.setDirectViewType("fromorg");
        } else if ("toorg".equals(directViewType)) {
            param.setDirectViewType("toorg");
        }
        return param;
    }

    public static Long getOrgRelationDefaultValue(Long org, String fromViewType, String toViewType, String directViewType) {
        Map<String, Object> allToOrg = SalesOrgHelper.getOrgRelationMap(org, fromViewType, toViewType, directViewType);
        if (allToOrg != null) {
            List detailList = (List)allToOrg.get("data");
            for (Map detailMap : detailList) {
                Boolean isDefault = (Boolean)detailMap.get("isDefault");
                if (!isDefault.booleanValue()) continue;
                return (Long)detailMap.get("orgId");
            }
        }
        return 0L;
    }

    public static List<Long> getAccountOrgRange(Long stockOrgId) {
        Boolean isAcconut = OrgHelper.checkOrgFunction(stockOrgId, "10");
        Map<String, Object> allToOrg = SalesOrgHelper.getOrgRelationMap(stockOrgId, "10", "05", "fromorg");
        List<Long> orgIds = new ArrayList<Long>(16);
        if (allToOrg != null) {
            orgIds = (List)allToOrg.get("orgId");
            if (isAcconut.booleanValue() && orgIds != null && orgIds.size() > 0 && !orgIds.contains(stockOrgId)) {
                orgIds.add(stockOrgId);
            }
        }
        return orgIds;
    }

    public static void processBotpOrg(DynamicObject org, DynamicObject entry, DynamicObject settleOrg, DynamicObject stockOrg, Map<Long, DynamicObject> ownerMap) {
        if (org == null) {
            return;
        }
        if (entry.get("e_stockorg") == null) {
            if (stockOrg == null) {
                Long stockOrgPK = SalesOrgHelper.getOrgDefaultValue((Long)org.getPkValue(), "03", "05", "toorg");
                if (stockOrgPK != 0L) {
                    stockOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)stockOrgPK, (String)"bos_org");
                    entry.set("e_stockorg", (Object)stockOrg);
                }
            } else {
                entry.set("e_stockorg", (Object)stockOrg);
            }
        }
        if (entry.get("entrysettleorg") == null) {
            if (settleOrg == null) {
                Long settleOrgPK = SalesOrgHelper.getOrgDefaultValue((Long)org.getPkValue(), "03", "10", "toorg");
                if (settleOrgPK != 0L) {
                    settleOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)settleOrgPK, (String)"bos_org");
                    entry.set("entrysettleorg", (Object)settleOrg);
                }
            } else {
                entry.set("entrysettleorg", (Object)settleOrg);
            }
        }
        if (entry.get("owner") == null && (stockOrg = entry.getDynamicObject("e_stockorg")) != null) {
            if (ownerMap == null) {
                ownerMap = new HashMap<Long, DynamicObject>(8);
            }
            if (ownerMap.get((Long)stockOrg.getPkValue()) != null) {
                entry.set("owner", (Object)ownerMap.get(stockOrg));
            } else {
                Long ownerPK = SalesOrgHelper.getOwnerDefaultValue((Long)org.getPkValue(), (Long)stockOrg.getPkValue());
                if (ownerPK != 0L) {
                    DynamicObject owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerPK, (String)"bos_org");
                    entry.set("owner", (Object)owner);
                    ownerMap.putIfAbsent((Long)stockOrg.getPkValue(), owner);
                }
            }
        }
    }

    public static Set<Long> getAllPurOrgs(Long salOrgId, Long SettleOrgId) {
        OrgTreeParam param = new OrgTreeParam();
        HashSet<Long> orgs = new HashSet<Long>(16);
        if (SettleOrgId != null) {
            param.setOrgViewNumber("02");
            param.setId(SettleOrgId.longValue());
            List rootInfoMap = ((IOrgService)ServiceFactory.getService(IOrgService.class)).getTreeChildrenMap(param);
            for (Map map : rootInfoMap) {
                orgs.add((Long)map.get("id"));
            }
        }
        if (OrgHelper.checkOrgFunction(SettleOrgId, "02")) {
            orgs.add(SettleOrgId);
        }
        if (salOrgId != null && OrgHelper.checkOrgFunction(salOrgId, "02")) {
            orgs.add(salOrgId);
        }
        return orgs;
    }

    public static boolean checkPurOrg(Long salOrgId, Long SettleOrgId, Long purOrg) {
        Set<Long> orgs = SalesOrgHelper.getAllPurOrgs(salOrgId, SettleOrgId);
        return orgs != null && orgs.size() > 0 && orgs.contains(purOrg);
    }
}

