/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.scmc.sm.business.helper.BillTplHelper;

public class SimulateQuoteHelper {
    private SimulateQuoteHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static void calcSubQtyAndBaseQty(int rowIndex, IDataModel model) {
        BigDecimal qty = (BigDecimal)model.getValue("subqty", rowIndex);
        DynamicObject unit = (DynamicObject)model.getValue("subunit", rowIndex);
        if (unit != null && qty != null) {
            int precision = unit.getInt("precision");
            int precisionaccount = BillTplHelper.getRoundMode(unit);
            qty = qty.setScale(precision, precisionaccount);
            model.beginInit();
            model.setValue("subqtydenominator", (Object)new BigDecimal(1L), rowIndex);
            model.setValue("subqty", (Object)qty, rowIndex);
            model.setValue("subqtynumerator", (Object)qty, rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("subbaseunit", rowIndex);
            if (baseUnit != null) {
                DynamicObject material = (DynamicObject)model.getValue("submaterial", rowIndex);
                BigDecimal baseQty = BigDecimal.ZERO;
                if (qty.compareTo(BigDecimal.ZERO) != 0) {
                    baseQty = BillTplHelper.getDesQtyConv(material, unit, qty, baseUnit);
                }
                model.setValue("subbaseqty", (Object)baseQty, rowIndex);
            }
            model.endInit();
        } else {
            model.beginInit();
            model.setValue("subqtydenominator", (Object)new BigDecimal(1L), rowIndex);
            if (qty != null) {
                model.setValue("subqtynumerator", (Object)qty, rowIndex);
            }
            model.endInit();
        }
    }

    public static void calcSubAmount(int parentRowIndex, int rowIndex, IDataModel model) {
        BigDecimal qty = (BigDecimal)model.getValue("qty", parentRowIndex);
        if (BigDecimal.ZERO.compareTo(qty) >= 0) {
            qty = new BigDecimal(1L);
        }
        BigDecimal subQty = (BigDecimal)model.getValue("subqty", rowIndex);
        DynamicObject quoteCurrency = (DynamicObject)model.getValue("settlecurrency");
        int quoteAmtPrecision = quoteCurrency == null ? 10 : quoteCurrency.getInt("amtprecision");
        BigDecimal subMaterialAmountOld = (BigDecimal)model.getValue("submaterialamount", rowIndex);
        BigDecimal subProcessAmountOld = (BigDecimal)model.getValue("subprocessamount", rowIndex);
        BigDecimal subLaborCostOld = (BigDecimal)model.getValue("sublaborcost", rowIndex);
        BigDecimal subManufactureCostOld = (BigDecimal)model.getValue("submanufacturecost", rowIndex);
        BigDecimal subPieceworkAmountOld = (BigDecimal)model.getValue("subpieceworkamount", rowIndex);
        BigDecimal subMaterialAmount = BigDecimal.ZERO;
        BigDecimal subProcessAmount = BigDecimal.ZERO;
        BigDecimal subLaborCost = BigDecimal.ZERO;
        BigDecimal subManufactureCost = BigDecimal.ZERO;
        BigDecimal subPieceworkAmount = BigDecimal.ZERO;
        if (qty != null && subQty != null && qty.compareTo(BigDecimal.ZERO) > 0 && subQty.compareTo(BigDecimal.ZERO) > 0) {
            BigDecimal subPieceworkPrice;
            BigDecimal subProcessPrice;
            BigDecimal subMaterialPrice = (BigDecimal)model.getValue("submaterialprice", rowIndex);
            if (subMaterialPrice != null && subMaterialPrice.compareTo(BigDecimal.ZERO) > 0) {
                subMaterialAmount = subMaterialPrice.multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
            }
            if ((subProcessPrice = (BigDecimal)model.getValue("subprocessprice", rowIndex)) != null && subProcessPrice.compareTo(BigDecimal.ZERO) > 0) {
                subProcessAmount = subProcessPrice.multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
            }
            BigDecimal subWorkHours = (BigDecimal)model.getValue("subworkhours", rowIndex);
            BigDecimal subWorkPrice = (BigDecimal)model.getValue("subworkprice", rowIndex);
            if (subWorkHours != null && subWorkPrice != null && subWorkHours.compareTo(BigDecimal.ZERO) > 0 && subWorkPrice.compareTo(BigDecimal.ZERO) > 0) {
                subLaborCost = subWorkHours.multiply(subWorkPrice).multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
            }
            BigDecimal subManufacturePrice = (BigDecimal)model.getValue("submanufactureprice", rowIndex);
            if (subWorkHours != null && subManufacturePrice != null && subWorkHours.compareTo(BigDecimal.ZERO) > 0 && subManufacturePrice.compareTo(BigDecimal.ZERO) > 0) {
                subManufactureCost = subWorkHours.multiply(subManufacturePrice).multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
            }
            if ((subPieceworkPrice = (BigDecimal)model.getValue("subpieceworkprice", rowIndex)) != null && subPieceworkPrice.compareTo(BigDecimal.ZERO) > 0) {
                subPieceworkAmount = subPieceworkPrice.multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
            }
        }
        BigDecimal materialCost = (BigDecimal)model.getValue("materialcost", parentRowIndex);
        BigDecimal processCost = (BigDecimal)model.getValue("processcost", parentRowIndex);
        BigDecimal manufactureCost = (BigDecimal)model.getValue("manufacturecost", parentRowIndex);
        BigDecimal laborCost = (BigDecimal)model.getValue("laborcost", parentRowIndex);
        BigDecimal pieceworkAmount = (BigDecimal)model.getValue("pieceworkamount", parentRowIndex);
        materialCost = materialCost.subtract(subMaterialAmountOld).add(subMaterialAmount).setScale(quoteAmtPrecision, 4);
        processCost = processCost.subtract(subProcessAmountOld).add(subProcessAmount).setScale(quoteAmtPrecision, 4);
        manufactureCost = manufactureCost.subtract(subManufactureCostOld).add(subManufactureCost).setScale(quoteAmtPrecision, 4);
        laborCost = laborCost.subtract(subLaborCostOld).add(subLaborCost).setScale(quoteAmtPrecision, 4);
        pieceworkAmount = pieceworkAmount.subtract(subPieceworkAmountOld).add(subPieceworkAmount).setScale(quoteAmtPrecision, 4);
        BigDecimal quoteCost = materialCost.add(processCost).add(manufactureCost).add(laborCost).add(pieceworkAmount).setScale(quoteAmtPrecision, 4);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", parentRowIndex);
        taxRate = taxRate.divide(new BigDecimal(100));
        BigDecimal costuprate = (BigDecimal)model.getValue("costuprate", parentRowIndex);
        costuprate = costuprate.divide(new BigDecimal(100));
        BigDecimal price = quoteCost.multiply(BigDecimal.ONE.add(costuprate)).divide(qty, 10, 4);
        BigDecimal priceAndTax = quoteCost.multiply(BigDecimal.ONE.add(costuprate)).multiply(BigDecimal.ONE.add(taxRate)).divide(qty, 10, 4);
        model.setValue("submaterialamount", (Object)subMaterialAmount, rowIndex);
        model.setValue("subprocessamount", (Object)subProcessAmount, rowIndex);
        model.setValue("sublaborcost", (Object)subLaborCost, rowIndex);
        model.setValue("submanufacturecost", (Object)subManufactureCost, rowIndex);
        model.setValue("subpieceworkamount", (Object)subPieceworkAmount, rowIndex);
        model.setValue("materialcost", (Object)materialCost, parentRowIndex);
        model.setValue("processcost", (Object)processCost, parentRowIndex);
        model.setValue("manufacturecost", (Object)manufactureCost, parentRowIndex);
        model.setValue("laborcost", (Object)laborCost, parentRowIndex);
        model.setValue("pieceworkamount", (Object)pieceworkAmount, parentRowIndex);
        model.setValue("quotecost", (Object)quoteCost, parentRowIndex);
        model.setValue("price", (Object)price, parentRowIndex);
        model.setValue("priceandtax", (Object)priceAndTax, parentRowIndex);
    }

    public static Map<String, BigDecimal> getHeadAmount(int entryFocusRow, IDataModel model, int[] rowIndexs) {
        BigDecimal materialCost = (BigDecimal)model.getValue("materialcost", entryFocusRow);
        BigDecimal processCost = (BigDecimal)model.getValue("processcost", entryFocusRow);
        BigDecimal manufactureCost = (BigDecimal)model.getValue("manufacturecost", entryFocusRow);
        BigDecimal laborCost = (BigDecimal)model.getValue("laborcost", entryFocusRow);
        BigDecimal pieceworkAmount = (BigDecimal)model.getValue("pieceworkamount", entryFocusRow);
        for (int seq : rowIndexs) {
            BigDecimal subMaterialAmount = (BigDecimal)model.getValue("submaterialamount", seq);
            materialCost = materialCost.subtract(subMaterialAmount);
            BigDecimal subProcessAmount = (BigDecimal)model.getValue("subprocessamount", seq);
            processCost = processCost.subtract(subProcessAmount);
            BigDecimal subLaborCost = (BigDecimal)model.getValue("sublaborcost", seq);
            laborCost = laborCost.subtract(subLaborCost);
            BigDecimal subManufactureCost = (BigDecimal)model.getValue("submanufacturecost", seq);
            manufactureCost = manufactureCost.subtract(subManufactureCost);
            BigDecimal subPieceworkAmount = (BigDecimal)model.getValue("subpieceworkamount", seq);
            pieceworkAmount = pieceworkAmount.subtract(subPieceworkAmount);
        }
        BigDecimal quoteCost = materialCost.add(processCost).add(manufactureCost).add(laborCost).add(pieceworkAmount);
        BigDecimal taxRate = (BigDecimal)model.getValue("taxrate", entryFocusRow);
        taxRate = taxRate.divide(new BigDecimal(100));
        BigDecimal costuprate = (BigDecimal)model.getValue("costuprate", entryFocusRow);
        costuprate = costuprate.divide(new BigDecimal(100));
        BigDecimal qty = (BigDecimal)model.getValue("qty", entryFocusRow);
        if (BigDecimal.ZERO.compareTo(qty) >= 0) {
            qty = new BigDecimal(1L);
        }
        BigDecimal price = quoteCost.multiply(BigDecimal.ONE.add(costuprate)).divide(qty, 10, 4);
        BigDecimal priceAndTax = quoteCost.multiply(BigDecimal.ONE.add(costuprate)).multiply(BigDecimal.ONE.add(taxRate)).divide(qty, 10, 4);
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("materialcost", materialCost);
        map.put("processcost", processCost);
        map.put("manufacturecost", manufactureCost);
        map.put("laborcost", laborCost);
        map.put("pieceworkamount", pieceworkAmount);
        map.put("quotecost", quoteCost);
        map.put("price", price);
        map.put("priceandtax", priceAndTax);
        return map;
    }

    public static void calcAllEntityAmount(IDataModel model) {
        DynamicObject billObj = model.getDataEntity(true);
        DynamicObjectCollection parentRowObjs = billObj.getDynamicObjectCollection("billentry");
        DynamicObject quoteCurrency = billObj.getDynamicObject("settlecurrency");
        int quoteAmtPrecision = quoteCurrency == null ? 10 : quoteCurrency.getInt("amtprecision");
        for (DynamicObject parentRow : parentRowObjs) {
            DynamicObjectCollection subRowObjs = parentRow.getDynamicObjectCollection("subentry");
            BigDecimal qty = parentRow.getBigDecimal("qty");
            if (BigDecimal.ZERO.compareTo(qty) >= 0) {
                qty = new BigDecimal(1L);
            }
            BigDecimal materialCost = BigDecimal.ZERO;
            BigDecimal processCost = BigDecimal.ZERO;
            BigDecimal manufactureCost = BigDecimal.ZERO;
            BigDecimal laborCost = BigDecimal.ZERO;
            BigDecimal pieceworkAmount = BigDecimal.ZERO;
            for (DynamicObject subRowObj : subRowObjs) {
                BigDecimal subQty = subRowObj.getBigDecimal("subqty");
                BigDecimal subMaterialAmount = BigDecimal.ZERO;
                BigDecimal subProcessAmount = BigDecimal.ZERO;
                BigDecimal subLaborCost = BigDecimal.ZERO;
                BigDecimal subManufactureCost = BigDecimal.ZERO;
                BigDecimal subPieceworkAmount = BigDecimal.ZERO;
                if (qty != null && subQty != null && qty.compareTo(BigDecimal.ZERO) > 0 && subQty.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal subPieceworkPrice;
                    BigDecimal subProcessPrice;
                    BigDecimal subMaterialPrice = subRowObj.getBigDecimal("submaterialprice");
                    if (subMaterialPrice != null && subMaterialPrice.compareTo(BigDecimal.ZERO) > 0) {
                        subMaterialAmount = subMaterialPrice.multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
                    }
                    if ((subProcessPrice = subRowObj.getBigDecimal("subprocessprice")) != null && subProcessPrice.compareTo(BigDecimal.ZERO) > 0) {
                        subProcessAmount = subProcessPrice.multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
                    }
                    BigDecimal subWorkHours = subRowObj.getBigDecimal("subworkhours");
                    BigDecimal subWorkPrice = subRowObj.getBigDecimal("subworkprice");
                    if (subWorkHours != null && subWorkPrice != null && subWorkHours.compareTo(BigDecimal.ZERO) > 0 && subWorkPrice.compareTo(BigDecimal.ZERO) > 0) {
                        subLaborCost = subWorkHours.multiply(subWorkPrice).multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
                    }
                    BigDecimal subManufacturePrice = subRowObj.getBigDecimal("submanufactureprice");
                    if (subWorkHours != null && subManufacturePrice != null && subWorkHours.compareTo(BigDecimal.ZERO) > 0 && subManufacturePrice.compareTo(BigDecimal.ZERO) > 0) {
                        subManufactureCost = subWorkHours.multiply(subManufacturePrice).multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
                    }
                    if ((subPieceworkPrice = subRowObj.getBigDecimal("subpieceworkprice")) != null && subPieceworkPrice.compareTo(BigDecimal.ZERO) > 0) {
                        subPieceworkAmount = subPieceworkPrice.multiply(qty).multiply(subQty).setScale(quoteAmtPrecision, 4);
                    }
                }
                materialCost = materialCost.add(subMaterialAmount);
                processCost = processCost.add(subProcessAmount);
                manufactureCost = manufactureCost.add(subManufactureCost);
                laborCost = laborCost.add(subLaborCost);
                pieceworkAmount = pieceworkAmount.add(subPieceworkAmount);
                subRowObj.set("submaterialamount", (Object)subMaterialAmount);
                subRowObj.set("subprocessamount", (Object)subProcessAmount);
                subRowObj.set("submanufacturecost", (Object)subManufactureCost);
                subRowObj.set("sublaborcost", (Object)subLaborCost);
                subRowObj.set("subpieceworkamount", (Object)subPieceworkAmount);
            }
            BigDecimal quoteCost = materialCost.add(processCost).add(manufactureCost).add(laborCost).add(pieceworkAmount).setScale(quoteAmtPrecision, 4);
            BigDecimal taxRate = parentRow.getBigDecimal("taxrate");
            taxRate = taxRate.divide(new BigDecimal(100));
            BigDecimal costuprate = parentRow.getBigDecimal("costuprate");
            costuprate = costuprate.divide(new BigDecimal(100));
            BigDecimal price = quoteCost.multiply(BigDecimal.ONE.add(costuprate)).divide(qty, 10, 4);
            BigDecimal priceAndTax = quoteCost.multiply(BigDecimal.ONE.add(costuprate)).multiply(BigDecimal.ONE.add(taxRate)).divide(qty, 10, 4);
            parentRow.set("materialcost", (Object)materialCost);
            parentRow.set("processcost", (Object)processCost);
            parentRow.set("manufacturecost", (Object)manufactureCost);
            parentRow.set("laborcost", (Object)laborCost);
            parentRow.set("pieceworkamount", (Object)pieceworkAmount);
            parentRow.set("quotecost", (Object)quoteCost);
            parentRow.set("price", (Object)price);
            parentRow.set("priceandtax", (Object)priceAndTax);
        }
    }
}

