/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.sm.business.helper.portal;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.sm.business.helper.DateHelper;
import kd.scmc.sm.enums.MaterialTypeEnum;
import kd.scmc.sm.enums.StatusEnum;
import kd.scmc.sm.util.QFBuilder;

public class SaleAmountCalculator {
    public static Map<String, Map<String, BigDecimal>> getTop5AmountByMaterialType() {
        HashMap<String, Map<String, BigDecimal>> result = new HashMap<String, Map<String, BigDecimal>>();
        TreeMap<String, BigDecimal> currentAmountCache = new TreeMap<String, BigDecimal>();
        Date[] currentMonthRange = DateHelper.getCurrentMonthRange();
        GetAmount getAmount = new GetAmount(currentMonthRange).invoke();
        SaleAmountCalculator.buildAmountCache(getAmount, currentAmountCache, 5);
        TreeMap<String, BigDecimal> preAmountCache = new TreeMap<String, BigDecimal>();
        Date[] currentMonthRangeLastYear = DateHelper.getCurrentMonthRangeLastYear();
        GetAmount getPreAmount = new GetAmount(currentMonthRangeLastYear).invoke();
        SaleAmountCalculator.buildAmountCache(getPreAmount, preAmountCache, 100);
        if (currentAmountCache.size() > 0) {
            currentAmountCache.forEach((k, v) -> {
                String key = k;
                BigDecimal preAmount = (BigDecimal)preAmountCache.get(k);
                BigDecimal currentAmount = v;
                HashMap<String, BigDecimal> amount = new HashMap<String, BigDecimal>();
                amount.put("prePeriod", preAmount == null ? BigDecimal.ZERO : preAmount);
                amount.put("currentPeriod", currentAmount);
                result.put(MaterialTypeEnum.getName((String)key), amount);
            });
        }
        return result;
    }

    private static void buildAmountCache(GetAmount getAmount, Map<String, BigDecimal> currentAmount, int top) {
        try (DataSet result = getAmount.getResult();){
            int i = 0;
            while (result.hasNext()) {
                if (++i > top) {
                    break;
                }
                Row row = result.next();
                String materialType = row.getString("materialtype");
                if (!StringUtils.isNotEmpty((String)materialType)) continue;
                if (row.getBigDecimal("amount") == null) {
                    currentAmount.put(materialType, BigDecimal.ZERO);
                    continue;
                }
                currentAmount.put(materialType, row.getBigDecimal("amount").divide(BigDecimal.valueOf(10000.0)));
            }
        }
    }

    private static class GetAmount {
        private Date[] currentMonthRange;
        private GroupbyDataSet groupBySet;

        public GetAmount(Date ... currentMonthRange) {
            this.currentMonthRange = currentMonthRange;
        }

        public DataSet getResult() {
            DataSet groupResult = this.groupBySet.sum("amount").finish();
            groupResult = groupResult.select(new String[]{"materialtype", "amount"});
            return groupResult.orderBy(new String[]{"amount desc"});
        }

        public GetAmount invoke() {
            HashSet<String> selector = new HashSet<String>();
            selector.add("billentry.material.masterid.materialtype as materialtype");
            selector.add("billentry.curamount as amount");
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
            qfBuilder.add("bizdate", "<=", (Object)this.currentMonthRange[1]);
            qfBuilder.add("bizdate", ">=", (Object)this.currentMonthRange[0]);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)"SaleAmountCalculator", (String)"sm_salorder", (String)String.join((CharSequence)",", selector), (QFilter[])qfBuilder.toArray(), null);
            this.groupBySet = dataSet.groupBy(new String[]{"materialtype"});
            return this;
        }
    }
}

