/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.report;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pms.business.helper.AppParameterHelper;
import kd.scmc.pms.business.helper.OperGrpHelper;
import kd.scmc.pms.business.helper.OrgHelper;
import kd.scmc.pms.report.helper.SalesHistoricalPriceRptHelper;

public class SalesHistoricalPriceRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("orgfield");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit customer = (BasedataEdit)this.getView().getControl("customerfield");
        customer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("materialfield");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizoperator = (BasedataEdit)this.getView().getControl("operatorfield");
        bizoperator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizoperatorgroup = (BasedataEdit)this.getView().getControl("operatorgroupfield");
        bizoperatorgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizdept = (BasedataEdit)this.getView().getControl("deptfield");
        bizdept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit biztype = (BasedataEdit)this.getView().getControl("biztypefield");
        biztype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        DynamicObjectCollection operateGroup;
        List orgList;
        super.beforeBindData(e);
        if (this.getModel().getValue("orgfield") == null && (orgList = OrgHelper.getHasPermissionOrg((String)"sal_historicalpricerpt", (String)"03")) != null && orgList.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (orgList.contains(orgId)) {
                this.getModel().setValue("orgfield", (Object)orgId);
            } else {
                this.getModel().setValue("orgfield", orgList.get(0));
            }
        }
        Object startdate = this.getModel().getValue("startdate");
        Object enddate = this.getModel().getValue("enddate");
        if (startdate == null || enddate == null) {
            Calendar startMonth = Calendar.getInstance();
            startMonth.add(2, -1);
            startMonth.set(5, startMonth.get(5));
            this.getModel().setValue("startdate", (Object)startMonth.getTime());
            this.getModel().setValue("enddate", (Object)TimeServiceHelper.today());
        }
        if ((operateGroup = (DynamicObjectCollection)this.getModel().getValue("operatorgroupfield")) == null || operateGroup.size() == 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"operatorfield"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"operatorfield"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("orgfield");
        switch (key) {
            case "orgfield": {
                List orgList = OrgHelper.getHasPermissionOrg((String)"sal_historicalpricerpt", (String)OrgHelper.getFisSaleViewType());
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "customerfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter customerFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
                QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_customer", (Long)((Long)org.getPkValue()));
                customerFilter.and(filter);
                formShowParameter.getListFilterParameter().setFilter(customerFilter);
                formShowParameter.setShowApproved(false);
                break;
            }
            case "materialfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)Long.valueOf(org.getPkValue().toString()));
                formShowParameter.getListFilterParameter().setFilter(qFilter);
                formShowParameter.setCustomParam("useOrg", (Object)org.getPkValue().toString());
                formShowParameter.setShowApproved(false);
                break;
            }
            case "operatorgroupfield": {
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                long userId = UserServiceHelper.getCurrentUserId();
                List<Long> orgGrpList = SalesHistoricalPriceRptHelper.getOperatorGroupByOrg(Long.parseLong(org.getPkValue().toString()));
                Object operatorGroupIsolate = AppParameterHelper.getSmAppParameter((Long)Long.parseLong(org.getPkValue().toString()), (String)"foperatorgroupisolate");
                if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                    HashSet<Long> userIDs = new HashSet<Long>();
                    userIDs.add(userId);
                    QFilter f = new QFilter("id", "in", (Object)OperGrpHelper.getOperatorGroupByUser((Long)((Long)org.getPkValue()), userIDs));
                    formShowParameter.getListFilterParameter().setFilter(f);
                    break;
                }
                QFilter f = new QFilter("id", "in", orgGrpList);
                formShowParameter.getListFilterParameter().setFilter(f);
                break;
            }
            case "operatorfield": {
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("operatorgroupfield");
                if (operateGroup == null || operateGroup.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u3002", (String)"SalesHistoricalPriceRptPlugin_2", (String)"scmc-sm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List<Long> groups = SalesHistoricalPriceRptPlugin.getBaseDataPkIds(operateGroup);
                SalesHistoricalPriceRptPlugin.getOperatorGroupByUser(groups, formShowParameter);
                break;
            }
            case "deptfield": {
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "biztypefield": {
                Object value = this.getModel().getValue("pricesourceentityfield");
                if (value != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4ef7\u683c\u6765\u6e90\u5355\u636e\u201d\u3002", (String)"SalesHistoricalPriceRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "orgfield": {
                this.getModel().setValue("materialfield", null);
                this.getModel().setValue("customerfield", null);
                this.getModel().setValue("operatorfield", null);
                this.getModel().setValue("operatorgroupfield", null);
                this.getModel().setValue("deptfield", null);
                break;
            }
            case "operatorgroupfield": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
            case "pricesourceentityfield": {
                if (newValue != null) break;
                this.getModel().setValue("biztypefield", null);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("orgfield");
        DynamicObject priceEntity = filter.getDynamicObject("pricesourceentityfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9500\u552e\u7ec4\u7ec7\u3002", (String)"SalesHistoricalPriceRptPlugin_0", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate == null && enddate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SalesHistoricalPriceRptPlugin_1", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        if (startdate != null && enddate != null && !SalesHistoricalPriceRptHelper.getTimeRange(startdate, enddate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u5e74\u5185\u7684\u65e5\u671f\u8303\u56f4\u3002", (String)"SalesHistoricalPriceRptPlugin_4", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        if (priceEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4ef7\u683c\u6765\u6e90\u5355\u636e\u201d\u3002", (String)"SalesHistoricalPriceRptPlugin_3", (String)"scmc-sm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.size() == 0) {
            this.getModel().setValue("operatorfield", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"operatorfield"});
        } else {
            this.getModel().setValue("operatorfield", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"operatorfield"});
        }
    }

    private static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    private static void getOperatorGroupByUser(List<Long> list, ListShowParameter showParameter) {
        if (list != null && list.size() > 0) {
            QFilter filter = new QFilter("operatorgrpid", "in", list);
            filter.and(new QFilter("invalid", "=", (Object)Boolean.FALSE));
            showParameter.getListFilterParameter().setFilter(filter);
        } else {
            QFilter filter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            showParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowDatas, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowDatas, queryParam);
        if (rowDatas.isEmpty()) {
            return;
        }
        HashSet<Long> currencyIds = new HashSet<Long>(10);
        for (DynamicObject row : rowDatas) {
            Object settlecurrency = row.get("settlecurrency");
            if (settlecurrency == null) continue;
            currencyIds.add(((DynamicObject)settlecurrency).getLong("id"));
        }
        QFilter pkFilter = new QFilter("id", "in", currencyIds);
        Map load = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id,priceprecision", (QFilter[])new QFilter[]{pkFilter});
        HashMap currencyAndPricePrecision = new HashMap(10);
        if (load != null && !load.isEmpty()) {
            load.values().forEach(baseData -> currencyAndPricePrecision.put(baseData.getLong("id"), baseData.getInt("priceprecision")));
        }
        for (DynamicObject row : rowDatas) {
            Long currencyId;
            Integer integer;
            int precision = 4;
            Object settlecurrency = row.get("settlecurrency");
            Object discountrate = row.get("discountrate");
            if (discountrate == null || BigDecimal.ZERO.compareTo((BigDecimal)discountrate) == 0) continue;
            if (settlecurrency instanceof DynamicObject && (integer = (Integer)currencyAndPricePrecision.get(currencyId = Long.valueOf(((DynamicObject)settlecurrency).getLong("id")))) != null) {
                precision = integer;
            }
            row.set("discountrate", (Object)((BigDecimal)discountrate).setScale(precision, RoundingMode.HALF_UP));
        }
    }
}

