/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pms.report.helper;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.OperatorGrpTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class SalesHistoricalPriceRptHelper {
    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>(32);
        selectorSet.add("billentry.material.masterid.id as material");
        selectorSet.add("billentry.material.masterid.name as materialname");
        selectorSet.add("billentry.material.masterid.modelnum as modelnum");
        selectorSet.add("billentry.auxpty as auxpty");
        selectorSet.add("org");
        selectorSet.add("customer");
        selectorSet.add("customer.name as customername");
        selectorSet.add("dept");
        selectorSet.add("operatorgroup");
        selectorSet.add("operator");
        selectorSet.add("bizdate");
        selectorSet.add("billno");
        selectorSet.add("billentry.seq as rowseq");
        selectorSet.add("currency");
        selectorSet.add("settlecurrency");
        selectorSet.add("exchangerate");
        selectorSet.add("billentry.curamountandtax as curamountandtax");
        selectorSet.add("billentry.amountandtax as amountandtax");
        selectorSet.add("billentry.id as entryid");
        selectorSet.add("id");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.baseqty as baseqty");
        selectorSet.add("billentry.qty as qty");
        selectorSet.add("billentry.priceandtax as priceandtax");
        selectorSet.add("billentry.discounttype as discounttype");
        selectorSet.add("billentry.discountrate as discountrate");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObjectCollection cusColl;
        DynamicObjectCollection biztypeColl;
        DynamicObjectCollection operators;
        DynamicObjectCollection operatorgroups;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("orgfield");
        filters.add(new QFilter("org", "=", org.getPkValue()));
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("bizdate", ">=", (Object)SalesHistoricalPriceRptHelper.getStartOrEndDate(startDate, false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("bizdate", "<=", (Object)SalesHistoricalPriceRptHelper.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("materialfield");
        if (materials != null && materials.size() > 0) {
            Object[] materialIdS = SalesHistoricalPriceRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", (Object)materialIdS));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
        }
        DynamicObjectCollection bizdepts = filterInfo.getDynamicObjectCollection("deptfield");
        if (bizdepts != null && bizdepts.size() > 0) {
            Object[] bizdeptsIds = SalesHistoricalPriceRptHelper.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", (Object)bizdeptsIds));
        }
        if ((operatorgroups = filterInfo.getDynamicObjectCollection("operatorgroupfield")) != null && operatorgroups.size() > 0) {
            Object[] bizoperatorgroupIds = SalesHistoricalPriceRptHelper.getBaseDataPkIds(operatorgroups);
            filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds));
        }
        if ((operators = filterInfo.getDynamicObjectCollection("operatorfield")) != null && operators.size() > 0) {
            Object[] bizoperatorgroupIds = SalesHistoricalPriceRptHelper.getBaseDataPkIds(operators);
            filters.add(new QFilter("operator", "in", (Object)bizoperatorgroupIds));
        }
        if ((biztypeColl = filterInfo.getDynamicObjectCollection("biztypefield")) != null && biztypeColl.size() > 0) {
            Object[] biztypes = SalesHistoricalPriceRptHelper.getBaseDataPkIds(biztypeColl);
            filters.add(new QFilter("biztype", "in", (Object)biztypes));
        }
        if ((cusColl = filterInfo.getDynamicObjectCollection("customerfield")) != null && cusColl.size() > 0) {
            Object[] customers = SalesHistoricalPriceRptHelper.getBaseDataPkIds(cusColl);
            filters.add(new QFilter("customer", "in", (Object)customers));
        }
        return filters;
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static boolean getTimeRange(Date d1, Date d2) {
        LocalDate endDate;
        LocalDate startDate = d1.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return startDate.until(endDate = d2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate(), ChronoUnit.YEARS) < 1L;
    }

    public static List<Long> getOperatorGroupByOrg(long orgId) {
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.SALEGRP.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }
}

